/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.events;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllTags;
import com.simibubi.create.CreateClient;
import com.simibubi.create.content.contraptions.elevator.ElevatorControlsHandler;
import com.simibubi.create.content.contraptions.wrench.RadialWrenchHandler;
import com.simibubi.create.content.equipment.toolbox.ToolboxHandlerClient;
import com.simibubi.create.content.kinetics.chainConveyor.ChainConveyorConnectionHandler;
import com.simibubi.create.content.kinetics.chainConveyor.ChainConveyorInteractionHandler;
import com.simibubi.create.content.kinetics.chainConveyor.ChainPackageInteractionHandler;
import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelConnectionHandler;
import com.simibubi.create.content.logistics.packagePort.PackagePortTargetSelectionHandler;
import com.simibubi.create.content.redstone.link.controller.LinkedControllerClientHandler;
import com.simibubi.create.content.trains.TrainHUD;
import com.simibubi.create.content.trains.entity.TrainRelocator;
import com.simibubi.create.content.trains.track.CurvedTrackInteraction;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class InputEvents {
    @SubscribeEvent
    public static void onKeyInput(InputEvent.Key event) {
        if (Minecraft.m_91087_().f_91080_ != null) {
            return;
        }
        int key = event.getKey();
        boolean pressed = event.getAction() != 0;
        CreateClient.SCHEMATIC_HANDLER.onKeyInput(key, pressed);
        ToolboxHandlerClient.onKeyInput(key, pressed);
        RadialWrenchHandler.onKeyInput(key, pressed);
    }

    @SubscribeEvent
    public static void onMouseScrolled(InputEvent.MouseScrollingEvent event) {
        if (Minecraft.m_91087_().f_91080_ != null) {
            return;
        }
        double delta = event.getScrollDelta();
        boolean cancelled = CreateClient.SCHEMATIC_HANDLER.mouseScrolled(delta) || CreateClient.SCHEMATIC_AND_QUILL_HANDLER.mouseScrolled(delta) || TrainHUD.onScroll(delta) || ElevatorControlsHandler.onScroll(delta);
        event.setCanceled(cancelled);
    }

    @SubscribeEvent
    public static void onMouseInput(InputEvent.MouseButton.Pre event) {
        if (Minecraft.m_91087_().f_91080_ != null) {
            return;
        }
        int button = event.getButton();
        boolean pressed = event.getAction() != 0;
        RadialWrenchHandler.onKeyInput(button, pressed);
        if (CreateClient.SCHEMATIC_HANDLER.onMouseInput(button, pressed)) {
            event.setCanceled(true);
        } else if (CreateClient.SCHEMATIC_AND_QUILL_HANDLER.onMouseInput(button, pressed)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onClickInput(InputEvent.InteractionKeyMappingTriggered event) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91080_ != null) {
            return;
        }
        if (CurvedTrackInteraction.onClickInput(event)) {
            event.setCanceled(true);
            return;
        }
        KeyMapping key = event.getKeyMapping();
        if ((key == mc.f_91066_.f_92095_ || key == mc.f_91066_.f_92096_) && CreateClient.GLUE_HANDLER.onMouseInput(key == mc.f_91066_.f_92096_)) {
            event.setCanceled(true);
        }
        if (key == mc.f_91066_.f_92095_ && (FactoryPanelConnectionHandler.onRightClick() || ChainConveyorConnectionHandler.onRightClick())) {
            event.setCanceled(true);
            return;
        }
        if (key == mc.f_91066_.f_92097_) {
            if (ToolboxHandlerClient.onPickItem()) {
                event.setCanceled(true);
            }
            return;
        }
        if (!event.isUseItem()) {
            return;
        }
        LinkedControllerClientHandler.deactivateInLectern();
        TrainRelocator.onClicked(event);
        if (ChainConveyorInteractionHandler.onUse()) {
            event.setCanceled(true);
            return;
        }
        if (PackagePortTargetSelectionHandler.onUse()) {
            event.setCanceled(true);
            return;
        }
        if (mc.f_91074_ != null) {
            ItemStack itemInHand = mc.f_91074_.m_21120_(event.getHand());
            if (AllTags.AllItemTags.WRENCH.matches(itemInHand)) {
                return;
            }
            if (itemInHand.m_150930_(Items.f_42026_) || AllBlocks.PACKAGE_FROGPORT.isIn(itemInHand)) {
                return;
            }
        }
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            if (ChainPackageInteractionHandler.onUse()) {
                event.setCanceled(true);
            }
        });
    }
}

