/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.trains.schedule.hat;

import com.google.gson.JsonObject;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.simibubi.create.Create;
import com.simibubi.create.content.trains.schedule.hat.TrainHatInfo;
import java.io.BufferedReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.ForgeRegistries;
import org.slf4j.Logger;

public class TrainHatInfoReloadListener {
    private static final Map<EntityType<?>, TrainHatInfo> ENTITY_INFO_MAP = new HashMap();
    public static final String HAT_INFO_DIRECTORY = "train_hat_info";
    public static final ResourceManagerReloadListener LISTENER = TrainHatInfoReloadListener::registerOffsetOverrides;
    private static final TrainHatInfo DEFAULT = new TrainHatInfo("", 0, Vec3.f_82478_, 1.0f);

    private static void registerOffsetOverrides(ResourceManager manager) {
        ENTITY_INFO_MAP.clear();
        FileToIdConverter converter = FileToIdConverter.m_246568_((String)HAT_INFO_DIRECTORY);
        converter.m_247457_(manager).forEach((location, resource) -> {
            String[] splitPath = location.m_135815_().split("/");
            ResourceLocation entityName = new ResourceLocation(location.m_135827_(), splitPath[splitPath.length - 1].replace(".json", ""));
            if (!ForgeRegistries.ENTITY_TYPES.containsKey(entityName)) {
                Create.LOGGER.error("Failed to load train hat info for entity {} as it does not exist.", (Object)entityName);
                return;
            }
            try (BufferedReader reader = resource.m_215508_();){
                JsonObject json = GsonHelper.m_13859_((Reader)reader);
                ENTITY_INFO_MAP.put((EntityType)ForgeRegistries.ENTITY_TYPES.getValue(entityName), (TrainHatInfo)TrainHatInfo.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)json).resultOrPartial(arg_0 -> ((Logger)Create.LOGGER).error(arg_0)).orElseThrow());
            }
            catch (Exception e) {
                Create.LOGGER.error("Failed to read train hat info for entity {}!", (Object)entityName, (Object)e);
            }
        });
        Create.LOGGER.info("Loaded {} train hat configurations.", (Object)ENTITY_INFO_MAP.size());
    }

    public static TrainHatInfo getHatInfoFor(EntityType<?> type) {
        return ENTITY_INFO_MAP.getOrDefault(type, DEFAULT);
    }
}

