/*
 * Decompiled with CFR 0.152.
 */
package com.sonicether.soundphysics.config.blocksound;

import com.sonicether.soundphysics.config.blocksound.BlockDefinition;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;

public class BlockTagDefinition
extends BlockDefinition {
    private final TagKey<Block> blockTag;

    public BlockTagDefinition(TagKey<Block> blockTag) {
        this.blockTag = blockTag;
    }

    @Override
    public String getConfigString() {
        return "#%s".formatted(this.blockTag.f_203868_());
    }

    @Override
    @Nullable
    public String getConfigComment() {
        return this.getName().getString();
    }

    @Override
    public Component getName() {
        return Component.m_237113_((String)this.getConfigString()).m_7220_((Component)Component.m_237113_((String)" (Block Tag)"));
    }

    public TagKey<Block> getBlockTag() {
        return this.blockTag;
    }

    @Nullable
    public static BlockTagDefinition fromConfigString(String configString) {
        if (!configString.startsWith("#")) {
            return null;
        }
        String id = configString.substring(1).trim();
        if (!ResourceLocation.m_135830_((String)id)) {
            return null;
        }
        return new BlockTagDefinition((TagKey<Block>)TagKey.m_203882_((ResourceKey)Registries.f_256747_, (ResourceLocation)new ResourceLocation(id)));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BlockTagDefinition that = (BlockTagDefinition)o;
        return Objects.equals(this.blockTag, that.blockTag);
    }

    public int hashCode() {
        return this.blockTag != null ? this.blockTag.hashCode() : 0;
    }
}

