/*
 * Decompiled with CFR 0.152.
 */
package com.jesz.createdieselgenerators.content.track_layers_bag;

import com.jesz.createdieselgenerators.CDGItems;
import com.jesz.createdieselgenerators.CreateDieselGenerators;
import com.jesz.createdieselgenerators.content.track_layers_bag.TrackLayersBagComponent;
import com.jesz.createdieselgenerators.mixins.UseOnContextInvoker;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.trains.track.TrackBlock;
import com.simibubi.create.content.trains.track.TrackBlockItem;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;

public class TrackLayersBagItem
extends Item {
    public TrackLayersBagItem(Item.Properties properties) {
        super(properties.m_41487_(1));
    }

    public Optional<TooltipComponent> m_142422_(ItemStack stack) {
        ItemStack track = TrackLayersBagItem.getTracks(stack);
        if (track.m_41619_()) {
            return Optional.empty();
        }
        return Optional.of(new TrackLayersBagComponent(track));
    }

    public void m_7373_(ItemStack stack, Level level, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.m_237110_((String)"item.minecraft.bundle.fullness", (Object[])new Object[]{TrackLayersBagItem.getTracks(stack).m_41613_(), 1024}).m_130940_(ChatFormatting.GRAY));
    }

    int add(ItemStack bag, ItemStack stack) {
        if (!stack.m_41619_() && stack.m_41720_() instanceof TrackBlockItem) {
            CompoundTag tag = bag.m_41784_();
            ItemStack stackInBag = TrackLayersBagItem.getTracks(bag);
            if (!ItemStack.m_150942_((ItemStack)stack, (ItemStack)stackInBag) && !stackInBag.m_41619_()) {
                return 0;
            }
            int oldCount = stackInBag.m_41613_();
            if (stackInBag.m_41619_()) {
                stackInBag = stack.m_41777_();
            } else {
                stackInBag.m_41764_(Math.min(oldCount + stack.m_41613_(), 1024));
            }
            tag.m_128405_("Count", stackInBag.m_41613_());
            tag.m_128365_("Item", (Tag)stackInBag.m_41739_(new CompoundTag()));
            return Math.min(stack.m_41613_(), 1024 - oldCount);
        }
        return 0;
    }

    static ItemStack removeOne(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        if (!tag.m_128441_("Item")) {
            return ItemStack.f_41583_;
        }
        ItemStack extractedStack = TrackLayersBagItem.getTracks(stack);
        ItemStack savedStack = extractedStack.m_41777_();
        savedStack.m_41774_(64);
        tag.m_128405_("Count", savedStack.m_41613_());
        tag.m_128365_("Item", (Tag)savedStack.m_41739_(new CompoundTag()));
        extractedStack.m_41764_(Math.min(64, extractedStack.m_41613_()));
        if (savedStack.m_41613_() == 0) {
            tag.m_128473_("Item");
            tag.m_128405_("Count", 0);
        }
        return extractedStack;
    }

    public int m_142158_(ItemStack stack) {
        return 1 + (int)((float)TrackLayersBagItem.getTracks(stack).m_41613_() / 1024.0f * 12.0f);
    }

    public int m_142159_(ItemStack stack) {
        return 0x66FF66;
    }

    public boolean m_142522_(ItemStack stack) {
        return TrackLayersBagItem.getTracks(stack).m_41613_() != 0;
    }

    public boolean m_142207_(ItemStack stack, Slot slot, ClickAction click, Player player) {
        int added;
        if (stack.m_41613_() != 1 || click != ClickAction.SECONDARY) {
            return false;
        }
        ItemStack stackInSlot = slot.m_7993_();
        if (stackInSlot.m_41619_() && slot.m_5857_(TrackLayersBagItem.getTracks(stack))) {
            player.m_5496_(SoundEvents.f_184216_, 0.8f, 0.8f + player.m_9236_().m_213780_().m_188501_() * 0.4f);
            slot.m_5852_(TrackLayersBagItem.removeOne(stack));
        } else if (!stackInSlot.m_41619_() && slot.m_8010_(player) && (added = this.add(stack, stackInSlot)) > 0) {
            player.m_5496_(SoundEvents.f_184215_, 0.8f, 0.8f + player.m_9236_().m_213780_().m_188501_() * 0.4f);
            stackInSlot.m_41774_(added);
        }
        return true;
    }

    public boolean m_142305_(ItemStack bag, ItemStack otherStack, Slot slot, ClickAction click, Player player, SlotAccess slotAccess) {
        if (bag.m_41613_() != 1 || click != ClickAction.SECONDARY || !slot.m_150651_(player)) {
            return false;
        }
        if (otherStack.m_41619_()) {
            ItemStack extractedStack = TrackLayersBagItem.removeOne(bag);
            if (!extractedStack.m_41619_()) {
                player.m_5496_(SoundEvents.f_184216_, 0.8f, 0.8f + player.m_9236_().m_213780_().m_188501_() * 0.4f);
                slotAccess.m_142104_(extractedStack);
            }
        } else {
            int added = this.add(bag, otherStack);
            if (added > 0) {
                player.m_5496_(SoundEvents.f_184215_, 0.8f, 0.8f + player.m_9236_().m_213780_().m_188501_() * 0.4f);
                otherStack.m_41774_(added);
            }
        }
        return true;
    }

    public static ItemStack getTracks(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        if (!tag.m_128441_("Item")) {
            return ItemStack.f_41583_;
        }
        ItemStack tracks = ItemStack.m_41712_((CompoundTag)tag.m_128469_("Item"));
        tracks.m_41764_(tag.m_128451_("Count"));
        return tracks;
    }

    public InteractionResult m_6225_(UseOnContext context) {
        ItemStack stack = context.m_43722_();
        ItemStack tracks = TrackLayersBagItem.getTracks(stack);
        if (tracks.m_41619_()) {
            return super.m_6225_(context);
        }
        BlockState clickedState = context.m_43725_().m_8055_(context.m_8083_());
        Block block = clickedState.m_60734_();
        if (!(block instanceof TrackBlock)) {
            CompoundTag tag = stack.m_41784_();
            tag.m_128405_("Count", Math.max(0, tag.m_128451_("Count") - 1));
            return ((TrackBlockItem)tracks.m_41720_()).m_40576_(new BlockPlaceContext(context.m_43725_(), context.m_43723_(), context.m_43724_(), tracks, ((UseOnContextInvoker)context).cdg_getHitResult()));
        }
        TrackBlock block2 = (TrackBlock)block;
        return InteractionResult.SUCCESS;
    }

    private InteractionResult place(BlockPlaceContext context, BlockItem item) {
        CollisionContext collision;
        if (!context.m_7059_()) {
            return InteractionResult.FAIL;
        }
        BlockPos pos = context.m_8083_();
        Level level = context.m_43725_();
        Player player = context.m_43723_();
        BlockState blockstate = item.m_40614_().m_5573_(context);
        CollisionContext collisionContext = collision = player == null ? CollisionContext.m_82749_() : CollisionContext.m_82750_((Entity)player);
        if (!blockstate.m_60710_((LevelReader)level, pos) || !level.m_45752_(blockstate, pos, collision)) {
            return InteractionResult.FAIL;
        }
        if (!level.m_7731_(pos, blockstate, 11)) {
            return InteractionResult.FAIL;
        }
        BlockState clickedState = level.m_8055_(pos);
        level.m_220407_(GameEvent.f_157797_, pos, GameEvent.Context.m_223719_((Entity)player, (BlockState)clickedState));
        SoundType sound = clickedState.getSoundType((LevelReader)level, pos, (Entity)context.m_43723_());
        level.m_5594_(player, pos, clickedState.m_60827_().m_56777_(), SoundSource.BLOCKS, (sound.m_56773_() + 1.0f) / 2.0f, sound.m_56774_() * 0.8f);
        return InteractionResult.m_19078_((boolean)level.f_46443_);
    }

    public void registerModelOverrides() {
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> ItemProperties.register((Item)((Item)CDGItems.TRACK_LAYERS_BAG.get()), (ResourceLocation)CreateDieselGenerators.rl("tracks"), (stack, level, entity, seed) -> TrackLayersBagItem.getTracks(stack).m_41613_()));
    }

    public static ItemStack full() {
        ItemStack stack = CDGItems.TRACK_LAYERS_BAG.asStack();
        ((TrackLayersBagItem)stack.m_41720_()).add(stack, AllBlocks.TRACK.asStack(1024));
        return stack;
    }
}

