/*
 * Decompiled with CFR 0.152.
 */
package com.jesz.createdieselgenerators.content.tools;

import com.jesz.createdieselgenerators.CDGConfig;
import com.simibubi.create.AllEnchantments;
import com.simibubi.create.foundation.utility.CreateLang;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.templates.FluidHandlerItemStack;
import net.minecraftforge.fml.ModList;

public interface FueledToolItem {
    default public int getBaseCapacity(ItemStack stack) {
        return (Integer)CDGConfig.TOOL_CAPACITY.get();
    }

    default public int getCapacityEnchantmentAddition(ItemStack stack) {
        return (Integer)CDGConfig.TOOL_CAPACITY_ENCHANTMENT.get();
    }

    default public int getCapacity(ItemStack stack) {
        if (!ModList.get().isLoaded("dungeons_libraries")) {
            return this.getBaseCapacity(stack) + this.getCapacityEnchantmentAddition(stack) * stack.getEnchantmentLevel((Enchantment)AllEnchantments.CAPACITY.get());
        }
        return this.getBaseCapacity(stack);
    }

    default public FluidStack readFluid(ItemStack stack) {
        return FluidStack.loadFluidStackFromNBT((CompoundTag)stack.m_41784_().m_128469_("Fluid"));
    }

    default public void writeFluid(ItemStack stack, FluidStack fluid) {
        stack.m_41784_().m_128365_("Fluid", (Tag)fluid.writeToNBT(new CompoundTag()));
    }

    default public int getCurrentFillLevel(ItemStack stack) {
        return this.readFluid(stack).getAmount();
    }

    default public void createTooltip(List<Component> tooltip, ItemStack stack) {
        if (stack.m_41783_() != null) {
            FluidStack fluid = this.readFluid(stack);
            if (fluid.isEmpty()) {
                tooltip.add((Component)Component.m_237115_((String)"createdieselgenerators.tooltip.empty").m_130940_(ChatFormatting.GRAY));
                return;
            }
            tooltip.add((Component)CreateLang.fluidName((FluidStack)fluid).component().m_130940_(ChatFormatting.GRAY).m_130946_(" ").m_7220_((Component)CreateLang.number((double)fluid.getAmount()).style(ChatFormatting.GOLD).component()).m_7220_((Component)Component.m_237115_((String)"create.generic.unit.millibuckets").m_130940_(ChatFormatting.GOLD)).m_7220_((Component)Component.m_237113_((String)" / ")).m_7220_((Component)CreateLang.number((double)this.getCapacity(stack)).style(ChatFormatting.GRAY).component()).m_7220_((Component)Component.m_237115_((String)"create.generic.unit.millibuckets").m_130940_(ChatFormatting.GRAY)));
            return;
        }
        tooltip.add((Component)Component.m_237115_((String)"createdieselgenerators.tooltip.empty").m_130940_(ChatFormatting.GRAY));
    }

    default public FluidHandlerItemStack getFluidHandler(ItemStack stack) {
        return new ToolItemFluidHandler(stack, this.getCapacity(stack), this::readFluid, this::writeFluid);
    }

    public static class ToolItemFluidHandler
    extends FluidHandlerItemStack {
        BiConsumer<ItemStack, FluidStack> write;
        Function<ItemStack, FluidStack> read;

        public ToolItemFluidHandler(ItemStack container, int capacity, Function<ItemStack, FluidStack> read, BiConsumer<ItemStack, FluidStack> write) {
            super(container, capacity);
            this.write = write;
            this.read = read;
        }

        public FluidStack getFluid() {
            return this.read.apply(this.container);
        }

        protected void setFluid(FluidStack fluid) {
            this.write.accept(this.container, fluid);
        }
    }
}

