/*
 * Decompiled with CFR 0.152.
 */
package com.jesz.createdieselgenerators.content.distillation;

import com.jesz.createdieselgenerators.CDGRecipes;
import com.jesz.createdieselgenerators.content.distillation.DistillationRecipe;
import com.jesz.createdieselgenerators.content.distillation.DistillationTankBlock;
import com.simibubi.create.api.connectivity.ConnectivityHandler;
import com.simibubi.create.api.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.content.fluids.tank.FluidTankBlock;
import com.simibubi.create.content.processing.basin.BasinBlockEntity;
import com.simibubi.create.content.processing.burner.BlazeBurnerBlock;
import com.simibubi.create.foundation.blockEntity.IMultiBlockEntityContainer;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.fluid.FluidIngredient;
import com.simibubi.create.foundation.fluid.SmartFluidTank;
import com.simibubi.create.foundation.recipe.RecipeFinder;
import com.simibubi.create.infrastructure.config.AllConfigs;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.createmod.catnip.animation.LerpedFloat;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public class DistillationTankBlockEntity
extends SmartBlockEntity
implements IMultiBlockEntityContainer.Fluid,
IHaveGoggleInformation {
    private static final int MAX_SIZE = 3;
    public float progress;
    protected LazyOptional<IFluidHandler> fluidCapability;
    protected boolean forceFluidLevelUpdate = true;
    public FluidTank tankInventory;
    protected BlockPos controller;
    protected BlockPos lastKnownPos;
    protected boolean updateConnectivity = false;
    public boolean window = false;
    protected int luminosity;
    protected int width = 1;
    protected int height = 1;
    private static final int SYNC_RATE = 8;
    protected int syncCooldown;
    protected boolean queuedSync;
    private LerpedFloat fluidLevel;
    BlazeBurnerBlock.HeatLevel currentHeating = BlazeBurnerBlock.HeatLevel.NONE;
    int processingTime = -1;
    DistillationRecipe currentRecipe;
    static final Object RECIPE_CACHE_KEY = new Object();

    public DistillationTankBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.tankInventory = this.createInventory();
        this.fluidCapability = LazyOptional.of(() -> this.tankInventory);
        this.refreshCapability();
    }

    protected SmartFluidTank createInventory() {
        return new SmartFluidTank(DistillationTankBlockEntity.getCapacityMultiplier(), this::onFluidStackChanged);
    }

    public BlazeBurnerBlock.HeatLevel getHeat() {
        int width = this.getControllerBE().width;
        BlazeBurnerBlock.HeatLevel lowestHeat = BlazeBurnerBlock.HeatLevel.SEETHING;
        for (int xOffset = 0; xOffset < width; ++xOffset) {
            for (int zOffset = 0; zOffset < width; ++zOffset) {
                BlockPos pos = this.getController().m_7918_(xOffset, -1, zOffset);
                BlockState blockState = this.f_58857_.m_8055_(pos);
                BlazeBurnerBlock.HeatLevel heat = BasinBlockEntity.getHeatLevelOf((BlockState)blockState);
                if (heat.isAtLeast(lowestHeat)) continue;
                lowestHeat = heat;
            }
        }
        return lowestHeat;
    }

    public void updateConnectivity() {
        this.updateConnectivity = false;
        if (this.f_58857_.f_46443_) {
            return;
        }
        if (!this.isController()) {
            return;
        }
        ConnectivityHandler.formMulti((BlockEntity)this);
    }

    private void startProcessing() {
        if (this.currentRecipe == null) {
            return;
        }
        this.processingTime = this.currentRecipe.getProcessingDuration();
        if (!this.f_58857_.f_46443_) {
            this.sendData();
        }
    }

    public void tick() {
        if (this.isController() && this.isBottom()) {
            if (this.processingTime > -1 && this.currentRecipe != null) {
                boolean canFill = true;
                for (int i = 0; i < this.currentRecipe.getFluidResults().size(); ++i) {
                    BlockEntity blockEntity = this.f_58857_.m_7702_(this.m_58899_().m_6630_(i + 1));
                    if (blockEntity instanceof DistillationTankBlockEntity) {
                        DistillationTankBlockEntity be = (DistillationTankBlockEntity)blockEntity;
                        if (!this.isSameMultiBlock(be)) {
                            canFill = false;
                            break;
                        }
                        if (be.tankInventory.getSpace() >= ((FluidStack)this.currentRecipe.getFluidResults().get(i)).getAmount()) continue;
                        canFill = false;
                        break;
                    }
                    canFill = false;
                    break;
                }
                if (canFill) {
                    --this.processingTime;
                }
                if (this.tankInventory.getFluid().getAmount() < ((FluidIngredient)this.currentRecipe.getFluidIngredients().get(0)).getRequiredAmount() || !this.currentRecipe.getRequiredHeat().testBlazeBurner(this.currentHeating)) {
                    this.currentRecipe = null;
                    this.processingTime = -1;
                }
            }
            if (this.processingTime == 0 && this.currentRecipe != null) {
                if (this.tankInventory.getFluid().getAmount() >= ((FluidIngredient)this.currentRecipe.getFluidIngredients().get(0)).getRequiredAmount() && this.currentRecipe.getRequiredHeat().testBlazeBurner(this.currentHeating)) {
                    this.tankInventory.drain(((FluidIngredient)this.currentRecipe.getFluidIngredients().get(0)).getRequiredAmount(), IFluidHandler.FluidAction.EXECUTE);
                    if (this.currentRecipe != null) {
                        DistillationTankBlockEntity be;
                        BlockEntity blockEntity;
                        for (int i = 0; i < this.currentRecipe.getFluidResults().size() && (blockEntity = this.f_58857_.m_7702_(this.m_58899_().m_6630_(i + 1))) instanceof DistillationTankBlockEntity && this.isSameMultiBlock(be = (DistillationTankBlockEntity)blockEntity); ++i) {
                            be.tankInventory.fill((FluidStack)this.currentRecipe.getFluidResults().get(i), IFluidHandler.FluidAction.EXECUTE);
                        }
                    }
                }
                this.currentRecipe = null;
                this.processingTime = -1;
                if (!this.tankInventory.isEmpty() && this.isController() && this.isBottom()) {
                    this.checkForRecipes();
                }
            }
            this.progress = this.currentRecipe != null ? (float)this.processingTime / (float)this.currentRecipe.getProcessingDuration() : 0.0f;
        }
        super.tick();
        if (this.syncCooldown > 0) {
            --this.syncCooldown;
            if (this.syncCooldown == 0 && this.queuedSync) {
                this.sendData();
            }
        }
        if (this.lastKnownPos == null) {
            this.lastKnownPos = this.m_58899_();
        } else if (!this.lastKnownPos.equals((Object)this.f_58858_) && this.f_58858_ != null) {
            this.onPositionChanged();
            return;
        }
        if (this.updateConnectivity) {
            this.updateConnectivity();
        }
        if (this.fluidLevel != null) {
            this.fluidLevel.tickChaser();
        }
    }

    public BlockPos getLastKnownPos() {
        return this.lastKnownPos;
    }

    public boolean isController() {
        return this.controller == null || this.f_58858_.m_123341_() == this.controller.m_123341_() && this.f_58858_.m_123342_() == this.controller.m_123342_() && this.f_58858_.m_123343_() == this.controller.m_123343_();
    }

    public void initialize() {
        super.initialize();
        this.updateTemperature();
        this.checkForRecipes();
        this.sendData();
        if (this.f_58857_.f_46443_) {
            this.invalidateRenderBoundingBox();
        }
    }

    private void onPositionChanged() {
        this.removeController(true);
        this.lastKnownPos = this.f_58858_;
    }

    protected List<Recipe<?>> getMatchingRecipes() {
        List list = RecipeFinder.get((Object)this.getRecipeCacheKey(), (Level)this.f_58857_, recipe -> recipe.m_6671_() == CDGRecipes.DISTILLATION.getType());
        return list.stream().filter(r -> {
            if (r instanceof DistillationRecipe) {
                DistillationRecipe recipe = (DistillationRecipe)((Object)r);
                if (!recipe.getRequiredHeat().testBlazeBurner(this.currentHeating)) {
                    return false;
                }
                return ((FluidIngredient)recipe.getFluidIngredients().get(0)).test(this.tankInventory.getFluid());
            }
            return false;
        }).collect(Collectors.toList());
    }

    Object getRecipeCacheKey() {
        return RECIPE_CACHE_KEY;
    }

    protected void onFluidStackChanged(FluidStack newFluidStack) {
        if (!this.m_58898_()) {
            return;
        }
        if (!this.tankInventory.isEmpty() && this.isController() && this.isBottom()) {
            this.checkForRecipes();
        }
        FluidType attributes = newFluidStack.getFluid().getFluidType();
        int luminosity = (int)((float)attributes.getLightLevel(newFluidStack) / 1.2f);
        boolean reversed = attributes.isLighterThanAir();
        int maxY = (int)(this.getFillState() * (float)this.height + 1.0f);
        for (int yOffset = 0; yOffset < this.height; ++yOffset) {
            boolean isBright;
            boolean bl = reversed ? this.height - yOffset <= maxY : (isBright = yOffset < maxY);
            int actualLuminosity = isBright ? luminosity : (luminosity > 0 ? 1 : 0);
            for (int xOffset = 0; xOffset < this.width; ++xOffset) {
                for (int zOffset = 0; zOffset < this.width; ++zOffset) {
                    BlockPos pos = this.f_58858_.m_7918_(xOffset, yOffset, zOffset);
                    DistillationTankBlockEntity tankAt = (DistillationTankBlockEntity)ConnectivityHandler.partAt((BlockEntityType)this.m_58903_(), (BlockGetter)this.f_58857_, (BlockPos)pos);
                    if (tankAt == null) continue;
                    this.f_58857_.m_46717_(pos, tankAt.m_58900_().m_60734_());
                    if (tankAt.luminosity == actualLuminosity) continue;
                    tankAt.setLuminosity(actualLuminosity);
                }
            }
        }
        if (!this.f_58857_.f_46443_) {
            this.m_6596_();
            this.sendData();
        }
        if (this.isVirtual()) {
            if (this.fluidLevel == null) {
                this.fluidLevel = LerpedFloat.linear().startWithValue((double)this.getFillState());
            }
            this.fluidLevel.chase((double)this.getFillState(), 0.5, LerpedFloat.Chaser.EXP);
        }
    }

    protected void setLuminosity(int luminosity) {
        if (this.f_58857_.f_46443_) {
            return;
        }
        if (this.luminosity == luminosity) {
            return;
        }
        this.luminosity = luminosity;
        this.sendData();
    }

    public DistillationTankBlockEntity getControllerBE() {
        if (this.isController()) {
            return this;
        }
        BlockEntity blockEntity = this.f_58857_.m_7702_(this.controller);
        if (blockEntity instanceof DistillationTankBlockEntity) {
            return (DistillationTankBlockEntity)blockEntity;
        }
        return null;
    }

    public void applyFluidTankSize(int blocks) {
        this.tankInventory.setCapacity(blocks * DistillationTankBlockEntity.getCapacityMultiplier());
        int overflow = this.tankInventory.getFluidAmount() - this.tankInventory.getCapacity();
        if (overflow > 0) {
            this.tankInventory.drain(overflow, IFluidHandler.FluidAction.EXECUTE);
        }
        this.forceFluidLevelUpdate = true;
    }

    public void removeController(boolean keepFluids) {
        if (this.f_58857_.f_46443_) {
            return;
        }
        this.updateConnectivity = true;
        if (!keepFluids) {
            this.applyFluidTankSize(1);
        }
        this.controller = null;
        this.width = 1;
        this.height = 1;
        this.onFluidStackChanged(this.tankInventory.getFluid());
        BlockState state = this.m_58900_();
        if (DistillationTankBlock.isTank(state)) {
            state = (BlockState)state.m_61124_((Property)DistillationTankBlock.BOTTOM, (Comparable)Boolean.valueOf(true));
            state = (BlockState)state.m_61124_((Property)DistillationTankBlock.TOP, (Comparable)Boolean.valueOf(true));
            state = (BlockState)state.m_61124_(DistillationTankBlock.SHAPE, (Comparable)(this.window ? FluidTankBlock.Shape.WINDOW : FluidTankBlock.Shape.PLAIN));
            this.m_58904_().m_7731_(this.f_58858_, state, 6);
        }
        this.refreshCapability();
        this.m_6596_();
        this.sendData();
    }

    public void toggleWindows() {
        DistillationTankBlockEntity be = this.getControllerBE();
        if (be == null) {
            return;
        }
        be.setWindows(!be.window);
    }

    public void sendData() {
        if (this.syncCooldown > 0) {
            this.queuedSync = true;
            return;
        }
        super.sendData();
        this.queuedSync = false;
        this.syncCooldown = 8;
    }

    public void setWindows(boolean window) {
        this.window = window;
        for (int yOffset = 0; yOffset < this.height; ++yOffset) {
            for (int xOffset = 0; xOffset < this.width; ++xOffset) {
                for (int zOffset = 0; zOffset < this.width; ++zOffset) {
                    BlockPos pos = this.f_58858_.m_7918_(xOffset, yOffset, zOffset);
                    BlockState blockState = this.f_58857_.m_8055_(pos);
                    if (!DistillationTankBlock.isTank(blockState)) continue;
                    FluidTankBlock.Shape shape = FluidTankBlock.Shape.PLAIN;
                    if (window) {
                        if (this.width == 1) {
                            shape = FluidTankBlock.Shape.WINDOW;
                        }
                        if (this.width == 2) {
                            FluidTankBlock.Shape shape2 = xOffset == 0 ? (zOffset == 0 ? FluidTankBlock.Shape.WINDOW_NW : FluidTankBlock.Shape.WINDOW_SW) : (shape = zOffset == 0 ? FluidTankBlock.Shape.WINDOW_NE : FluidTankBlock.Shape.WINDOW_SE);
                        }
                        if (this.width == 3 && Math.abs(xOffset - zOffset) == 1) {
                            shape = FluidTankBlock.Shape.WINDOW;
                        }
                    }
                    this.f_58857_.m_7731_(pos, (BlockState)blockState.m_61124_(DistillationTankBlock.SHAPE, (Comparable)shape), 22);
                    this.f_58857_.m_7726_().m_7827_().m_7174_(pos);
                }
            }
        }
    }

    public void setController(BlockPos controller) {
        if (this.f_58857_.f_46443_ && !this.isVirtual()) {
            return;
        }
        if (controller.equals((Object)this.controller)) {
            return;
        }
        this.controller = controller;
        this.refreshCapability();
        this.m_6596_();
        this.sendData();
    }

    private void refreshCapability() {
        LazyOptional<IFluidHandler> oldCap = this.fluidCapability;
        this.fluidCapability = LazyOptional.of(() -> this.handlerForCapability());
        oldCap.invalidate();
    }

    private IFluidHandler handlerForCapability() {
        return this.isController() ? this.tankInventory : (this.getControllerBE() != null ? this.getControllerBE().handlerForCapability() : new FluidTank(0));
    }

    public BlockPos getController() {
        return this.isController() ? this.f_58858_ : this.controller;
    }

    protected AABB createRenderBoundingBox() {
        if (this.isController()) {
            return super.createRenderBoundingBox().m_82363_((double)(this.width - 1), 0.0, (double)(this.width - 1));
        }
        return super.createRenderBoundingBox();
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        DistillationTankBlockEntity controllerBE = this.getControllerBE();
        if (controllerBE == null) {
            return false;
        }
        return this.containedFluidTooltip(tooltip, isPlayerSneaking, controllerBE.getCapability(ForgeCapabilities.FLUID_HANDLER));
    }

    protected void read(CompoundTag compound, boolean clientPacket) {
        boolean changeOfController;
        super.read(compound, clientPacket);
        BlockPos controllerBefore = this.controller;
        int prevSize = this.width;
        int prevHeight = this.height;
        int prevLum = this.luminosity;
        this.updateConnectivity = compound.m_128441_("Uninitialized");
        this.luminosity = compound.m_128451_("Luminosity");
        this.controller = null;
        this.lastKnownPos = null;
        if (compound.m_128441_("LastKnownPos")) {
            this.lastKnownPos = NbtUtils.m_129239_((CompoundTag)compound.m_128469_("LastKnownPos"));
        }
        if (compound.m_128441_("Controller")) {
            this.controller = NbtUtils.m_129239_((CompoundTag)compound.m_128469_("Controller"));
        }
        if (this.isController()) {
            this.window = compound.m_128471_("Window");
            this.width = compound.m_128451_("Size");
            this.height = compound.m_128451_("Height");
            this.tankInventory.setCapacity(this.getTotalTankSize() * DistillationTankBlockEntity.getCapacityMultiplier());
            this.tankInventory.readFromNBT(compound.m_128469_("TankContent"));
            if (this.tankInventory.getSpace() < 0) {
                this.tankInventory.drain(-this.tankInventory.getSpace(), IFluidHandler.FluidAction.EXECUTE);
            }
        }
        if (compound.m_128441_("ForceFluidLevel") || this.fluidLevel == null) {
            this.fluidLevel = LerpedFloat.linear().startWithValue((double)this.getFillState());
        }
        if (!clientPacket) {
            return;
        }
        boolean bl = controllerBefore == null ? this.controller != null : (changeOfController = !controllerBefore.equals((Object)this.controller));
        if (changeOfController || prevSize != this.width || prevHeight != this.height) {
            if (this.m_58898_()) {
                this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 16);
            }
            if (this.isController()) {
                this.tankInventory.setCapacity(DistillationTankBlockEntity.getCapacityMultiplier() * this.getTotalTankSize());
            }
            this.invalidateRenderBoundingBox();
        }
        if (this.isController()) {
            float fillState = this.getFillState();
            if (compound.m_128441_("ForceFluidLevel") || this.fluidLevel == null) {
                this.fluidLevel = LerpedFloat.linear().startWithValue((double)fillState);
            }
            this.fluidLevel.chase((double)fillState, 0.5, LerpedFloat.Chaser.EXP);
            this.processingTime = compound.m_128451_("Progress");
        }
        if (this.luminosity != prevLum && this.m_58898_()) {
            this.f_58857_.m_7726_().m_7827_().m_7174_(this.f_58858_);
        }
        if (compound.m_128441_("LazySync")) {
            this.fluidLevel.chase((double)this.fluidLevel.getChaseTarget(), 0.125, LerpedFloat.Chaser.EXP);
        }
        this.updateTemperature();
        List<Recipe<?>> r = this.getMatchingRecipes();
        if (!r.isEmpty()) {
            this.currentRecipe = (DistillationRecipe)r.get(0);
            if (this.processingTime <= 0) {
                this.startProcessing();
            }
        }
    }

    public float getFillState() {
        return (float)this.tankInventory.getFluidAmount() / (float)this.tankInventory.getCapacity();
    }

    public void write(CompoundTag compound, boolean clientPacket) {
        if (this.updateConnectivity) {
            compound.m_128379_("Uninitialized", true);
        }
        if (this.lastKnownPos != null) {
            compound.m_128365_("LastKnownPos", (Tag)NbtUtils.m_129224_((BlockPos)this.lastKnownPos));
        }
        if (!this.isController()) {
            compound.m_128365_("Controller", (Tag)NbtUtils.m_129224_((BlockPos)this.controller));
        }
        if (this.isController()) {
            compound.m_128379_("Window", this.window);
            compound.m_128365_("TankContent", (Tag)this.tankInventory.writeToNBT(new CompoundTag()));
            compound.m_128405_("Size", this.width);
            compound.m_128405_("Height", this.height);
            compound.m_128405_("Progress", this.processingTime);
        }
        compound.m_128405_("Luminosity", this.luminosity);
        super.write(compound, clientPacket);
        if (!clientPacket) {
            return;
        }
        if (this.forceFluidLevelUpdate) {
            compound.m_128379_("ForceFluidLevel", true);
        }
        if (this.queuedSync) {
            compound.m_128379_("LazySync", true);
        }
        this.forceFluidLevelUpdate = false;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (!this.fluidCapability.isPresent()) {
            this.refreshCapability();
        }
        if (cap == ForgeCapabilities.FLUID_HANDLER) {
            return this.fluidCapability.cast();
        }
        return super.getCapability(cap, side);
    }

    public void invalidate() {
        super.invalidate();
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
    }

    public int getTotalTankSize() {
        return this.width * this.width;
    }

    public static int getCapacityMultiplier() {
        return (Integer)AllConfigs.server().fluids.fluidTankCapacity.get() * 1000;
    }

    public LerpedFloat getFluidLevel() {
        return this.fluidLevel;
    }

    public void preventConnectivityUpdate() {
        this.updateConnectivity = false;
    }

    public void notifyMultiUpdated() {
        BlockState state = this.m_58900_();
        if (DistillationTankBlock.isTank(state)) {
            state = (BlockState)state.m_61124_((Property)DistillationTankBlock.BOTTOM, (Comparable)Boolean.valueOf(this.getBottomConnectivity()));
            state = (BlockState)state.m_61124_((Property)DistillationTankBlock.TOP, (Comparable)Boolean.valueOf(this.getTopConnectivity()));
            this.f_58857_.m_7731_(this.m_58899_(), state, 6);
        }
        if (this.isController()) {
            this.setWindows(this.window);
        }
        this.onFluidStackChanged(this.tankInventory.getFluid());
        this.m_6596_();
    }

    private boolean getBottomConnectivity() {
        BlockEntity blockEntity = this.f_58857_.m_7702_(this.m_58899_().m_7495_());
        if (blockEntity instanceof DistillationTankBlockEntity) {
            DistillationTankBlockEntity be = (DistillationTankBlockEntity)blockEntity;
            return !this.isSameMultiBlock(be);
        }
        return true;
    }

    private boolean getTopConnectivity() {
        BlockEntity blockEntity = this.f_58857_.m_7702_(this.m_58899_().m_7494_());
        if (blockEntity instanceof DistillationTankBlockEntity) {
            DistillationTankBlockEntity be = (DistillationTankBlockEntity)blockEntity;
            return !this.isSameMultiBlock(be);
        }
        return true;
    }

    public void setExtraData(@Nullable Object data) {
        if (data instanceof Boolean) {
            this.window = (Boolean)data;
        }
    }

    @Nullable
    public Object getExtraData() {
        return this.window;
    }

    public Object modifyExtraData(Object data) {
        if (data instanceof Boolean) {
            Boolean windows = (Boolean)data;
            windows = windows | this.window;
            return windows;
        }
        return data;
    }

    public Direction.Axis getMainConnectionAxis() {
        return Direction.Axis.Y;
    }

    public int getMaxLength(Direction.Axis longAxis, int width) {
        if (longAxis == Direction.Axis.Y) {
            return 1;
        }
        return this.getMaxWidth();
    }

    public int getMaxWidth() {
        return 3;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public boolean hasTank() {
        return true;
    }

    public int getTankSize(int tank) {
        return DistillationTankBlockEntity.getCapacityMultiplier();
    }

    public void setTankSize(int tank, int blocks) {
        this.applyFluidTankSize(blocks);
    }

    public IFluidTank getTank(int tank) {
        return this.tankInventory;
    }

    public FluidStack getFluid(int tank) {
        return this.tankInventory.getFluid().copy();
    }

    public void updateVerticalMulti() {
        BlockEntity blockEntity;
        BlockState state = this.m_58900_();
        if (DistillationTankBlock.isTank(state)) {
            state = (BlockState)state.m_61124_((Property)DistillationTankBlock.BOTTOM, (Comparable)Boolean.valueOf(this.getBottomConnectivity()));
            if ((state = (BlockState)state.m_61124_((Property)DistillationTankBlock.TOP, (Comparable)Boolean.valueOf(this.getTopConnectivity()))) != this.m_58900_()) {
                this.f_58857_.m_7731_(this.m_58899_(), state, 3);
            }
        }
        if ((blockEntity = this.f_58857_.m_7702_(this.m_58899_().m_7495_())) instanceof DistillationTankBlockEntity) {
            DistillationTankBlockEntity be = (DistillationTankBlockEntity)blockEntity;
            be.updateVerticalMulti();
        }
    }

    public boolean isBottom() {
        DistillationTankBlockEntity be;
        BlockEntity blockEntity = this.f_58857_.m_7702_(this.m_58899_().m_7495_());
        return !(blockEntity instanceof DistillationTankBlockEntity && this.isSameMultiBlock(be = (DistillationTankBlockEntity)blockEntity));
    }

    void checkForRecipes() {
        this.f_58857_.m_46473_().m_6180_("recipeFinding");
        if (this.processingTime <= -1) {
            List<Recipe<?>> r = this.getMatchingRecipes();
            if (!r.isEmpty()) {
                this.currentRecipe = (DistillationRecipe)r.get(0);
                this.startProcessing();
            } else {
                this.currentRecipe = null;
            }
        }
        this.f_58857_.m_46473_().m_7238_();
    }

    private boolean isSameMultiBlock(DistillationTankBlockEntity be) {
        DistillationTankBlockEntity otherControllerBE = be.getControllerBE();
        DistillationTankBlockEntity controllerBE = this.getControllerBE();
        if (otherControllerBE == null || controllerBE == null) {
            return false;
        }
        if (otherControllerBE == controllerBE) {
            return true;
        }
        if (otherControllerBE.m_58899_().m_123341_() == controllerBE.m_58899_().m_123341_() && otherControllerBE.m_58899_().m_123343_() == controllerBE.m_58899_().m_123343_()) {
            return otherControllerBE.width == controllerBE.width;
        }
        return false;
    }

    public void updateTemperature() {
        if (!this.isBottom()) {
            return;
        }
        if (this.isController()) {
            this.currentHeating = this.getHeat();
            this.sendData();
            this.checkForRecipes();
            return;
        }
        DistillationTankBlockEntity be = this.getControllerBE();
        if (be == null) {
            return;
        }
        be.updateTemperature();
    }
}

