/*
 * Decompiled with CFR 0.152.
 */
package com.jesz.createdieselgenerators.content.diesel_engine.huge;

import com.jesz.createdieselgenerators.content.diesel_engine.huge.HugeDieselEngineBlock;
import com.simibubi.create.content.kinetics.base.GeneratingKineticBlockEntity;
import com.simibubi.create.content.kinetics.base.RotatedPillarKineticBlock;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import net.createmod.catnip.data.Couple;
import net.createmod.catnip.data.Pair;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class PoweredEngineShaftBlockEntity
extends GeneratingKineticBlockEntity {
    float stressCapacity;
    float speed;
    int movementDirection = 0;
    int initialTicks;
    public List<Pair<BlockPos, Couple<Float>>> engines = new ArrayList<Pair<BlockPos, Couple<Float>>>(4);
    public float currentStressPitch = 0.0f;
    float targetStressPitch = 0.0f;

    public PoweredEngineShaftBlockEntity(BlockEntityType<?> typeIn, BlockPos pos, BlockState state) {
        super(typeIn, pos, state);
    }

    public boolean isEngineForConnectorDisplay(BlockPos pos) {
        Direction.Axis axis = (Direction.Axis)this.m_58900_().m_61143_((Property)RotatedPillarKineticBlock.AXIS);
        for (Direction d : List.of(axis == Direction.Axis.Z ? Direction.UP : Direction.NORTH, axis == Direction.Axis.Z ? Direction.DOWN : Direction.SOUTH, axis == Direction.Axis.X ? Direction.UP : Direction.EAST, axis == Direction.Axis.X ? Direction.DOWN : Direction.WEST)) {
            BlockState st = this.m_58904_().m_8055_(this.m_58899_().m_5484_(d, 2));
            if (!(st.m_60734_() instanceof HugeDieselEngineBlock) || st.m_61143_((Property)HugeDieselEngineBlock.FACING) != d.m_122424_()) continue;
            return this.m_58899_().m_5484_(d, 2).equals((Object)pos);
        }
        return false;
    }

    public void update(BlockPos sourcePos, int direction, float stress, float speed) {
        boolean found = false;
        for (Pair<BlockPos, Couple<Float>> engine : this.engines) {
            if (!((BlockPos)engine.getFirst()).equals((Object)sourcePos)) continue;
            found = true;
            break;
        }
        if (!found) {
            this.engines.add((Pair<BlockPos, Couple<Float>>)Pair.of((Object)sourcePos, (Object)Couple.create((Object)Float.valueOf(stress), (Object)Float.valueOf(speed))));
        }
        AtomicReference<Float> maxSpeed = new AtomicReference<Float>(Float.valueOf(0.0f));
        for (Pair<BlockPos, Couple<Float>> engine : this.engines) {
            if (!(((Float)((Couple)engine.getSecond()).getSecond()).floatValue() > maxSpeed.get().floatValue())) continue;
            maxSpeed.set((Float)((Couple)engine.getSecond()).getSecond());
        }
        this.speed = maxSpeed.get().floatValue();
        this.movementDirection = direction;
        this.reActivateSource = true;
    }

    public boolean canBePoweredBy(BlockPos globalPos) {
        return this.initialTicks == 0;
    }

    public void removeGenerator(BlockPos sourcePos) {
        this.engines.removeIf(p -> ((BlockPos)p.getFirst()).equals((Object)sourcePos));
        if (this.engines.isEmpty()) {
            this.movementDirection = 0;
            this.speed = 0.0f;
            this.stressCapacity = 0.0f;
        }
        this.reActivateSource = true;
    }

    protected void write(CompoundTag compound, boolean clientPacket) {
        super.write(compound, clientPacket);
        compound.m_128405_("Direction", this.movementDirection);
        if (this.initialTicks > 0) {
            compound.m_128405_("Warmup", this.initialTicks);
        }
        ListTag engineList = new ListTag();
        for (Pair<BlockPos, Couple<Float>> engine : this.engines) {
            CompoundTag tag = new CompoundTag();
            tag.m_128350_("Capacity", ((Float)((Couple)engine.getSecond()).getFirst()).floatValue());
            tag.m_128350_("Speed", ((Float)((Couple)engine.getSecond()).getSecond()).floatValue());
            tag.m_128365_("Pos", (Tag)NbtUtils.m_129224_((BlockPos)((BlockPos)engine.getFirst())));
            engineList.add((Object)tag);
        }
        compound.m_128350_("GeneratedSpeed", this.speed);
        compound.m_128365_("Engines", (Tag)engineList);
        compound.m_128350_("Pitch", this.targetStressPitch);
    }

    protected void read(CompoundTag compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        this.movementDirection = compound.m_128451_("Direction");
        this.initialTicks = compound.m_128451_("Warmup");
        ListTag engineList = compound.m_128437_("Engines", 10);
        this.engines.clear();
        for (int i = 0; i < engineList.size(); ++i) {
            this.engines.add((Pair<BlockPos, Couple<Float>>)Pair.of((Object)NbtUtils.m_129239_((CompoundTag)engineList.m_128728_(i).m_128469_("Pos")), (Object)Couple.create((Object)Float.valueOf(engineList.m_128728_(i).m_128457_("Capacity")), (Object)Float.valueOf(engineList.m_128728_(i).m_128457_("Speed")))));
        }
        this.engines.clear();
        this.speed = compound.m_128457_("GeneratedSpeed");
        this.targetStressPitch = compound.m_128457_("Pitch");
    }

    public float getGeneratedSpeed() {
        return (float)this.movementDirection * this.speed;
    }

    public float calculateAddedStressCapacity() {
        if (this.movementDirection == 0) {
            return 0.0f;
        }
        float capacity = 0.0f;
        for (Pair<BlockPos, Couple<Float>> engine : this.engines) {
            capacity += ((Float)((Couple)engine.getSecond()).getFirst()).floatValue();
        }
        this.lastCapacityProvided = capacity;
        return capacity;
    }

    public int getRotationAngleOffset(Direction.Axis axis) {
        int combinedCoords = axis.m_7863_(this.f_58858_.m_123341_(), this.f_58858_.m_123342_(), this.f_58858_.m_123343_());
        return super.getRotationAngleOffset(axis) + (combinedCoords % 2 == 0 ? 180 : 0);
    }

    public void updateFromNetwork(float maxStress, float currentStress, int networkSize) {
        super.updateFromNetwork(maxStress, currentStress, networkSize);
        this.targetStressPitch = maxStress == 0.0f ? 0.0f : currentStress / maxStress * 4.0f;
        this.sendData();
    }

    public void tick() {
        super.tick();
        this.currentStressPitch = Mth.m_14179_((float)0.2f, (float)this.currentStressPitch, (float)this.targetStressPitch);
    }
}

