/*
 * Decompiled with CFR 0.152.
 */
package com.jesz.createdieselgenerators.content.diesel_engine;

import com.jesz.createdieselgenerators.CDGConfig;
import com.jesz.createdieselgenerators.CDGItems;
import com.jesz.createdieselgenerators.CDGPartialModels;
import com.jesz.createdieselgenerators.CreateDieselGenerators;
import com.jesz.createdieselgenerators.content.diesel_engine.IEngine;
import com.jesz.createdieselgenerators.content.diesel_engine.huge.HugeDieselEngineBlock;
import com.jesz.createdieselgenerators.content.diesel_engine.huge.HugeDieselEngineBlockEntity;
import com.jesz.createdieselgenerators.content.diesel_engine.modular.ModularDieselEngineBlock;
import com.jesz.createdieselgenerators.content.diesel_engine.modular.ModularDieselEngineBlockEntity;
import com.jesz.createdieselgenerators.content.diesel_engine.normal.DieselEngineBlock;
import com.jesz.createdieselgenerators.content.diesel_engine.normal.DieselEngineBlockEntity;
import com.jesz.createdieselgenerators.fuel_type.FuelTypeManager;
import com.mojang.blaze3d.vertex.PoseStack;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import java.util.ArrayList;
import java.util.List;
import net.createmod.catnip.render.CachedBuffers;
import net.createmod.catnip.render.SuperByteBuffer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public interface EngineUpgrades {
    public static final List<EngineUpgrades> allUpgrades = new ArrayList<EngineUpgrades>();
    public static final EngineUpgrades NONE = EngineUpgrades.add(new NoUpgrade());
    public static final EngineUpgrades SILENCER = EngineUpgrades.add(new SilencerUpgrade());
    public static final EngineUpgrades TURBOCHARGER = EngineUpgrades.add(new TurbochargerUpgrade());

    public static EngineUpgrades add(EngineUpgrades upgrade) {
        allUpgrades.add(upgrade);
        return upgrade;
    }

    public ResourceLocation getId();

    default public boolean canAddOn(IEngine engine) {
        return true;
    }

    default public float getSpeed(float speed, IEngine engine) {
        return speed;
    }

    default public float getStress(float stress, IEngine engine) {
        return stress;
    }

    default public void playSounds(int tick, IEngine engine) {
        if (tick % Math.max(1, FuelTypeManager.getSoundSpeed(engine.fs().getFluid())) == 0) {
            engine.playSound();
        }
    }

    public ItemStack getItem();

    default public void render(BlockEntity be, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light) {
    }

    public static void renderPartial(BlockEntity be, PoseStack ms, MultiBufferSource buffer, PartialModel normalModel, PartialModel normalVerticalModel, PartialModel modularModel, PartialModel hugeModel, int light) {
        if (be instanceof DieselEngineBlockEntity) {
            Direction facing = (Direction)be.m_58900_().m_61143_((Property)DieselEngineBlock.FACING);
            if (facing.m_122434_() == Direction.Axis.Y) {
                ((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)CachedBuffers.partial((PartialModel)normalVerticalModel, (BlockState)be.m_58900_()).center()).rotateYDegrees(facing.m_122421_() == Direction.AxisDirection.POSITIVE ? 270.0f : 180.0f)).uncenter()).light(light).renderInto(ms, buffer.m_6299_(RenderType.m_110463_()));
            } else {
                ((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)CachedBuffers.partial((PartialModel)normalModel, (BlockState)be.m_58900_()).center()).rotateYDegrees(facing.m_122435_())).uncenter()).light(light).renderInto(ms, buffer.m_6299_(RenderType.m_110463_()));
            }
        } else if (be instanceof ModularDieselEngineBlockEntity) {
            Direction facing = (Direction)be.m_58900_().m_61143_((Property)ModularDieselEngineBlock.FACING);
            ((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)CachedBuffers.partial((PartialModel)modularModel, (BlockState)be.m_58900_()).center()).rotateYDegrees(facing.m_122435_())).uncenter()).light(light).renderInto(ms, buffer.m_6299_(RenderType.m_110463_()));
        } else if (be instanceof HugeDieselEngineBlockEntity) {
            Direction facing = (Direction)be.m_58900_().m_61143_((Property)HugeDieselEngineBlock.FACING);
            if (facing.m_122434_() == Direction.Axis.Y) {
                ((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)CachedBuffers.partial((PartialModel)hugeModel, (BlockState)be.m_58900_()).center()).rotateZ(90.0f)).rotateYDegrees(facing.m_122421_() == Direction.AxisDirection.POSITIVE ? 270.0f : 180.0f)).uncenter()).light(light).renderInto(ms, buffer.m_6299_(RenderType.m_110463_()));
            } else {
                ((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)CachedBuffers.partial((PartialModel)hugeModel, (BlockState)be.m_58900_()).center()).rotateYDegrees(facing.m_122435_())).uncenter()).light(light).renderInto(ms, buffer.m_6299_(RenderType.m_110463_()));
            }
        }
    }

    public static class NoUpgrade
    implements EngineUpgrades {
        @Override
        public ResourceLocation getId() {
            return CreateDieselGenerators.rl("none");
        }

        @Override
        public ItemStack getItem() {
            return ItemStack.f_41583_;
        }
    }

    public static class SilencerUpgrade
    implements EngineUpgrades {
        @Override
        public ResourceLocation getId() {
            return CreateDieselGenerators.rl("silencer");
        }

        @Override
        public void render(BlockEntity be, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light) {
            EngineUpgrades.renderPartial(be, ms, buffer, CDGPartialModels.ENGINE_SILENCER, CDGPartialModels.ENGINE_SILENCER_VERTICAL, CDGPartialModels.MODULAR_ENGINE_SILENCER, CDGPartialModels.HUGE_ENGINE_SILENCER, light);
        }

        @Override
        public void playSounds(int tick, IEngine engine) {
        }

        @Override
        public ItemStack getItem() {
            return ((Item)CDGItems.ENGINE_SILENCER.get()).m_7968_();
        }
    }

    public static class TurbochargerUpgrade
    implements EngineUpgrades {
        @Override
        public ResourceLocation getId() {
            return CreateDieselGenerators.rl("turbocharger");
        }

        @Override
        public float getSpeed(float speed, IEngine engine) {
            return (float)((double)speed * (Double)CDGConfig.TURBOCHARGED_ENGINE_MULTIPLIER.get());
        }

        @Override
        public float getStress(float stress, IEngine engine) {
            return (float)((double)stress * (Double)CDGConfig.TURBOCHARGED_ENGINE_MULTIPLIER.get());
        }

        @Override
        public void render(BlockEntity be, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light) {
            EngineUpgrades.renderPartial(be, ms, buffer, CDGPartialModels.ENGINE_TURBOCHARGER, CDGPartialModels.ENGINE_TURBOCHARGER_VERTICAL, CDGPartialModels.MODULAR_TURBOCHARGER, CDGPartialModels.ENGINE_TURBOCHARGER, light);
        }

        @Override
        public void playSounds(int tick, IEngine engine) {
            if (tick % Math.max(1, FuelTypeManager.getSoundSpeed(engine.fs().getFluid()) / 2) == 0) {
                engine.playSound();
            }
        }

        @Override
        public ItemStack getItem() {
            return ((Item)CDGItems.ENGINE_TURBO.get()).m_7968_();
        }

        @Override
        public boolean canAddOn(IEngine engine) {
            return engine instanceof DieselEngineBlockEntity || engine instanceof ModularDieselEngineBlockEntity;
        }
    }
}

