/*
 * Decompiled with CFR 0.152.
 */
package com.jesz.createdieselgenerators.content.burner;

import com.jesz.createdieselgenerators.content.burner.BurnerBlock;
import com.jesz.createdieselgenerators.fuel_type.FuelTypeManager;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.processing.burner.BlazeBurnerBlock;
import com.simibubi.create.foundation.fluid.SmartFluidTank;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class BurnerBlockEntity
extends KineticBlockEntity {
    public float heat = -1.0f;
    SmartFluidTank tank = new SmartFluidTank(100, this::onFluidStackChanged);
    public float valveState = 0.2f;
    public float prevValveState;
    int tick;
    float multiplier;
    boolean ignited = false;
    int ignitionTries;
    int x = 0;
    int y = 0;
    Fluid lastFluid;

    public void tick() {
        boolean containsValidFuel;
        this.tick = (this.tick + 1) % 40000;
        super.tick();
        this.prevValveState = this.valveState;
        this.valveState = Mth.m_14036_((float)(this.valveState + this.getSpeed() / 5000.0f), (float)0.0f, (float)1.0f);
        float multiplier = 0.0f;
        boolean bl = containsValidFuel = !this.tank.getFluid().isEmpty();
        if (containsValidFuel) {
            multiplier = this.multiplier;
        }
        if (multiplier == 0.0f) {
            containsValidFuel = false;
        }
        if (this.valveState == 0.0f || !containsValidFuel) {
            this.heat = -1.0f;
            if (!this.f_58857_.f_46443_) {
                if (this.ignited) {
                    this.f_58857_.m_5594_(null, this.f_58858_, SoundEvents.f_11937_, SoundSource.BLOCKS, 0.3f, this.f_58857_.m_213780_().m_188501_() * 0.4f + 0.7f);
                }
                this.ignited = false;
                this.ignitionTries = 0;
            }
        }
        if (containsValidFuel && this.valveState != 0.0f) {
            this.heat = (this.valveState + 1.0f) * multiplier;
            if (this.f_58857_.f_46443_) {
                return;
            }
            if (this.tick % 5 == 0 && !this.ignited) {
                this.f_58857_.m_5594_(null, this.f_58858_, SoundEvents.f_11942_, SoundSource.BLOCKS, 1.5f, this.f_58857_.m_213780_().m_188501_() * 0.4f + 0.7f);
                ++this.ignitionTries;
                if (this.ignitionTries > 4) {
                    this.ignited = true;
                }
            }
            if ((int)((float)this.tick % (10.0f / this.valveState)) == 0) {
                this.tank.drain(1, IFluidHandler.FluidAction.EXECUTE);
                this.sendData();
                this.m_6596_();
            }
        }
        if (this.f_58857_.f_46443_) {
            return;
        }
        if (this.m_58900_().m_61143_(BurnerBlock.HEAT_LEVEL) != this.calculateHeatLevel(this.heat)) {
            this.f_58857_.m_46597_(this.f_58858_, (BlockState)((BlockState)this.m_58900_().m_61124_(BurnerBlock.HEAT_LEVEL, (Comparable)this.calculateHeatLevel(this.heat))).m_61124_((Property)BurnerBlock.LIT, (Comparable)Boolean.valueOf(this.heat > 0.0f)));
            this.notifyUpdate();
        }
    }

    public void tickAudio() {
        super.tickAudio();
        if (this.valveState == 0.0f || this.heat == -1.0f) {
            return;
        }
        RandomSource random = RandomSource.m_216327_();
        if (this.tick % 100 == 0) {
            this.f_58857_.m_7785_((double)this.f_58858_.m_123341_(), (double)this.f_58858_.m_123342_(), (double)this.f_58858_.m_123343_(), SoundEvents.f_11936_, SoundSource.BLOCKS, 0.3f, 1.0f, true);
        }
        this.x = (this.x + 1) % 4;
        if (this.x == 3) {
            this.y = (this.y + 1) % 4;
        }
        if (this.x != 0 && this.x != 3 && this.y != 0 && this.y != 3) {
            return;
        }
        if (this.heat >= 1.8f && random.m_216339_(0, (int)(1.0f + this.heat * 2.0f)) != 1) {
            this.f_58857_.m_7106_((ParticleOptions)ParticleTypes.f_123745_, (double)this.f_58858_.m_123341_() + 0.3475 + (double)this.x / 9.0, (double)this.f_58858_.m_123342_() + 0.75, (double)this.f_58858_.m_123343_() + 0.3475 + (double)this.y / 9.0, 0.0, 0.02 * (double)this.valveState, 0.0);
            return;
        }
        this.f_58857_.m_7106_((ParticleOptions)ParticleTypes.f_123744_, (double)this.f_58858_.m_123341_() + 0.3475 + (double)((float)this.x / 9.0f), (double)this.f_58858_.m_123342_() + 0.75, (double)this.f_58858_.m_123343_() + 0.3475 + (double)((float)this.y / 9.0f), 0.0, 0.02 * (double)this.valveState, 0.0);
        this.f_58857_.m_7106_((ParticleOptions)ParticleTypes.f_123762_, (double)this.f_58858_.m_123341_() + 0.3475 + (double)((float)this.x / 9.0f), (double)this.f_58858_.m_123342_() + 0.75, (double)this.f_58858_.m_123343_() + 0.3475 + (double)((float)this.y / 9.0f), 0.0, 0.02 * (double)this.valveState, 0.0);
    }

    void onFluidStackChanged(FluidStack stack) {
        if (this.lastFluid != stack.getFluid()) {
            this.multiplier = FuelTypeManager.getBurnerStrength(this.tank.getFluid().getRawFluid());
        }
        this.lastFluid = stack.getFluid();
    }

    public BlazeBurnerBlock.HeatLevel calculateHeatLevel(float heat) {
        if ((double)heat >= 1.8) {
            return BlazeBurnerBlock.HeatLevel.SEETHING;
        }
        if ((double)heat >= 1.4) {
            return BlazeBurnerBlock.HeatLevel.KINDLED;
        }
        if ((double)heat >= 1.2) {
            return BlazeBurnerBlock.HeatLevel.FADING;
        }
        if (heat >= 1.0f) {
            return BlazeBurnerBlock.HeatLevel.SMOULDERING;
        }
        return BlazeBurnerBlock.HeatLevel.NONE;
    }

    protected void write(CompoundTag compound, boolean clientPacket) {
        compound.m_128350_("ValveState", this.valveState);
        compound.m_128350_("Heat", this.heat);
        compound.m_128405_("Tick", this.tick);
        compound.m_128365_("FluidContent", (Tag)this.tank.writeToNBT(new CompoundTag()));
        super.write(compound, clientPacket);
    }

    protected void read(CompoundTag compound, boolean clientPacket) {
        this.valveState = compound.m_128457_("ValveState");
        this.heat = compound.m_128457_("Heat");
        this.tick = compound.m_128451_("Tick");
        this.tank.readFromNBT(compound.m_128469_("FluidContent"));
        super.read(compound, clientPacket);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == ForgeCapabilities.FLUID_HANDLER) {
            return LazyOptional.of(() -> this.tank).cast();
        }
        return super.getCapability(cap, side);
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        return this.containedFluidTooltip(tooltip, isPlayerSneaking, LazyOptional.of(() -> this.tank));
    }

    public BurnerBlockEntity(BlockEntityType<?> typeIn, BlockPos pos, BlockState state) {
        super(typeIn, pos, state);
    }
}

