/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.recipe.serializer;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import mekanism.api.SerializerHelper;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.recipes.chemical.ItemStackChemicalToItemStackRecipe;
import mekanism.api.recipes.ingredients.ChemicalStackIngredient;
import mekanism.api.recipes.ingredients.ItemStackIngredient;
import mekanism.api.recipes.ingredients.creator.IngredientCreatorAccess;
import mekanism.common.Mekanism;
import mekanism.common.recipe.ingredient.chemical.ChemicalIngredientDeserializer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import org.jetbrains.annotations.NotNull;

public abstract class ItemStackChemicalToItemStackRecipeSerializer<CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>, INGREDIENT extends ChemicalStackIngredient<CHEMICAL, STACK>, RECIPE extends ItemStackChemicalToItemStackRecipe<CHEMICAL, STACK, INGREDIENT>>
implements RecipeSerializer<RECIPE> {
    private final IFactory<CHEMICAL, STACK, INGREDIENT, RECIPE> factory;

    protected ItemStackChemicalToItemStackRecipeSerializer(IFactory<CHEMICAL, STACK, INGREDIENT, RECIPE> factory) {
        this.factory = factory;
    }

    protected abstract ChemicalIngredientDeserializer<CHEMICAL, STACK, INGREDIENT> getDeserializer();

    @NotNull
    public RECIPE fromJson(@NotNull ResourceLocation recipeId, @NotNull JsonObject json) {
        JsonArray itemInput = GsonHelper.m_13885_((JsonObject)json, (String)"itemInput") ? GsonHelper.m_13933_((JsonObject)json, (String)"itemInput") : GsonHelper.m_13930_((JsonObject)json, (String)"itemInput");
        ItemStackIngredient itemIngredient = (ItemStackIngredient)IngredientCreatorAccess.item().deserialize((JsonElement)itemInput);
        JsonArray chemicalInput = GsonHelper.m_13885_((JsonObject)json, (String)"chemicalInput") ? GsonHelper.m_13933_((JsonObject)json, (String)"chemicalInput") : GsonHelper.m_13930_((JsonObject)json, (String)"chemicalInput");
        INGREDIENT chemicalIngredient = this.getDeserializer().deserialize((JsonElement)chemicalInput);
        ItemStack output = SerializerHelper.getItemStack(json, "output");
        if (output.m_41619_()) {
            throw new JsonSyntaxException("Recipe output must not be empty.");
        }
        return this.factory.create(recipeId, itemIngredient, chemicalIngredient, output);
    }

    public RECIPE fromNetwork(@NotNull ResourceLocation recipeId, @NotNull FriendlyByteBuf buffer) {
        try {
            ItemStackIngredient itemInput = (ItemStackIngredient)IngredientCreatorAccess.item().read(buffer);
            INGREDIENT chemicalInput = this.getDeserializer().read(buffer);
            ItemStack output = buffer.m_130267_();
            return this.factory.create(recipeId, itemInput, chemicalInput, output);
        }
        catch (Exception e) {
            Mekanism.logger.error("Error reading itemstack chemical to itemstack recipe from packet.", (Throwable)e);
            throw e;
        }
    }

    public void toNetwork(@NotNull FriendlyByteBuf buffer, @NotNull RECIPE recipe) {
        try {
            ((ItemStackChemicalToItemStackRecipe)recipe).write(buffer);
        }
        catch (Exception e) {
            Mekanism.logger.error("Error writing itemstack chemical to itemstack recipe to packet.", (Throwable)e);
            throw e;
        }
    }

    @FunctionalInterface
    public static interface IFactory<CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>, INGREDIENT extends ChemicalStackIngredient<CHEMICAL, STACK>, RECIPE extends ItemStackChemicalToItemStackRecipe<CHEMICAL, STACK, INGREDIENT>> {
        public RECIPE create(ResourceLocation var1, ItemStackIngredient var2, INGREDIENT var3, ItemStack var4);
    }
}

