/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element.custom.module;

import java.util.List;
import mekanism.api.gear.config.ModuleEnumData;
import mekanism.api.text.IHasTextComponent;
import mekanism.client.gui.element.custom.module.GuiModuleScreen;
import mekanism.client.gui.element.custom.module.MiniElement;
import mekanism.common.content.gear.ModuleConfigItem;
import mekanism.common.util.MekanismUtils;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

class EnumToggle<TYPE extends Enum<TYPE>>
extends MiniElement {
    private static final ResourceLocation SLIDER = MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "slider.png");
    private static final float TEXT_SCALE = 0.7f;
    private static final int BAR_START = 10;
    private final int BAR_LENGTH;
    private final ModuleConfigItem<TYPE> data;
    private final int optionDistance;
    boolean dragging = false;

    EnumToggle(GuiModuleScreen parent, ModuleConfigItem<TYPE> data, int xPos, int yPos, int dataIndex) {
        super(parent, xPos, yPos, dataIndex);
        this.data = data;
        this.BAR_LENGTH = this.parent.getScreenWidth() - 24;
        this.optionDistance = this.BAR_LENGTH / (this.getData().getEnums().size() - 1);
    }

    @Override
    protected int getNeededHeight() {
        return 28;
    }

    private ModuleEnumData<TYPE> getData() {
        return (ModuleEnumData)this.data.getData();
    }

    @Override
    protected void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        int center = this.optionDistance * ((Enum)this.data.get()).ordinal();
        guiGraphics.m_280163_(SLIDER, this.getRelativeX() + 10 + center - 2, this.getRelativeY() + 11, 0.0f, 0.0f, 5, 6, 8, 8);
        guiGraphics.m_280163_(SLIDER, this.getRelativeX() + 10, this.getRelativeY() + 17, 0.0f, 6.0f, this.BAR_LENGTH, 2, 8, 8);
    }

    @Override
    protected void renderForeground(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        int textColor = this.parent.screenTextColor();
        this.parent.drawTextWithScale(guiGraphics, this.data.getDescription(), this.getRelativeX() + 3, this.getRelativeY(), textColor, 0.8f);
        List<TYPE> options = this.getData().getEnums();
        int count = options.size();
        for (int i = 0; i < count; ++i) {
            int center = this.optionDistance * i;
            Component text = ((IHasTextComponent)((Object)((Enum)options.get(i)))).getTextComponent();
            int textWidth = this.parent.getStringWidth(text);
            float widthScaling = (float)textWidth / 2.0f * 0.7f;
            float left = (float)(10 + center) - widthScaling;
            if (left < 0.0f) {
                left = 0.0f;
            } else {
                int max = this.parent.getScreenWidth() - 1;
                int end = this.xPos + (int)Math.ceil(left + (float)textWidth * 0.7f);
                if (end > max) {
                    left -= (float)(end - max);
                }
            }
            this.parent.drawTextWithScale(guiGraphics, text, (float)this.getRelativeX() + left, this.getRelativeY() + 20, textColor, 0.7f);
        }
    }

    @Override
    protected void click(double mouseX, double mouseY) {
        if (!this.dragging) {
            int center = this.optionDistance * ((Enum)this.data.get()).ordinal();
            if (this.mouseOver(mouseX, mouseY, 10 + center - 2, 11, 5, 6)) {
                this.dragging = true;
            } else if (this.mouseOver(mouseX, mouseY, 10, 10, this.BAR_LENGTH, 12)) {
                this.setData(this.getData().getEnums(), mouseX);
            }
        }
    }

    @Override
    protected void onDrag(double mouseX, double mouseY, double deltaX, double deltaY) {
        if (this.dragging) {
            this.setData(this.getData().getEnums(), mouseX);
        }
    }

    private void setData(List<TYPE> options, double mouseX) {
        int size = options.size() - 1;
        int cur = (int)Math.round((mouseX - (double)this.getX() - 10.0) / (double)this.BAR_LENGTH * (double)size);
        if ((cur = Mth.m_14045_((int)cur, (int)0, (int)size)) != ((Enum)this.data.get()).ordinal()) {
            this.setData(this.data, (Enum)options.get(cur));
        }
    }

    @Override
    protected void release(double mouseX, double mouseY) {
        this.dragging = false;
    }
}

