/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.gear.config;

import java.util.Objects;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.gear.config.ModuleConfigData;
import net.minecraft.nbt.CompoundTag;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@NothingNullByDefault
public class ModuleIntegerData
implements ModuleConfigData<Integer> {
    private int value;

    protected ModuleIntegerData(int def) {
        this.value = def;
    }

    protected int sanitizeValue(int value) {
        return value;
    }

    @Override
    public Integer get() {
        return this.value;
    }

    @Override
    public void set(Integer val) {
        Objects.requireNonNull(val, "Value cannot be null.");
        this.value = this.sanitizeValue(val);
    }

    @Override
    public void read(String name, CompoundTag tag) {
        Objects.requireNonNull(tag, "Tag cannot be null.");
        Objects.requireNonNull(name, "Name cannot be null.");
        this.value = this.sanitizeValue(tag.m_128451_(name));
    }

    @Override
    public void write(String name, CompoundTag tag) {
        Objects.requireNonNull(tag, "Tag cannot be null.");
        Objects.requireNonNull(name, "Name cannot be null.");
        tag.m_128405_(name, this.value);
    }
}

