/*
 * Decompiled with CFR 0.152.
 */
package ru.vidtu.ksyxis;

import java.util.List;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.CheckReturnValue;
import org.jetbrains.annotations.Contract;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;
import org.objectweb.asm.tree.ClassNode;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;
import org.spongepowered.asm.service.IClassBytecodeProvider;
import org.spongepowered.asm.service.MixinService;
import ru.vidtu.ksyxis.Ksyxis;

@NullMarked
@ApiStatus.Internal
public final class KsyxisPlugin
implements IMixinConfigPlugin {
    private static final String PLUGIN_ERROR = "Ksyxis: Unable to apply the Ksyxis plugin. It`s probably a bug or something, you should report it on GitHub. Ensure to include as much information (game version, loader type, loader version, mod version, other mods, logs, etc.) in the bug report as possible, this error screen is NOT enough. If you don`t want any hassles and just want to load the game without solving anything, delete the Ksyxis mod. (provider: %s, plugin: %s, targetClassName: %s, mixinClassName: %s)";
    private static final Logger LOGGER = LogManager.getLogger((String)"Ksyxis/KsyxisPlugin");
    private final IClassBytecodeProvider provider = MixinService.getService().getBytecodeProvider();

    @ApiStatus.Internal
    @Contract(pure=true)
    public KsyxisPlugin() {
    }

    @CheckReturnValue
    public boolean shouldApplyMixin(String targetClassName, String mixinClassName) {
        try {
            if (!mixinClassName.startsWith("ru.vidtu.ksyxis.mixins.")) {
                if (!LOGGER.isTraceEnabled()) {
                    return true;
                }
                LOGGER.trace("Ksyxis: Applying mixin, because it's not a part of Ksyxis. (provider: {}, plugin: {}, targetClassName: {}, mixinClassName: {})", new Object[]{this.provider, this, targetClassName, mixinClassName});
                return true;
            }
            ClassNode node = this.provider.getClassNode(targetClassName);
            if (node == null) {
                throw new NullPointerException("Ksyxis: Bytecode provider returned null. (provider: " + this.provider + ", plugin: " + this + ", targetClassName: " + targetClassName + ", mixinClassName: " + mixinClassName + ')');
            }
            if (!LOGGER.isDebugEnabled()) {
                return true;
            }
            LOGGER.debug("Ksyxis: Bytecode provider returned a valid node, applying mixin... (provider: {}, plugin: {}, targetClassName: {}, mixinClassName: {})", new Object[]{this.provider, this, targetClassName, mixinClassName});
            return true;
        }
        catch (ClassNotFoundException e) {
            if (!LOGGER.isDebugEnabled()) {
                return false;
            }
            LOGGER.debug("Ksyxis: Bytecode provider threw an exception, mixin WON'T be applied. (provider: {}, plugin: {}, targetClassName: {}, mixinClassName: {})", new Object[]{this.provider, this, targetClassName, mixinClassName, e});
            return false;
        }
        catch (Throwable t) {
            String message = String.format(PLUGIN_ERROR, this.provider, this, targetClassName, mixinClassName);
            throw Ksyxis.handleError(message, t);
        }
    }

    @Contract(pure=true)
    public void onLoad(String mixinPackage) {
    }

    @Contract(value="-> null", pure=true)
    public @Nullable String getRefMapperConfig() {
        return null;
    }

    @Contract(pure=true)
    public void acceptTargets(Set<String> myTargets, Set<String> otherTargets) {
    }

    @Contract(value="-> null", pure=true)
    public @Nullable List<String> getMixins() {
        return null;
    }

    @Contract(pure=true)
    public void preApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    @Contract(pure=true)
    public void postApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    @Contract(pure=true)
    public String toString() {
        return "Ksyxis/KsyxisPlugin{provider=" + this.provider + '}';
    }
}

