/*
 * Decompiled with CFR 0.152.
 */
package ru.vidtu.ksyxis;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.CheckReturnValue;
import org.jetbrains.annotations.Contract;
import org.jspecify.annotations.NullMarked;
import org.spongepowered.asm.launch.MixinBootstrap;
import org.spongepowered.asm.mixin.Mixins;

@NullMarked
public final class Ksyxis {
    public static final int SPAWN_CHUNKS = 441;
    private static final String MIXIN_ABSENT = "Ksyxis: No Mixin found. If you`re using old (1.15.2 or older) Forge, please install a Mixin loader, for example MixinBootstrap, MixinBooter, UniMixins, or any other at your choice. If you`re using new (1.16 or newer) Forge, any Fabric, any Quilt, any Ornithe, any LegacyFabric, or any NeoForge, then something went wrong and you should report it on GitHub. Ensure to include as much information (game version, loader type, loader version, mod version, other mods, logs, etc.) in the bug report as possible, this error screen is NOT enough. If you don`t want any hassles and just want to load the game without solving anything, delete the Ksyxis mod. (platform: %s; manual: %s)";
    private static final String MIXIN_INJECT = "Ksyxis: Unable to inject the Ksyxis configuration. It`s probably a bug or something, you should report it on GitHub. Ensure to include as much information (game version, loader type, loader version, mod version, other mods, logs, etc.) in the bug report as possible, this error screen is NOT enough. If you don`t want any hassles and just want to load the game without solving anything, delete the Ksyxis mod. (platform: %s; manual: %s)";
    private static final Logger LOGGER = LogManager.getLogger((String)"Ksyxis");
    public static final int LOADED_CHUNKS = Ksyxis.getLoadedChunks();

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    @Contract(value="-> fail", pure=true)
    private Ksyxis() {
        throw new AssertionError((Object)"No instances.");
    }

    public static void init(String platform, boolean manual) {
        try {
            long start = System.nanoTime();
            LOGGER.info("Ksyxis: Booting... (platform: {}, manual: {})", new Object[]{platform, manual});
            String mixinVersion = Ksyxis.obtainMixinVersion(platform, manual);
            LOGGER.info("Ksyxis: Found Mixin library. (version: {})", new Object[]{mixinVersion});
            if (manual) {
                MixinBootstrap.init();
                LOGGER.debug("Ksyxis: Mixin Bootstrap success.");
                Mixins.addConfiguration((String)"ksyxis.mixins.json");
                LOGGER.debug("Ksyxis: Mixin config added.");
            }
            LOGGER.info("Ksyxis: Ready. As always, this mod will speed up your world loading and might or might not break it. ({} ms)", new Object[]{(System.nanoTime() - start) / 1000000L});
        }
        catch (Throwable t) {
            String message = String.format(MIXIN_INJECT, platform, manual);
            throw Ksyxis.handleError(message, t);
        }
    }

    @Contract(value="_, _ -> fail")
    @CheckReturnValue
    static RuntimeException handleError(String message, Throwable error) {
        LOGGER.error(message, error);
        error.printStackTrace();
        try {
            Class<?> tinyFd = Class.forName("org.lwjgl.util.tinyfd.TinyFileDialogs");
            Method tinyFdMessageBox = tinyFd.getMethod("tinyfd_messageBox", CharSequence.class, CharSequence.class, CharSequence.class, CharSequence.class, Boolean.TYPE);
            tinyFdMessageBox.invoke(null, "Minecraft | Ksyxis Mod", message, "ok", "error", false);
        }
        catch (Throwable th) {
            error.addSuppressed(new RuntimeException("Unable to display the LWJGL3 error message. Maybe it's LWJGL2 or server here.", th));
        }
        try {
            Class<?> sys = Class.forName("org.lwjgl.Sys");
            Method sysAlert = sys.getMethod("alert", String.class, String.class);
            sysAlert.invoke(null, "Minecraft | Ksyxis Mod", message);
        }
        catch (Throwable th) {
            error.addSuppressed(new RuntimeException("Unable to display the LWJGL2 error message. Maybe it's LWJGL3 or server here.", th));
        }
        LOGGER.error(message, error);
        error.printStackTrace();
        try {
            System.exit(-2037852655);
        }
        catch (Throwable th) {
            error.addSuppressed(new RuntimeException("Unable to exit the game normally.", th));
        }
        LOGGER.error(message, error);
        error.printStackTrace();
        try {
            Class<?> shutdownClass = Class.forName("java.lang.Shutdown");
            Method shutdownMethod = shutdownClass.getDeclaredMethod("exit", Integer.TYPE);
            shutdownMethod.setAccessible(true);
            shutdownMethod.invoke(null, -2037852655);
        }
        catch (Throwable th) {
            error.addSuppressed(new RuntimeException("Unable to exit the game reflectively.", th));
        }
        LOGGER.error(message, error);
        error.printStackTrace();
        throw new RuntimeException(message, error);
    }

    @CheckReturnValue
    private static String obtainMixinVersion(String platform, boolean manual) {
        try {
            Field field = MixinBootstrap.class.getField("VERSION");
            Object obj = field.get(null);
            return String.valueOf(obj);
        }
        catch (Throwable t) {
            String message = String.format(MIXIN_ABSENT, platform, manual);
            throw Ksyxis.handleError(message, t);
        }
    }

    @Contract(pure=true)
    private static int getLoadedChunks() {
        try {
            Class<?> modernFixPluginClass = Class.forName("org.embeddedt.modernfix.core.ModernFixMixinPlugin");
            Field modernFixPluginField = modernFixPluginClass.getDeclaredField("instance");
            Method modernFixIsOptionEnabled = modernFixPluginClass.getMethod("isOptionEnabled", String.class);
            Object modernFix = modernFixPluginField.get(null);
            boolean removeSpawnChunks = (Boolean)modernFixIsOptionEnabled.invoke(modernFix, "perf.remove_spawn_chunks.MinecraftServer");
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Ksyxis: ModernFix's 'removeSpawnChunks' option is: {}", new Object[]{removeSpawnChunks});
            }
            return removeSpawnChunks ? 441 : 0;
        }
        catch (Throwable t) {
            LOGGER.debug("Ksyxis: Unable to provide compat for ModernFix, it's probably not installed.", t);
            return 0;
        }
    }
}

