/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.loader.stage1.gui;

import gg.essential.loader.stage1.gui.EssentialStyle;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

public class UpdatePromptUI
implements EssentialStyle {
    private final CompletableFuture<Boolean> closedFuture = new CompletableFuture();
    private final JFrame frame = this.makeFrame(it -> this.closedFuture.complete(null));
    private final String title;
    private final String description;

    public UpdatePromptUI(String title, String description) {
        this.title = title;
        this.description = description;
    }

    public void show() {
        ArrayList<JLabel> htmlLabels = new ArrayList<JLabel>();
        JPanel content = this.makeContent(this.frame);
        content.setBorder(new EmptyBorder(0, 57, 0, 57));
        content.add(Box.createHorizontalStrut(281));
        htmlLabels.add(this.makeTitle(content, this.html(this.centered(this.title))));
        JLabel explanation = new JLabel(this.html(this.centered(this.description)), 0);
        explanation.setMaximumSize(new Dimension(281, Integer.MAX_VALUE));
        explanation.setForeground(COLOR_FOREGROUND);
        explanation.setAlignmentX(0.5f);
        if (EssentialStyle.Fonts.medium != null) {
            explanation.setFont(EssentialStyle.Fonts.medium.deriveFont(16.0f));
        }
        content.add(explanation);
        htmlLabels.add(explanation);
        content.add(Box.createVerticalStrut(29));
        JPanel buttons = new JPanel();
        buttons.setOpaque(false);
        buttons.setLayout(new BoxLayout(buttons, 0));
        buttons.add(this.makeButton("Skip Update", COLOR_BUTTON, COLOR_BUTTON_HOVER, () -> this.closedFuture.complete(false)));
        buttons.add(Box.createHorizontalStrut(6));
        buttons.add(this.makeButton("Update Now", COLOR_PRIMARY_BUTTON, COLOR_PRIMARY_BUTTON_HOVER, () -> this.closedFuture.complete(true)));
        content.add(buttons);
        content.add(Box.createVerticalStrut(29));
        this.frame.pack();
        htmlLabels.forEach(this::fixJLabelHeight);
        this.frame.pack();
        this.frame.setLocationRelativeTo(null);
        this.frame.setVisible(true);
    }

    public Boolean waitForClose() {
        Boolean verdict = this.closedFuture.join();
        this.close();
        return verdict;
    }

    public void close() {
        this.frame.dispose();
    }

    public static void main(String[] args) {
        UpdatePromptUI ui = new UpdatePromptUI("Essential Loader Update!", "Short text of stuff we added in this fantastic update of ours, oh yeah, let's add more text.");
        ui.show();
        System.out.println(ui.waitForClose());
    }
}

