/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.overlay;

import com.google.common.base.Suppliers;
import com.mojang.text2speech.Narrator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.Direction;
import net.minecraft.util.StringUtil;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import snownee.jade.Jade;
import snownee.jade.api.Accessor;
import snownee.jade.api.EntityAccessor;
import snownee.jade.api.IJadeProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.callback.JadeRayTraceCallback;
import snownee.jade.api.callback.JadeTooltipCollectedCallback;
import snownee.jade.api.config.IWailaConfig;
import snownee.jade.api.theme.IThemeHelper;
import snownee.jade.gui.BaseOptionsScreen;
import snownee.jade.impl.ObjectDataCenter;
import snownee.jade.impl.Tooltip;
import snownee.jade.impl.WailaClientRegistration;
import snownee.jade.impl.WailaCommonRegistration;
import snownee.jade.impl.config.WailaConfig;
import snownee.jade.overlay.ProgressTracker;
import snownee.jade.overlay.RayTracing;
import snownee.jade.overlay.TooltipRenderer;
import snownee.jade.util.ClientProxy;

public class WailaTickHandler {
    private static WailaTickHandler INSTANCE = new WailaTickHandler();
    private static final Supplier<Narrator> NARRATOR = Suppliers.memoize(Narrator::getNarrator);
    private static String lastNarration = "";
    private static long lastNarrationTime = 0L;
    public TooltipRenderer tooltipRenderer = null;
    public ProgressTracker progressTracker = new ProgressTracker();

    public static WailaTickHandler instance() {
        if (INSTANCE == null) {
            INSTANCE = new WailaTickHandler();
        }
        return INSTANCE;
    }

    public static void narrate(ITooltip tooltip, boolean dedupe) {
        if (!NARRATOR.get().active() || tooltip.isEmpty()) {
            return;
        }
        if (System.currentTimeMillis() - lastNarrationTime < 500L) {
            return;
        }
        String narration = tooltip.getMessage();
        if (dedupe && narration.equals(lastNarration)) {
            return;
        }
        CompletableFuture.runAsync(() -> {
            Narrator narrator = NARRATOR.get();
            narrator.clear();
            narrator.say(StringUtil.m_14406_((String)narration), false);
        });
        lastNarration = narration;
        lastNarrationTime = System.currentTimeMillis();
    }

    public static void clearLastNarration() {
        lastNarration = "";
    }

    public void tickClient() {
        BlockHitResult blockTarget;
        this.progressTracker.tick();
        WailaConfig.ConfigGeneral config = Jade.CONFIG.get().getGeneral();
        if (!config.shouldDisplayTooltip()) {
            this.tooltipRenderer = null;
            return;
        }
        Minecraft client = Minecraft.m_91087_();
        if (!ClientProxy.shouldShowWithOverlay(client, client.f_91080_)) {
            return;
        }
        ClientLevel world = client.f_91073_;
        Entity entity = client.m_91288_();
        if (world == null || entity == null) {
            this.tooltipRenderer = null;
            return;
        }
        RayTracing.INSTANCE.fire();
        HitResult target = RayTracing.INSTANCE.getTarget();
        Tooltip tooltip = new Tooltip();
        if (target == null) {
            this.tooltipRenderer = null;
            return;
        }
        Accessor<EntityHitResult> accessor = null;
        if (target instanceof BlockHitResult && (blockTarget = (BlockHitResult)target).m_6662_() != HitResult.Type.MISS) {
            BlockState state = RayTracing.wrapBlock((BlockGetter)world, blockTarget, CollisionContext.m_82750_((Entity)entity));
            BlockEntity tileEntity = world.m_7702_(blockTarget.m_82425_());
            accessor = WailaClientRegistration.INSTANCE.blockAccessor().blockState(state).blockEntity(tileEntity).hit(blockTarget).requireVerification().build();
        } else if (target instanceof EntityHitResult) {
            EntityHitResult entityTarget = (EntityHitResult)target;
            accessor = WailaClientRegistration.INSTANCE.entityAccessor().hit(entityTarget).entity(entityTarget.m_82443_()).requireVerification().build();
        } else if (client.f_91080_ instanceof BaseOptionsScreen) {
            accessor = WailaClientRegistration.INSTANCE.blockAccessor().blockState(Blocks.f_50440_.m_49966_()).hit(new BlockHitResult(entity.m_20182_(), Direction.UP, entity.m_20183_(), false)).build();
        }
        EntityAccessor originalAccessor = accessor;
        for (JadeRayTraceCallback callback : WailaClientRegistration.INSTANCE.rayTraceCallback.callbacks()) {
            accessor = callback.onRayTrace(target, accessor, originalAccessor);
        }
        ObjectDataCenter.set(accessor);
        if (accessor == null || accessor.getHitResult() == null) {
            this.tooltipRenderer = null;
            return;
        }
        Accessor.ClientHandler<Accessor<?>> handler = WailaClientRegistration.INSTANCE.getAccessorHandler(accessor.getAccessorType());
        if (!handler.shouldDisplay(accessor)) {
            this.tooltipRenderer = null;
            return;
        }
        if (accessor.isServerConnected()) {
            if (!accessor.verifyData(accessor.getServerData())) {
                accessor.getServerData().m_128431_().clear();
            }
            boolean request = handler.shouldRequestData(accessor);
            if (ObjectDataCenter.isTimeElapsed(ObjectDataCenter.rateLimiter)) {
                ObjectDataCenter.resetTimer();
                if (request) {
                    handler.requestData(accessor);
                }
            }
            if (request && ObjectDataCenter.getServerData() == null) {
                return;
            }
        }
        if (config.getDisplayMode() == IWailaConfig.DisplayMode.LITE && !ClientProxy.isShowDetailsPressed()) {
            Tooltip dummyTooltip = new Tooltip();
            handler.gatherComponents(accessor, $ -> {
                if (Math.abs(WailaCommonRegistration.INSTANCE.priorities.byValue((IJadeProvider)$)) > 5000) {
                    return tooltip;
                }
                return dummyTooltip;
            });
            if (!dummyTooltip.isEmpty()) {
                tooltip.sneakyDetails = true;
            }
        } else {
            handler.gatherComponents(accessor, $ -> tooltip);
        }
        for (JadeTooltipCollectedCallback callback : WailaClientRegistration.INSTANCE.tooltipCollectedCallback.callbacks()) {
            callback.onTooltipCollected(tooltip, accessor);
        }
        this.tooltipRenderer = new TooltipRenderer(tooltip, true);
        this.tooltipRenderer.setPaddingFromTheme(IThemeHelper.get().theme());
    }
}

