/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.addon.vanilla;

import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.TamableAnimal;
import snownee.jade.api.EntityAccessor;
import snownee.jade.api.IEntityComponentProvider;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.Identifiers;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.util.CommonProxy;

public enum AnimalOwnerProvider implements IEntityComponentProvider,
IServerDataProvider<EntityAccessor>
{
    INSTANCE;


    @Override
    public void appendTooltip(ITooltip tooltip, EntityAccessor accessor, IPluginConfig config) {
        String name;
        if (accessor.getServerData().m_128441_("OwnerName")) {
            name = accessor.getServerData().m_128461_("OwnerName");
        } else {
            Entity entity = accessor.getEntity();
            UUID ownerUUID = null;
            if (entity instanceof OwnableEntity) {
                ownerUUID = ((OwnableEntity)entity).m_21805_();
            }
            if (ownerUUID == null) {
                return;
            }
            name = CommonProxy.getLastKnownUsername(ownerUUID);
            if (name == null) {
                name = "???";
            }
        }
        tooltip.add((Component)Component.m_237110_((String)"jade.owner", (Object[])new Object[]{name}));
    }

    @Override
    public void appendServerData(CompoundTag data, EntityAccessor accessor) {
        String name;
        MinecraftServer server = accessor.getLevel().m_7654_();
        if (server != null && server.m_7779_(accessor.getPlayer().m_36316_()) && accessor.getEntity() instanceof TamableAnimal) {
            return;
        }
        Entity entity = accessor.getEntity();
        UUID ownerUUID = null;
        if (entity instanceof OwnableEntity) {
            ownerUUID = ((OwnableEntity)entity).m_21805_();
        }
        if (ownerUUID != null && (name = CommonProxy.getLastKnownUsername(ownerUUID)) != null) {
            data.m_128359_("OwnerName", name);
        }
    }

    @Override
    public ResourceLocation getUid() {
        return Identifiers.MC_ANIMAL_OWNER;
    }
}

