/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.util.classloader;

import com.google.common.io.ByteStreams;
import gg.essential.util.classloader.IsolatedClassLoader;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.security.CodeSigner;
import java.security.CodeSource;
import java.util.function.BiFunction;
import java.util.jar.Manifest;

public class RelaunchClassLoader
extends IsolatedClassLoader {
    private final BiFunction<String, byte[], byte[]> transformer;

    public RelaunchClassLoader(URL[] urls, ClassLoader parent, BiFunction<String, byte[], byte[]> transformer) {
        super(urls, parent);
        this.transformer = transformer;
    }

    public RelaunchClassLoader(URL[] urls, ClassLoader parent) {
        this(urls, parent, (BiFunction<String, byte[], byte[]>)null);
    }

    @Override
    protected Class<?> findClassImpl(String name2) throws ClassNotFoundException {
        String pkgName;
        byte[] bytes;
        Manifest jarManifest;
        URL jarUrl;
        try {
            URL url = this.getResource(name2.replace('.', '/') + ".class");
            if (url == null) {
                throw new ClassNotFoundException(name2);
            }
            URLConnection urlConnection = url.openConnection();
            if (urlConnection instanceof JarURLConnection) {
                JarURLConnection jarConnection = (JarURLConnection)urlConnection;
                jarUrl = jarConnection.getJarFileURL();
                jarManifest = jarConnection.getManifest();
            } else {
                jarUrl = url;
                jarManifest = null;
            }
            try (InputStream in = urlConnection.getInputStream();){
                bytes = ByteStreams.toByteArray((InputStream)in);
            }
        }
        catch (Exception e) {
            throw new ClassNotFoundException(name2, e);
        }
        int pkgIndex = name2.lastIndexOf(46);
        if (pkgIndex > 0 && this.getPackage(pkgName = name2.substring(0, pkgIndex)) == null) {
            try {
                if (jarManifest != null) {
                    this.definePackage(pkgName, jarManifest, jarUrl);
                } else {
                    this.definePackage(pkgName, null, null, null, null, null, null, jarUrl);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if (this.transformer != null) {
            bytes = this.transformer.apply(name2, bytes);
        }
        return this.defineClass(name2, bytes, 0, bytes.length, new CodeSource(jarUrl, (CodeSigner[])null));
    }

    static {
        RelaunchClassLoader.registerAsParallelCapable();
    }
}

