/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.util;

import gg.essential.elementa.state.BasicState;
import gg.essential.gui.common.ReadOnlyState;
import gg.essential.gui.elementa.state.v2.State;
import gg.essential.lib.gson.Gson;
import gg.essential.lib.gson.JsonElement;
import gg.essential.lib.gson.JsonObject;
import gg.essential.lib.gson.JsonParser;
import gg.essential.lib.okhttp3.Request;
import gg.essential.lib.okhttp3.Response;
import gg.essential.util.APIException;
import gg.essential.util.DispatchersKt;
import gg.essential.util.EssentialGuiExtensionsKt;
import gg.essential.util.HttpUtils;
import gg.essential.util.PlayerNotFoundException;
import gg.essential.util.RateLimitException;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ConcurrentHashMap;
import kotlinx.coroutines.CoroutineDispatcher;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.ExecutorsKt;

public class UuidNameLookup {
    private static final String UUID_TO_NAME_API = "https://sessionserver.mojang.com/session/minecraft/profile/";
    private static final String NAME_TO_UUID_API = "https://api.mojang.com/users/profiles/minecraft/";
    private static final ConcurrentHashMap<UUID, CompletableFuture<String>> uuidLoadingFutures = new ConcurrentHashMap();
    private static final ConcurrentHashMap<String, CompletableFuture<UUID>> nameLoadingFutures = new ConcurrentHashMap();

    private static Profile fetchProfile(String apiAddress) throws PlayerNotFoundException, RateLimitException, IOException {
        Request request2 = new Request.Builder().url(apiAddress).header("Content-Type", "application/json").build();
        try (Response response2 = HttpUtils.getHttpClient().join().newCall(request2).execute();){
            String json2 = response2.body() != null ? response2.body().string() : null;
            switch (response2.code()) {
                case 204: 
                case 404: {
                    throw new PlayerNotFoundException("Player not found");
                }
                case 429: {
                    throw new RateLimitException("Rate limit exceeded");
                }
            }
            if (json2 == null) {
                throw new APIException("Failed to load profile: No response body");
            }
            JsonElement jsonElement = JsonParser.parseString(json2);
            if (!jsonElement.isJsonObject()) {
                throw new APIException("Failed to load profile: Invalid response");
            }
            JsonObject jsonObject = jsonElement.getAsJsonObject();
            if (jsonObject.has("errorMessage")) {
                throw new APIException("Failed to load profile: " + jsonObject.get("errorMessage").getAsString());
            }
            Profile profile2 = new Gson().fromJson((JsonElement)jsonObject, Profile.class);
            return profile2;
        }
    }

    public static Profile fetchProfileFromUsername(String username) throws PlayerNotFoundException, RateLimitException, IOException {
        return UuidNameLookup.fetchProfile(NAME_TO_UUID_API + username);
    }

    public static Profile fetchProfileFromUUID(UUID uuid) throws PlayerNotFoundException, RateLimitException, IOException {
        return UuidNameLookup.fetchProfile(UUID_TO_NAME_API + uuid.toString().replaceAll("-", ""));
    }

    public static CompletableFuture<String> getName(UUID uuid) {
        return uuidLoadingFutures.computeIfAbsent(uuid, ignored1 -> CompletableFuture.supplyAsync(() -> {
            try {
                Profile profile2 = UuidNameLookup.fetchProfileFromUUID(uuid);
                nameLoadingFutures.put(profile2.getName().toLowerCase(Locale.ROOT), CompletableFuture.completedFuture(uuid));
                return profile2.getName();
            }
            catch (Exception e) {
                uuidLoadingFutures.remove(uuid);
                throw new CompletionException("Failed to load name", e);
            }
        }, ExecutorsKt.asExecutor((CoroutineDispatcher)Dispatchers.getIO())));
    }

    public static CompletableFuture<UUID> getUUID(String userName) {
        return nameLoadingFutures.computeIfAbsent(userName.toLowerCase(Locale.ROOT), nameLower -> CompletableFuture.supplyAsync(() -> {
            try {
                Profile profile2 = UuidNameLookup.fetchProfileFromUsername(nameLower);
                UUID loadedUuid = UUID.fromString(new StringBuilder(profile2.getId()).insert(20, '-').insert(16, '-').insert(12, '-').insert(8, '-').toString());
                uuidLoadingFutures.put(loadedUuid, CompletableFuture.completedFuture(profile2.getName()));
                return loadedUuid;
            }
            catch (Exception e) {
                nameLoadingFutures.remove(nameLower);
                throw new CompletionException("Failed to load UUID", e);
            }
        }, ExecutorsKt.asExecutor((CoroutineDispatcher)Dispatchers.getIO())));
    }

    public static void populate(String username, UUID uuid) {
        uuidLoadingFutures.computeIfAbsent(uuid, k -> new CompletableFuture()).complete(username);
        nameLoadingFutures.computeIfAbsent(username.toLowerCase(Locale.ROOT), k -> new CompletableFuture()).complete(uuid);
    }

    @Deprecated
    public static ReadOnlyState<String> getNameAsState(UUID uuid) {
        return UuidNameLookup.getNameAsState(uuid, "");
    }

    @Deprecated
    public static ReadOnlyState<String> getNameAsState(UUID uuid, String initialValue) {
        BasicState<String> state2 = new BasicState<String>(initialValue);
        UuidNameLookup.getName(uuid).thenAcceptAsync(state2::set, ExecutorsKt.asExecutor((CoroutineDispatcher)DispatchersKt.getClient(Dispatchers.INSTANCE)));
        return new ReadOnlyState<String>(state2);
    }

    public static State<String> nameState(UUID uuid) {
        return UuidNameLookup.nameState(uuid, "");
    }

    public static State<String> nameState(UUID uuid, String initialValue) {
        State<String> nullableState = EssentialGuiExtensionsKt.toState(UuidNameLookup.getName(uuid));
        return observer -> {
            String value = (String)nullableState.get(observer);
            if (value == null) {
                value = initialValue;
            }
            return value;
        };
    }

    public static class Profile {
        private String id;
        private String name;
        private List<Property> properties;

        public String getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public List<Property> getProperties() {
            return this.properties;
        }
    }

    public class Property {
        private String name;
        private String value;

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }
    }
}

