/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.quic.backend;

import gg.essential.quic.LogOnce;
import gg.essential.quic.ProxyHandler;
import gg.essential.quic.QuicUtil;
import gg.essential.quic.backend.QuicBackend;
import gg.essential.quic.backend.QuicListener;
import gg.essential.quic.backend.SelfSignedCert;
import gg.essential.quic.backend.WrappedLoggingFactory;
import io.netty.bootstrap.Bootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoop;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.local.LocalAddress;
import io.netty.channel.local.LocalChannel;
import io.netty.channel.local.LocalServerChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.ChannelInputShutdownReadComplete;
import io.netty.channel.socket.DatagramPacket;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import io.netty.incubator.codec.quic.InsecureQuicTokenHandler;
import io.netty.incubator.codec.quic.QuicChannel;
import io.netty.incubator.codec.quic.QuicClientCodecBuilder;
import io.netty.incubator.codec.quic.QuicServerCodecBuilder;
import io.netty.incubator.codec.quic.QuicSslContext;
import io.netty.incubator.codec.quic.QuicSslContextBuilder;
import io.netty.incubator.codec.quic.QuicStreamChannel;
import io.netty.incubator.codec.quic.QuicStreamType;
import io.netty.incubator.codec.quic.QuicTokenHandler;
import io.netty.util.concurrent.DefaultThreadFactory;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;

public class QuicBackendImpl
implements QuicBackend {
    private static final QuicSslContext quicClientSslContext;
    private static final QuicClientCodecBuilder quicClientCodec;
    private static final SelfSignedCert certificate;
    private static final QuicSslContext quicServerSslContext;
    private static final QuicServerCodecBuilder quicServerCodecBuilder;
    private static final InetSocketAddress QUIC_LOCAL_ADDRESS;
    private static final InetSocketAddress QUIC_REMOTE_ADDRESS;
    private final NioEventLoopGroup group = new NioEventLoopGroup(1, (ThreadFactory)new DefaultThreadFactory("QUIC Backend", true));
    private final Logger logger;
    private final QuicListener listener;
    private final EventLoop eventLoop = this.group.next();
    private Channel transportChannel;
    private QuicChannel quicChannel;
    private QuicStreamChannel streamChannel;

    public QuicBackendImpl(Logger logger2, QuicListener listener2) {
        this.logger = logger2;
        this.listener = listener2;
    }

    @Override
    public int connect() {
        Channel udpTransportChannel = ((ServerBootstrap)new ServerBootstrap().channel(LocalServerChannel.class)).group((EventLoopGroup)this.eventLoop).childHandler((ChannelHandler)new ChannelInitializer<LocalChannel>(){

            protected void initChannel(LocalChannel ch) throws Exception {
                ch.pipeline().addLast(new ChannelHandler[]{new UdpProxyHandler(QuicBackendImpl.this.logger, QuicBackendImpl.this.listener)});
                QuicBackendImpl.this.transportChannel = (Channel)ch;
            }
        }).bind((SocketAddress)LocalAddress.ANY).awaitUninterruptibly().channel();
        Channel quicConnectionChannel = ((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().channel(LocalChannel.class)).group((EventLoopGroup)this.eventLoop)).handler(quicClientCodec.build())).connect(udpTransportChannel.localAddress()).awaitUninterruptibly().channel();
        HttpProxyInitializer httpProxy = new HttpProxyInitializer();
        Channel httpChannel = ((ServerBootstrap)new ServerBootstrap().group((EventLoopGroup)this.eventLoop).channel(NioServerSocketChannel.class)).childHandler((ChannelHandler)httpProxy).childOption(ChannelOption.AUTO_READ, (Object)false).bind(QuicUtil.LOCALHOST, 0).syncUninterruptibly().channel();
        QuicChannel.newBootstrap((Channel)quicConnectionChannel).handler((ChannelHandler)new ChannelInboundHandlerAdapter(){

            public void channelInactive(ChannelHandlerContext ctx) throws Exception {
                ctx.channel().parent().close();
            }
        }).localAddress((SocketAddress)QUIC_LOCAL_ADDRESS).remoteAddress((SocketAddress)QUIC_REMOTE_ADDRESS).connect().addListener(quicChannelFuture -> {
            if (!quicChannelFuture.isSuccess()) {
                this.logger.error("Failed to create QUIC channel", quicChannelFuture.cause());
                this.finishClose();
                return;
            }
            QuicChannel quicChannel = (QuicChannel)quicChannelFuture.getNow();
            quicChannel.createStream(QuicStreamType.BIDIRECTIONAL, (ChannelHandler)new McProxyHandler(this.listener)).addListener(streamChannelFuture -> {
                if (!streamChannelFuture.isSuccess()) {
                    this.logger.error("Failed to create QUIC stream", streamChannelFuture.cause());
                    quicChannel.close();
                    this.finishClose();
                    return;
                }
                this.streamChannel = (QuicStreamChannel)streamChannelFuture.getNow();
                this.listener.onOpen();
            });
            this.quicChannel = quicChannel;
            httpProxy.quicChannel = quicChannel;
        });
        return ((InetSocketAddress)httpChannel.localAddress()).getPort();
    }

    @Override
    public void accept(final int httpPort) {
        Channel udpTransportChannel = ((ServerBootstrap)new ServerBootstrap().channel(LocalServerChannel.class)).group((EventLoopGroup)this.eventLoop).childHandler((ChannelHandler)new ChannelInitializer<LocalChannel>(){

            protected void initChannel(LocalChannel ch) throws Exception {
                ch.pipeline().addLast(new ChannelHandler[]{new UdpProxyHandler(QuicBackendImpl.this.logger, QuicBackendImpl.this.listener)});
                QuicBackendImpl.this.transportChannel = (Channel)ch;
            }
        }).bind((SocketAddress)LocalAddress.ANY).awaitUninterruptibly().channel();
        Channel quicConnectionChannel = ((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().channel(LocalChannel.class)).group((EventLoopGroup)this.eventLoop)).handler((ChannelHandler)new ChannelInboundHandlerAdapter())).connect(udpTransportChannel.localAddress()).awaitUninterruptibly().channel();
        ChannelHandler serverCodec = quicServerCodecBuilder.clone().handler((ChannelHandler)new ChannelInboundHandlerAdapter(){

            public void channelInactive(ChannelHandlerContext ctx) throws Exception {
                ctx.channel().parent().close();
            }
        }).streamHandler((ChannelHandler)new ChannelInitializer<QuicStreamChannel>(){
            boolean waitingForInitialChannel = true;

            protected void initChannel(QuicStreamChannel ch) throws Exception {
                if (this.waitingForInitialChannel) {
                    this.waitingForInitialChannel = false;
                    QuicBackendImpl.this.streamChannel = ch;
                    ch.pipeline().addLast(new ChannelHandler[]{new McProxyHandler(QuicBackendImpl.this.listener){

                        public void channelActive(ChannelHandlerContext ctx) throws Exception {
                            QuicBackendImpl.this.listener.onOpen();
                        }
                    }});
                } else {
                    ch.config().setAutoRead(false);
                    ch.pipeline().addLast(new ChannelHandler[]{new TcpProxyFrontendHandler(QuicUtil.LOCALHOST, httpPort)});
                }
            }
        }).build();
        quicConnectionChannel.pipeline().addLast(new ChannelHandler[]{serverCodec});
    }

    @Override
    public void transportRecv(byte[] packet) {
        ByteBuf buf = Unpooled.wrappedBuffer((byte[])packet);
        this.transportChannel.writeAndFlush((Object)new DatagramPacket(buf, QUIC_LOCAL_ADDRESS, QUIC_REMOTE_ADDRESS));
    }

    @Override
    public void quicSend(byte[] buf) {
        this.streamChannel.writeAndFlush((Object)Unpooled.wrappedBuffer((byte[])buf));
    }

    @Override
    public void close() throws IOException {
        if (this.streamChannel != null) {
            this.streamChannel.writeAndFlush((Object)Unpooled.EMPTY_BUFFER).addListener((GenericFutureListener)QuicStreamChannel.SHUTDOWN_OUTPUT);
        } else {
            if (this.quicChannel != null) {
                this.quicChannel.close();
            }
            this.finishClose();
        }
    }

    private void finishClose() {
        this.eventLoop.schedule(() -> {
            if (this.transportChannel != null) {
                this.transportChannel.close();
            }
            this.group.shutdownGracefully();
            this.listener.onClosed();
        }, 1L, TimeUnit.SECONDS);
    }

    static {
        InternalLoggerFactory.setDefaultFactory((InternalLoggerFactory)new WrappedLoggingFactory(InternalLoggerFactory.getDefaultFactory()));
        quicClientSslContext = QuicSslContextBuilder.forClient().trustManager(InsecureTrustManagerFactory.INSTANCE).applicationProtocols(new String[]{"minecraft"}).build();
        quicClientCodec = (QuicClientCodecBuilder)((QuicClientCodecBuilder)((QuicClientCodecBuilder)((QuicClientCodecBuilder)new QuicClientCodecBuilder().sslContext(quicClientSslContext)).maxIdleTimeout(30L, TimeUnit.SECONDS)).initialMaxData(10000000L)).initialMaxStreamDataBidirectionalLocal(10000000L);
        try {
            certificate = new SelfSignedCert();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        quicServerSslContext = QuicSslContextBuilder.forServer((PrivateKey)certificate.privateKey(), null, (X509Certificate[])new X509Certificate[]{certificate.certificate()}).applicationProtocols(new String[]{"minecraft"}).build();
        quicServerCodecBuilder = (QuicServerCodecBuilder)((QuicServerCodecBuilder)((QuicServerCodecBuilder)((QuicServerCodecBuilder)((QuicServerCodecBuilder)new QuicServerCodecBuilder().sslContext(quicServerSslContext)).tokenHandler((QuicTokenHandler)InsecureQuicTokenHandler.INSTANCE).maxIdleTimeout(30L, TimeUnit.SECONDS)).initialMaxData(10000000L)).initialMaxStreamDataBidirectionalRemote(10000000L)).initialMaxStreamsBidirectional(10L);
        QUIC_LOCAL_ADDRESS = new InetSocketAddress("172.16.10.10", 10000);
        QUIC_REMOTE_ADDRESS = new InetSocketAddress("172.16.10.10", 10001);
    }

    private class TcpProxyFrontendHandler
    extends ProxyHandler {
        private final int tcpPort;
        private final InetAddress tcpHost;

        public TcpProxyFrontendHandler(InetAddress tcpHost, int tcpPort) {
            super(LogOnce.to(arg_0 -> ((Logger)QuicBackendImpl.this.logger).debug(arg_0)), (Channel)null);
            this.tcpHost = tcpHost;
            this.tcpPort = tcpPort;
        }

        public void channelActive(ChannelHandlerContext ctx) {
            Channel quicStreamChannel = ctx.channel();
            ((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group((EventLoopGroup)quicStreamChannel.eventLoop())).channel(NioSocketChannel.class)).handler((ChannelHandler)new ProxyHandler(quicStreamChannel))).connect(this.tcpHost, this.tcpPort).addListener((GenericFutureListener)((ChannelFutureListener)tcpChannelFuture -> {
                if (!tcpChannelFuture.isSuccess()) {
                    QuicBackendImpl.this.logger.error("Failed to create TCP connection", tcpChannelFuture.cause());
                    quicStreamChannel.close();
                    return;
                }
                this.targetChannel = tcpChannelFuture.channel();
                if (quicStreamChannel.isActive()) {
                    quicStreamChannel.config().setAutoRead(true);
                } else {
                    this.targetChannel.close();
                }
            }));
        }
    }

    private class HttpProxyFrontendHandler
    extends ProxyHandler {
        private final QuicChannel quicChannel;

        public HttpProxyFrontendHandler(QuicChannel quicChannel) {
            super(LogOnce.to(arg_0 -> ((Logger)QuicBackendImpl.this.logger).debug(arg_0)), (Channel)null);
            this.quicChannel = quicChannel;
        }

        public void channelActive(ChannelHandlerContext ctx) throws Exception {
            super.channelActive(ctx);
            Channel tcpChannel = ctx.channel();
            this.quicChannel.createStream(QuicStreamType.BIDIRECTIONAL, (ChannelHandler)new ProxyHandler(tcpChannel)).addListener(streamChannelFuture -> {
                if (!streamChannelFuture.isSuccess()) {
                    QuicBackendImpl.this.logger.info("Failed to create QUIC stream", streamChannelFuture.cause());
                    tcpChannel.close();
                    return;
                }
                this.targetChannel = (Channel)streamChannelFuture.getNow();
                if (tcpChannel.isActive()) {
                    tcpChannel.config().setAutoRead(true);
                }
            });
        }
    }

    private class HttpProxyInitializer
    extends ChannelInitializer<SocketChannel> {
        public QuicChannel quicChannel;

        private HttpProxyInitializer() {
        }

        protected void initChannel(SocketChannel ch) {
            if (this.quicChannel == null) {
                ch.close();
                return;
            }
            ch.pipeline().addLast(new ChannelHandler[]{new HttpProxyFrontendHandler(this.quicChannel)});
        }
    }

    private class McProxyHandler
    extends ChannelDuplexHandler {
        private final QuicListener listener;

        private McProxyHandler(QuicListener listener2) {
            this.listener = listener2;
        }

        public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
            ByteBuf byteBuf = (ByteBuf)msg;
            byte[] bytes = new byte[byteBuf.readableBytes()];
            byteBuf.readBytes(bytes);
            byteBuf.release();
            this.listener.quicRecv(bytes);
        }

        public void userEventTriggered(ChannelHandlerContext ctx, Object evt) {
            if (evt == ChannelInputShutdownReadComplete.INSTANCE) {
                QuicBackendImpl.this.logger.debug("QUIC stream closed. Closing QUIC channel.");
                this.listener.onReceivingStreamClosed();
                ctx.close().addListener(future2 -> ((QuicChannel)ctx.channel().parent()).close(true, 0, Unpooled.EMPTY_BUFFER));
            }
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
            QuicBackendImpl.this.logger.error("QUIC MC Forwarding Error", cause);
            if (ctx.channel().isActive()) {
                ctx.channel().writeAndFlush((Object)Unpooled.EMPTY_BUFFER).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
            }
        }
    }

    private class UdpProxyHandler
    extends SimpleChannelInboundHandler<DatagramPacket> {
        private final Logger logger;
        private final QuicListener listener;

        private UdpProxyHandler(Logger logger2, QuicListener listener2) {
            this.logger = logger2;
            this.listener = listener2;
        }

        protected void channelRead0(ChannelHandlerContext ctx, DatagramPacket packet) throws Exception {
            ByteBuf msg = (ByteBuf)packet.content();
            byte[] bytes = new byte[msg.readableBytes()];
            msg.readBytes(bytes);
            this.listener.transportSend(bytes);
        }

        public void channelInactive(ChannelHandlerContext ctx) throws Exception {
            QuicBackendImpl.this.finishClose();
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
            this.logger.error("QUIC UDP Forwarding Error", cause);
            if (ctx.channel().isActive()) {
                ctx.channel().writeAndFlush((Object)Unpooled.EMPTY_BUFFER).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
            }
        }
    }
}

