/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.network.connectionmanager.profile;

import com.google.common.collect.Maps;
import com.sparkuniverse.toolbox.chat.enums.ChannelType;
import com.sparkuniverse.toolbox.chat.model.Channel;
import gg.essential.api.gui.NotificationBuilder;
import gg.essential.config.EssentialConfig;
import gg.essential.connectionmanager.common.enums.ActivityType;
import gg.essential.connectionmanager.common.enums.ProfileStatus;
import gg.essential.connectionmanager.common.packet.profile.ClientProfileActivityPacket;
import gg.essential.connectionmanager.common.packet.profile.ServerProfileActivityPacket;
import gg.essential.connectionmanager.common.packet.profile.ServerProfileStatusPacket;
import gg.essential.connectionmanager.common.packet.profile.trustedhosts.ServerProfileTrustedHostsClearPacket;
import gg.essential.connectionmanager.common.packet.profile.trustedhosts.ServerProfileTrustedHostsPopulatePacket;
import gg.essential.connectionmanager.common.packet.profile.trustedhosts.ServerProfileTrustedHostsRemovePacket;
import gg.essential.data.OnboardingData;
import gg.essential.elementa.state.BasicState;
import gg.essential.elementa.state.State;
import gg.essential.gui.EssentialPalette;
import gg.essential.gui.friends.SocialMenu;
import gg.essential.gui.friends.previews.ChannelPreview;
import gg.essential.gui.friends.state.IStatusManager;
import gg.essential.gui.multiplayer.EssentialMultiplayerGui;
import gg.essential.gui.notification.ExtensionsKt;
import gg.essential.gui.notification.Notifications;
import gg.essential.lib.gson.Gson;
import gg.essential.lib.gson.JsonParseException;
import gg.essential.network.connectionmanager.ConnectionCodec;
import gg.essential.network.connectionmanager.ConnectionManager;
import gg.essential.network.connectionmanager.NetworkedManager;
import gg.essential.network.connectionmanager.StateCallbackManager;
import gg.essential.network.connectionmanager.handler.profile.ServerProfileActivityPacketHandler;
import gg.essential.network.connectionmanager.handler.profile.ServerProfileStatusPacketHandler;
import gg.essential.network.connectionmanager.handler.profile.trustedhosts.ServerProfileTrustedHostsClearPacketHandler;
import gg.essential.network.connectionmanager.handler.profile.trustedhosts.ServerProfileTrustedHostsPopulatePacketHandler;
import gg.essential.network.connectionmanager.handler.profile.trustedhosts.ServerProfileTrustedHostsRemovePacketHandler;
import gg.essential.network.connectionmanager.queue.PacketQueue;
import gg.essential.network.connectionmanager.queue.SequentialPacketQueue;
import gg.essential.network.connectionmanager.subscription.SubscriptionManager;
import gg.essential.profiles.model.TrustedHost;
import gg.essential.util.CachedAvatarImage;
import gg.essential.util.GuiUtil;
import gg.essential.util.HttpUtils;
import gg.essential.util.Multithreading;
import gg.essential.util.StringsKt;
import gg.essential.util.UUIDUtil;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProfileManager
extends StateCallbackManager<IStatusManager>
implements NetworkedManager,
SubscriptionManager.Listener {
    @NotNull
    private final ConnectionManager connectionManager;
    @NotNull
    private final Map<UUID, ProfileStatus> statuses = Maps.newConcurrentMap();
    @NotNull
    private final Map<UUID, Pair<ActivityType, String>> activities = Maps.newConcurrentMap();
    @NotNull
    private final Map<String, TrustedHost> trustedHosts = Maps.newConcurrentMap();
    @NotNull
    private final PacketQueue updateQueue;
    @NotNull
    private final State<Set<String>> trustedHostsState = new BasicState(new HashSet());
    @NotNull
    private final State<Set<String>> userTrustedHostsState = new BasicState(new HashSet());
    private boolean loadedDefaultTrustedHosts = false;

    public ProfileManager(@NotNull ConnectionManager connectionManager) {
        this.connectionManager = connectionManager;
        this.updateQueue = new SequentialPacketQueue.Builder(connectionManager).onTimeoutSkip().create();
        connectionManager.registerPacketHandler(ServerProfileActivityPacket.class, new ServerProfileActivityPacketHandler());
        connectionManager.registerPacketHandler(ServerProfileStatusPacket.class, new ServerProfileStatusPacketHandler());
        connectionManager.registerPacketHandler(ServerProfileTrustedHostsClearPacket.class, new ServerProfileTrustedHostsClearPacketHandler());
        connectionManager.registerPacketHandler(ServerProfileTrustedHostsPopulatePacket.class, new ServerProfileTrustedHostsPopulatePacketHandler());
        connectionManager.registerPacketHandler(ServerProfileTrustedHostsRemovePacket.class, new ServerProfileTrustedHostsRemovePacketHandler());
    }

    @NotNull
    public Map<UUID, Pair<ActivityType, String>> getActivities() {
        return this.activities;
    }

    @NotNull
    public synchronized Map<String, TrustedHost> getTrustedHosts() {
        if (!(OnboardingData.hasAcceptedTos() && EssentialConfig.INSTANCE.getEssentialEnabled() || this.loadedDefaultTrustedHosts)) {
            this.loadedDefaultTrustedHosts = true;
            try {
                TrustedHost[] trustedHosts;
                Gson gson = ConnectionCodec.gson;
                String trustedHostURL = "https://api.essential.gg/v2/trusted_hosts";
                for (TrustedHost trustedHost : trustedHosts = gson.fromJson(HttpUtils.httpGetToStringBlocking(trustedHostURL), TrustedHost[].class)) {
                    this.addTrustedHost(trustedHost);
                }
            }
            catch (JsonParseException | IOException e) {
                e.printStackTrace();
            }
        }
        return this.trustedHosts;
    }

    @Nullable
    public ProfileStatus getStatus() {
        return this.getStatus(UUIDUtil.getClientUUID());
    }

    @Nullable
    public ActivityType getActivityType() {
        return this.getActivity(UUIDUtil.getClientUUID()).map(Pair::getFirst).orElse(null);
    }

    @NotNull
    public ProfileStatus getStatus(@NotNull UUID uuid) {
        return this.getStatusIfLoaded(uuid).orElse(ProfileStatus.OFFLINE);
    }

    @NotNull
    public Optional<ProfileStatus> getStatusIfLoaded(@NotNull UUID uuid) {
        return Optional.ofNullable(this.statuses.get(uuid));
    }

    @NotNull
    public Optional<Pair<ActivityType, String>> getActivity(@NotNull UUID uuid) {
        return Optional.ofNullable(this.activities.get(uuid));
    }

    @NotNull
    public Optional<TrustedHost> getTrustedHost(@NotNull String id2) {
        return Optional.ofNullable(this.trustedHosts.get(id2));
    }

    public void setPlayerStatus(@NotNull UUID uuid, @Nullable ProfileStatus status2, @Nullable Long timestamp) {
        if (status2 == null) {
            this.removePlayerStatus(uuid);
            return;
        }
        ProfileStatus put = this.statuses.put(uuid, status2);
        if (put == ProfileStatus.OFFLINE && status2 == ProfileStatus.ONLINE && this.connectionManager.getRelationshipManager().isFriend(uuid) && EssentialConfig.INSTANCE.getFriendConnectionStatus()) {
            UUIDUtil.getName(uuid).thenAcceptAsync(username -> Notifications.INSTANCE.push("", "", 4.0f, (Function0<Unit>)((Function0)() -> {
                ChannelPreview cbp;
                SocialMenu gui2 = SocialMenu.getInstance();
                Channel channel2 = null;
                for (Channel value : this.connectionManager.getChatManager().getChannels().values()) {
                    if (value.getType() != ChannelType.DIRECT_MESSAGE || !value.getMembers().contains(uuid)) continue;
                    channel2 = value;
                    break;
                }
                if (gui2 == null) {
                    Long channelId = channel2 == null ? null : Long.valueOf(channel2.getId());
                    GuiUtil.openScreen(SocialMenu.class, () -> new SocialMenu(channelId));
                } else if (channel2 != null && (cbp = gui2.getChatTab().get(channel2.getId())) != null) {
                    gui2.openMessageScreen(cbp);
                }
                return Unit.INSTANCE;
            }), (Function0<Unit>)((Function0)() -> Unit.INSTANCE), (Function1<? super NotificationBuilder, Unit>)((Function1)notificationBuilder -> {
                ExtensionsKt.iconAndMarkdownBody(notificationBuilder, CachedAvatarImage.create(uuid), StringsKt.colored(username, EssentialPalette.TEXT_HIGHLIGHT) + " is online!");
                return Unit.INSTANCE;
            })), (Executor)Multithreading.getPool());
        }
        for (IStatusManager statusManager : this.getCallbacks()) {
            statusManager.refreshActivity(uuid);
        }
    }

    public void setPlayerActivity(@NotNull UUID uuid, @Nullable ActivityType activityType, @Nullable String metadata2) {
        if (activityType == null || metadata2 == null) {
            this.removePlayerActivity(uuid);
            return;
        }
        this.activities.put(uuid, (Pair<ActivityType, String>)new Pair((Object)activityType, (Object)metadata2));
        for (IStatusManager statusManager : this.getCallbacks()) {
            statusManager.refreshActivity(uuid);
        }
        EssentialMultiplayerGui gui2 = EssentialMultiplayerGui.getInstance();
        if (gui2 != null) {
            gui2.updatePlayerActivity(uuid);
        }
    }

    public void updatePlayerActivity(@Nullable ActivityType activityType, @Nullable String metadata2) {
        this.setPlayerActivity(UUIDUtil.getClientUUID(), activityType, metadata2);
        this.updateQueue.enqueue(new ClientProfileActivityPacket(activityType, metadata2));
    }

    public void addTrustedHost(@NotNull TrustedHost trustedHost) {
        this.trustedHosts.put(trustedHost.getId(), trustedHost);
        this.updateTrustedHostState();
    }

    private void updateTrustedHostState() {
        this.trustedHostsState.set(this.trustedHosts.values().stream().flatMap(trustedHost -> trustedHost.getDomains().stream()).collect(Collectors.toSet()));
        this.userTrustedHostsState.set(this.trustedHosts.values().stream().filter(trustedHost -> trustedHost.getProfileId() != null).flatMap(trustedHost -> trustedHost.getDomains().stream()).collect(Collectors.toSet()));
    }

    public void removePlayerStatus(@NotNull UUID uuid) {
        this.statuses.remove(uuid);
        for (IStatusManager statusManager : this.getCallbacks()) {
            statusManager.refreshActivity(uuid);
        }
    }

    public void removePlayerActivity(@NotNull UUID uuid) {
        this.activities.remove(uuid);
        EssentialMultiplayerGui gui2 = EssentialMultiplayerGui.getInstance();
        if (gui2 != null) {
            gui2.updatePlayerActivity(uuid);
        }
        for (IStatusManager statusManager : this.getCallbacks()) {
            statusManager.refreshActivity(uuid);
        }
    }

    public void removeTrustedHost(@NotNull String id2) {
        this.trustedHosts.remove(id2);
        this.updateTrustedHostState();
    }

    public void clearTrustedHosts() {
        this.trustedHosts.clear();
        this.updateTrustedHostState();
    }

    @Override
    public void onConnected() {
        Optional<Pair<ActivityType, String>> clientActivity = this.getActivity(UUIDUtil.getClientUUID());
        this.resetState();
        clientActivity.ifPresent(activity2 -> this.updatePlayerActivity((ActivityType)((Object)((Object)activity2.getFirst())), (String)activity2.getSecond()));
    }

    @Override
    public void resetState() {
        this.updateQueue.reset();
        this.trustedHosts.clear();
        this.activities.clear();
        this.statuses.clear();
        this.updateTrustedHostState();
    }

    @Override
    public void onSubscriptionRemoved(@NotNull Set<UUID> uuids) {
        for (UUID uuid : uuids) {
            if (this.connectionManager.getRelationshipManager().isFriend(uuid)) continue;
            this.removePlayerActivity(uuid);
        }
    }
}

