/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.network.connectionmanager.notices;

import gg.essential.Essential;
import gg.essential.gui.elementa.state.v2.MutableState;
import gg.essential.gui.elementa.state.v2.State;
import gg.essential.gui.elementa.state.v2.StateKt;
import gg.essential.gui.state.Sale;
import gg.essential.network.connectionmanager.notices.NoticeListener;
import gg.essential.notices.NoticeType;
import gg.essential.notices.model.Notice;
import gg.essential.util.Multithreading;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SaleNoticeManager
implements NoticeListener {
    private final boolean saleSuppressedByJvmFlag = System.getProperty("essential.disableSale", "false").equals("true");
    private final MutableState<@NotNull Set<Sale>> currentState = StateKt.mutableStateOf(Collections.emptySet());
    private final Map<String, Sale> salesMap = new HashMap<String, Sale>();
    private ScheduledFuture<?> nextUpdateFuture = null;

    @Override
    public void noticeAdded(Notice notice) {
        if (this.saleSuppressedByJvmFlag) {
            return;
        }
        if (notice.getType() == NoticeType.SALE) {
            if (notice.getExpiresAt() == null) {
                Essential.logger.error("Notice " + notice.getId() + " is type sale but does not have an expiration date set!");
                return;
            }
            int discount = ((Number)notice.getMetadata().get("discount")).intValue();
            @Nullable HashSet<Integer> packagesSet = null;
            if (notice.getMetadata().containsKey("packages")) {
                packagesSet = new HashSet<Integer>();
                for (Number packages : (Collection)notice.getMetadata().get("packages")) {
                    packagesSet.add(packages.intValue());
                }
                if (packagesSet.isEmpty()) {
                    packagesSet = null;
                }
            }
            HashSet<String> onlyCosmetics = null;
            if (notice.getMetadata().containsKey("cosmetics")) {
                onlyCosmetics = new HashSet<String>((Collection)notice.getMetadata().get("cosmetics"));
            }
            this.salesMap.put(notice.getId(), new Sale(notice.getExpiresAt().toInstant(), (String)notice.getMetadata().get("sale_name"), notice.getMetadata().containsKey("sale_name_compact") ? (String)notice.getMetadata().get("sale_name_compact") : (discount == 0 ? null : "SALE"), discount, (Boolean)notice.getMetadata().getOrDefault("display_time", Boolean.TRUE), (String)notice.getMetadata().get("category"), packagesSet, onlyCosmetics, (String)notice.getMetadata().get("tooltip"), (String)notice.getMetadata().get("coupon")));
            this.refreshState();
        }
    }

    private void refreshState() {
        this.currentState.set(new HashSet<Sale>(this.salesMap.values()));
        this.scheduleUpdate();
    }

    private void scheduleUpdate() {
        Optional<Sale> first;
        if (this.nextUpdateFuture != null) {
            this.nextUpdateFuture.cancel(false);
        }
        if ((first = this.salesMap.values().stream().min(Comparator.comparing(Sale::getExpiration))).isPresent()) {
            Sale sale = first.get();
            this.nextUpdateFuture = Multithreading.scheduleOnMainThread(() -> {
                Instant now2 = Instant.now();
                if (this.salesMap.entrySet().removeIf(entry -> ((Sale)entry.getValue()).getExpiration().isBefore(now2))) {
                    this.refreshState();
                }
            }, Instant.now().until(sale.getExpiration(), ChronoUnit.MILLIS) + 1000L, TimeUnit.MILLISECONDS);
        }
    }

    public State<@NotNull Set<Sale>> getSaleState() {
        return this.currentState;
    }

    @Override
    public void noticeRemoved(Notice notice) {
        if (notice.getType() == NoticeType.SALE) {
            this.salesMap.remove(notice.getId());
            this.refreshState();
        }
    }

    @Override
    public void onConnect() {
    }
}

