/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.network.connectionmanager.notices;

import gg.essential.cosmetics.ExtensionsKt;
import gg.essential.gui.elementa.state.v2.MutableState;
import gg.essential.gui.elementa.state.v2.ObservedInstant;
import gg.essential.gui.elementa.state.v2.State;
import gg.essential.gui.elementa.state.v2.StateKt;
import gg.essential.network.connectionmanager.cosmetics.CosmeticsData;
import gg.essential.network.connectionmanager.notices.NoticeListener;
import gg.essential.network.connectionmanager.notices.NoticesManager;
import gg.essential.network.cosmetics.Cosmetic;
import gg.essential.notices.NoticeType;
import gg.essential.notices.model.Notice;
import java.time.Instant;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;

public class CosmeticNotices
implements NoticeListener {
    private final NoticesManager noticesManager;
    private final CosmeticsData cosmeticsData;
    private final String METADATA_KEY = "cosmetic_id";
    private final ConcurrentHashMap<String, MutableState<Boolean>> cosmeticToNewStateMap = new ConcurrentHashMap();
    private final MutableState<Boolean> hasAnyNewCosmetics = StateKt.mutableStateOf(false);

    public CosmeticNotices(NoticesManager noticesManager, CosmeticsData cosmeticsData) {
        this.noticesManager = noticesManager;
        this.cosmeticsData = cosmeticsData;
    }

    public State<Boolean> getNewState(String cosmeticId) {
        return this.cosmeticToNewStateMap.computeIfAbsent(cosmeticId, ignored -> StateKt.mutableStateOf(false));
    }

    private Notice getNotice(final String cosmeticId) {
        List<Notice> notices = this.noticesManager.getNotices(NoticeType.NEW_BANNER, null, (Map<String, Object>)new HashMap<String, Object>(){
            {
                this.put("cosmetic_id", cosmeticId);
            }
        });
        if (!notices.isEmpty()) {
            return notices.get(0);
        }
        return null;
    }

    public void clearNewState(String cosmeticId) {
        Notice notice;
        MutableState<Boolean> booleanState = this.cosmeticToNewStateMap.get(cosmeticId);
        if (booleanState != null) {
            booleanState.set(false);
        }
        if ((notice = this.getNotice(cosmeticId)) != null) {
            this.noticesManager.queueDismissNotice(notice.getId());
        }
        this.updateGlobalState();
    }

    private void updateGlobalState() {
        this.hasAnyNewCosmetics.set(this.cosmeticToNewStateMap.entrySet().stream().anyMatch(entry -> {
            if (!((Boolean)((MutableState)entry.getValue()).get()).booleanValue()) {
                return false;
            }
            Cosmetic cosmetic2 = this.cosmeticsData.getCosmetic((String)entry.getKey());
            if (cosmetic2 == null) {
                return false;
            }
            return ExtensionsKt.isAvailable(cosmetic2, new ObservedInstant(Instant.now(), (Function1<? super Instant, Unit>)((Function1)__ -> Unit.INSTANCE)));
        }));
    }

    public State<Boolean> getHasAnyNewCosmetics() {
        return this.hasAnyNewCosmetics;
    }

    @Override
    public void noticeAdded(Notice notice) {
        if (notice.getType() == NoticeType.NEW_BANNER && notice.getMetadata().containsKey("cosmetic_id")) {
            String cosmeticId = (String)notice.getMetadata().get("cosmetic_id");
            this.cosmeticToNewStateMap.computeIfAbsent(cosmeticId, ignored -> StateKt.mutableStateOf(true)).set(true);
            this.updateGlobalState();
        }
    }

    @Override
    public void noticeRemoved(Notice notice) {
    }

    @Override
    public void onConnect() {
        this.resetState();
    }

    public void cosmeticAdded(String id2) {
        MutableState<Boolean> existingState = this.cosmeticToNewStateMap.get(id2);
        if (existingState != null && ((Boolean)existingState.get()).booleanValue()) {
            this.updateGlobalState();
        }
    }
}

