/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.model.backend.atlas;

import gg.essential.model.backend.RenderBackend;
import gg.essential.model.backend.atlas.Entry;
import gg.essential.model.backend.atlas.Packing;
import gg.essential.model.backend.atlas.XYWH;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u001a\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\u001a \u0010\u0000\u001a\u0004\u0018\u00010\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a(\u0010\u0007\u001a\u0004\u0018\u00010\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u0006H\u0002\u00a8\u0006\n"}, d2={"pack", "Lgg/essential/model/backend/atlas/Packing;", "textures", "", "Lgg/essential/model/backend/RenderBackend$Texture;", "maxAtlasSize", "", "packWithSize", "atlasWidth", "atlasHeight", "cosmetics"})
public final class TextureAtlasKt {
    private static final Packing pack(Iterable<? extends RenderBackend.Texture> textures, int maxAtlasSize) {
        Packing packing;
        int discardStep = 16;
        int initialSize = 512;
        Packing bestPacking = TextureAtlasKt.packWithSize(textures, initialSize, initialSize);
        int squareSize = initialSize;
        while (bestPacking == null) {
            if ((squareSize *= 2) > maxAtlasSize) {
                return null;
            }
            bestPacking = TextureAtlasKt.packWithSize(textures, squareSize, squareSize);
        }
        int step = -squareSize / 2;
        if (squareSize > initialSize) {
            step /= 2;
        }
        while (Math.abs(step) >= discardStep) {
            Packing packing2;
            step = (packing2 = TextureAtlasKt.packWithSize(textures, squareSize += step, squareSize)) == null ? Math.abs(step / 2) : -Math.abs(step / 2);
            Packing packing3 = packing2;
            if (packing3 == null) {
                packing3 = bestPacking;
            }
            bestPacking = packing3;
        }
        int width2 = bestPacking.getAtlasWidth();
        int height2 = bestPacking.getAtlasHeight();
        step = -width2 / 2;
        while (Math.abs(step) >= discardStep) {
            packing = TextureAtlasKt.packWithSize(textures, width2 += step, height2);
            step = packing == null ? Math.abs(step / 2) : -Math.abs(step / 2);
            Packing packing4 = packing;
            if (packing4 == null) {
                packing4 = bestPacking;
            }
            bestPacking = packing4;
        }
        width2 = bestPacking.getAtlasWidth();
        height2 = bestPacking.getAtlasHeight();
        step = -height2 / 2;
        while (Math.abs(step) >= discardStep) {
            packing = TextureAtlasKt.packWithSize(textures, width2, height2 += step);
            step = packing == null ? Math.abs(step / 2) : -Math.abs(step / 2);
            Packing packing5 = packing;
            if (packing5 == null) {
                packing5 = bestPacking;
            }
            bestPacking = packing5;
        }
        return bestPacking;
    }

    private static final Packing packWithSize(Iterable<? extends RenderBackend.Texture> textures, int atlasWidth, int atlasHeight) {
        List packedTextures = new ArrayList();
        XYWH[] xYWHArray = new XYWH[]{new XYWH(0, 0, atlasWidth, atlasHeight)};
        List freeRects = CollectionsKt.mutableListOf((Object[])xYWHArray);
        block0: for (RenderBackend.Texture texture : textures) {
            for (int i2 = CollectionsKt.getLastIndex((List)freeRects); -1 < i2; --i2) {
                XYWH freeRect = (XYWH)freeRects.get(i2);
                if (TextureAtlasKt.packWithSize$place(freeRect, packedTextures, texture, freeRects, i2, texture.getWidth(), texture.getHeight(), false)) continue block0;
            }
            return null;
        }
        return new Packing(atlasWidth, atlasHeight, packedTextures);
    }

    private static final boolean packWithSize$place(XYWH freeRect, List<Entry> packedTextures, RenderBackend.Texture texture, List<XYWH> freeRects, int i2, int textureW, int textureH, boolean flipped) {
        int remainingW = freeRect.getW() - textureW;
        int remainingH = freeRect.getH() - textureH;
        if (remainingW < 0 || remainingH < 0) {
            return false;
        }
        packedTextures.add(new Entry(texture, freeRect.getX(), freeRect.getY(), textureW, textureH, flipped));
        freeRects.set(i2, (XYWH)CollectionsKt.last(freeRects));
        CollectionsKt.removeLast(freeRects);
        if (remainingW != 0 || remainingH != 0) {
            if (remainingW == 0) {
                freeRects.add(new XYWH(freeRect.getX(), freeRect.getY() + textureH, freeRect.getW(), remainingH));
            } else if (remainingH == 0) {
                freeRects.add(new XYWH(freeRect.getX() + textureW, freeRect.getY(), remainingW, freeRect.getH()));
            } else if (remainingW > remainingH) {
                freeRects.add(new XYWH(freeRect.getX() + textureW, freeRect.getY(), remainingW, freeRect.getH()));
                freeRects.add(new XYWH(freeRect.getX(), freeRect.getY() + textureH, textureW, remainingH));
            } else {
                freeRects.add(new XYWH(freeRect.getX(), freeRect.getY() + textureH, freeRect.getW(), remainingH));
                freeRects.add(new XYWH(freeRect.getX() + textureW, freeRect.getY(), remainingW, textureH));
            }
        }
        return true;
    }

    public static final /* synthetic */ Packing access$pack(Iterable textures, int maxAtlasSize) {
        return TextureAtlasKt.pack(textures, maxAtlasSize);
    }
}

