/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.model;

import gg.essential.Essential;
import gg.essential.event.render.RenderTickEvent;
import gg.essential.gui.common.EmulatedUI3DPlayer;
import gg.essential.lib.kbrewster.eventbus.Subscribe;
import gg.essential.lib.kotgl.matrix.matrices.Mat4;
import gg.essential.lib.kotgl.matrix.vectors.Vectors;
import gg.essential.lib.kotgl.matrix.vectors.mutables.MutableVec3;
import gg.essential.lib.kotgl.matrix.vectors.mutables.MutableVectors;
import gg.essential.mixins.impl.client.renderer.entity.PlayerEntityRendererExt;
import gg.essential.model.ParticleSystem;
import gg.essential.model.molang.MolangQueryEntity;
import gg.essential.model.util.KotglKt;
import gg.essential.model.util.Quaternion;
import java.util.UUID;
import kotlin.Pair;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlayerMolangQuery
implements MolangQueryEntity,
ParticleSystem.Locator {
    private final Player player;
    private long removedWorldTime = -1L;
    private static float partialTicksMenu;
    private static float partialTicksInGame;

    public PlayerMolangQuery(Player player2) {
        this.player = player2;
    }

    public Player getPlayer() {
        return this.player;
    }

    private float getPartialTicks() {
        return this.player instanceof EmulatedUI3DPlayer.EmulatedPlayer ? partialTicksMenu : partialTicksInGame;
    }

    @Override
    public float getLifeTime() {
        if (this.player.f_19797_ <= 1) {
            return (float)this.player.f_19797_ / 20.0f;
        }
        return ((float)this.player.f_19797_ + this.getPartialTicks()) / 20.0f;
    }

    @Override
    public float getTime() {
        if (this.isValid()) {
            return this.getLifeTime();
        }
        Level world = this.player.m_20193_();
        if (world == null) {
            return this.getLifeTime();
        }
        long worldTime = world.m_46467_();
        if (this.removedWorldTime == -1L) {
            this.removedWorldTime = worldTime;
        }
        int timeSinceRemoved = (int)(worldTime - this.removedWorldTime);
        return ((float)(this.player.f_19797_ + timeSinceRemoved) + this.getPartialTicks()) / 20.0f;
    }

    @Override
    public float getModifiedDistanceMoved() {
        float next = this.player.f_19787_;
        float prev = this.player.f_19867_;
        float now2 = prev + (next - prev) * this.getPartialTicks();
        return now2 * 16.0f;
    }

    @Override
    public float getModifiedMoveSpeed() {
        float next = this.player.f_19787_;
        float prev = this.player.f_19867_;
        return (next - prev) * 16.0f;
    }

    @Override
    @NotNull
    public ParticleSystem.Locator getLocator() {
        return this;
    }

    @Override
    @NotNull
    public UUID getUuid() {
        return this.player.m_20148_();
    }

    @Override
    @Nullable
    public ParticleSystem.Locator getParent() {
        return null;
    }

    @Override
    public boolean isValid() {
        return !this.player.m_213877_();
    }

    @Override
    @NotNull
    public gg.essential.lib.kotgl.matrix.vectors.Vec3 getPosition() {
        return (gg.essential.lib.kotgl.matrix.vectors.Vec3)this.getPositionAndRotation().getFirst();
    }

    @Override
    @NotNull
    public Quaternion getRotation() {
        return (Quaternion)this.getPositionAndRotation().getSecond();
    }

    public gg.essential.lib.kotgl.matrix.vectors.Vec3 getEntityPosition() {
        return this.getEntityPositionMut();
    }

    public Quaternion getEntityRotation() {
        return this.getBaseRotation();
    }

    private MutableVec3 getEntityPositionMut() {
        float partialTicks = this.getPartialTicks();
        Vec3 nextPos = this.player.m_20182_();
        float nextX = (float)nextPos.f_82479_;
        float nextY = (float)nextPos.f_82480_;
        float nextZ = (float)nextPos.f_82481_;
        float prevX = (float)this.player.f_19790_;
        float prevY = (float)this.player.f_19791_;
        float prevZ = (float)this.player.f_19792_;
        return MutableVectors.mutableVec3(prevX + (nextX - prevX) * partialTicks, prevY + (nextY - prevY) * partialTicks, prevZ + (nextZ - prevZ) * partialTicks);
    }

    private gg.essential.lib.kotgl.matrix.vectors.Vec3 getBasePosition() {
        MutableVec3 pos = this.getEntityPositionMut();
        if (this.player.m_6047_()) {
            pos.setY(pos.getY() - 0.125f);
        }
        return pos;
    }

    private float getRenderYaw() {
        RealYawAccess access = (RealYawAccess)this.player;
        float next = access.essential$getRealRenderYaw();
        float prev = access.essential$getRealPrevRenderYaw();
        return prev + (next - prev) * this.getPartialTicks();
    }

    private Quaternion getBaseRotation() {
        return Quaternion.Companion.fromAxisAngle(Vectors.vecUnitY(), (float)(Math.PI - Math.toRadians(this.getRenderYaw())));
    }

    @Override
    @NotNull
    public Pair<gg.essential.lib.kotgl.matrix.vectors.Vec3, Quaternion> getPositionAndRotation() {
        if (!(this.player instanceof AbstractClientPlayer)) {
            return new Pair((Object)this.getBasePosition(), (Object)this.getBaseRotation());
        }
        EntityRenderer renderer = Minecraft.m_91087_().m_91290_().m_114382_((Entity)this.player);
        if (!(renderer instanceof PlayerEntityRendererExt)) {
            return new Pair((Object)this.getBasePosition(), (Object)this.getBaseRotation());
        }
        PlayerEntityRendererExt rendererExt = (PlayerEntityRendererExt)renderer;
        gg.essential.lib.kotgl.matrix.vectors.Vec3 renderPos = Vectors.vec3(0.0f, 9.3750004E-4f, 0.0f);
        Mat4 mat = rendererExt.essential$getTransform((AbstractClientPlayer)this.player, this.getRenderYaw(), this.getPartialTicks());
        MutableVec3 position2 = MutableVectors.plus(KotglKt.transformPosition(mat, renderPos), this.getBasePosition());
        Quaternion rotation = Quaternion.Companion.fromRotationMatrix(KotglKt.toMat3(mat));
        return new Pair((Object)position2, (Object)rotation);
    }

    @Override
    @NotNull
    public gg.essential.lib.kotgl.matrix.vectors.Vec3 getVelocity() {
        Vec3 motion = this.player.m_20184_();
        return Vectors.vec3((float)motion.f_82479_ * 20.0f, (float)motion.f_82480_ * 20.0f, (float)motion.f_82481_ * 20.0f);
    }

    @Override
    public boolean isVisible() {
        return true;
    }

    static {
        Essential.EVENT_BUS.register(new Object(){

            @Subscribe(priority=1)
            private void renderWorld(RenderTickEvent event) {
                partialTicksMenu = event.getPartialTicksMenu();
                partialTicksInGame = event.getPartialTicksInGame();
            }
        });
    }

    public static interface RealYawAccess {
        public float essential$getRealRenderYaw();

        public float essential$getRealPrevRenderYaw();
    }
}

