/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.model;

import gg.essential.mod.cosmetics.CapeModel;
import gg.essential.mod.cosmetics.CosmeticSlot;
import gg.essential.model.BedrockModel;
import gg.essential.model.Bone;
import gg.essential.model.Bones;
import gg.essential.model.Box3;
import gg.essential.model.Cube;
import gg.essential.model.CubeUvData;
import gg.essential.model.EnumPart;
import gg.essential.model.Side;
import gg.essential.model.Vector3;
import gg.essential.model.file.ModelFile;
import gg.essential.network.cosmetics.Cosmetic;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0014\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 ,2\u00020\u0001:\u0001,B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J,\u0010\u001a\u001a \u0012\u0004\u0012\u00020\u001b\u0012\u0014\u0012\u0012\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001d0\u001c0\u001cj\u0002`\u001e\u0018\u00010\n2\u0006\u0010\u001f\u001a\u00020 J&\u0010!\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0002J\u000e\u0010(\u001a\u00020)*\u0004\u0018\u00010*H\u0002J\f\u0010+\u001a\u00020'*\u00020'H\u0002R%\u0010\b\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0006\u0012\u0004\u0018\u00010\f0\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0014\u001a\u00020\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019\u00a8\u0006-"}, d2={"Lgg/essential/model/ModelParser;", "", "cosmetic", "Lgg/essential/network/cosmetics/Cosmetic;", "textureWidth", "", "textureHeight", "(Lgg/essential/network/cosmetics/Cosmetic;II)V", "boundingBoxes", "", "Lkotlin/Pair;", "Lgg/essential/model/Box3;", "Lgg/essential/model/Side;", "getBoundingBoxes", "()Ljava/util/List;", "textureFrameCount", "getTextureFrameCount", "()I", "setTextureFrameCount", "(I)V", "translucent", "", "getTranslucent", "()Z", "setTranslucent", "(Z)V", "parse", "Lgg/essential/model/Bones;", "", "Lgg/essential/model/Cube;", "Lgg/essential/model/RenderGeometry;", "file", "Lgg/essential/model/file/ModelFile;", "parseCubes", "geometry", "Lgg/essential/model/file/ModelFile$Geometry;", "bone", "Lgg/essential/model/file/ModelFile$Bone;", "extraInflate", "", "toFloatArray", "", "Lgg/essential/model/file/ModelFile$UvFace;", "toRadians", "Companion", "cosmetics"})
@SourceDebugExtension(value={"SMAP\nModelParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ModelParser.kt\ngg/essential/model/ModelParser\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,160:1\n1#2:161\n357#3,7:162\n*S KotlinDebug\n*F\n+ 1 ModelParser.kt\ngg/essential/model/ModelParser\n*L\n76#1:162,7\n*E\n"})
public final class ModelParser {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Cosmetic cosmetic;
    private final int textureWidth;
    private final int textureHeight;
    @NotNull
    private final List<Pair<Box3, Side>> boundingBoxes;
    private int textureFrameCount;
    private boolean translucent;
    @NotNull
    private static final Iterable<IndexedValue<Set<CosmeticSlot>>> EXTRA_INFLATE_GROUPS;
    @NotNull
    public static final String ROOT_BONE_NAME = "__internal_root__";

    public ModelParser(@NotNull Cosmetic cosmetic2, int textureWidth, int textureHeight) {
        Intrinsics.checkNotNullParameter((Object)cosmetic2, (String)"cosmetic");
        this.cosmetic = cosmetic2;
        this.textureWidth = textureWidth;
        this.textureHeight = textureHeight;
        this.boundingBoxes = new ArrayList();
        this.textureFrameCount = 1;
    }

    @NotNull
    public final List<Pair<Box3, Side>> getBoundingBoxes() {
        return this.boundingBoxes;
    }

    public final int getTextureFrameCount() {
        return this.textureFrameCount;
    }

    public final void setTextureFrameCount(int n) {
        this.textureFrameCount = n;
    }

    public final boolean getTranslucent() {
        return this.translucent;
    }

    public final void setTranslucent(boolean bl) {
        this.translucent = bl;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Pair<Bones, List<List<Cube>>> parse(@NotNull ModelFile file) {
        float f;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        ModelFile.Geometry geometry = (ModelFile.Geometry)CollectionsKt.firstOrNull(file.getGeometries());
        if (geometry == null) {
            return null;
        }
        ModelFile.Geometry geometry2 = geometry;
        this.textureFrameCount = RangesKt.coerceAtLeast((int)(this.textureHeight / geometry2.getDescription().getTextureHeight()), (int)1);
        this.translucent = geometry2.getDescription().getTextureTranslucent();
        if (Intrinsics.areEqual((Object)this.cosmetic.getType().getId(), (Object)"PLAYER")) {
            f = 0.0f;
        } else {
            IndexedValue<Set<CosmeticSlot>> indexedValue;
            block14: {
                Iterable<IndexedValue<Set<CosmeticSlot>>> iterable = EXTRA_INFLATE_GROUPS;
                for (IndexedValue<Set<CosmeticSlot>> indexedValue2 : iterable) {
                    IndexedValue<Set<CosmeticSlot>> it = indexedValue2;
                    boolean bl = false;
                    if (!((Set)it.getValue()).contains(this.cosmetic.getType().getSlot())) continue;
                    indexedValue = indexedValue2;
                    break block14;
                }
                indexedValue = null;
            }
            IndexedValue indexedValue3 = (IndexedValue)indexedValue;
            f = (float)(indexedValue3 != null ? indexedValue3.getIndex() : 0) * 0.01f + 0.01f;
        }
        float extraInflate = f;
        List bones = new ArrayList();
        List renderGeometry = new ArrayList();
        Map children = new LinkedHashMap();
        for (ModelFile.Bone bone : CollectionsKt.asReversed(geometry2.getBones())) {
            Object object;
            void $this$getOrPut$iv;
            BedrockModel.Offset offset2;
            Object origin;
            if (StringsKt.startsWith$default((String)bone.getName(), (String)"bbox_", (boolean)false, (int)2, null)) {
                for (ModelFile.Cube cube : bone.getCubes()) {
                    origin = cube.getOrigin();
                    Vector3 size = cube.getSize();
                    Box3 box2 = new Box3(null, null, 3, null);
                    box2.expandByPoint(Vector3.copy$default((Vector3)origin, 0.0f, 0.0f, 0.0f, 7, null).negateY());
                    box2.expandByPoint(((Vector3)origin).plus(size).negateY());
                    box2.expandByScalar(cube.getInflate() + 0.025f);
                    this.boundingBoxes.add((Pair<Box3, Side>)TuplesKt.to((Object)box2, (Object)((Object)bone.getSide())));
                }
                continue;
            }
            if (EnumPart.Companion.fromBoneName(bone.getName()) != null) {
                EnumPart it;
                boolean bl = false;
                offset2 = (BedrockModel.Offset)MapsKt.getValue(BedrockModel.Companion.getOFFSETS(), (Object)((Object)it));
            } else {
                offset2 = null;
            }
            BedrockModel.Offset offset3 = offset2;
            int n = bones.size();
            String string = bone.getName();
            List list = (List)children.remove(bone.getName());
            if (list == null) {
                list = CollectionsKt.emptyList();
            }
            BedrockModel.Offset offset4 = offset3;
            BedrockModel.Offset offset5 = offset3;
            BedrockModel.Offset offset6 = offset3;
            Bone boneModel = new Bone(n, string, list, offset4 != null ? offset4.getPivotX() : bone.getPivot().x, offset5 != null ? offset5.getPivotY() : -bone.getPivot().y, offset6 != null ? offset6.getPivotZ() : bone.getPivot().z, this.toRadians(bone.getRotation().x), this.toRadians(bone.getRotation().y), this.toRadians(bone.getRotation().z), bone.getSide());
            bones.add(boneModel);
            renderGeometry.add(this.parseCubes(geometry2, bone, extraInflate));
            origin = children;
            String string2 = bone.getParent();
            if (string2 == null) {
                string2 = ROOT_BONE_NAME;
            }
            String key$iv = string2;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl = false;
                List answer$iv = new ArrayList();
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            ((List)object).add(0, boneModel);
        }
        int n = bones.size();
        List list = (List)children.remove(ROOT_BONE_NAME);
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        bones.add(new Bone(n, ROOT_BONE_NAME, list, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, null, 1016, null));
        renderGeometry.add(CollectionsKt.emptyList());
        return new Pair((Object)new Bones(bones), (Object)renderGeometry);
    }

    private final List<Cube> parseCubes(ModelFile.Geometry geometry, ModelFile.Bone bone, float extraInflate) {
        List cubeList = new ArrayList();
        for (ModelFile.Cube cube : bone.getCubes()) {
            Cube cube2;
            Vector3 vector3 = Vector3.copy$default(cube.getOrigin(), 0.0f, 0.0f, 0.0f, 7, null).negateY();
            float x = vector3.component1();
            float y = vector3.component2();
            float z = vector3.component3();
            Vector3 vector32 = cube.getSize();
            float dx = vector32.component1();
            float dy = vector32.component2();
            float dz = vector32.component3();
            Boolean bl = cube.getMirror();
            boolean mirror = bl != null ? bl.booleanValue() : bone.getMirror();
            float inflate = cube.getInflate() + extraInflate;
            ModelFile.Uvs uv = cube.getUv();
            if (uv instanceof ModelFile.Uvs.PerFace) {
                CubeUvData uvData = new CubeUvData(this.toFloatArray(((ModelFile.Uvs.PerFace)uv).getNorth()), this.toFloatArray(((ModelFile.Uvs.PerFace)uv).getEast()), this.toFloatArray(((ModelFile.Uvs.PerFace)uv).getSouth()), this.toFloatArray(((ModelFile.Uvs.PerFace)uv).getWest()), this.toFloatArray(((ModelFile.Uvs.PerFace)uv).getUp()), this.toFloatArray(((ModelFile.Uvs.PerFace)uv).getDown()));
                cube2 = new Cube(x, y - dy, z, dx, dy, dz, inflate, mirror, this.textureWidth, this.textureHeight, uvData);
            } else if (uv instanceof ModelFile.Uvs.Box) {
                float[] fArray = ((ModelFile.Uvs.Box)uv).getUv();
                float u = fArray[0];
                float v = fArray[1];
                cube2 = new Cube(u, v, x, y - dy, z, dx, dy, dz, inflate, mirror, this.textureWidth, this.textureHeight);
            } else {
                throw new NoWhenBranchMatchedException();
            }
            Cube cubeModel = cube2;
            cubeList.add(cubeModel);
        }
        if (EnumPart.Companion.fromBoneName(bone.getName()) == EnumPart.CAPE && !Intrinsics.areEqual((Object)geometry.getDescription().getIdentifier(), (Object)CapeModel.INSTANCE.getGEOMETRY_ID())) {
            CollectionsKt.removeFirstOrNull((List)cubeList);
        }
        return cubeList;
    }

    private final float toRadians(float $this$toRadians) {
        return (float)((double)$this$toRadians / 180.0 * Math.PI);
    }

    private final float[] toFloatArray(ModelFile.UvFace $this$toFloatArray) {
        if ($this$toFloatArray == null) {
            float[] fArray = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
            return fArray;
        }
        float[] fArray = $this$toFloatArray.getUv();
        float u = fArray[0];
        float v = fArray[1];
        float[] fArray2 = $this$toFloatArray.getSize();
        float du = fArray2[0];
        float dv = fArray2[1];
        float[] fArray3 = new float[]{u, v, u + du, v + dv};
        return fArray3;
    }

    static {
        Object[] objectArray = new Set[4];
        objectArray[0] = SetsKt.setOf((Object)CosmeticSlot.PANTS);
        Object[] objectArray2 = new CosmeticSlot[]{CosmeticSlot.TOP, CosmeticSlot.HEAD, CosmeticSlot.FACE, CosmeticSlot.BACK};
        objectArray[1] = SetsKt.setOf((Object[])objectArray2);
        objectArray2 = new CosmeticSlot[]{CosmeticSlot.HAT, CosmeticSlot.FULL_BODY};
        objectArray[2] = SetsKt.setOf((Object[])objectArray2);
        objectArray2 = new CosmeticSlot[]{CosmeticSlot.ACCESSORY, CosmeticSlot.ARMS, CosmeticSlot.SHOES};
        objectArray[3] = SetsKt.setOf((Object[])objectArray2);
        EXTRA_INFLATE_GROUPS = CollectionsKt.withIndex((Iterable)CollectionsKt.listOf((Object[])objectArray));
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R \u0010\u0003\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lgg/essential/model/ModelParser$Companion;", "", "()V", "EXTRA_INFLATE_GROUPS", "", "Lkotlin/collections/IndexedValue;", "", "Lgg/essential/mod/cosmetics/CosmeticSlot;", "ROOT_BONE_NAME", "", "cosmetics"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

