/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.mixins.transformers.feature.per_server_settings;

import gg.essential.Essential;
import gg.essential.lib.mixinextras.injector.ModifyExpressionValue;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ServerList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtIo;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyArg;

@Mixin(value={ServerList.class})
public abstract class Mixin_PreserveCustomServerData {
    private static final String NBT_READ = "Lnet/minecraft/nbt/NbtIo;read(Ljava/io/File;)Lnet/minecraft/nbt/CompoundTag;";
    private static final String NBT_WRITE = "Lnet/minecraft/nbt/NbtIo;write(Lnet/minecraft/nbt/CompoundTag;Ljava/io/File;)V";
    @Shadow
    @Final
    private Minecraft f_105426_;

    @Unique
    private File backupFile() {
        return new File(this.f_105426_.f_91069_, "servers.essential.dat");
    }

    @ModifyArg(method={"save"}, at=@At(value="INVOKE", target="Lnet/minecraft/nbt/NbtIo;write(Lnet/minecraft/nbt/CompoundTag;Ljava/io/File;)V"))
    private CompoundTag backupServerList(CompoundTag tag2) throws IOException {
        NbtIo.m_128955_((CompoundTag)tag2, (File)this.backupFile());
        return tag2;
    }

    @ModifyExpressionValue(method={"load"}, at={@At(value="INVOKE", target="Lnet/minecraft/nbt/NbtIo;read(Ljava/io/File;)Lnet/minecraft/nbt/CompoundTag;")})
    private CompoundTag validateAndRestoreServerList(CompoundTag vanillaTag) {
        CompoundTag backupTag;
        if (vanillaTag == null) {
            return null;
        }
        try {
            backupTag = NbtIo.m_128953_((File)this.backupFile());
        }
        catch (Exception e) {
            Essential.logger.error("Couldn't load server list backup", (Throwable)e);
            try {
                NbtIo.m_128955_((CompoundTag)vanillaTag, (File)this.backupFile());
            }
            catch (Exception e1) {
                Essential.logger.error("Couldn't re-write server list backup", (Throwable)e1);
            }
            backupTag = null;
        }
        if (backupTag == null) {
            return vanillaTag;
        }
        if (vanillaTag.equals((Object)backupTag)) {
            return vanillaTag;
        }
        ListTag vanillaServers = vanillaTag.m_128437_("servers", 10);
        ListTag backupServers = backupTag.m_128437_("servers", 10);
        HashSet<CompoundTag> alreadyMatched = new HashSet<CompoundTag>();
        for (int pass = 0; pass < 3; ++pass) {
            block10: for (int vanillaIdx = 0; vanillaIdx < vanillaServers.size(); ++vanillaIdx) {
                List<CompoundTag> vanillaMatches;
                List<CompoundTag> backupMatches;
                CompoundTag vanillaServer = vanillaServers.m_128728_(vanillaIdx);
                if (alreadyMatched.contains(vanillaServer)) continue;
                String name2 = vanillaServer.m_128461_("name");
                String address = vanillaServer.m_128461_("ip");
                switch (pass) {
                    case 0: {
                        backupMatches = this.find(backupServers, alreadyMatched, name2, address);
                        vanillaMatches = this.find(vanillaServers, alreadyMatched, name2, address);
                        break;
                    }
                    case 1: {
                        backupMatches = this.find(backupServers, alreadyMatched, null, address);
                        vanillaMatches = this.find(vanillaServers, alreadyMatched, null, address);
                        break;
                    }
                    case 2: {
                        backupMatches = this.find(backupServers, alreadyMatched, name2, null);
                        vanillaMatches = this.find(vanillaServers, alreadyMatched, name2, null);
                        if (backupMatches.size() == vanillaMatches.size()) break;
                        continue block10;
                    }
                    default: {
                        throw new AssertionError();
                    }
                }
                if (backupMatches.isEmpty()) continue;
                int index2 = vanillaMatches.indexOf(vanillaServer);
                if (index2 >= backupMatches.size()) {
                    index2 = backupMatches.size() - 1;
                }
                CompoundTag backupServer = backupMatches.get(index2);
                alreadyMatched.add(vanillaServer);
                alreadyMatched.add(backupServer);
                for (String key : backupServer.m_128431_()) {
                    if (!key.startsWith("essential:")) continue;
                    vanillaServer.m_128365_(key, backupServer.m_128423_(key));
                }
            }
        }
        return vanillaTag;
    }

    @Unique
    private List<CompoundTag> find(ListTag list, Set<CompoundTag> alreadyMatched, String name2, String address) {
        ArrayList<CompoundTag> result = new ArrayList<CompoundTag>();
        for (int i2 = 0; i2 < list.size(); ++i2) {
            CompoundTag server = list.m_128728_(i2);
            String serverName2 = server.m_128461_("name");
            String serverAddress = server.m_128461_("ip");
            if (alreadyMatched.contains(server) || name2 != null && !serverName2.equals(name2) || address != null && !serverAddress.equals(address)) continue;
            result.add(server);
        }
        return result;
    }
}

