/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.mixins.transformers.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import gg.essential.cosmetics.CosmeticsRenderState;
import gg.essential.lib.kotgl.matrix.matrices.Matrices;
import gg.essential.lib.kotgl.matrix.matrices.mutables.MutableMat4;
import gg.essential.lib.kotgl.matrix.matrices.mutables.MutableMatrices;
import gg.essential.model.backend.PlayerPose;
import gg.essential.model.util.PlayerPoseManager;
import gg.essential.model.util.UMatrixStack;
import gg.essential.util.GLUtil;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.layers.ParrotOnShoulderLayer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import org.spongepowered.asm.mixin.Dynamic;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Surrogate;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ParrotOnShoulderLayer.class})
public abstract class Mixin_ApplyPoseTransform_EntityOnShoulder {
    @Unique
    private void applyPoseTransform(CosmeticsRenderState cState, boolean leftSide, PoseStack matrixStack) {
        PlayerPose transformedPose;
        PlayerPoseManager poseManager = cState.poseManager();
        if (poseManager == null) {
            return;
        }
        PlayerPose basePose = PlayerPose.Companion.neutral();
        if (basePose.equals(transformedPose = poseManager.computePose(cState.wearablesManager(), basePose))) {
            return;
        }
        PlayerPose.Part part = leftSide ? transformedPose.getLeftShoulderEntity() : transformedPose.getRightShoulderEntity();
        UMatrixStack uMatrixStack = new UMatrixStack(Matrices.identityMat4(), Matrices.identityMat3());
        uMatrixStack.translate(part.getPivotX(), part.getPivotY(), part.getPivotZ());
        uMatrixStack.rotate(part.getRotateAngleZ(), 0.0f, 0.0f, 1.0f, false);
        uMatrixStack.rotate(part.getRotateAngleY(), 0.0f, 1.0f, 0.0f, false);
        uMatrixStack.rotate(part.getRotateAngleX(), 1.0f, 0.0f, 0.0f, false);
        MutableMat4 modelMatrix = uMatrixStack.peek().getModel();
        if (part.getExtra() != null) {
            MutableMatrices.timesSelf(modelMatrix, part.getExtra());
        }
        GLUtil.INSTANCE.glMultMatrix(matrixStack, modelMatrix, 0.0625f);
    }

    @Inject(method={"m_262347_", "lambda$render$1", "lambda$renderParrot$1"}, at={@At(value="INVOKE", target="Lcom/mojang/blaze3d/vertex/PoseStack;pushPose()V", shift=At.Shift.AFTER, remap=true)})
    private void applyPoseTransform(PoseStack matrixStack, boolean leftSide, Player player2, CompoundTag nbt, MultiBufferSource buffer, int packedLight, float limbSwing, float limbSwingAmount, float netHeadYaw, float headPitch, EntityType<?> entityType, CallbackInfo ci) {
        if (!(player2 instanceof AbstractClientPlayer)) {
            return;
        }
        CosmeticsRenderState.Live cState = new CosmeticsRenderState.Live((AbstractClientPlayer)player2);
        this.applyPoseTransform(cState, leftSide, matrixStack);
    }

    @Surrogate
    @Dynamic(value="Optifine changes arguments")
    private void applyPoseTransform(Player player2, boolean leftSide, PoseStack matrixStack, MultiBufferSource buffer, CompoundTag nbt, int packedLight, float limbSwing, float limbSwingAmount, float netHeadYaw, float headPitch, EntityType<?> entityType, CallbackInfo ci) {
        if (!(player2 instanceof AbstractClientPlayer)) {
            return;
        }
        CosmeticsRenderState.Live cState = new CosmeticsRenderState.Live((AbstractClientPlayer)player2);
        this.applyPoseTransform(cState, leftSide, matrixStack);
    }

    @Surrogate
    @Dynamic(value="Optifine changes arguments")
    private void applyPoseTransform(Player player2, boolean leftSide, CompoundTag nbt, PoseStack matrixStack, MultiBufferSource buffer, int packedLight, float limbSwing, float limbSwingAmount, float netHeadYaw, float headPitch, EntityType<?> entityType, CallbackInfo ci) {
        if (!(player2 instanceof AbstractClientPlayer)) {
            return;
        }
        CosmeticsRenderState.Live cState = new CosmeticsRenderState.Live((AbstractClientPlayer)player2);
        this.applyPoseTransform(cState, leftSide, matrixStack);
    }
}

