/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.mixins.transformers.client.renderer.entity;

import gg.essential.cosmetics.CosmeticsRenderState;
import gg.essential.lib.mixinextras.sugar.Local;
import gg.essential.mixins.impl.client.model.ElytraPoseSupplier;
import gg.essential.model.backend.PlayerPose;
import gg.essential.model.backend.minecraft.PlayerPoseKt;
import gg.essential.model.util.PlayerPoseManager;
import net.minecraft.client.model.ElytraModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.world.entity.LivingEntity;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ElytraModel.class})
public abstract class Mixin_ApplyPoseTransform_Elytra
implements ElytraPoseSupplier {
    @Shadow
    @Final
    private ModelPart f_102533_;
    @Shadow
    @Final
    private ModelPart f_102532_;
    @Unique
    private PlayerPose resetPose;

    @Inject(method={"setupAnim"}, at={@At(value="HEAD")})
    private void resetPose(CallbackInfo ci, @Local(argsOnly=true) LivingEntity entity) {
        if (!(entity instanceof AbstractClientPlayer)) {
            return;
        }
        CosmeticsRenderState.Live cState = new CosmeticsRenderState.Live((AbstractClientPlayer)entity);
        if (this.resetPose == null) {
            this.resetPose = PlayerPoseKt.withElytraPose(PlayerPose.Companion.neutral(), this.f_102533_, this.f_102532_, cState);
        } else {
            PlayerPoseKt.applyElytraPose(this.resetPose, this.f_102533_, this.f_102532_, cState);
        }
    }

    @Inject(method={"setupAnim"}, at={@At(value="TAIL")})
    private void applyPoseTransform(CallbackInfo ci, @Local(argsOnly=true) LivingEntity entity) {
        PlayerPose transformedPose;
        if (!(entity instanceof AbstractClientPlayer)) {
            return;
        }
        CosmeticsRenderState.Live cState = new CosmeticsRenderState.Live((AbstractClientPlayer)entity);
        PlayerPoseManager poseManager = cState.poseManager();
        if (poseManager == null) {
            return;
        }
        PlayerPose basePose = PlayerPoseKt.withElytraPose(PlayerPose.Companion.neutral(), this.f_102533_, this.f_102532_, cState);
        if (basePose.equals(transformedPose = poseManager.computePose(cState.wearablesManager(), basePose))) {
            return;
        }
        PlayerPoseKt.applyElytraPose(transformedPose, this.f_102533_, this.f_102532_, cState);
    }

    @Override
    @Nullable
    public PlayerPose.Part getLeftWingPose() {
        return PlayerPoseKt.toPose(this.f_102533_);
    }

    @Override
    @Nullable
    public PlayerPose.Part getRightWingPose() {
        return PlayerPoseKt.toPose(this.f_102532_);
    }
}

