/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.lib.okhttp3.internal.http;

import gg.essential.lib.okhttp3.HttpUrl;
import gg.essential.lib.okhttp3.Request;
import java.net.Proxy;

public final class RequestLine {
    private RequestLine() {
    }

    public static String get(Request request2, Proxy.Type proxyType) {
        StringBuilder result = new StringBuilder();
        result.append(request2.method());
        result.append(' ');
        if (RequestLine.includeAuthorityInRequestLine(request2, proxyType)) {
            result.append(request2.url());
        } else {
            result.append(RequestLine.requestPath(request2.url()));
        }
        result.append(" HTTP/1.1");
        return result.toString();
    }

    private static boolean includeAuthorityInRequestLine(Request request2, Proxy.Type proxyType) {
        return !request2.isHttps() && proxyType == Proxy.Type.HTTP;
    }

    public static String requestPath(HttpUrl url) {
        String path = url.encodedPath();
        String query = url.encodedQuery();
        return query != null ? path + '?' + query : path;
    }
}

