/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.lib.okhttp3.internal;

import gg.essential.lib.okhttp3.HttpUrl;
import gg.essential.lib.okhttp3.RequestBody;
import gg.essential.lib.okhttp3.ResponseBody;
import gg.essential.lib.okio.Buffer;
import gg.essential.lib.okio.BufferedSource;
import gg.essential.lib.okio.ByteString;
import gg.essential.lib.okio.Source;
import java.io.Closeable;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.IDN;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

public final class Util {
    public static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    public static final String[] EMPTY_STRING_ARRAY = new String[0];
    public static final ResponseBody EMPTY_RESPONSE = ResponseBody.create(null, EMPTY_BYTE_ARRAY);
    public static final RequestBody EMPTY_REQUEST = RequestBody.create(null, EMPTY_BYTE_ARRAY);
    private static final ByteString UTF_8_BOM = ByteString.decodeHex("efbbbf");
    private static final ByteString UTF_16_BE_BOM = ByteString.decodeHex("feff");
    private static final ByteString UTF_16_LE_BOM = ByteString.decodeHex("fffe");
    private static final ByteString UTF_32_BE_BOM = ByteString.decodeHex("0000ffff");
    private static final ByteString UTF_32_LE_BOM = ByteString.decodeHex("ffff0000");
    public static final Charset UTF_8 = Charset.forName("UTF-8");
    public static final Charset ISO_8859_1 = Charset.forName("ISO-8859-1");
    private static final Charset UTF_16_BE = Charset.forName("UTF-16BE");
    private static final Charset UTF_16_LE = Charset.forName("UTF-16LE");
    private static final Charset UTF_32_BE = Charset.forName("UTF-32BE");
    private static final Charset UTF_32_LE = Charset.forName("UTF-32LE");
    public static final TimeZone UTC = TimeZone.getTimeZone("GMT");
    public static final Comparator<String> NATURAL_ORDER = new Comparator<String>(){

        @Override
        public int compare(String a, String b) {
            return a.compareTo(b);
        }
    };
    private static final Pattern VERIFY_AS_IP_ADDRESS = Pattern.compile("([0-9a-fA-F]*:[0-9a-fA-F:.]*)|([\\d.]+)");

    private Util() {
    }

    public static void checkOffsetAndCount(long arrayLength, long offset2, long count) {
        if ((offset2 | count) < 0L || offset2 > arrayLength || arrayLength - offset2 < count) {
            throw new ArrayIndexOutOfBoundsException();
        }
    }

    public static boolean equal(Object a, Object b) {
        return a == b || a != null && a.equals(b);
    }

    public static void closeQuietly(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (RuntimeException rethrown) {
                throw rethrown;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void closeQuietly(Socket socket) {
        if (socket != null) {
            try {
                socket.close();
            }
            catch (AssertionError e) {
                if (!Util.isAndroidGetsocknameError(e)) {
                    throw e;
                }
            }
            catch (RuntimeException rethrown) {
                throw rethrown;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void closeQuietly(ServerSocket serverSocket) {
        if (serverSocket != null) {
            try {
                serverSocket.close();
            }
            catch (RuntimeException rethrown) {
                throw rethrown;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static boolean discard(Source source, int timeout, TimeUnit timeUnit) {
        try {
            return Util.skipAll(source, timeout, timeUnit);
        }
        catch (IOException e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean skipAll(Source source, int duration, TimeUnit timeUnit) throws IOException {
        long now2 = System.nanoTime();
        long originalDuration = source.timeout().hasDeadline() ? source.timeout().deadlineNanoTime() - now2 : Long.MAX_VALUE;
        source.timeout().deadlineNanoTime(now2 + Math.min(originalDuration, timeUnit.toNanos(duration)));
        try {
            Buffer skipBuffer = new Buffer();
            while (source.read(skipBuffer, 8192L) != -1L) {
                skipBuffer.clear();
            }
            boolean bl = true;
            return bl;
        }
        catch (InterruptedIOException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (originalDuration == Long.MAX_VALUE) {
                source.timeout().clearDeadline();
            } else {
                source.timeout().deadlineNanoTime(now2 + originalDuration);
            }
        }
    }

    public static <T> List<T> immutableList(List<T> list) {
        return Collections.unmodifiableList(new ArrayList<T>(list));
    }

    public static <T> List<T> immutableList(T ... elements) {
        return Collections.unmodifiableList(Arrays.asList((Object[])elements.clone()));
    }

    public static ThreadFactory threadFactory(final String name2, final boolean daemon) {
        return new ThreadFactory(){

            @Override
            public Thread newThread(Runnable runnable) {
                Thread result = new Thread(runnable, name2);
                result.setDaemon(daemon);
                return result;
            }
        };
    }

    public static String[] intersect(Comparator<? super String> comparator, String[] first, String[] second) {
        ArrayList<String> result = new ArrayList<String>();
        block0: for (String a : first) {
            for (String b : second) {
                if (comparator.compare(a, b) != 0) continue;
                result.add(a);
                continue block0;
            }
        }
        return result.toArray(new String[result.size()]);
    }

    public static boolean nonEmptyIntersection(Comparator<String> comparator, String[] first, String[] second) {
        if (first == null || second == null || first.length == 0 || second.length == 0) {
            return false;
        }
        for (String a : first) {
            for (String b : second) {
                if (comparator.compare(a, b) != 0) continue;
                return true;
            }
        }
        return false;
    }

    public static String hostHeader(HttpUrl url, boolean includeDefaultPort) {
        String host = url.host().contains(":") ? "[" + url.host() + "]" : url.host();
        return includeDefaultPort || url.port() != HttpUrl.defaultPort(url.scheme()) ? host + ":" + url.port() : host;
    }

    public static String toHumanReadableAscii(String s) {
        int c;
        int length = s.length();
        for (int i2 = 0; i2 < length; i2 += Character.charCount(c)) {
            c = s.codePointAt(i2);
            if (c > 31 && c < 127) continue;
            Buffer buffer = new Buffer();
            buffer.writeUtf8(s, 0, i2);
            for (int j = i2; j < length; j += Character.charCount(c)) {
                c = s.codePointAt(j);
                buffer.writeUtf8CodePoint(c > 31 && c < 127 ? c : 63);
            }
            return buffer.readUtf8();
        }
        return s;
    }

    public static boolean isAndroidGetsocknameError(AssertionError e) {
        return ((Throwable)((Object)e)).getCause() != null && ((Throwable)((Object)e)).getMessage() != null && ((Throwable)((Object)e)).getMessage().contains("getsockname failed");
    }

    public static int indexOf(Comparator<String> comparator, String[] array, String value) {
        int size = array.length;
        for (int i2 = 0; i2 < size; ++i2) {
            if (comparator.compare(array[i2], value) != 0) continue;
            return i2;
        }
        return -1;
    }

    public static String[] concat(String[] array, String value) {
        String[] result = new String[array.length + 1];
        System.arraycopy(array, 0, result, 0, array.length);
        result[result.length - 1] = value;
        return result;
    }

    public static int skipLeadingAsciiWhitespace(String input2, int pos, int limit) {
        block3: for (int i2 = pos; i2 < limit; ++i2) {
            switch (input2.charAt(i2)) {
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': {
                    continue block3;
                }
                default: {
                    return i2;
                }
            }
        }
        return limit;
    }

    public static int skipTrailingAsciiWhitespace(String input2, int pos, int limit) {
        block3: for (int i2 = limit - 1; i2 >= pos; --i2) {
            switch (input2.charAt(i2)) {
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': {
                    continue block3;
                }
                default: {
                    return i2 + 1;
                }
            }
        }
        return pos;
    }

    public static String trimSubstring(String string, int pos, int limit) {
        int start2 = Util.skipLeadingAsciiWhitespace(string, pos, limit);
        int end = Util.skipTrailingAsciiWhitespace(string, start2, limit);
        return string.substring(start2, end);
    }

    public static int delimiterOffset(String input2, int pos, int limit, String delimiters) {
        for (int i2 = pos; i2 < limit; ++i2) {
            if (delimiters.indexOf(input2.charAt(i2)) == -1) continue;
            return i2;
        }
        return limit;
    }

    public static int delimiterOffset(String input2, int pos, int limit, char delimiter) {
        for (int i2 = pos; i2 < limit; ++i2) {
            if (input2.charAt(i2) != delimiter) continue;
            return i2;
        }
        return limit;
    }

    public static String canonicalizeHost(String host) {
        if (host.contains(":")) {
            InetAddress inetAddress;
            InetAddress inetAddress2 = inetAddress = host.startsWith("[") && host.endsWith("]") ? Util.decodeIpv6(host, 1, host.length() - 1) : Util.decodeIpv6(host, 0, host.length());
            if (inetAddress == null) {
                return null;
            }
            byte[] address = inetAddress.getAddress();
            if (address.length == 16) {
                return Util.inet6AddressToAscii(address);
            }
            throw new AssertionError((Object)("Invalid IPv6 address: '" + host + "'"));
        }
        try {
            String result = IDN.toASCII(host).toLowerCase(Locale.US);
            if (result.isEmpty()) {
                return null;
            }
            if (Util.containsInvalidHostnameAsciiCodes(result)) {
                return null;
            }
            return result;
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    private static boolean containsInvalidHostnameAsciiCodes(String hostnameAscii) {
        for (int i2 = 0; i2 < hostnameAscii.length(); ++i2) {
            char c = hostnameAscii.charAt(i2);
            if (c <= '\u001f' || c >= '\u007f') {
                return true;
            }
            if (" #%/:?@[\\]".indexOf(c) == -1) continue;
            return true;
        }
        return false;
    }

    public static int indexOfControlOrNonAscii(String input2) {
        int length = input2.length();
        for (int i2 = 0; i2 < length; ++i2) {
            char c = input2.charAt(i2);
            if (c > '\u001f' && c < '\u007f') continue;
            return i2;
        }
        return -1;
    }

    public static boolean verifyAsIpAddress(String host) {
        return VERIFY_AS_IP_ADDRESS.matcher(host).matches();
    }

    public static String format(String format, Object ... args) {
        return String.format(Locale.US, format, args);
    }

    public static Charset bomAwareCharset(BufferedSource source, Charset charset) throws IOException {
        if (source.rangeEquals(0L, UTF_8_BOM)) {
            source.skip(UTF_8_BOM.size());
            return UTF_8;
        }
        if (source.rangeEquals(0L, UTF_16_BE_BOM)) {
            source.skip(UTF_16_BE_BOM.size());
            return UTF_16_BE;
        }
        if (source.rangeEquals(0L, UTF_16_LE_BOM)) {
            source.skip(UTF_16_LE_BOM.size());
            return UTF_16_LE;
        }
        if (source.rangeEquals(0L, UTF_32_BE_BOM)) {
            source.skip(UTF_32_BE_BOM.size());
            return UTF_32_BE;
        }
        if (source.rangeEquals(0L, UTF_32_LE_BOM)) {
            source.skip(UTF_32_LE_BOM.size());
            return UTF_32_LE;
        }
        return charset;
    }

    public static int checkDuration(String name2, long duration, TimeUnit unit) {
        if (duration < 0L) {
            throw new IllegalArgumentException(name2 + " < 0");
        }
        if (unit == null) {
            throw new NullPointerException("unit == null");
        }
        long millis = unit.toMillis(duration);
        if (millis > Integer.MAX_VALUE) {
            throw new IllegalArgumentException(name2 + " too large.");
        }
        if (millis == 0L && duration > 0L) {
            throw new IllegalArgumentException(name2 + " too small.");
        }
        return (int)millis;
    }

    public static AssertionError assertionError(String message2, Exception e) {
        return (AssertionError)((Object)((Throwable)((Object)new AssertionError((Object)message2))).initCause(e));
    }

    public static int decodeHexDigit(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'a' && c <= 'f') {
            return c - 97 + 10;
        }
        if (c >= 'A' && c <= 'F') {
            return c - 65 + 10;
        }
        return -1;
    }

    @Nullable
    private static InetAddress decodeIpv6(String input2, int pos, int limit) {
        byte[] address = new byte[16];
        int b = 0;
        int compress = -1;
        int groupOffset = -1;
        int i2 = pos;
        while (i2 < limit) {
            char c;
            int hexDigit;
            if (b == address.length) {
                return null;
            }
            if (i2 + 2 <= limit && input2.regionMatches(i2, "::", 0, 2)) {
                if (compress != -1) {
                    return null;
                }
                compress = b += 2;
                if ((i2 += 2) == limit) {
                    break;
                }
            } else if (b != 0 && !input2.regionMatches(i2, ":", 0, 1)) {
                if (input2.regionMatches(i2, ".", 0, 1)) {
                    if (!Util.decodeIpv4Suffix(input2, groupOffset, limit, address, b - 2)) {
                        return null;
                    }
                    b += 2;
                    break;
                }
                return null;
            }
            int value = 0;
            groupOffset = ++i2;
            while (i2 < limit && (hexDigit = Util.decodeHexDigit(c = input2.charAt(i2))) != -1) {
                value = (value << 4) + hexDigit;
                ++i2;
            }
            int groupLength = i2 - groupOffset;
            if (groupLength == 0 || groupLength > 4) {
                return null;
            }
            address[b++] = (byte)(value >>> 8 & 0xFF);
            address[b++] = (byte)(value & 0xFF);
        }
        if (b != address.length) {
            if (compress == -1) {
                return null;
            }
            System.arraycopy(address, compress, address, address.length - (b - compress), b - compress);
            Arrays.fill(address, compress, compress + (address.length - b), (byte)0);
        }
        try {
            return InetAddress.getByAddress(address);
        }
        catch (UnknownHostException e) {
            throw new AssertionError();
        }
    }

    private static boolean decodeIpv4Suffix(String input2, int pos, int limit, byte[] address, int addressOffset) {
        int b = addressOffset;
        int i2 = pos;
        while (i2 < limit) {
            char c;
            if (b == address.length) {
                return false;
            }
            if (b != addressOffset && input2.charAt(i2) != '.') {
                return false;
            }
            int value = 0;
            int groupOffset = ++i2;
            while (i2 < limit && (c = input2.charAt(i2)) >= '0' && c <= '9') {
                if (value == 0 && groupOffset != i2) {
                    return false;
                }
                if ((value = value * 10 + c - 48) > 255) {
                    return false;
                }
                ++i2;
            }
            int groupLength = i2 - groupOffset;
            if (groupLength == 0) {
                return false;
            }
            address[b++] = (byte)value;
        }
        return b == addressOffset + 4;
    }

    private static String inet6AddressToAscii(byte[] address) {
        int longestRunOffset = -1;
        int longestRunLength = 0;
        for (int i2 = 0; i2 < address.length; i2 += 2) {
            int currentRunOffset = i2;
            while (i2 < 16 && address[i2] == 0 && address[i2 + 1] == 0) {
                i2 += 2;
            }
            int currentRunLength = i2 - currentRunOffset;
            if (currentRunLength <= longestRunLength || currentRunLength < 4) continue;
            longestRunOffset = currentRunOffset;
            longestRunLength = currentRunLength;
        }
        Buffer result = new Buffer();
        int i3 = 0;
        while (i3 < address.length) {
            if (i3 == longestRunOffset) {
                result.writeByte(58);
                if ((i3 += longestRunLength) != 16) continue;
                result.writeByte(58);
                continue;
            }
            if (i3 > 0) {
                result.writeByte(58);
            }
            int group2 = (address[i3] & 0xFF) << 8 | address[i3 + 1] & 0xFF;
            result.writeHexadecimalUnsignedLong(group2);
            i3 += 2;
        }
        return result.readUtf8();
    }
}

