/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.lib.mixinextras.wrapper;

import gg.essential.lib.mixinextras.sugar.impl.SingleIterationList;
import gg.essential.lib.mixinextras.utils.CompatibilityHelper;
import gg.essential.lib.mixinextras.utils.MixinInternals;
import gg.essential.lib.mixinextras.wrapper.WrapperInjectionInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;
import org.spongepowered.asm.mixin.injection.code.Injector;
import org.spongepowered.asm.mixin.injection.struct.InjectionInfo;
import org.spongepowered.asm.mixin.injection.struct.InjectionNodes;
import org.spongepowered.asm.mixin.injection.struct.Target;
import org.spongepowered.asm.mixin.transformer.MixinTargetContext;

public abstract class InjectorWrapperImpl {
    private final InjectionInfo wrapperInfo;
    protected final ClassNode classNode;
    private final boolean useGranularInject;

    protected InjectorWrapperImpl(InjectionInfo wrapper, MixinTargetContext mixin, MethodNode method, AnnotationNode annotation2, boolean useGranularInject) {
        this.wrapperInfo = wrapper;
        this.classNode = mixin.getTargetClassNode();
        this.useGranularInject = useGranularInject;
    }

    public boolean usesGranularInject() {
        return this.useGranularInject;
    }

    protected abstract InjectionInfo getDelegate();

    protected abstract MethodNode getHandler();

    protected boolean isValid() {
        return this.getDelegate().isValid();
    }

    public int getOrder() {
        return CompatibilityHelper.getOrder(this.getDelegate());
    }

    protected void prepare() {
        this.getDelegate().prepare();
        MethodNode handler = this.getHandler();
        handler.visibleAnnotations.remove(InjectionInfo.getInjectorAnnotation((IMixinInfo)CompatibilityHelper.getMixin(this.wrapperInfo).getMixin(), (MethodNode)handler));
    }

    protected void preInject() {
        CompatibilityHelper.preInject(this.getDelegate());
    }

    protected void inject() {
        if (this.useGranularInject) {
            this.granularInject((target2, node2, call) -> {});
            return;
        }
        this.getDelegate().inject();
    }

    protected void granularInject(HandlerCallCallback callback) {
        InjectionInfo delegate2 = this.getDelegate();
        if (delegate2 instanceof WrapperInjectionInfo) {
            WrapperInjectionInfo wrapper = (WrapperInjectionInfo)delegate2;
            wrapper.impl.granularInject(callback);
            return;
        }
        this.doGranularInject(callback);
    }

    protected void doPostInject(Runnable postInject) {
        postInject.run();
    }

    protected void addCallbackInvocation(MethodNode handler) {
        this.getDelegate().addCallbackInvocation(handler);
    }

    protected RuntimeException granularInjectNotSupported() {
        return new IllegalStateException(this.getDelegate().getClass() + " does not support granular injection! Please report to LlamaLad7!");
    }

    private void doGranularInject(HandlerCallCallback callback) {
        InjectionInfo delegate2 = this.getDelegate();
        Map<Target, List<InjectionNodes.InjectionNode>> targets = MixinInternals.getTargets(delegate2);
        Injector injector = MixinInternals.getInjector(delegate2);
        for (Map.Entry<Target, List<InjectionNodes.InjectionNode>> entry : targets.entrySet()) {
            Target target2 = entry.getKey();
            HashSet<MethodInsnNode> discoveredHandlerCalls = new HashSet<MethodInsnNode>(this.findHandlerCalls(target2));
            for (InjectionNodes.InjectionNode node2 : entry.getValue()) {
                InjectorWrapperImpl.inject(injector, target2, node2);
                for (MethodInsnNode handlerCall : this.findHandlerCalls(target2)) {
                    if (!discoveredHandlerCalls.add(handlerCall)) continue;
                    callback.onFound(target2, node2, handlerCall);
                }
            }
            InjectorWrapperImpl.postInject(injector, target2, entry.getValue());
        }
        targets.clear();
    }

    private List<MethodInsnNode> findHandlerCalls(Target target2) {
        MethodNode handler = this.getHandler();
        ArrayList<MethodInsnNode> result = new ArrayList<MethodInsnNode>();
        for (AbstractInsnNode insn : target2) {
            if (!(insn instanceof MethodInsnNode)) continue;
            MethodInsnNode call = (MethodInsnNode)insn;
            if (!call.owner.equals(this.classNode.name) || !call.name.equals(handler.name) || !call.desc.equals(handler.desc)) continue;
            result.add(call);
        }
        return result;
    }

    private static void inject(Injector injector, Target target2, InjectionNodes.InjectionNode node2) {
        injector.inject(target2, new SingleIterationList<InjectionNodes.InjectionNode>(Collections.singletonList(node2), 0));
    }

    private static void postInject(Injector injector, Target target2, List<InjectionNodes.InjectionNode> nodes) {
        injector.inject(target2, new SingleIterationList<InjectionNodes.InjectionNode>(nodes, 1));
    }

    @FunctionalInterface
    public static interface HandlerCallCallback {
        public void onFound(Target var1, InjectionNodes.InjectionNode var2, MethodInsnNode var3);
    }

    @FunctionalInterface
    public static interface Factory {
        public InjectorWrapperImpl create(InjectionInfo var1, MixinTargetContext var2, MethodNode var3, AnnotationNode var4);
    }
}

