/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.lib.kdiscordipc.core.socket.impl;

import gg.essential.lib.kdiscordipc.core.socket.RawPacket;
import gg.essential.lib.kdiscordipc.core.socket.Socket;
import gg.essential.lib.kdiscordipc.core.util.IntegerKt;
import java.io.DataInputStream;
import java.io.File;
import java.io.InputStream;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.newsclub.net.unix.AFUNIXSocket;
import org.newsclub.net.unix.AFUNIXSocketAddress;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\b\u0010\u0015\u001a\u00020\u0014H\u0002J\u0010\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u0012H\u0016R\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lgg/essential/lib/kdiscordipc/core/socket/impl/UnixSocket;", "Lgg/essential/lib/kdiscordipc/core/socket/Socket;", "()V", "connected", "", "getConnected", "()Z", "socket", "Lorg/newsclub/net/unix/AFUNIXSocket;", "kotlin.jvm.PlatformType", "close", "", "connect", "file", "Ljava/io/File;", "read", "Lgg/essential/lib/kdiscordipc/core/socket/RawPacket;", "readBytes", "", "length", "", "readLittleEndianInt", "write", "bytes", "KDiscordIPC"})
public final class UnixSocket
implements Socket {
    private final AFUNIXSocket socket = AFUNIXSocket.newInstance();

    @Override
    public boolean getConnected() {
        return this.socket.isConnected();
    }

    @Override
    public void connect(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this.socket.connect((SocketAddress)AFUNIXSocketAddress.of((File)file));
    }

    @Override
    @NotNull
    public RawPacket read() {
        int opcode = this.readLittleEndianInt();
        int length = this.readLittleEndianInt();
        DataInputStream stream = new DataInputStream((InputStream)this.socket.getInputStream());
        byte[] data = new byte[length];
        stream.readFully(data);
        return new RawPacket(opcode, length, data);
    }

    private final int readLittleEndianInt() {
        return IntegerKt.reverse(ByteBuffer.wrap(this.readBytes(4)).getInt());
    }

    private final byte[] readBytes(int length) {
        byte[] array = new byte[length];
        this.socket.getInputStream().read(array, 0, length);
        return array;
    }

    @Override
    public void write(@NotNull byte[] bytes) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        this.socket.getOutputStream().write(bytes);
    }

    @Override
    public void close() {
        this.socket.close();
    }
}

