/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.lib.caffeine.cache;

import gg.essential.lib.caffeine.cache.Caffeine;
import gg.essential.lib.caffeine.cache.Scheduler;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.checkerframework.checker.nullness.qual.Nullable;

final class Pacer {
    static final long TOLERANCE = Caffeine.ceilingPowerOfTwo(TimeUnit.SECONDS.toNanos(1L));
    final Scheduler scheduler;
    long nextFireTime;
    @Nullable Future<?> future;

    Pacer(Scheduler scheduler) {
        this.scheduler = Objects.requireNonNull(scheduler);
    }

    public void schedule(Executor executor, Runnable command, long now2, long delay2) {
        long scheduleAt = now2 + delay2;
        if (this.future == null) {
            if (this.nextFireTime != 0L) {
                return;
            }
        } else if (this.nextFireTime - now2 > 0L) {
            if (this.maySkip(scheduleAt)) {
                return;
            }
            this.future.cancel(false);
        }
        long actualDelay = this.calculateSchedule(now2, delay2, scheduleAt);
        this.future = this.scheduler.schedule(executor, command, actualDelay, TimeUnit.NANOSECONDS);
    }

    boolean maySkip(long scheduleAt) {
        long delta = scheduleAt - this.nextFireTime;
        return delta >= 0L || -delta <= TOLERANCE;
    }

    long calculateSchedule(long now2, long delay2, long scheduleAt) {
        if (delay2 <= TOLERANCE) {
            this.nextFireTime = now2 + TOLERANCE;
            return TOLERANCE;
        }
        this.nextFireTime = scheduleAt;
        return delay2;
    }
}

