/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.ice;

import gg.essential.ice.Candidate;
import gg.essential.ice.CandidateManager;
import gg.essential.ice.CandidateType;
import gg.essential.ice.IceAgent;
import gg.essential.ice.LocalCandidate;
import gg.essential.ice.LocalPeerReflexiveCandidate;
import gg.essential.ice.RemoteCandidate;
import gg.essential.ice.RemoteCandidateImpl;
import gg.essential.ice.UtilsKt;
import gg.essential.ice.stun.StunAttribute;
import gg.essential.ice.stun.StunClass;
import gg.essential.ice.stun.StunManager;
import gg.essential.ice.stun.StunMessage;
import gg.essential.ice.stun.StunRequest;
import gg.essential.ice.stun.StunSocket;
import gg.essential.ice.stun.StunType;
import gg.essential.ice.stun.TransactionId;
import gg.essential.ice.stun.UdpStunPacket;
import gg.essential.slf4j.ExtendedLoggerKt;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlin.time.TimeSource;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CompletableDeferred;
import kotlinx.coroutines.CompletableDeferredKt;
import kotlinx.coroutines.CompletableJob;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.CoroutineStart;
import kotlinx.coroutines.Deferred;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.JobKt;
import kotlinx.coroutines.channels.BufferOverflow;
import kotlinx.coroutines.channels.Channel;
import kotlinx.coroutines.channels.ChannelIterator;
import kotlinx.coroutines.channels.ChannelKt;
import kotlinx.coroutines.channels.SendChannel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.spi.LoggingEventBuilder;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u009c\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u0000 X2\u00020\u0001:\u0003WXYB[\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\r\u0012\u0018\u0010\u0010\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\r0\u0011\u00a2\u0006\u0002\u0010\u0012J\u0010\u00103\u001a\u00020(2\u0006\u00104\u001a\u00020\u001bH\u0002J\u0010\u00105\u001a\u00020(2\u0006\u00104\u001a\u00020,H\u0002J\u0016\u00106\u001a\u00020(2\u0006\u00107\u001a\u00020\u0015H\u0082@\u00a2\u0006\u0002\u00108J\u0010\u00109\u001a\u00020(2\u0006\u0010:\u001a\u00020\u000fH\u0002J\n\u0010;\u001a\u0004\u0018\u00010\u0015H\u0002J\u0012\u0010<\u001a\u0004\u0018\u00010\u001b2\u0006\u0010=\u001a\u00020>H\u0002J\u0010\u0010?\u001a\u00020(2\u0006\u0010@\u001a\u00020\u0015H\u0002J\u0016\u0010A\u001a\u00020(2\u0006\u00107\u001a\u00020\u0015H\u0082@\u00a2\u0006\u0002\u00108J\u000e\u0010B\u001a\u00020(H\u0082@\u00a2\u0006\u0002\u0010CJ\u000e\u0010D\u001a\u00020(H\u0082@\u00a2\u0006\u0002\u0010CJ\u0016\u0010E\u001a\u00020(2\u0006\u0010=\u001a\u00020FH\u0082@\u00a2\u0006\u0002\u0010GJ\u001e\u0010H\u001a\u00020(2\u0006\u0010=\u001a\u00020F2\u0006\u0010I\u001a\u00020JH\u0082@\u00a2\u0006\u0002\u0010KJ\u0016\u0010L\u001a\u00020(2\u0006\u00107\u001a\u00020\u0015H\u0082@\u00a2\u0006\u0002\u00108J6\u0010M\u001a\u0010\u0012\u0004\u0012\u00020N\u0012\u0006\u0012\u0004\u0018\u00010O0\r2\u0006\u0010P\u001a\u00020Q2\u0006\u00107\u001a\u00020\u00152\b\b\u0002\u0010A\u001a\u00020\u000bH\u0082@\u00a2\u0006\u0002\u0010RJ\u001a\u0010S\u001a\u0004\u0018\u00010\u00152\u0006\u0010T\u001a\u00020\u001b2\u0006\u0010U\u001a\u00020,H\u0002J\u000e\u0010V\u001a\u00020(H\u0082@\u00a2\u0006\u0002\u0010CR\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R#\u0010\u0019\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u000f0\r0\u001a\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010 \u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0017\u0010!\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\u001dR\u0014\u0010#\u001a\b\u0012\u0004\u0012\u00020\u001b0\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010$\u001a\b\u0012\u0004\u0012\u00020\u000f0\u001a\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010\u001dR\u0017\u0010&\u001a\b\u0012\u0004\u0012\u00020(0'\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010*R\u0017\u0010+\u001a\b\u0012\u0004\u0012\u00020,0\u001a\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010\u001dR\u0014\u0010.\u001a\b\u0012\u0004\u0012\u00020,0\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0010\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\r0\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010/\u001a\b\u0012\u0004\u0012\u00020\u000b0'X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u00100\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u00101\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u00102\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006Z"}, d2={"Lgg/essential/ice/IceAgent;", "", "logger", "Lorg/slf4j/Logger;", "parentScope", "Lkotlinx/coroutines/CoroutineScope;", "stunManager", "Lgg/essential/ice/stun/StunManager;", "candidateManager", "Lgg/essential/ice/CandidateManager;", "controlling", "", "localCreds", "Lkotlin/Pair;", "", "", "remoteCreds", "Lkotlinx/coroutines/Deferred;", "(Lorg/slf4j/Logger;Lkotlinx/coroutines/CoroutineScope;Lgg/essential/ice/stun/StunManager;Lgg/essential/ice/CandidateManager;ZLkotlin/Pair;Lkotlinx/coroutines/Deferred;)V", "checklist", "", "Lgg/essential/ice/IceAgent$CandidatePair;", "checksScope", "coroutineScope", "highVolumeLogging", "inboundDataChannel", "Lkotlinx/coroutines/channels/Channel;", "Lgg/essential/ice/LocalCandidate;", "getInboundDataChannel", "()Lkotlinx/coroutines/channels/Channel;", "job", "Lkotlinx/coroutines/CompletableJob;", "lastReceivedDataPair", "localCandidateChannel", "getLocalCandidateChannel", "localCandidates", "outboundDataChannel", "getOutboundDataChannel", "readyForData", "Lkotlinx/coroutines/CompletableDeferred;", "", "getReadyForData", "()Lkotlinx/coroutines/CompletableDeferred;", "remoteCandidateChannel", "Lgg/essential/ice/RemoteCandidate;", "getRemoteCandidateChannel", "remoteCandidates", "remoteIsIce4J", "selectedPair", "triggeredCheckQueue", "validList", "addLocalCandidate", "candidate", "addRemoteCandidate", "checkPair", "pair", "(Lgg/essential/ice/IceAgent$CandidatePair;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "dispatchDataPacket", "bytes", "getBestValidPair", "getLocalCandidate", "packet", "Lgg/essential/ice/stun/StunSocket$ReceivedPacket;", "logValidList", "nominatedPair", "nominate", "performConnectivityChecks", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "performRTTChecks", "processPacket", "Lgg/essential/ice/IceAgent$ReceivedPacket;", "(Lgg/essential/ice/IceAgent$ReceivedPacket;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "processStunRequest", "message", "Lgg/essential/ice/stun/StunMessage;", "(Lgg/essential/ice/IceAgent$ReceivedPacket;Lgg/essential/ice/stun/StunMessage;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "selectPair", "sendIceBindingRequest", "Lgg/essential/ice/stun/StunRequest;", "Lgg/essential/ice/stun/UdpStunPacket;", "tId", "Lgg/essential/ice/stun/TransactionId;", "(Lgg/essential/ice/stun/TransactionId;Lgg/essential/ice/IceAgent$CandidatePair;ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "tryPair", "local", "remote", "waitForGoodCandidateAndThenNominateIt", "CandidatePair", "Companion", "ReceivedPacket", "ice"})
@SourceDebugExtension(value={"SMAP\nIceAgent.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IceAgent.kt\ngg/essential/ice/IceAgent\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 StunMessage.kt\ngg/essential/ice/stun/StunMessage\n*L\n1#1,722:1\n1#2:723\n1#2:739\n1#2:741\n1#2:771\n1#2:773\n1#2:775\n2333#3,14:724\n2624#3,3:742\n223#3,2:745\n1726#3,3:747\n1747#3,3:750\n1747#3,3:753\n2333#3,14:756\n37#4:738\n37#4:740\n37#4:770\n37#4:772\n37#4:774\n*S KotlinDebug\n*F\n+ 1 IceAgent.kt\ngg/essential/ice/IceAgent\n*L\n374#1:739\n385#1:741\n608#1:771\n618#1:773\n645#1:775\n314#1:724,14\n388#1:742,3\n402#1:745,2\n459#1:747,3\n467#1:750,3\n481#1:753,3\n534#1:756,14\n374#1:738\n385#1:740\n608#1:770\n618#1:772\n645#1:774\n*E\n"})
public final class IceAgent {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Logger logger;
    @NotNull
    private final StunManager stunManager;
    @NotNull
    private final CandidateManager candidateManager;
    private final boolean controlling;
    @NotNull
    private final Pair<String, byte[]> localCreds;
    @NotNull
    private final Deferred<Pair<String, byte[]>> remoteCreds;
    @NotNull
    private final CompletableJob job;
    @NotNull
    private final CoroutineScope coroutineScope;
    @NotNull
    private final CoroutineScope checksScope;
    @NotNull
    private final Channel<LocalCandidate> localCandidateChannel;
    @NotNull
    private final Channel<RemoteCandidate> remoteCandidateChannel;
    @NotNull
    private final CompletableDeferred<Unit> readyForData;
    @NotNull
    private final Channel<Pair<LocalCandidate, byte[]>> inboundDataChannel;
    @NotNull
    private final Channel<byte[]> outboundDataChannel;
    @NotNull
    private CompletableDeferred<Boolean> remoteIsIce4J;
    private boolean highVolumeLogging;
    @NotNull
    private final List<LocalCandidate> localCandidates;
    @NotNull
    private final List<RemoteCandidate> remoteCandidates;
    @NotNull
    private final List<CandidatePair> triggeredCheckQueue;
    @NotNull
    private final List<CandidatePair> checklist;
    @NotNull
    private final List<CandidatePair> validList;
    @Nullable
    private CandidatePair selectedPair;
    @Nullable
    private CandidatePair lastReceivedDataPair;
    private static final int MAX_CHECKLIST_SIZE = 100;
    private static final boolean LOG_DATA_PACKET_CONTENT = Boolean.parseBoolean(System.getProperty("essential.sps.log_data_packet_content"));
    private static final Integer RELAY_PENALTY = Integer.getInteger("essential.sps.relay_latency_threshold", 100);
    private static final MessageDigest sha256 = MessageDigest.getInstance("SHA-256");

    public IceAgent(@NotNull Logger logger2, @NotNull CoroutineScope parentScope, @NotNull StunManager stunManager, @NotNull CandidateManager candidateManager, boolean controlling, @NotNull Pair<String, byte[]> localCreds, @NotNull Deferred<Pair<String, byte[]>> remoteCreds) {
        Intrinsics.checkNotNullParameter((Object)logger2, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)parentScope, (String)"parentScope");
        Intrinsics.checkNotNullParameter((Object)stunManager, (String)"stunManager");
        Intrinsics.checkNotNullParameter((Object)candidateManager, (String)"candidateManager");
        Intrinsics.checkNotNullParameter(localCreds, (String)"localCreds");
        Intrinsics.checkNotNullParameter(remoteCreds, (String)"remoteCreds");
        this.logger = logger2;
        this.stunManager = stunManager;
        this.candidateManager = candidateManager;
        this.controlling = controlling;
        this.localCreds = localCreds;
        this.remoteCreds = remoteCreds;
        this.job = JobKt.Job((Job)JobKt.getJob((CoroutineContext)parentScope.getCoroutineContext()));
        this.coroutineScope = CoroutineScopeKt.plus((CoroutineScope)parentScope, (CoroutineContext)((CoroutineContext)this.job));
        this.checksScope = CoroutineScopeKt.plus((CoroutineScope)this.coroutineScope, (CoroutineContext)((CoroutineContext)JobKt.Job((Job)((Job)this.job))));
        this.localCandidateChannel = ChannelKt.Channel$default((int)Integer.MAX_VALUE, null, null, (int)6, null);
        this.remoteCandidateChannel = ChannelKt.Channel$default((int)Integer.MAX_VALUE, null, null, (int)6, null);
        this.readyForData = CompletableDeferredKt.CompletableDeferred((Job)((Job)this.job));
        this.inboundDataChannel = ChannelKt.Channel((int)1000, (BufferOverflow)BufferOverflow.DROP_OLDEST, (Function1)((Function1)new Function1<Pair<? extends LocalCandidate, ? extends byte[]>, Unit>(this){
            final /* synthetic */ IceAgent this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull Pair<? extends LocalCandidate, byte[]> pair) {
                Intrinsics.checkNotNullParameter(pair, (String)"pair");
                IceAgent.access$getLogger$p(this.this$0).warn("IceAgent.inboundDataChannel overflow, dropping packet of {} bytes", (Object)((byte[])pair.getSecond()).length);
            }
        }));
        this.outboundDataChannel = ChannelKt.Channel((int)1000, (BufferOverflow)BufferOverflow.DROP_OLDEST, (Function1)((Function1)new Function1<byte[], Unit>(this){
            final /* synthetic */ IceAgent this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull byte[] packet) {
                Intrinsics.checkNotNullParameter((Object)packet, (String)"packet");
                IceAgent.access$getLogger$p(this.this$0).warn("IceAgent.outboundDataChannel overflow, dropping packet of {} bytes", (Object)packet.length);
            }
        }));
        this.remoteIsIce4J = CompletableDeferredKt.CompletableDeferred$default(null, (int)1, null);
        this.highVolumeLogging = true;
        BuildersKt.launch$default((CoroutineScope)this.coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ IceAgent this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        this.label = 1;
                        v0 = DelayKt.delay-VtjQ1oo((long)DurationKt.toDuration((int)2, (DurationUnit)DurationUnit.MINUTES), (Continuation)((Continuation)this));
                        if (v0 == var2_2) {
                            return var2_2;
                        }
                        ** GOTO lbl14
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl14:
                        // 2 sources

                        IceAgent.access$getLogger$p(this.this$0).debug("Ending logging of high volume events.");
                        IceAgent.access$setHighVolumeLogging$p(this.this$0, false);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
        this.localCandidates = new ArrayList();
        this.remoteCandidates = new ArrayList();
        this.triggeredCheckQueue = new ArrayList();
        this.checklist = new ArrayList();
        this.validList = new ArrayList();
        BuildersKt.launch$default((CoroutineScope)this.coroutineScope, null, (CoroutineStart)CoroutineStart.UNDISPATCHED, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            Object L$0;
            int label;
            final /* synthetic */ IceAgent this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var4_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        var2_3 = IceAgent.access$getCandidateManager$p(this.this$0).getCandidates((Job)IceAgent.access$getJob$p(this.this$0)).iterator();
lbl6:
                        // 2 sources

                        while (true) {
                            this.L$0 = var2_3;
                            this.label = 1;
                            v0 = var2_3.hasNext((Continuation)this);
                            if (v0 == var4_2) {
                                return var4_2;
                            }
                            ** GOTO lbl17
                            break;
                        }
                    }
                    case 1: {
                        var2_3 = (ChannelIterator)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl17:
                        // 2 sources

                        if (((Boolean)v0).booleanValue()) {
                            candidate = (LocalCandidate)var2_3.next();
                            IceAgent.access$addLocalCandidate(this.this$0, candidate);
                            ** continue;
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
        BuildersKt.launch$default((CoroutineScope)this.coroutineScope, null, (CoroutineStart)CoroutineStart.UNDISPATCHED, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            Object L$0;
            int label;
            final /* synthetic */ IceAgent this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var4_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        var2_3 = this.this$0.getRemoteCandidateChannel().iterator();
lbl6:
                        // 2 sources

                        while (true) {
                            this.L$0 = var2_3;
                            this.label = 1;
                            v0 = var2_3.hasNext((Continuation)this);
                            if (v0 == var4_2) {
                                return var4_2;
                            }
                            ** GOTO lbl17
                            break;
                        }
                    }
                    case 1: {
                        var2_3 = (ChannelIterator)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl17:
                        // 2 sources

                        if (((Boolean)v0).booleanValue()) {
                            candidate = (RemoteCandidate)var2_3.next();
                            IceAgent.access$addRemoteCandidate(this.this$0, candidate);
                            ** continue;
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
        StunManager.StunServer stunServer = this.stunManager.registerServer((Job)this.job, (String)this.localCreds.getFirst(), (byte[])this.localCreds.getSecond());
        BuildersKt.launch$default((CoroutineScope)this.coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(stunServer, this, null){
            Object L$0;
            int label;
            final /* synthetic */ StunManager.StunServer $stunServer;
            final /* synthetic */ IceAgent this$0;
            {
                this.$stunServer = $stunServer;
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var9_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        var2_3 = this.$stunServer.getStunRequestReceiveChannel().iterator();
lbl6:
                        // 3 sources

                        while (true) {
                            this.L$0 = var2_3;
                            this.label = 1;
                            v0 = var2_3.hasNext((Continuation)this);
                            if (v0 == var9_2) {
                                return var9_2;
                            }
                            ** GOTO lbl17
                            break;
                        }
                    }
                    case 1: {
                        var2_3 = (ChannelIterator)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl17:
                        // 2 sources

                        if (!((Boolean)v0).booleanValue()) break;
                        var3_4 = (Pair)var2_3.next();
                        packet = (StunSocket.ReceivedPacket)var3_4.component1();
                        message = (StunMessage)var3_4.component2();
                        if (IceAgent.access$getLocalCandidate(this.this$0, packet) == null) ** GOTO lbl6
                        var6_7 = packet.getData();
                        var7_8 = packet.getSource();
                        this.L$0 = var2_3;
                        this.label = 2;
                        v1 = IceAgent.access$processStunRequest(this.this$0, new ReceivedPacket(var8_9, var7_8, var6_7), message, (Continuation)this);
                        if (v1 == var9_2) {
                            return var9_2;
                        }
                        ** GOTO lbl34
                    }
                    case 2: {
                        var2_3 = (ChannelIterator)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl34:
                        // 2 sources

                        ** continue;
                    }
                }
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
        BuildersKt.launch$default((CoroutineScope)this.coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(stunServer, this, null){
            Object L$0;
            int label;
            final /* synthetic */ StunManager.StunServer $stunServer;
            final /* synthetic */ IceAgent this$0;
            {
                this.$stunServer = $stunServer;
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var7_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        var2_3 = this.$stunServer.getDataReceiveChannel().iterator();
lbl6:
                        // 3 sources

                        while (true) {
                            this.L$0 = var2_3;
                            this.label = 1;
                            v0 = var2_3.hasNext((Continuation)this);
                            if (v0 == var7_2) {
                                return var7_2;
                            }
                            ** GOTO lbl17
                            break;
                        }
                    }
                    case 1: {
                        var2_3 = (ChannelIterator)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl17:
                        // 2 sources

                        if (!((Boolean)v0).booleanValue()) break;
                        packet = (StunSocket.ReceivedPacket)var2_3.next();
                        if (IceAgent.access$getLocalCandidate(this.this$0, packet) == null) ** GOTO lbl6
                        var4_5 = packet.getData();
                        var5_6 = packet.getSource();
                        this.L$0 = var2_3;
                        this.label = 2;
                        v1 = IceAgent.access$processPacket(this.this$0, new ReceivedPacket(var6_7, var5_6, var4_5), (Continuation)this);
                        if (v1 == var7_2) {
                            return var7_2;
                        }
                        ** GOTO lbl32
                    }
                    case 2: {
                        var2_3 = (ChannelIterator)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl32:
                        // 2 sources

                        ** continue;
                    }
                }
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
        BuildersKt.launch$default((CoroutineScope)this.checksScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ IceAgent this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = this.this$0.performConnectivityChecks((Continuation<? super Unit>)((Continuation)this));
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
        if (this.controlling) {
            BuildersKt.launch$default((CoroutineScope)this.coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                int label;
                final /* synthetic */ IceAgent this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            this.label = 1;
                            Object object3 = this.this$0.waitForGoodCandidateAndThenNominateIt((Continuation<? super Unit>)((Continuation)this));
                            if (object3 != object2) return Unit.INSTANCE;
                            return object2;
                        }
                        case 1: {
                            void $result;
                            ResultKt.throwOnFailure((Object)$result);
                            Object object3 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        }
        BuildersKt.launch$default((CoroutineScope)this.coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            Object L$0;
            int label;
            final /* synthetic */ IceAgent this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var4_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        var2_3 = this.this$0.getOutboundDataChannel().iterator();
lbl6:
                        // 2 sources

                        while (true) {
                            this.L$0 = var2_3;
                            this.label = 1;
                            v0 = var2_3.hasNext((Continuation)this);
                            if (v0 == var4_2) {
                                return var4_2;
                            }
                            ** GOTO lbl17
                            break;
                        }
                    }
                    case 1: {
                        var2_3 = (ChannelIterator)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl17:
                        // 2 sources

                        if (((Boolean)v0).booleanValue()) {
                            packet = (byte[])var2_3.next();
                            IceAgent.access$dispatchDataPacket(this.this$0, packet);
                            ** continue;
                        }
                        SendChannel.DefaultImpls.close$default((SendChannel)((SendChannel)this.this$0.getInboundDataChannel()), null, (int)1, null);
                        Job.DefaultImpls.cancel$default((Job)((Job)IceAgent.access$getJob$p(this.this$0)), null, (int)1, null);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    @NotNull
    public final Channel<LocalCandidate> getLocalCandidateChannel() {
        return this.localCandidateChannel;
    }

    @NotNull
    public final Channel<RemoteCandidate> getRemoteCandidateChannel() {
        return this.remoteCandidateChannel;
    }

    @NotNull
    public final CompletableDeferred<Unit> getReadyForData() {
        return this.readyForData;
    }

    @NotNull
    public final Channel<Pair<LocalCandidate, byte[]>> getInboundDataChannel() {
        return this.inboundDataChannel;
    }

    @NotNull
    public final Channel<byte[]> getOutboundDataChannel() {
        return this.outboundDataChannel;
    }

    private final LocalCandidate getLocalCandidate(StunSocket.ReceivedPacket packet) {
        LocalCandidate localCandidate;
        StunSocket.RelayAllocation relay = packet.getRelay();
        if (relay != null) {
            Object v0;
            block4: {
                Iterable iterable = this.localCandidates;
                for (Object t : iterable) {
                    LocalCandidate it = (LocalCandidate)t;
                    boolean bl = false;
                    if (!(it.getType() == CandidateType.Relayed && Intrinsics.areEqual((Object)it.getRelay(), (Object)relay))) continue;
                    v0 = t;
                    break block4;
                }
                v0 = null;
            }
            localCandidate = v0;
        } else {
            Object v2;
            block5: {
                StunSocket socket = packet.getSocket();
                Iterable iterable = this.localCandidates;
                for (Object t : iterable) {
                    LocalCandidate it = (LocalCandidate)t;
                    boolean bl = false;
                    if (!(it.getType() == CandidateType.Host && Intrinsics.areEqual((Object)it.getSocket(), (Object)socket))) continue;
                    v2 = t;
                    break block5;
                }
                v2 = null;
            }
            localCandidate = v2;
        }
        return localCandidate;
    }

    private final void addLocalCandidate(LocalCandidate candidate2) {
        if (this.selectedPair != null) {
            this.logger.debug("Ignoring new local candidate {} because we already have a selected pair.", (Object)candidate2);
            candidate2.close();
            return;
        }
        for (LocalCandidate other : this.localCandidates) {
            if (!Intrinsics.areEqual((Object)other.getAddress(), (Object)candidate2.getAddress()) || !Intrinsics.areEqual((Object)other.getBase(), (Object)candidate2.getBase())) continue;
            this.logger.debug("Ignoring new local candidate {} because we already have {}", (Object)candidate2, (Object)other);
            candidate2.close();
            return;
        }
        this.logger.debug("Got new local candidate: {}", (Object)candidate2);
        this.localCandidates.add(candidate2);
        if (candidate2.getType() != CandidateType.PeerReflexive) {
            this.localCandidateChannel.trySend-JP2dKIU((Object)candidate2);
            for (RemoteCandidate remoteCandidate : this.remoteCandidates) {
                this.tryPair(candidate2, remoteCandidate);
            }
        }
    }

    private final void addRemoteCandidate(RemoteCandidate candidate2) {
        if (this.selectedPair != null) {
            this.logger.debug("Ignoring new remote candidate {} because we already have a selected pair.", (Object)candidate2);
            return;
        }
        for (RemoteCandidate other : this.remoteCandidates) {
            if (!Intrinsics.areEqual((Object)other.getAddress(), (Object)candidate2.getAddress())) continue;
            this.logger.debug("Ignoring new remote candidate {} because we already have {}", (Object)candidate2, (Object)other);
            if (other.getType() == CandidateType.PeerReflexive && candidate2.isRelay()) {
                other.setType(CandidateType.Relayed);
            }
            return;
        }
        this.logger.debug("Got new remote candidate: {}", (Object)candidate2);
        this.remoteCandidates.add(candidate2);
        for (LocalCandidate localCandidate : this.localCandidates) {
            this.tryPair(localCandidate, candidate2);
        }
    }

    private final CandidatePair tryPair(LocalCandidate local, RemoteCandidate remote) {
        CandidatePair newPair;
        block8: {
            if (local.isIPv6() != remote.isIPv6()) {
                return null;
            }
            if (local.isLinkLocal() != remote.isLinkLocal()) {
                return null;
            }
            if (local.isRelay() && remote.isSiteLocal() || remote.isRelay() && local.isSiteLocal()) {
                return null;
            }
            newPair = new CandidatePair(local, remote, this.controlling);
            for (CandidatePair oldPair : this.checklist) {
                if (!Intrinsics.areEqual((Object)newPair.getLocal().getBase(), (Object)oldPair.getLocal().getBase()) || !Intrinsics.areEqual((Object)newPair.getRemote().getAddress(), (Object)oldPair.getRemote().getAddress())) continue;
                if (newPair.getPriority() > oldPair.getPriority() && oldPair.getState() == CandidatePair.State.Waiting) {
                    this.logger.trace("Replacing lower priority candidate pair {} with new pair", (Object)oldPair);
                    this.checklist.remove(oldPair);
                    break;
                }
                return oldPair;
            }
            this.logger.trace("New candidate pair: {}", (Object)newPair);
            int index2 = CollectionsKt.binarySearch$default(this.checklist, (Object)newPair, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    CandidatePair it = (CandidatePair)a;
                    boolean bl = false;
                    Comparable comparable = Long.valueOf(-it.getPriority());
                    it = (CandidatePair)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Long.valueOf(-it.getPriority()));
                }
            }, (int)0, (int)0, (int)12, null);
            this.checklist.add(index2 >= 0 ? index2 : -index2 - 1, newPair);
            if (this.checklist.size() > 100) {
                for (CandidatePair entry : this.checklist) {
                    if (entry.getState() != CandidatePair.State.Failed) continue;
                    this.checklist.remove(entry);
                    break;
                }
                if (this.checklist.size() > 100) {
                    CollectionsKt.removeLast(this.checklist);
                }
            }
            StunSocket.RelayAllocation relayAllocation = local.getRelay();
            if (relayAllocation == null) break block8;
            InetAddress[] inetAddressArray = new InetAddress[1];
            Intrinsics.checkNotNullExpressionValue((Object)remote.getAddress().getAddress(), (String)"getAddress(...)");
            StunSocket.RelayAllocation.createPermission$default(relayAllocation, inetAddressArray, false, 2, null);
        }
        return newPair;
    }

    /*
     * Unable to fully structure code
     */
    private final Object performConnectivityChecks(Continuation<? super Unit> var1_1) {
        if (!(var1_1 instanceof performConnectivityChecks.1)) ** GOTO lbl-1000
        var9_2 = var1_1;
        if ((var9_2.label & -2147483648) != 0) {
            var9_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var1_1){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ IceAgent this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return IceAgent.access$performConnectivityChecks(this.this$0, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var10_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = this;
                $continuation.label = 1;
                v0 = this.remoteCreds.await((Continuation)$continuation);
                if (v0 == var10_4) {
                    return var10_4;
                }
                ** GOTO lbl22
            }
            case 1: {
                this = (IceAgent)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl22:
                // 5 sources

                while (true) {
                    $continuation.L$0 = this;
                    $continuation.label = 2;
                    v1 = this.stunManager.getBindingPacer().await(false, (Continuation<? super Unit>)$continuation);
                    if (v1 == var10_4) {
                        return var10_4;
                    }
                    ** GOTO lbl33
                    break;
                }
            }
            case 2: {
                this = (IceAgent)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl33:
                // 2 sources

                if ((v2 = IceAgent.performConnectivityChecks$pollTriggeredCheck(this)) != null) ** GOTO lbl43
                var3_6 = this.checklist;
                for (T var5_8 : var3_6) {
                    it = (CandidatePair)var5_8;
                    $i$a$-find-IceAgent$performConnectivityChecks$pair$1 = false;
                    if (!(it.getState() == CandidatePair.State.Waiting)) continue;
                    v3 = var5_8;
                    ** GOTO lbl42
                }
                v3 = null;
lbl42:
                // 2 sources

                v2 = v3;
lbl43:
                // 2 sources

                if ((pair = v2) != null) break;
                $continuation.L$0 = this;
                $continuation.label = 3;
                v4 = this.performRTTChecks((Continuation<? super Unit>)$continuation);
                if (v4 != var10_4) ** GOTO lbl22
                return var10_4;
            }
            case 3: {
                this = (IceAgent)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v4 = $result;
                ** GOTO lbl22
            }
        }
        pair.setState(CandidatePair.State.InProgress);
        v5 = pair.getCheck();
        if (v5 != null) {
            Job.DefaultImpls.cancel$default((Job)v5, null, (int)1, null);
        }
        pair.setCheck(BuildersKt.launch$default((CoroutineScope)this.checksScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, pair, null){
            int label;
            final /* synthetic */ IceAgent this$0;
            final /* synthetic */ CandidatePair $pair;
            {
                this.this$0 = $receiver;
                this.$pair = $pair;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = IceAgent.access$checkPair(this.this$0, this.$pair, (Continuation)this);
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null));
        ** while (true)
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    private final Object performRTTChecks(Continuation<? super Unit> var1_1) {
        if (!(var1_1 instanceof performRTTChecks.1)) ** GOTO lbl-1000
        var13_2 = var1_1;
        if ((var13_2.label & -2147483648) != 0) {
            var13_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var1_1){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ IceAgent this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return IceAgent.access$performRTTChecks(this.this$0, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var14_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $this$minByOrNull$iv = this.validList;
                $i$f$minByOrNull = false;
                iterator$iv = $this$minByOrNull$iv.iterator();
                if (!iterator$iv.hasNext()) {
                    v0 = null;
                } else {
                    minElem$iv = iterator$iv.next();
                    if (!iterator$iv.hasNext()) {
                        v0 = minElem$iv;
                    } else {
                        it = (CandidatePair)minElem$iv;
                        $i$a$-minByOrNull-IceAgent$performRTTChecks$pair$1 = false;
                        minValue$iv = it.getExtraRttChecks();
                        do {
                            e$iv = iterator$iv.next();
                            it = (CandidatePair)e$iv;
                            $i$a$-minByOrNull-IceAgent$performRTTChecks$pair$1 = false;
                            v$iv = it.getExtraRttChecks();
                            if (minValue$iv <= v$iv) continue;
                            minElem$iv = e$iv;
                            minValue$iv = v$iv;
                        } while (iterator$iv.hasNext());
                        v0 = minElem$iv;
                    }
                }
                v1 = v0;
                if (v1 == null) {
                    return Unit.INSTANCE;
                }
                pair = v1;
                $continuation.L$0 = this;
                $continuation.L$1 = pair;
                $continuation.label = 1;
                v2 = this.remoteIsIce4J.await((Continuation)$continuation);
                if (v2 == var14_4) {
                    return var14_4;
                }
                ** GOTO lbl51
            }
            case 1: {
                pair = (CandidatePair)$continuation.L$1;
                this = (IceAgent)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
lbl51:
                // 2 sources

                if (((Boolean)v2).booleanValue()) {
                    return Unit.INSTANCE;
                }
                var3_17 = pair.getExtraRttChecks();
                pair.setExtraRttChecks(var3_17 + 1);
                BuildersKt.launch$default((CoroutineScope)this.checksScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, pair, null){
                    Object L$0;
                    int label;
                    final /* synthetic */ IceAgent this$0;
                    final /* synthetic */ CandidatePair $pair;
                    {
                        this.this$0 = $receiver;
                        this.$pair = $pair;
                        super(2, $completion);
                    }

                    /*
                     * Unable to fully structure code
                     */
                    @Nullable
                    public final Object invokeSuspend(@NotNull Object var1_1) {
                        var9_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)var1_1);
                                tId = TransactionId.Companion.create();
                                logger = ExtendedLoggerKt.withKeyValue(IceAgent.access$getLogger$p(this.this$0), "tId", tId);
                                logger.trace("Starting rtt check: {}", (Object)this.$pair);
                                this.L$0 = logger;
                                this.label = 1;
                                v0 = IceAgent.sendIceBindingRequest$default(this.this$0, tId, this.$pair, false, (Continuation)this, 4, null);
                                if (v0 == var9_2) {
                                    return var9_2;
                                }
                                ** GOTO lbl18
                            }
                            case 1: {
                                logger = (Logger)this.L$0;
                                ResultKt.throwOnFailure((Object)$result);
                                v0 = $result;
lbl18:
                                // 2 sources

                                var4_5 = (Pair)v0;
                                request = (StunRequest)var4_5.component1();
                                response = (UdpStunPacket)var4_5.component2();
                                if (response == null) {
                                    logger.warn("RTT check of previously valid pair failed, no response: {}", (Object)this.$pair);
                                    return Unit.INSTANCE;
                                }
                                if (response.getMessage().getCls() == StunClass.ResponseError) {
                                    logger.warn("Failed, got unexpected error response: {}", (Object)response.getMessage());
                                    return Unit.INSTANCE;
                                }
                                rtt = request.getRoundTripTime-5sfh64U(response);
                                logger.trace("Measured RTT of {} to be {}ms", (Object)this.$pair, (Object)Boxing.boxLong((long)Duration.getInWholeMilliseconds-impl((long)rtt)));
                                v1 = this.$pair.getRtt-FghU774();
                                this.$pair.setRtt-BwNAW2A(Duration.box-impl((long)UtilsKt.min-QTBD994(v1 != null ? v1.unbox-impl() : Duration.Companion.getINFINITE-UwyO8pc(), rtt)));
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    @Nullable
                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)3, null);
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final Object checkPair(CandidatePair var1_1, Continuation<? super Unit> var2_2) {
        if (!(var2_2 instanceof checkPair.1)) ** GOTO lbl-1000
        var20_3 = var2_2;
        if ((var20_3.label & -2147483648) != 0) {
            var20_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var2_2){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                /* synthetic */ Object result;
                final /* synthetic */ IceAgent this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return IceAgent.access$checkPair(this.this$0, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var24_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                tId = TransactionId.Companion.create();
                logger = ExtendedLoggerKt.withKeyValue(this.logger, "tId", tId);
                logger.debug("Starting connectivity check: {}", (Object)pair);
                $continuation.L$0 = this;
                $continuation.L$1 = pair;
                $continuation.L$2 = logger;
                $continuation.label = 1;
                v0 = IceAgent.sendIceBindingRequest$default(this, tId, pair, false, (Continuation)$continuation, 4, null);
                if (v0 == var24_5) {
                    return var24_5;
                }
                ** GOTO lbl29
            }
            case 1: {
                logger = (Logger)$continuation.L$2;
                pair = (CandidatePair)$continuation.L$1;
                this = (IceAgent)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl29:
                // 2 sources

                var5_8 = (Pair)v0;
                request = (StunRequest)var5_8.component1();
                response = (UdpStunPacket)var5_8.component2();
                if (response == null) {
                    logger.debug("Connectivity check failed, no response: {}", (Object)pair);
                    pair.setState(CandidatePair.State.Failed);
                    return Unit.INSTANCE;
                }
                if (!Intrinsics.areEqual((Object)pair.getRemote().getAddress(), (Object)response.getSource())) {
                    logger.debug("Failed, request destination ({}) does not match response source ({}).", (Object)pair.getRemote().getAddress(), (Object)response.getSource());
                    pair.setState(CandidatePair.State.Failed);
                    return Unit.INSTANCE;
                }
                if (response.getMessage().getCls() == StunClass.ResponseError) {
                    logger.warn("Failed, got unexpected error response: {}", (Object)response.getMessage());
                    pair.setState(CandidatePair.State.Failed);
                    return Unit.INSTANCE;
                }
                this_$iv = response.getMessage();
                $i$f$attribute = false;
                for (StunAttribute it$iv : (Iterable)this_$iv.getAttributes()) {
                    $i$a$-firstNotNullOfOrNull-StunMessage$attribute$1$iv = false;
                    v1 = it$iv;
                    if (!(v1 instanceof StunAttribute.XorMappedAddress)) {
                        v1 = null;
                    }
                    if ((it$iv = (StunAttribute)((StunAttribute.XorMappedAddress)v1)) == null) continue;
                    v2 = it$iv;
                    ** GOTO lbl56
                }
                v2 = null;
lbl56:
                // 2 sources

                v3 = (StunAttribute.XorMappedAddress)v2;
                v4 = mappedAddress = v3 != null ? v3.getAddress() : null;
                if (mappedAddress == null) {
                    logger.warn("Failed, response was missing XOR-MAPPED-ADDRESS: {}", (Object)response.getMessage());
                    pair.setState(CandidatePair.State.Failed);
                    return Unit.INSTANCE;
                }
                rtt = request.getRoundTripTime-5sfh64U(response);
                logger.debug("Connectivity check succeeded: {} ({}ms)", (Object)pair, (Object)Boxing.boxLong((long)Duration.getInWholeMilliseconds-impl((long)rtt)));
                var12_14 = response.getMessage();
                var18_27 = this.remoteIsIce4J;
                $i$f$attribute = false;
                for (StunAttribute it$iv : (Iterable)this_$iv.getAttributes()) {
                    $i$a$-firstNotNullOfOrNull-StunMessage$attribute$1$iv = false;
                    v5 = it$iv;
                    if (!(v5 instanceof StunAttribute.Software)) {
                        v5 = null;
                    }
                    if ((it$iv = (StunAttribute)((StunAttribute.Software)v5)) == null) continue;
                    v6 = it$iv;
                    ** GOTO lbl77
                }
                v6 = null;
lbl77:
                // 2 sources

                v7 = (StunAttribute.Software)v6;
                var18_27.complete((Object)Boxing.boxBoolean((boolean)Intrinsics.areEqual((Object)(v7 != null ? v7.getValue() : null), (Object)"ice4j.org")));
                $this$none$iv = this.localCandidates;
                $i$f$none = false;
                if (!($this$none$iv instanceof Collection) || !((Collection)$this$none$iv).isEmpty()) ** GOTO lbl85
                v8 = true;
                ** GOTO lbl92
lbl85:
                // 2 sources

                for (T element$iv : $this$none$iv) {
                    it /* !! */  = (LocalCandidate)element$iv;
                    $i$a$-none-IceAgent$checkPair$2 = false;
                    if (!Intrinsics.areEqual((Object)it /* !! */ .getAddress(), (Object)mappedAddress)) continue;
                    v8 = false;
                    ** GOTO lbl92
                }
                v8 = true;
lbl92:
                // 3 sources

                if (v8) {
                    this.addLocalCandidate(new LocalPeerReflexiveCandidate(pair.getLocal(), mappedAddress));
                }
                validPair = null;
                if (Intrinsics.areEqual((Object)pair.getLocal().getAddress(), (Object)mappedAddress)) {
                    validPair = pair;
                }
                if (validPair != null) ** GOTO lbl107
                $i$f$attribute = this.checklist;
                for (LocalCandidate it : $i$f$attribute) {
                    it = (CandidatePair)it /* !! */ ;
                    $i$a$-find-IceAgent$checkPair$3 = false;
                    if (!(Intrinsics.areEqual((Object)it.getLocal().getAddress(), (Object)mappedAddress) != false && Intrinsics.areEqual((Object)it.getRemote().getAddress(), (Object)pair.getRemote().getAddress()) != false)) continue;
                    v9 /* !! */  = it /* !! */ ;
                    ** GOTO lbl106
                }
                v9 /* !! */  = null;
lbl106:
                // 2 sources

                validPair = (CandidatePair)v9 /* !! */ ;
lbl107:
                // 2 sources

                if (validPair != null) ** GOTO lbl122
                $this$first$iv = this.localCandidates;
                $i$f$first = false;
                for (T element$iv : $this$first$iv) {
                    it = (LocalCandidate)element$iv;
                    $i$a$-first-IceAgent$checkPair$4 = false;
                    if (!Intrinsics.areEqual((Object)it.getAddress(), (Object)mappedAddress)) continue;
                    ** GOTO lbl116
                }
                throw new NoSuchElementException("Collection contains no element matching the predicate.");
lbl116:
                // 1 sources

                var21_33 = this.controlling;
                var22_34 = pair.getRemote();
                var23_35 = (LocalCandidate)element$iv;
                validPair = new CandidatePair(var23_35, var22_34, var21_33 != false);
                this.checklist.add(validPair);
lbl122:
                // 2 sources

                this.validList.add(validPair);
                v10 = pair.getRtt-FghU774();
                pair.setRtt-BwNAW2A(Duration.box-impl((long)UtilsKt.min-QTBD994(v10 != null ? v10.unbox-impl() : Duration.Companion.getINFINITE-UwyO8pc(), rtt)));
                v11 = validPair.getRtt-FghU774();
                validPair.setRtt-BwNAW2A(Duration.box-impl((long)UtilsKt.min-QTBD994(v11 != null ? v11.unbox-impl() : Duration.Companion.getINFINITE-UwyO8pc(), rtt)));
                pair.setState(CandidatePair.State.Succeeded);
                validPair.setState(CandidatePair.State.Succeeded);
                $continuation.L$0 = this;
                $continuation.L$1 = pair;
                $continuation.L$2 = logger;
                $continuation.L$3 = validPair;
                $continuation.label = 2;
                v12 = this.remoteIsIce4J.await((Continuation)$continuation);
                if (v12 == var24_5) {
                    return var24_5;
                }
                ** GOTO lbl146
            }
            case 2: {
                validPair = (CandidatePair)$continuation.L$3;
                logger = (Logger)$continuation.L$2;
                pair = (CandidatePair)$continuation.L$1;
                this = (IceAgent)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v12 = $result;
lbl146:
                // 2 sources

                if (!((Boolean)v12).booleanValue()) {
                    this.readyForData.complete((Object)Unit.INSTANCE);
                }
                if (this.selectedPair != null || !pair.getNominateOnSuccess() && !validPair.getNominateOnSuccess()) break;
                logger.info("Nomination successful: {}", (Object)validPair);
                this.logValidList(validPair);
                $continuation.L$0 = null;
                $continuation.L$1 = null;
                $continuation.L$2 = null;
                $continuation.L$3 = null;
                $continuation.label = 3;
                v13 = this.selectPair(validPair, (Continuation<? super Unit>)$continuation);
                if (v13 == var24_5) {
                    return var24_5;
                }
                ** GOTO lbl164
            }
            case 3: {
                ResultKt.throwOnFailure((Object)$result);
                v13 = $result;
lbl164:
                // 2 sources

                return Unit.INSTANCE;
            }
        }
        return Unit.INSTANCE;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    private final Object sendIceBindingRequest(TransactionId var1_1, CandidatePair var2_2, boolean var3_3, Continuation<? super Pair<StunRequest, UdpStunPacket>> var4_4) {
        if (!(var4_4 instanceof sendIceBindingRequest.1)) ** GOTO lbl-1000
        var12_5 = var4_4;
        if ((var12_5.label & -2147483648) != 0) {
            var12_5.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var4_4){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                boolean Z$0;
                /* synthetic */ Object result;
                final /* synthetic */ IceAgent this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return IceAgent.access$sendIceBindingRequest(this.this$0, null, null, false, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var13_7 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                localUsername = (String)this.localCreds.component1();
                $continuation.L$0 = this;
                $continuation.L$1 = tId;
                $continuation.L$2 = pair;
                $continuation.L$3 = localUsername;
                $continuation.Z$0 = nominate;
                $continuation.label = 1;
                v0 = this.remoteCreds.await((Continuation)$continuation);
                if (v0 == var13_7) {
                    return var13_7;
                }
                ** GOTO lbl31
            }
            case 1: {
                nominate = $continuation.Z$0;
                localUsername = (String)$continuation.L$3;
                pair = (CandidatePair)$continuation.L$2;
                tId = (TransactionId)$continuation.L$1;
                this = (IceAgent)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl31:
                // 2 sources

                var6_9 = (Pair)v0;
                remoteUsername = (String)var6_9.component1();
                remotePassword = (byte[])var6_9.component2();
                var10_12 = new StunAttribute[]{new StunAttribute.Priority(LocalCandidate.Companion.computePriority(CandidateType.PeerReflexive, pair.getLocal().getPreference())), nominate != false ? StunAttribute.UseCandidate.INSTANCE : null, this.controlling != false ? (StunAttribute)new StunAttribute.IceControlling(0L, null) : (StunAttribute)new StunAttribute.IceControlled(0L, null), new StunAttribute.TransactionTransmitCounter(0, 0), new StunAttribute.Username(remoteUsername + ':' + localUsername), new StunAttribute.MessageIntegrity(remotePassword)};
                msg = new StunMessage(StunType.Binding, StunClass.Request, var1_1, CollectionsKt.listOfNotNull((Object[])var10_12));
                $continuation.L$0 = null;
                $continuation.L$1 = null;
                $continuation.L$2 = null;
                $continuation.L$3 = null;
                $continuation.label = 2;
                v1 = CoroutineScopeKt.coroutineScope((Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Pair<? extends StunRequest, ? extends UdpStunPacket>>, Object>(this, pair, msg, null){
                    Object L$0;
                    int label;
                    final /* synthetic */ IceAgent this$0;
                    final /* synthetic */ CandidatePair $pair;
                    final /* synthetic */ StunMessage $msg;
                    {
                        this.this$0 = $receiver;
                        this.$pair = $pair;
                        this.$msg = $msg;
                        super(2, $completion);
                    }

                    /*
                     * WARNING - void declaration
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                Logger logger2 = ExtendedLoggerKt.with(IceAgent.access$getLogger$p(this.this$0), (Function1<? super LoggingEventBuilder, Unit>)((Function1)new Function1<LoggingEventBuilder, Unit>(this.$pair){
                                    final /* synthetic */ CandidatePair $pair;
                                    {
                                        this.$pair = $pair;
                                        super(1);
                                    }

                                    public final void invoke(@NotNull LoggingEventBuilder $this$with) {
                                        Intrinsics.checkNotNullParameter((Object)$this$with, (String)"$this$with");
                                        gg.essential.ice.IceAgent$Companion.access$addKeyValues(IceAgent.Companion, $this$with, this.$pair.getLocal());
                                    }
                                }));
                                StunRequest request2 = new StunRequest(logger2, IceAgent.access$getCoroutineScope$p(this.this$0), (Function2<? super DatagramPacket, ? super Continuation<? super Boolean>, ? extends Object>)((Function2)new Function2<DatagramPacket, Continuation<? super Boolean>, Object>((Object)this.$pair.getLocal()){

                                    @Nullable
                                    public final Object invoke(@NotNull DatagramPacket p0, @NotNull Continuation<? super Boolean> $completion) {
                                        return ((LocalCandidate)this.receiver).send(p0, $completion);
                                    }
                                }), this.$pair.getRemote().getAddress(), this.$msg);
                                IceAgent.access$getStunManager$p(this.this$0).sendRequest(request2);
                                StunRequest stunRequest = request2;
                                this.L$0 = stunRequest;
                                this.label = 1;
                                Object object3 = request2.await((Continuation<? super UdpStunPacket>)((Continuation)this));
                                if (object3 != object2) return TuplesKt.to((Object)stunRequest, (Object)object3);
                                return object2;
                            }
                            case 1: {
                                void $result;
                                StunRequest stunRequest = (StunRequest)this.L$0;
                                ResultKt.throwOnFailure((Object)$result);
                                Object object3 = $result;
                                return TuplesKt.to((Object)stunRequest, (Object)object3);
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    @Nullable
                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Pair<StunRequest, UdpStunPacket>> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation)$continuation);
                if (v1 == var13_7) {
                    return var13_7;
                }
                ** GOTO lbl48
            }
            case 2: {
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl48:
                // 2 sources

                return v1;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    static /* synthetic */ Object sendIceBindingRequest$default(IceAgent iceAgent, TransactionId transactionId, CandidatePair candidatePair, boolean bl, Continuation continuation, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        return iceAgent.sendIceBindingRequest(transactionId, candidatePair, bl, (Continuation<? super Pair<StunRequest, UdpStunPacket>>)continuation);
    }

    /*
     * Unable to fully structure code
     */
    private final Object waitForGoodCandidateAndThenNominateIt(Continuation<? super Unit> var1_1) {
        block31: {
            if (!(var1_1 instanceof waitForGoodCandidateAndThenNominateIt.1)) ** GOTO lbl-1000
            var13_2 = var1_1;
            if ((var13_2.label & -2147483648) != 0) {
                var13_2.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, var1_1){
                    Object L$0;
                    long J$0;
                    /* synthetic */ Object result;
                    final /* synthetic */ IceAgent this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return IceAgent.access$waitForGoodCandidateAndThenNominateIt(this.this$0, (Continuation)this);
                    }
                };
            }
            $result = $continuation.result;
            var14_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            block0 : switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    $continuation.L$0 = this;
                    $continuation.label = 1;
                    v0 = this.remoteIsIce4J.await((Continuation)$continuation);
                    if (v0 == var14_4) {
                        return var14_4;
                    }
                    ** GOTO lbl22
                }
                case 1: {
                    this = (IceAgent)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl22:
                    // 2 sources

                    if (!((Boolean)v0).booleanValue()) break;
lbl23:
                    // 3 sources

                    while (this.validList.isEmpty()) {
                        $continuation.L$0 = this;
                        $continuation.label = 2;
                        v1 = DelayKt.delay-VtjQ1oo((long)DurationKt.toDuration((double)0.1, (DurationUnit)DurationUnit.SECONDS), (Continuation)$continuation);
                        if (v1 != var14_4) continue;
                        return var14_4;
                    }
                    break;
                }
                case 2: {
                    this = (IceAgent)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v1 = $result;
                    ** GOTO lbl23
                }
            }
            relayWaitTimeout = TimeSource.Monotonic.ValueTimeMark.plus-LRDsOJo((long)TimeSource.Monotonic.INSTANCE.markNow-z9LOYto(), (long)DurationKt.toDuration((int)10, (DurationUnit)DurationUnit.SECONDS));
            while (true) {
                block29: {
                    $this$all$iv = this.validList;
                    $i$f$all = false;
                    if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                        v2 = true;
                    } else {
                        for (T element$iv : $this$all$iv) {
                            it = (CandidatePair)element$iv;
                            $i$a$-all-IceAgent$waitForGoodCandidateAndThenNominateIt$2 = false;
                            if (it.getLocal().isRelay() != false || it.getRemote().isRelay() != false) continue;
                            v2 = false;
                            break block29;
                        }
                        v2 = true;
                    }
                }
                if (v2) {
                    $continuation.L$0 = this;
                    $continuation.J$0 = relayWaitTimeout;
                    $continuation.label = 3;
                    v3 = DelayKt.delay-VtjQ1oo((long)DurationKt.toDuration((double)0.1, (DurationUnit)DurationUnit.SECONDS), (Continuation)$continuation);
                    if (v3 != var14_4) continue;
                    return var14_4;
                }
                ** GOTO lbl68
                break;
            }
            {
                case 3: {
                    relayWaitTimeout = $continuation.J$0;
                    this = (IceAgent)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v3 = $result;
                    if (!TimeSource.Monotonic.ValueTimeMark.hasPassedNow-impl((long)relayWaitTimeout)) ** continue;
lbl68:
                    // 2 sources

                    directWaitTimeout = TimeSource.Monotonic.ValueTimeMark.plus-LRDsOJo((long)TimeSource.Monotonic.INSTANCE.markNow-z9LOYto(), (long)DurationKt.toDuration((int)3, (DurationUnit)DurationUnit.SECONDS));
                    while (true) {
                        $this$any$iv = this.checklist;
                        $i$f$any = false;
                        if (!($this$any$iv instanceof Collection) || !((Collection)$this$any$iv).isEmpty()) ** GOTO lbl75
                        v4 = false;
                        ** GOTO lbl82
lbl75:
                        // 2 sources

                        for (T element$iv : $this$any$iv) {
                            it = (CandidatePair)element$iv;
                            $i$a$-any-IceAgent$waitForGoodCandidateAndThenNominateIt$3 = false;
                            if (!(it.getState().compareTo((Enum)CandidatePair.State.InProgress) <= 0)) continue;
                            v4 = true;
                            ** GOTO lbl82
                        }
                        v4 = false;
lbl82:
                        // 3 sources

                        if (!v4) break block0;
                        $continuation.L$0 = this;
                        $continuation.J$0 = directWaitTimeout;
                        $continuation.label = 4;
                        v5 = DelayKt.delay-VtjQ1oo((long)DurationKt.toDuration((double)0.1, (DurationUnit)DurationUnit.SECONDS), (Continuation)$continuation);
                        if (v5 != var14_4) continue;
                        return var14_4;
                    }
                }
                case 4: {
                    directWaitTimeout = $continuation.J$0;
                    this = (IceAgent)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v5 = $result;
                    if (!TimeSource.Monotonic.ValueTimeMark.hasPassedNow-impl((long)directWaitTimeout)) ** continue;
                    break;
                }
            }
            minWaitTimeout = TimeSource.Monotonic.ValueTimeMark.plus-LRDsOJo((long)TimeSource.Monotonic.INSTANCE.markNow-z9LOYto(), (long)DurationKt.toDuration((int)30, (DurationUnit)DurationUnit.SECONDS));
lbl99:
            // 2 sources

            while (true) {
                if (!this.checklist.isEmpty()) {
                    block30: {
                        $this$any$iv = this.checklist;
                        $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            v6 = false;
                        } else {
                            for (T element$iv : $this$any$iv) {
                                it = (CandidatePair)element$iv;
                                $i$a$-any-IceAgent$waitForGoodCandidateAndThenNominateIt$4 = false;
                                if (!(it.getState().compareTo((Enum)CandidatePair.State.InProgress) <= 0)) continue;
                                v6 = true;
                                break block30;
                            }
                            v6 = false;
                        }
                    }
                    if (!v6 && TimeSource.Monotonic.ValueTimeMark.hasPassedNow-impl((long)minWaitTimeout)) break block31;
                }
                $continuation.L$0 = this;
                $continuation.J$0 = minWaitTimeout;
                $continuation.label = 5;
                v7 = DelayKt.delay-VtjQ1oo((long)DurationKt.toDuration((double)0.1, (DurationUnit)DurationUnit.SECONDS), (Continuation)$continuation);
                if (v7 != var14_4) continue;
                return var14_4;
            }
            {
                case 5: {
                    minWaitTimeout = $continuation.J$0;
                    this = (IceAgent)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v7 = $result;
                    ** continue;
                }
            }
        }
        v8 = this.getBestValidPair();
        if (v8 == null) {
            throw new IOException("No valid pairs could be found.");
        }
        nominatePair = v8;
        v9 = nominatePair.getRtt-FghU774();
        this.logger.info("Nominate: {} ({}ms RTT)", (Object)nominatePair, (Object)(v9 != null ? Boxing.boxLong((long)Duration.getInWholeMilliseconds-impl((long)v9.unbox-impl())) : null));
        this.logValidList(nominatePair);
        $continuation.L$0 = null;
        $continuation.label = 6;
        v10 = this.nominate(nominatePair, (Continuation<? super Unit>)$continuation);
        if (v10 == var14_4) {
            return var14_4;
        }
        ** GOTO lbl145
        {
            case 6: {
                ResultKt.throwOnFailure((Object)$result);
                v10 = $result;
lbl145:
                // 2 sources

                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    private final Object nominate(CandidatePair var1_1, Continuation<? super Unit> var2_2) {
        if (!(var2_2 instanceof nominate.1)) ** GOTO lbl-1000
        var7_3 = var2_2;
        if ((var7_3.label & -2147483648) != 0) {
            var7_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var2_2){
                Object L$0;
                Object L$1;
                Object L$2;
                /* synthetic */ Object result;
                final /* synthetic */ IceAgent this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return IceAgent.access$nominate(this.this$0, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var8_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                if (!this.controlling) {
                    $i$a$-check-IceAgent$nominate$2 = false;
                    $i$a$-check-IceAgent$nominate$2 = "Only the controlling agent may nominate a pair.";
                    throw new IllegalStateException($i$a$-check-IceAgent$nominate$2.toString());
                }
                tId = TransactionId.Companion.create();
                logger = ExtendedLoggerKt.withKeyValue(this.logger, "tId", tId);
                logger.debug("Nominating: {}", (Object)pair);
                $continuation.L$0 = this;
                $continuation.L$1 = pair;
                $continuation.L$2 = logger;
                $continuation.label = 1;
                v0 = this.sendIceBindingRequest(tId, pair, true, (Continuation<? super Pair<StunRequest, UdpStunPacket>>)$continuation);
                if (v0 == var8_5) {
                    return var8_5;
                }
                ** GOTO lbl33
            }
            case 1: {
                logger = (Logger)$continuation.L$2;
                pair = (CandidatePair)$continuation.L$1;
                this = (IceAgent)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl33:
                // 2 sources

                if ((response = (UdpStunPacket)((Pair)v0).component2()) == null) {
                    logger.error("Nomination failed, no response: {}", (Object)pair);
                    throw new IOException("Nomination timeout");
                }
                logger.info("Nomination successful: {}", (Object)pair);
                $continuation.L$0 = null;
                $continuation.L$1 = null;
                $continuation.L$2 = null;
                $continuation.label = 2;
                v1 = this.selectPair(pair, (Continuation<? super Unit>)$continuation);
                if (v1 == var8_5) {
                    return var8_5;
                }
                ** GOTO lbl48
            }
            case 2: {
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl48:
                // 2 sources

                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final Object selectPair(CandidatePair var1_1, Continuation<? super Unit> var2_2) {
        if (!(var2_2 instanceof selectPair.1)) ** GOTO lbl-1000
        var7_3 = var2_2;
        if ((var7_3.label & -2147483648) != 0) {
            var7_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var2_2){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ IceAgent this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return IceAgent.access$selectPair(this.this$0, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var8_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                if (!(this.selectedPair == null)) {
                    var4_6 = "Check failed.";
                    throw new IllegalStateException(var4_6.toString());
                }
                this.selectedPair = pair;
                $continuation.L$0 = this;
                $continuation.L$1 = pair;
                $continuation.label = 1;
                v0 = this.remoteIsIce4J.await((Continuation)$continuation);
                if (v0 == var8_5) {
                    return var8_5;
                }
                ** GOTO lbl28
            }
            case 1: {
                pair = (CandidatePair)$continuation.L$1;
                this = (IceAgent)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl28:
                // 2 sources

                if (((Boolean)v0).booleanValue()) {
                    this.readyForData.complete((Object)Unit.INSTANCE);
                }
                v1 = pair.getLocal().getRelay();
                if (v1 != null) {
                    v1.createChannel(pair.getRemote().getAddress());
                }
                CoroutineScopeKt.cancel$default((CoroutineScope)this.checksScope, null, (int)1, null);
                var5_8 = pair.getLocal();
                v2 /* !! */  = var5_8 instanceof LocalPeerReflexiveCandidate != false ? (LocalPeerReflexiveCandidate)var5_8 : null;
                if (v2 /* !! */  == null || (v2 /* !! */  = v2 /* !! */ .getBaseCandidate()) == null) {
                    v2 /* !! */  = pair.getLocal();
                }
                local /* !! */  = v2 /* !! */ ;
                for (LocalCandidate other : this.localCandidates) {
                    if (Intrinsics.areEqual((Object)other, (Object)local /* !! */ )) continue;
                    other.close();
                }
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final CandidatePair getBestValidPair() {
        Object v0;
        Iterable $this$minByOrNull$iv = this.validList;
        boolean $i$f$minByOrNull = false;
        Iterator iterator$iv = $this$minByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v0 = null;
        } else {
            Object minElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v0 = minElem$iv;
            } else {
                long score;
                CandidatePair pair = (CandidatePair)minElem$iv;
                boolean bl = false;
                Duration duration = pair.getRtt-FghU774();
                long l = score = duration != null ? Duration.getInWholeMilliseconds-impl((long)duration.unbox-impl()) : 9999L;
                if (pair.getLocal().isRelay()) {
                    Integer n = RELAY_PENALTY;
                    Intrinsics.checkNotNullExpressionValue((Object)n, (String)"RELAY_PENALTY");
                    score += ((Number)n).longValue();
                }
                if (pair.getRemote().isRelay()) {
                    Integer n = RELAY_PENALTY;
                    Intrinsics.checkNotNullExpressionValue((Object)n, (String)"RELAY_PENALTY");
                    score += ((Number)n).longValue();
                }
                long minValue$iv = score;
                do {
                    long v$iv;
                    long score2;
                    Object e$iv = iterator$iv.next();
                    CandidatePair pair2 = (CandidatePair)e$iv;
                    $i$a$-minByOrNull-IceAgent$getBestValidPair$1 = false;
                    Duration duration2 = pair2.getRtt-FghU774();
                    long l2 = score2 = duration2 != null ? Duration.getInWholeMilliseconds-impl((long)duration2.unbox-impl()) : 9999L;
                    if (pair2.getLocal().isRelay()) {
                        Integer n = RELAY_PENALTY;
                        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"RELAY_PENALTY");
                        score2 += ((Number)n).longValue();
                    }
                    if (pair2.getRemote().isRelay()) {
                        Integer n = RELAY_PENALTY;
                        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"RELAY_PENALTY");
                        score2 += ((Number)n).longValue();
                    }
                    if (minValue$iv <= (v$iv = score2)) continue;
                    minElem$iv = e$iv;
                    minValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v0 = minElem$iv;
            }
        }
        return v0;
    }

    private final void logValidList(CandidatePair nominatedPair) {
        for (CandidatePair pair : this.validList) {
            Object[] objectArray = new Object[3];
            objectArray[0] = pair == nominatedPair ? "*" : " ";
            objectArray[1] = pair;
            Duration duration = pair.getRtt-FghU774();
            objectArray[2] = duration != null ? Long.valueOf(Duration.getInWholeMilliseconds-impl((long)duration.unbox-impl())) : null;
            this.logger.info(" {} {} ({}ms RTT)", objectArray);
        }
    }

    private final void dispatchDataPacket(byte[] bytes) {
        CandidatePair candidatePair = this.selectedPair;
        if (candidatePair == null && (candidatePair = this.controlling ? null : this.lastReceivedDataPair) == null && (candidatePair = this.getBestValidPair()) == null) {
            return;
        }
        CandidatePair pair = candidatePair;
        if (this.highVolumeLogging) {
            LoggingEventBuilder loggingEventBuilder;
            byte[] byArray = sha256.digest(bytes);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"digest(...)");
            String checksum = UtilsKt.toBase64String(byArray);
            LoggingEventBuilder loggingEventBuilder2 = this.logger.atTrace();
            Intrinsics.checkNotNullExpressionValue((Object)loggingEventBuilder2, (String)"atTrace(...)");
            LoggingEventBuilder $this$dispatchDataPacket_u24lambda_u2414 = loggingEventBuilder = IceAgent.Companion.addKeyValues(loggingEventBuilder2, pair.getLocal()).addKeyValue("remoteAddress", (Object)pair.getRemote().getAddress());
            boolean bl = false;
            if (LOG_DATA_PACKET_CONTENT) {
                Object[] objectArray = new Object[]{bytes.length, checksum, UtilsKt.toBase64String(bytes)};
                $this$dispatchDataPacket_u24lambda_u2414.log("Sending {} bytes of data with checksum {}: {}", objectArray);
            } else {
                $this$dispatchDataPacket_u24lambda_u2414.log("Sending {} bytes of data with checksum {}", (Object)bytes.length, (Object)checksum);
            }
        }
        pair.getLocal().sendUnchecked(UtilsKt.DatagramPacket(bytes, pair.getRemote().getAddress()));
    }

    private final Object processPacket(ReceivedPacket packet, Continuation<? super Unit> $completion) {
        Iterable iterable;
        if (this.highVolumeLogging) {
            byte[] byArray = sha256.digest(packet.getData());
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"digest(...)");
            String checksum = UtilsKt.toBase64String(byArray);
            LoggingEventBuilder loggingEventBuilder = this.logger.atTrace();
            Intrinsics.checkNotNullExpressionValue((Object)loggingEventBuilder, (String)"atTrace(...)");
            Iterable $this$processPacket_u24lambda_u2415 = iterable = IceAgent.Companion.addKeyValues(loggingEventBuilder, packet.getCandidate()).addKeyValue("remoteAddress", (Object)packet.getSource());
            boolean bl = false;
            if (LOG_DATA_PACKET_CONTENT) {
                Object[] objectArray = new Object[]{Boxing.boxInt((int)packet.getData().length), checksum, UtilsKt.toBase64String(packet.getData())};
                $this$processPacket_u24lambda_u2415.log("Received {} bytes of data with checksum {}: {}", objectArray);
            } else {
                $this$processPacket_u24lambda_u2415.log("Received {} bytes of data with checksum {}", Boxing.boxInt((int)packet.getData().length), checksum);
            }
        }
        if (!this.controlling && this.selectedPair == null) {
            Object v2;
            block6: {
                Iterable iterable2 = this.validList;
                IceAgent iceAgent = this;
                iterable = iterable2;
                for (Object t : iterable) {
                    CandidatePair it = (CandidatePair)t;
                    boolean bl = false;
                    if (!(Intrinsics.areEqual((Object)it.getLocal().getBase(), (Object)packet.getCandidate().getBase()) && Intrinsics.areEqual((Object)it.getRemote().getAddress(), (Object)packet.getSource()))) continue;
                    v2 = t;
                    break block6;
                }
                v2 = null;
            }
            iceAgent.lastReceivedDataPair = v2;
        }
        Object object = this.inboundDataChannel.send((Object)new Pair((Object)packet.getCandidate(), (Object)packet.getData()), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private final Object processStunRequest(ReceivedPacket packet, StunMessage message2, Continuation<? super Unit> $completion) {
        Logger logger2 = ExtendedLoggerKt.with(this.logger, (Function1<? super LoggingEventBuilder, Unit>)((Function1)new Function1<LoggingEventBuilder, Unit>(packet, message2){
            final /* synthetic */ ReceivedPacket $packet;
            final /* synthetic */ StunMessage $message;
            {
                this.$packet = $packet;
                this.$message = $message;
                super(1);
            }

            public final void invoke(@NotNull LoggingEventBuilder $this$with) {
                Intrinsics.checkNotNullParameter((Object)$this$with, (String)"$this$with");
                gg.essential.ice.IceAgent$Companion.access$addKeyValues(IceAgent.Companion, $this$with, this.$packet.getCandidate());
                $this$with.addKeyValue("remoteAddress", (Object)this.$packet.getSource());
                $this$with.addKeyValue("tId", (Object)this.$message.getTransactionId());
            }
        }));
        if (WhenMappings.$EnumSwitchMapping$1[message2.getType().ordinal()] == 1) {
            CandidatePair pair;
            CandidatePair candidatePair;
            Object v7;
            Object it2;
            Object remoteCandidate;
            block28: {
                block26: {
                    Object object;
                    StunAttribute stunAttribute;
                    StunAttribute stunAttribute2;
                    StunMessage stunMessage;
                    StunType stunType;
                    StunClass stunClass;
                    TransactionId transactionId;
                    Object[] objectArray;
                    block25: {
                        void this_$iv;
                        logger2.trace("Received STUN Binding request.");
                        objectArray = new StunAttribute[3];
                        StunMessage stunMessage2 = message2;
                        int n = 0;
                        Object[] objectArray2 = objectArray;
                        transactionId = null;
                        stunClass = StunClass.ResponseSuccess;
                        stunType = null;
                        stunMessage = message2;
                        boolean $i$f$attribute = false;
                        for (StunAttribute it$iv : (Iterable)this_$iv.getAttributes()) {
                            boolean bl = false;
                            StunAttribute stunAttribute3 = it$iv;
                            if (!(stunAttribute3 instanceof StunAttribute.TransactionTransmitCounter)) {
                                stunAttribute3 = null;
                            }
                            if ((it$iv = (StunAttribute)((StunAttribute.TransactionTransmitCounter)stunAttribute3)) == null) continue;
                            stunAttribute2 = it$iv;
                            break block25;
                        }
                        stunAttribute2 = null;
                    }
                    objectArray2[n] = stunAttribute = stunAttribute2;
                    objectArray[1] = new StunAttribute.XorMappedAddress(packet.getSource());
                    objectArray[2] = new StunAttribute.MessageIntegrity(message2.getIntegrityProtectionKey());
                    StunMessage response2 = StunMessage.copy$default(stunMessage, stunType, stunClass, transactionId, CollectionsKt.listOfNotNull((Object[])objectArray), 5, null);
                    packet.reply(response2.encode());
                    remoteCandidate = null;
                    Iterable $i$f$attribute = this.remoteCandidates;
                    for (StunAttribute it$iv : $i$f$attribute) {
                        RemoteCandidate it2 = (RemoteCandidate)((Object)it$iv);
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)it2.getAddress(), (Object)packet.getSource())) continue;
                        object = it$iv;
                        break block26;
                    }
                    object = remoteCandidate = null;
                }
                if (remoteCandidate == null) {
                    Integer priority;
                    StunAttribute stunAttribute;
                    block27: {
                        StunMessage this_$iv = message2;
                        boolean $i$f$attribute = false;
                        for (StunAttribute it$iv : (Iterable)this_$iv.getAttributes()) {
                            boolean bl = false;
                            StunAttribute stunAttribute4 = it$iv;
                            if (!(stunAttribute4 instanceof StunAttribute.Priority)) {
                                stunAttribute4 = null;
                            }
                            if ((it$iv = (StunAttribute)((StunAttribute.Priority)stunAttribute4)) == null) continue;
                            stunAttribute = it$iv;
                            break block27;
                        }
                        stunAttribute = null;
                    }
                    StunAttribute.Priority priority2 = (StunAttribute.Priority)stunAttribute;
                    Integer n = priority = priority2 != null ? Boxing.boxInt((int)priority2.getValue()) : null;
                    if (priority == null) {
                        logger2.warn("Received STUN Binding request which is missing PRIORITY attribute: {}", (Object)message2);
                        return Unit.INSTANCE;
                    }
                    remoteCandidate = new RemoteCandidateImpl(CandidateType.PeerReflexive, packet.getSource(), priority);
                    this.addRemoteCandidate((RemoteCandidate)remoteCandidate);
                }
                Iterable iterable = this.validList;
                it2 = iterable.iterator();
                while (it2.hasNext()) {
                    Object it$iv = it2.next();
                    CandidatePair it3 = (CandidatePair)it$iv;
                    boolean bl = false;
                    if (!(Intrinsics.areEqual((Object)it3.getLocal().getBase(), (Object)packet.getCandidate().getBase()) && Intrinsics.areEqual((Object)it3.getRemote().getAddress(), (Object)packet.getSource()))) continue;
                    v7 = it$iv;
                    break block28;
                }
                v7 = null;
            }
            if ((candidatePair = (CandidatePair)v7) == null) {
                Object v9;
                block29: {
                    it2 = this.checklist;
                    Iterator it$iv = it2.iterator();
                    while (it$iv.hasNext()) {
                        Object t = it$iv.next();
                        CandidatePair it4 = (CandidatePair)t;
                        boolean bl = false;
                        if (!(Intrinsics.areEqual((Object)it4.getLocal(), (Object)packet.getCandidate()) && Intrinsics.areEqual((Object)it4.getRemote(), (Object)remoteCandidate))) continue;
                        v9 = t;
                        break block29;
                    }
                    v9 = null;
                }
                if ((candidatePair = (CandidatePair)v9) == null && (candidatePair = this.tryPair(packet.getCandidate(), (RemoteCandidate)remoteCandidate)) == null) {
                    return Unit.INSTANCE;
                }
            }
            if (!(pair = candidatePair).getHadTriggeredCheck() && !this.triggeredCheckQueue.contains(pair)) {
                pair.setHadTriggeredCheck(true);
                switch (WhenMappings.$EnumSwitchMapping$0[pair.getState().ordinal()]) {
                    case 1: {
                        break;
                    }
                    case 2: 
                    case 3: {
                        this.triggeredCheckQueue.add(pair);
                        break;
                    }
                    case 4: {
                        pair.setState(CandidatePair.State.Waiting);
                        this.triggeredCheckQueue.add(pair);
                    }
                }
            }
            if (!this.controlling) {
                StunAttribute stunAttribute;
                block30: {
                    StunMessage this_$iv = message2;
                    boolean $i$f$attribute = false;
                    for (StunAttribute it$iv : (Iterable)this_$iv.getAttributes()) {
                        StunAttribute stunAttribute5;
                        boolean bl = false;
                        StunAttribute stunAttribute6 = it$iv;
                        if (!(stunAttribute6 instanceof StunAttribute.UseCandidate)) {
                            stunAttribute6 = null;
                        }
                        if ((stunAttribute5 = (StunAttribute)((StunAttribute.UseCandidate)stunAttribute6)) == null) continue;
                        stunAttribute = stunAttribute5;
                        break block30;
                    }
                    stunAttribute = null;
                }
                if (stunAttribute != null && this.selectedPair == null) {
                    if (pair.getState() == CandidatePair.State.Succeeded) {
                        logger2.info("Nomination successful: {}", (Object)pair);
                        this.logValidList(pair);
                        Object object = this.selectPair(pair, $completion);
                        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                            return object;
                        }
                        return Unit.INSTANCE;
                    }
                    logger2.info("Remote nominated a pair, now waiting for its check to succeed: {}", (Object)pair);
                    pair.setNominateOnSuccess(true);
                }
            }
        } else {
            logger2.warn("Ignoring STUN request because it had unexpected type {}.", (Object)message2.getType());
        }
        return Unit.INSTANCE;
    }

    private static final CandidatePair performConnectivityChecks$pollTriggeredCheck(IceAgent this$0) {
        while (!((Collection)this$0.triggeredCheckQueue).isEmpty()) {
            Object object = CollectionsKt.removeFirst(this$0.triggeredCheckQueue);
            CandidatePair it = (CandidatePair)object;
            boolean bl = false;
            CandidatePair candidatePair = (CandidatePair)(this$0.checklist.contains(it) && it.getState() != CandidatePair.State.Succeeded ? object : null);
            if (candidatePair == null) continue;
            return candidatePair;
        }
        return null;
    }

    public static final /* synthetic */ Object access$checkPair(IceAgent $this, CandidatePair pair, Continuation $completion) {
        return $this.checkPair(pair, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Object access$performRTTChecks(IceAgent $this, Continuation $completion) {
        return $this.performRTTChecks((Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Logger access$getLogger$p(IceAgent $this) {
        return $this.logger;
    }

    public static final /* synthetic */ Object access$sendIceBindingRequest(IceAgent $this, TransactionId tId, CandidatePair pair, boolean nominate2, Continuation $completion) {
        return $this.sendIceBindingRequest(tId, pair, nominate2, (Continuation<? super Pair<StunRequest, UdpStunPacket>>)$completion);
    }

    public static final /* synthetic */ CoroutineScope access$getCoroutineScope$p(IceAgent $this) {
        return $this.coroutineScope;
    }

    public static final /* synthetic */ StunManager access$getStunManager$p(IceAgent $this) {
        return $this.stunManager;
    }

    public static final /* synthetic */ Object access$nominate(IceAgent $this, CandidatePair pair, Continuation $completion) {
        return $this.nominate(pair, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Object access$selectPair(IceAgent $this, CandidatePair pair, Continuation $completion) {
        return $this.selectPair(pair, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Object access$processPacket(IceAgent $this, ReceivedPacket packet, Continuation $completion) {
        return $this.processPacket(packet, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Object access$processStunRequest(IceAgent $this, ReceivedPacket packet, StunMessage message2, Continuation $completion) {
        return $this.processStunRequest(packet, message2, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ void access$setHighVolumeLogging$p(IceAgent $this, boolean bl) {
        $this.highVolumeLogging = bl;
    }

    public static final /* synthetic */ CandidateManager access$getCandidateManager$p(IceAgent $this) {
        return $this.candidateManager;
    }

    public static final /* synthetic */ CompletableJob access$getJob$p(IceAgent $this) {
        return $this.job;
    }

    public static final /* synthetic */ void access$addLocalCandidate(IceAgent $this, LocalCandidate candidate2) {
        $this.addLocalCandidate(candidate2);
    }

    public static final /* synthetic */ void access$addRemoteCandidate(IceAgent $this, RemoteCandidate candidate2) {
        $this.addRemoteCandidate(candidate2);
    }

    public static final /* synthetic */ LocalCandidate access$getLocalCandidate(IceAgent $this, StunSocket.ReceivedPacket packet) {
        return $this.getLocalCandidate(packet);
    }

    public static final /* synthetic */ void access$dispatchDataPacket(IceAgent $this, byte[] bytes) {
        $this.dispatchDataPacket(bytes);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u000f\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001:\u00013B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u00101\u001a\u000202H\u0016R\u001c\u0010\t\u001a\u0004\u0018\u00010\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u001a\u0010\u001c\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u0017\"\u0004\b\u001e\u0010\u0019R\u0011\u0010\u001f\u001a\u00020 \u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\"\u0010%\u001a\u0004\u0018\u00010&X\u0086\u000e\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010(\"\u0004\b)\u0010*R\u001a\u0010+\u001a\u00020,X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010.\"\u0004\b/\u00100\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u00064"}, d2={"Lgg/essential/ice/IceAgent$CandidatePair;", "", "local", "Lgg/essential/ice/LocalCandidate;", "remote", "Lgg/essential/ice/RemoteCandidate;", "isLocalControlling", "", "(Lgg/essential/ice/LocalCandidate;Lgg/essential/ice/RemoteCandidate;Z)V", "check", "Lkotlinx/coroutines/Job;", "getCheck", "()Lkotlinx/coroutines/Job;", "setCheck", "(Lkotlinx/coroutines/Job;)V", "extraRttChecks", "", "getExtraRttChecks", "()I", "setExtraRttChecks", "(I)V", "hadTriggeredCheck", "getHadTriggeredCheck", "()Z", "setHadTriggeredCheck", "(Z)V", "getLocal", "()Lgg/essential/ice/LocalCandidate;", "nominateOnSuccess", "getNominateOnSuccess", "setNominateOnSuccess", "priority", "", "getPriority", "()J", "getRemote", "()Lgg/essential/ice/RemoteCandidate;", "rtt", "Lkotlin/time/Duration;", "getRtt-FghU774", "()Lkotlin/time/Duration;", "setRtt-BwNAW2A", "(Lkotlin/time/Duration;)V", "state", "Lgg/essential/ice/IceAgent$CandidatePair$State;", "getState", "()Lgg/essential/ice/IceAgent$CandidatePair$State;", "setState", "(Lgg/essential/ice/IceAgent$CandidatePair$State;)V", "toString", "", "State", "ice"})
    private static final class CandidatePair {
        @NotNull
        private final LocalCandidate local;
        @NotNull
        private final RemoteCandidate remote;
        @NotNull
        private State state;
        @Nullable
        private Job check;
        @Nullable
        private Duration rtt;
        private int extraRttChecks;
        private boolean hadTriggeredCheck;
        private boolean nominateOnSuccess;
        private final long priority;

        /*
         * WARNING - void declaration
         */
        public CandidatePair(@NotNull LocalCandidate local, @NotNull RemoteCandidate remote, boolean isLocalControlling) {
            void $this$priority_u24lambda_u240;
            Intrinsics.checkNotNullParameter((Object)local, (String)"local");
            Intrinsics.checkNotNullParameter((Object)remote, (String)"remote");
            this.local = local;
            this.remote = remote;
            this.state = State.Waiting;
            CandidatePair candidatePair = this;
            CandidatePair candidatePair2 = this;
            boolean bl = false;
            int g = (isLocalControlling ? (Candidate)$this$priority_u24lambda_u240.local : (Candidate)$this$priority_u24lambda_u240.remote).getPriority();
            int d = (isLocalControlling ? (Candidate)$this$priority_u24lambda_u240.remote : (Candidate)$this$priority_u24lambda_u240.local).getPriority();
            long l = ((long)Math.min(g, d) << 32) + ((long)Math.max(g, d) << 1) + (long)(g > d ? 1 : 0);
            candidatePair2.priority = l;
        }

        @NotNull
        public final LocalCandidate getLocal() {
            return this.local;
        }

        @NotNull
        public final RemoteCandidate getRemote() {
            return this.remote;
        }

        @NotNull
        public final State getState() {
            return this.state;
        }

        public final void setState(@NotNull State state2) {
            Intrinsics.checkNotNullParameter((Object)((Object)state2), (String)"<set-?>");
            this.state = state2;
        }

        @Nullable
        public final Job getCheck() {
            return this.check;
        }

        public final void setCheck(@Nullable Job job) {
            this.check = job;
        }

        @Nullable
        public final Duration getRtt-FghU774() {
            return this.rtt;
        }

        public final void setRtt-BwNAW2A(@Nullable Duration duration) {
            this.rtt = duration;
        }

        public final int getExtraRttChecks() {
            return this.extraRttChecks;
        }

        public final void setExtraRttChecks(int n) {
            this.extraRttChecks = n;
        }

        public final boolean getHadTriggeredCheck() {
            return this.hadTriggeredCheck;
        }

        public final void setHadTriggeredCheck(boolean bl) {
            this.hadTriggeredCheck = bl;
        }

        public final boolean getNominateOnSuccess() {
            return this.nominateOnSuccess;
        }

        public final void setNominateOnSuccess(boolean bl) {
            this.nominateOnSuccess = bl;
        }

        public final long getPriority() {
            return this.priority;
        }

        @NotNull
        public String toString() {
            return this.local + " -> " + this.remote;
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lgg/essential/ice/IceAgent$CandidatePair$State;", "", "(Ljava/lang/String;I)V", "Waiting", "InProgress", "Succeeded", "Failed", "ice"})
        public static final class State
        extends Enum<State> {
            public static final /* enum */ State Waiting = new State();
            public static final /* enum */ State InProgress = new State();
            public static final /* enum */ State Succeeded = new State();
            public static final /* enum */ State Failed = new State();
            private static final /* synthetic */ State[] $VALUES;
            private static final /* synthetic */ EnumEntries $ENTRIES;

            public static State[] values() {
                return (State[])$VALUES.clone();
            }

            public static State valueOf(String value) {
                return Enum.valueOf(State.class, value);
            }

            @NotNull
            public static EnumEntries<State> getEntries() {
                return $ENTRIES;
            }

            static {
                $VALUES = stateArray = new State[]{State.Waiting, State.InProgress, State.Succeeded, State.Failed};
                $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\f\u001a\u00020\r*\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0007\u001a\n \b*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\tR\u0016\u0010\n\u001a\n \b*\u0004\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lgg/essential/ice/IceAgent$Companion;", "", "()V", "LOG_DATA_PACKET_CONTENT", "", "MAX_CHECKLIST_SIZE", "", "RELAY_PENALTY", "kotlin.jvm.PlatformType", "Ljava/lang/Integer;", "sha256", "Ljava/security/MessageDigest;", "addKeyValues", "Lorg/slf4j/spi/LoggingEventBuilder;", "candidate", "Lgg/essential/ice/LocalCandidate;", "ice"})
    public static final class Companion {
        private Companion() {
        }

        private final LoggingEventBuilder addKeyValues(LoggingEventBuilder $this$addKeyValues, LocalCandidate candidate2) {
            if (candidate2.getType() == CandidateType.Relayed) {
                $this$addKeyValues.addKeyValue("hostAddress", (Object)candidate2.getSocket().getHostAddress());
                $this$addKeyValues.addKeyValue("relayAddress", (Object)candidate2.getAddress());
            } else {
                $this$addKeyValues.addKeyValue("hostAddress", (Object)candidate2.getAddress());
            }
            return $this$addKeyValues;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0006\u001a\u00020\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0011"}, d2={"Lgg/essential/ice/IceAgent$ReceivedPacket;", "", "candidate", "Lgg/essential/ice/LocalCandidate;", "source", "Ljava/net/InetSocketAddress;", "data", "", "(Lgg/essential/ice/LocalCandidate;Ljava/net/InetSocketAddress;[B)V", "getCandidate", "()Lgg/essential/ice/LocalCandidate;", "getData", "()[B", "getSource", "()Ljava/net/InetSocketAddress;", "reply", "", "ice"})
    private static final class ReceivedPacket {
        @NotNull
        private final LocalCandidate candidate;
        @NotNull
        private final InetSocketAddress source;
        @NotNull
        private final byte[] data;

        public ReceivedPacket(@NotNull LocalCandidate candidate2, @NotNull InetSocketAddress source, @NotNull byte[] data) {
            Intrinsics.checkNotNullParameter((Object)candidate2, (String)"candidate");
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            this.candidate = candidate2;
            this.source = source;
            this.data = data;
        }

        @NotNull
        public final LocalCandidate getCandidate() {
            return this.candidate;
        }

        @NotNull
        public final InetSocketAddress getSource() {
            return this.source;
        }

        @NotNull
        public final byte[] getData() {
            return this.data;
        }

        public final void reply(@NotNull byte[] data) {
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            this.candidate.sendUnchecked(UtilsKt.DatagramPacket(data, this.source));
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[CandidatePair.State.values().length];
            try {
                nArray[CandidatePair.State.Succeeded.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CandidatePair.State.Waiting.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CandidatePair.State.InProgress.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CandidatePair.State.Failed.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[StunType.values().length];
            try {
                nArray[StunType.Binding.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

