/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.handlers;

import com.mojang.authlib.GameProfile;
import gg.essential.Essential;
import gg.essential.compat.ImmediatelyFastCompat;
import gg.essential.config.EssentialConfig;
import gg.essential.connectionmanager.common.enums.ProfileStatus;
import gg.essential.cosmetics.CosmeticsRenderState;
import gg.essential.data.OnboardingData;
import gg.essential.elementa.utils.ExtensionsKt;
import gg.essential.gui.EssentialPalette;
import gg.essential.mixins.ext.client.network.NetHandlerPlayClientExt;
import gg.essential.network.connectionmanager.ConnectionManager;
import gg.essential.network.connectionmanager.profile.ProfileManager;
import gg.essential.render.TextRenderTypeVertexConsumer;
import gg.essential.universal.UGraphics;
import gg.essential.universal.UMatrixStack;
import gg.essential.universal.UMinecraft;
import gg.essential.universal.shader.BlendState;
import gg.essential.util.Diamond;
import java.awt.Color;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;

public class OnlineIndicator {
    public static final ThreadLocal<Boolean> currentlyDrawingEntityName = ThreadLocal.withInitial(() -> false);

    public static boolean currentlyDrawingEntityName() {
        return currentlyDrawingEntityName.get();
    }

    public static void drawNametagIndicator(UMatrixStack matrixStack, MultiBufferSource vertexConsumerProvider, CosmeticsRenderState cState, String str, int light) {
        if (!cState.onlineIndicator()) {
            return;
        }
        boolean alwaysOnTop = !cState.isSneaking();
        int stringWidth = Minecraft.m_91087_().f_91062_.m_92895_(str);
        float vanillaX = -((float)(stringWidth / 2));
        Color color2 = EssentialPalette.ESSENTIAL_BLUE;
        float x1 = vanillaX - 11.0f;
        float y1 = -1.0f;
        float x2 = vanillaX - 1.0f;
        float y2 = OnlineIndicator.getDiamondBackgroundYMin();
        UGraphics.enableBlend();
        UGraphics.tryBlendFuncSeparate(770, 771, 1, 0);
        int backgroundOpacity = OnlineIndicator.getTextBackgroundOpacity();
        double z = 0.01;
        TextRenderTypeVertexConsumer vertexConsumer = TextRenderTypeVertexConsumer.create(vertexConsumerProvider, alwaysOnTop);
        vertexConsumer.pos(matrixStack, x1, y1, z).color(0, 0, 0, backgroundOpacity).tex(0.0, 0.0).light(light).endVertex();
        vertexConsumer.pos(matrixStack, x1, y2, z).color(0, 0, 0, backgroundOpacity).tex(0.0, 0.0).light(light).endVertex();
        vertexConsumer.pos(matrixStack, x2, y2, z).color(0, 0, 0, backgroundOpacity).tex(0.0, 0.0).light(light).endVertex();
        vertexConsumer.pos(matrixStack, x2, y1, z).color(0, 0, 0, backgroundOpacity).tex(0.0, 0.0).light(light).endVertex();
        float diamondCenter = (y1 + y2) / 2.0f + OnlineIndicator.getDiamondYOffset();
        Diamond.drawDiamond(matrixStack, vertexConsumer, 6, vanillaX - 6.0f, diamondCenter, ExtensionsKt.withAlpha(color2, 32).getRGB(), light);
        if (alwaysOnTop) {
            vertexConsumer = TextRenderTypeVertexConsumer.create(vertexConsumerProvider, false);
            Diamond.drawDiamond(matrixStack, vertexConsumer, 6, vanillaX - 6.0f, diamondCenter, color2.getRGB(), light);
        }
    }

    public static float getDiamondBackgroundYMin() {
        return 9.0f;
    }

    public static int getTextBackgroundOpacity() {
        return (int)(UMinecraft.getMinecraft().f_91066_.m_92141_(0.25f) * 255.0f);
    }

    private static float getDiamondYOffset() {
        return -0.5f;
    }

    public static void drawTabIndicatorOuter(UMatrixStack matrixStack, MultiBufferSource.BufferSource provider2, PlayerInfo networkPlayerInfo, int x, int y) {
        OnlineIndicator.drawTabIndicator(matrixStack, provider2, networkPlayerInfo, x, y);
    }

    private static void drawTabIndicator(UMatrixStack matrixStack, MultiBufferSource.BufferSource provider2, PlayerInfo networkPlayerInfo, int x, int y) {
        ProfileStatus status2;
        UUID actualUuid;
        if (!OnboardingData.hasAcceptedTos() || !EssentialConfig.INSTANCE.getShowEssentialIndicatorOnTab() || networkPlayerInfo == null) {
            return;
        }
        ConnectionManager connectionManager = Essential.getInstance().getConnectionManager();
        ProfileManager profileManager = connectionManager.getProfileManager();
        GameProfile gameProfile2 = networkPlayerInfo.m_105312_();
        if (gameProfile2 == null) {
            return;
        }
        UUID playerUuid = gameProfile2.getId();
        if (playerUuid == null) {
            return;
        }
        if (playerUuid.version() == 2 && (actualUuid = OnlineIndicator.findUUIDFromDisplayName(networkPlayerInfo.m_105342_())) != null) {
            playerUuid = actualUuid;
        }
        if ((status2 = profileManager.getStatus(playerUuid)) == ProfileStatus.OFFLINE) {
            return;
        }
        OnlineIndicator.beforeTabDraw();
        BlendState prevBlendState = BlendState.active();
        BlendState.NORMAL.activate();
        matrixStack.push();
        TextRenderTypeVertexConsumer vertexConsumer = TextRenderTypeVertexConsumer.create((MultiBufferSource)provider2);
        matrixStack.translate(0.0f, 0.0f, 5.0f);
        Diamond.drawDiamond(matrixStack, vertexConsumer, 4, x - 9, (float)y + 1.5f, EssentialPalette.ESSENTIAL_BLUE.getRGB());
        provider2.m_109911_();
        matrixStack.pop();
        prevBlendState.activate();
        OnlineIndicator.afterTabDraw();
    }

    public static UUID findUUIDFromDisplayName(Component displayName) {
        String[] nameParts;
        if (displayName == null) {
            return null;
        }
        ClientPacketListener netHandler = UMinecraft.getNetHandler();
        if (netHandler == null) {
            return null;
        }
        Map<String, UUID> nameToIdCache = ((NetHandlerPlayClientExt)netHandler).essential$getNameIdCache();
        String unformattedText = displayName.getString();
        for (String part : nameParts = unformattedText.replaceAll("\\W", " ").split(" ")) {
            if (part.isEmpty() || !nameToIdCache.containsKey(part)) continue;
            return nameToIdCache.get(part);
        }
        return null;
    }

    public static void beforeTabDraw() {
        ImmediatelyFastCompat.beforeHudDraw();
    }

    public static void afterTabDraw() {
        ImmediatelyFastCompat.afterHudDraw();
    }
}

