/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.handlers;

import gg.essential.api.utils.mojang.SkinResponse;
import gg.essential.gui.notification.Notifications;
import gg.essential.lib.gson.JsonObject;
import gg.essential.mod.Model;
import gg.essential.mod.Skin;
import gg.essential.util.ApiSkinKt;
import gg.essential.util.HttpUtils;
import gg.essential.util.JsonHolder;
import gg.essential.util.ModelKt;
import gg.essential.util.MojangAPI;
import gg.essential.util.USession;
import java.io.File;
import java.io.IOException;
import java.util.Locale;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.BooleanSupplier;
import kotlin.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MojangSkinManager {
    public static final String SESSION_URL = "https://sessionserver.mojang.com/session/minecraft/profile/%s?unsigned=false";
    private static final Logger LOGGER = LoggerFactory.getLogger(MojangSkinManager.class);
    private final BooleanSupplier delayChanges;
    private SkinUpdate queuedSkinChange;
    @NotNull
    private CompletableFuture<Skin> activeSkin;

    public MojangSkinManager(BooleanSupplier delayChanges) {
        this.delayChanges = delayChanges;
        this.activeSkin = this.getSkinFromMinecraft();
        this.onReAuth(() -> {
            this.activeSkin = this.getSkinFromMinecraft();
        });
    }

    protected abstract void onReAuth(Runnable var1);

    protected abstract CompletableFuture<Skin> getSkinFromMinecraft();

    protected abstract void applySkinToGame(Skin var1);

    @NotNull
    public CompletableFuture<Skin> getActiveSkin() {
        return this.activeSkin;
    }

    @Nullable
    public static Pair<String, String> getTextureProperty(UUID uuid) {
        try {
            JsonHolder jsonHolder = new JsonHolder(HttpUtils.httpGetToStringBlocking(String.format(Locale.ROOT, SESSION_URL, uuid.toString().replace("-", ""))));
            if (jsonHolder.getKeys().isEmpty()) {
                return null;
            }
            JsonObject properties2 = jsonHolder.optJSONArray("properties").get(0).getAsJsonObject();
            return new Pair((Object)properties2.get("value").getAsString(), (Object)properties2.get("signature").getAsString());
        }
        catch (IOException e) {
            LOGGER.error("Failed to fetch texture property", (Throwable)e);
            return null;
        }
    }

    @Nullable
    public Skin uploadSkin(String accessToken, Model model, File file, boolean notification) {
        this.queuedSkinChange = new SkinUpload(accessToken, model, file);
        return this.updateSkinNow(notification, true);
    }

    public void changeSkin(String accessToken, Model model, String url) {
        this.queuedSkinChange = new SkinChange(accessToken, model, url);
        if (this.delayChanges.getAsBoolean()) {
            return;
        }
        this.updateSkinNow(false, false);
    }

    public void flushChanges(boolean notification) {
        this.updateSkinNow(notification, false);
    }

    @Nullable
    private synchronized Skin updateSkinNow(boolean notification, boolean userSet) {
        SkinUpdate queuedSkinChange = this.queuedSkinChange;
        this.queuedSkinChange = null;
        if (queuedSkinChange == null) {
            return null;
        }
        if (queuedSkinChange.matches(this.activeSkin.join())) {
            return null;
        }
        SkinResponse updateSkinWithMojang = queuedSkinChange.execute();
        Optional<Skin> maybeSkin = Optional.ofNullable(updateSkinWithMojang).flatMap(response2 -> Optional.ofNullable(response2.getSkins())).flatMap(skins -> skins.stream().filter(it -> "ACTIVE".equals(it.getState())).findFirst()).map(ApiSkinKt::toMod);
        if (maybeSkin.isPresent()) {
            Skin skin = maybeSkin.get();
            this.applySkinToGame(skin);
            this.activeSkin = CompletableFuture.completedFuture(skin);
            if (notification) {
                Notifications.INSTANCE.push("Skin", "Skin updated successfully");
            }
            return skin;
        }
        Notifications.INSTANCE.push("Skin", "Failed to upload skin, please try again");
        return null;
    }

    private static class SkinChange
    extends SkinUpdate {
        private final String url;

        protected SkinChange(String accessToken, Model model, String url) {
            super(accessToken, model);
            this.url = url;
        }

        @Override
        public boolean matches(Skin activeSkin) {
            return activeSkin.getHash().equals(Skin.hashFromUrl(this.url)) && activeSkin.getModel() == this.model;
        }

        @Override
        public SkinResponse execute() {
            return MojangAPI.INSTANCE.changeSkin(this.accessToken, USession.Companion.activeNow().getUuid(), ModelKt.toAPIModel(this.model), this.url);
        }
    }

    private static class SkinUpload
    extends SkinUpdate {
        private final File file;

        protected SkinUpload(String accessToken, Model model, File file) {
            super(accessToken, model);
            this.file = file;
        }

        @Override
        public boolean matches(Skin activeSkin) {
            return false;
        }

        @Override
        public SkinResponse execute() {
            return MojangAPI.INSTANCE.uploadSkin(this.accessToken, ModelKt.toAPIModel(this.model), this.file);
        }
    }

    private static abstract class SkinUpdate {
        protected final String accessToken;
        protected final Model model;

        protected SkinUpdate(String accessToken, Model model) {
            this.accessToken = accessToken;
            this.model = model;
        }

        public abstract boolean matches(Skin var1);

        public abstract SkinResponse execute();
    }
}

