/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.handlers;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.InsecurePublicKeyException;
import com.mojang.authlib.properties.Property;
import com.mojang.authlib.properties.PropertyMap;
import com.mojang.authlib.yggdrasil.ServicesKeyInfo;
import com.mojang.authlib.yggdrasil.ServicesKeySet;
import com.mojang.authlib.yggdrasil.ServicesKeyType;
import com.mojang.authlib.yggdrasil.YggdrasilAuthenticationService;
import gg.essential.Essential;
import gg.essential.api.utils.JsonHolder;
import gg.essential.network.connectionmanager.subscription.SubscriptionManager;
import gg.essential.util.ExtensionsKt;
import gg.essential.util.UUIDUtil;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.security.PublicKey;
import java.security.Signature;
import java.util.Base64;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import org.jetbrains.annotations.NotNull;
import sun.misc.Unsafe;

public class GameProfileManager
implements SubscriptionManager.Listener {
    public static final String SKIN_URL = "http://textures.minecraft.net/texture/%s";
    private final Map<UUID, Overwrites> uuidToOverwrites = new ConcurrentHashMap<UUID, Overwrites>();

    public GameProfile handleGameProfile(GameProfile profile2) {
        Overwrites overwrites = this.uuidToOverwrites.get(profile2.getId());
        if (overwrites == null) {
            return null;
        }
        Property property2 = profile2.getProperties().get((Object)"textures").stream().findFirst().orElse(null);
        if (property2 == null || ManagedTexturesProperty.hasOverwrites(property2, overwrites)) {
            return null;
        }
        return overwrites.apply(profile2);
    }

    public void updatePlayerSkin(UUID uuid, String hash, String type) {
        this.updatePlayerSkin(uuid, new Overwrites(hash, type, null));
    }

    private void updatePlayerSkin(UUID uuid, Overwrites overwrites) {
        this.uuidToOverwrites.put(uuid, overwrites);
    }

    @Override
    public void onSubscriptionRemoved(@NotNull Set<UUID> uuids) {
        for (UUID uuid : uuids) {
            this.uuidToOverwrites.remove(uuid);
        }
    }

    public static void updatePropertyMap(PropertyMap profileProperties, Property property2) {
        profileProperties.removeAll((Object)"textures");
        profileProperties.put((Object)"textures", (Object)property2);
    }

    public static String getSafeTexturesValue(GameProfile profile2) {
        Iterator textures;
        Minecraft mc = Minecraft.m_91087_();
        PropertyMap properties2 = null;
        try {
            if (!mc.m_91108_().getTextures(profile2, true).isEmpty()) {
                properties2 = profile2.getProperties();
            }
        }
        catch (InsecurePublicKeyException insecurePublicKeyException) {
        }
        catch (Exception e) {
            Essential.logger.error("Error getting profile textures", (Throwable)e);
        }
        if (properties2 == null && UUIDUtil.getClientUUID().equals(profile2.getId())) {
            properties2 = mc.m_91095_();
        }
        if (properties2 != null && (textures = properties2.get((Object)"textures").iterator()).hasNext()) {
            return ((Property)textures.next()).getValue();
        }
        return "e30=";
    }

    public static void register(YggdrasilAuthenticationService authenticationService) throws ReflectiveOperationException {
        Field theUnsafeField = Unsafe.class.getDeclaredField("theUnsafe");
        theUnsafeField.setAccessible(true);
        Unsafe unsafe = (Unsafe)theUnsafeField.get(null);
        Field servicesKeySetField = YggdrasilAuthenticationService.class.getDeclaredField("servicesKeySet");
        long servicesKeySetOffset = unsafe.objectFieldOffset(servicesKeySetField);
        ServicesKeySet originalSet = (ServicesKeySet)unsafe.getObject(authenticationService, servicesKeySetOffset);
        ServicesKeySet wrapperSet = type -> {
            if (type != ServicesKeyType.PROFILE_PROPERTY) {
                return originalSet.keys(type);
            }
            return originalSet.keys(type).stream().map(TrustingServicesKeyInfo::new).collect(Collectors.toList());
        };
        unsafe.putObject(authenticationService, servicesKeySetOffset, wrapperSet);
    }

    public static class Overwrites {
        private final String skinHash;
        private final String skinType;
        private final String capeHash;

        public Overwrites(String skinHash, String skinType, String capeHash) {
            this.skinHash = skinHash;
            this.skinType = skinType;
            this.capeHash = capeHash;
        }

        public String apply(String originalValue, UUID id2) {
            String url;
            JsonHolder root = new JsonHolder(new String(Base64.getDecoder().decode(originalValue)));
            if (!root.optString("profileId").isEmpty() && !id2.equals(UUIDUtil.formatWithDashes(root.optString("profileId")))) {
                return originalValue;
            }
            JsonHolder textures = root.optOrCreateJsonHolder("textures");
            if (this.skinHash != null || this.skinType != null) {
                JsonHolder skin = textures.optOrCreateJsonHolder("SKIN");
                if (this.skinHash != null && !(url = skin.optString("url")).endsWith(this.skinHash)) {
                    skin.put("url", String.format(Locale.ROOT, GameProfileManager.SKIN_URL, this.skinHash));
                }
                if (this.skinType != null) {
                    if (this.skinType.equals("default")) {
                        skin.remove("metadata");
                    } else {
                        skin.optOrCreateJsonHolder("metadata").put("model", this.skinType);
                    }
                }
            }
            if (this.capeHash != null) {
                if (this.capeHash.isEmpty()) {
                    textures.remove("CAPE");
                } else {
                    JsonHolder cape = textures.optOrCreateJsonHolder("CAPE");
                    url = cape.optString("url");
                    if (!url.endsWith(this.capeHash)) {
                        cape.put("url", String.format(Locale.ROOT, GameProfileManager.SKIN_URL, this.capeHash));
                    }
                }
            }
            return Base64.getEncoder().encodeToString(root.toString().getBytes(StandardCharsets.UTF_8));
        }

        public GameProfile apply(GameProfile originalProfile) {
            GameProfile updatedProfile = ExtensionsKt.copy(originalProfile);
            GameProfileManager.updatePropertyMap(updatedProfile.getProperties(), ManagedTexturesProperty.create(originalProfile, this));
            return updatedProfile;
        }
    }

    private static class ManagedTexturesProperty
    extends TrustedProperty {
        private final Overwrites overwrites;

        private ManagedTexturesProperty(GameProfile originalProfile, Overwrites overwrites) {
            super("textures", overwrites.apply(GameProfileManager.getSafeTexturesValue(originalProfile), originalProfile.getId()));
            this.overwrites = overwrites;
        }

        public static Property create(GameProfile originalProfile, Overwrites overwrites) {
            return new ManagedTexturesProperty(originalProfile, overwrites);
        }

        public static boolean hasOverwrites(Property property2, Overwrites overwrites) {
            return property2 instanceof ManagedTexturesProperty && ((ManagedTexturesProperty)property2).overwrites == overwrites;
        }
    }

    private record TrustingServicesKeyInfo(ServicesKeyInfo inner) implements ServicesKeyInfo
    {
        public int keyBitCount() {
            return this.inner.keyBitCount();
        }

        public int signatureBitCount() {
            return this.inner.signatureBitCount();
        }

        public Signature signature() {
            return this.inner.signature();
        }

        public boolean validateProperty(Property property2) {
            return property2 instanceof TrustedProperty || this.inner.validateProperty(property2);
        }
    }

    private static class TrustedProperty
    extends Property {
        public TrustedProperty(String name2, String value) {
            super(name2, value, "trusted");
        }

        public boolean isSignatureValid(PublicKey publicKey) {
            return true;
        }
    }
}

