/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.gui.screenshot.image;

import gg.essential.elementa.UIComponent;
import gg.essential.elementa.state.BasicState;
import gg.essential.elementa.state.State;
import gg.essential.universal.UGraphics;
import gg.essential.universal.UMatrixStack;
import gg.essential.universal.render.DrawCallBuilder;
import gg.essential.universal.render.URenderPipeline;
import gg.essential.universal.shader.BlendState;
import gg.essential.universal.vertex.UBufferBuilder;
import gg.essential.universal.vertex.UBuiltBuffer;
import gg.essential.util.GuiEssentialPlatform;
import gg.essential.util.UIdentifier;
import java.awt.Color;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\b\u0016\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u0013\b\u0016\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004B\u0015\u0012\u000e\u0010\u0002\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J&\u0010\r\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011R\u0019\u0010\u0002\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0014"}, d2={"Lgg/essential/gui/screenshot/image/ScreenshotImage;", "Lgg/essential/elementa/UIComponent;", "texture", "Lgg/essential/util/UIdentifier;", "(Lgg/essential/util/UIdentifier;)V", "Lgg/essential/elementa/state/State;", "(Lgg/essential/elementa/state/State;)V", "getTexture", "()Lgg/essential/elementa/state/State;", "draw", "", "matrixStack", "Lgg/essential/universal/UMatrixStack;", "renderImage", "color", "Ljava/awt/Color;", "width", "", "height", "Companion", "essential-gui-essential"})
public class ScreenshotImage
extends UIComponent {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final State<UIdentifier> texture;
    @NotNull
    private static final URenderPipeline PIPELINE;

    public ScreenshotImage(@NotNull State<UIdentifier> texture) {
        Intrinsics.checkNotNullParameter(texture, (String)"texture");
        this.texture = texture;
    }

    @NotNull
    public final State<UIdentifier> getTexture() {
        return this.texture;
    }

    public ScreenshotImage(@Nullable UIdentifier texture) {
        this((State<UIdentifier>)new BasicState<UIdentifier>(texture));
    }

    public /* synthetic */ ScreenshotImage(UIdentifier uIdentifier, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            uIdentifier = null;
        }
        this(uIdentifier);
    }

    @Override
    public void draw(@NotNull UMatrixStack matrixStack) {
        Intrinsics.checkNotNullParameter((Object)matrixStack, (String)"matrixStack");
        this.beforeDrawCompat(matrixStack);
        UIdentifier textureInstance = this.texture.get();
        if (textureInstance != null) {
            double x = this.getLeft();
            double y = this.getTop();
            double width2 = this.getWidth();
            double height2 = this.getHeight();
            Color color2 = this.getColor();
            if (color2.getAlpha() == 0) {
                super.draw(matrixStack);
                return;
            }
            matrixStack.push();
            matrixStack.translate(x, y, 0.0);
            this.renderImage(matrixStack, color2, width2, height2);
            matrixStack.pop();
        }
        super.draw(matrixStack);
    }

    public final void renderImage(@NotNull UMatrixStack matrixStack, @NotNull Color color2, double width2, double height2) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)matrixStack, (String)"matrixStack");
            Intrinsics.checkNotNullParameter((Object)color2, (String)"color");
            UIdentifier uIdentifier = this.texture.get();
            if (uIdentifier == null) {
                return;
            }
            UIdentifier textureInstance = uIdentifier;
            int textureId = GuiEssentialPlatform.Companion.getPlatform().getGlId(textureInstance);
            float red = (float)color2.getRed() / 255.0f;
            float green = (float)color2.getGreen() / 255.0f;
            float blue = (float)color2.getBlue() / 255.0f;
            float alpha = (float)color2.getAlpha() / 255.0f;
            UBufferBuilder worldRenderer = UBufferBuilder.Companion.create(UGraphics.DrawMode.QUADS, UGraphics.CommonVertexFormats.POSITION_TEXTURE_COLOR);
            worldRenderer.pos(matrixStack, 0.0, height2, 0.0).tex(0.0, 1.0).color(red, green, blue, alpha).endVertex();
            worldRenderer.pos(matrixStack, width2, height2, 0.0).tex(1.0, 1.0).color(red, green, blue, alpha).endVertex();
            worldRenderer.pos(matrixStack, width2, 0.0, 0.0).tex(1.0, 0.0).color(red, green, blue, alpha).endVertex();
            worldRenderer.pos(matrixStack, 0.0, 0.0, 0.0).tex(0.0, 0.0).color(red, green, blue, alpha).endVertex();
            UBuiltBuffer uBuiltBuffer = worldRenderer.build();
            if (uBuiltBuffer == null) break block1;
            uBuiltBuffer.drawAndClose(PIPELINE, (Function1<? super DrawCallBuilder, Unit>)((Function1)new Function1<DrawCallBuilder, Unit>(textureId){
                final /* synthetic */ int $textureId;
                {
                    this.$textureId = $textureId;
                    super(1);
                }

                public final void invoke(@NotNull DrawCallBuilder $this$drawAndClose) {
                    Intrinsics.checkNotNullParameter((Object)$this$drawAndClose, (String)"$this$drawAndClose");
                    $this$drawAndClose.texture(0, this.$textureId);
                }
            }));
        }
    }

    static {
        URenderPipeline.Builder builder;
        Companion = new Companion(null);
        URenderPipeline.Builder $this$PIPELINE_u24lambda_u240 = builder = URenderPipeline.Companion.builderWithDefaultShader("essential:screenshot_image", UGraphics.DrawMode.QUADS, UGraphics.CommonVertexFormats.POSITION_TEXTURE_COLOR);
        boolean bl = false;
        $this$PIPELINE_u24lambda_u240.setBlendState(BlendState.NORMAL);
        PIPELINE = builder.build();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lgg/essential/gui/screenshot/image/ScreenshotImage$Companion;", "", "()V", "PIPELINE", "Lgg/essential/universal/render/URenderPipeline;", "essential-gui-essential"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

