/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.gui.screenshot.handler;

import com.google.common.collect.Sets;
import com.sparkuniverse.toolbox.serialization.DateTimeTypeAdapter;
import com.sparkuniverse.toolbox.serialization.UUIDTypeAdapter;
import com.sparkuniverse.toolbox.util.DateTime;
import gg.essential.gui.screenshot.UtilsKt;
import gg.essential.gui.screenshot.handler.ScreenshotChecksumManager;
import gg.essential.handlers.screenshot.ClientScreenshotMetadata;
import gg.essential.lib.gson.Gson;
import gg.essential.lib.gson.GsonBuilder;
import gg.essential.lib.gson.JsonSyntaxException;
import gg.essential.network.connectionmanager.media.IScreenshotMetadataManager;
import gg.essential.util.USession;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.file.Path;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\r\u0018\u0000 '2\u00020\u0001:\u0001'B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\fJ\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\rH\u0002J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0003J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0018\u001a\u00020\u0003H\u0016J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\r2\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0014\u001a\u00020\fH\u0002J\u0010\u0010\u001c\u001a\u0004\u0018\u00010\r2\u0006\u0010\u001d\u001a\u00020\fJ\u0010\u0010\u001e\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u000e\u0010\u001f\u001a\u00020\u00162\u0006\u0010 \u001a\u00020\fJ\u0012\u0010!\u001a\u0004\u0018\u00010\r2\u0006\u0010\"\u001a\u00020\fH\u0002J\u0012\u0010#\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0014\u001a\u00020\fH\u0002J\u000e\u0010$\u001a\u00020\u00162\u0006\u0010%\u001a\u00020\rJ\u0010\u0010&\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\rH\u0002R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\u000e\u001a&\u0012\f\u0012\n \t*\u0004\u0018\u00010\f0\f \t*\u0012\u0012\f\u0012\n \t*\u0004\u0018\u00010\f0\f\u0018\u00010\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lgg/essential/gui/screenshot/handler/ScreenshotMetadataManager;", "Lgg/essential/network/connectionmanager/media/IScreenshotMetadataManager;", "metadataFolder", "Ljava/io/File;", "screenshotChecksumManager", "Lgg/essential/gui/screenshot/handler/ScreenshotChecksumManager;", "(Ljava/io/File;Lgg/essential/gui/screenshot/handler/ScreenshotChecksumManager;)V", "gson", "Lgg/essential/lib/gson/Gson;", "kotlin.jvm.PlatformType", "metadataCache", "", "", "Lgg/essential/handlers/screenshot/ClientScreenshotMetadata;", "negativeChecksumCache", "", "", "createMetadata", "time", "Lcom/sparkuniverse/toolbox/util/DateTime;", "checksum", "deleteMetadata", "", "metadata", "file", "getMetadata", "path", "Ljava/nio/file/Path;", "getMetadataCache", "mediaId", "getOrCreateMetadata", "handleExternalDelete", "fileName", "readMetadata", "imageChecksum", "tryRecoverMetadata", "updateMetadata", "screenshotMetadata", "writeMetadata", "Companion", "essential-gui-essential"})
@SourceDebugExtension(value={"SMAP\nScreenshotMetadataManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScreenshotMetadataManager.kt\ngg/essential/gui/screenshot/handler/ScreenshotMetadataManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,169:1\n1#2:170\n288#3,2:171\n*S KotlinDebug\n*F\n+ 1 ScreenshotMetadataManager.kt\ngg/essential/gui/screenshot/handler/ScreenshotMetadataManager\n*L\n100#1:171,2\n*E\n"})
public final class ScreenshotMetadataManager
implements IScreenshotMetadataManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final File metadataFolder;
    @NotNull
    private final ScreenshotChecksumManager screenshotChecksumManager;
    private final Gson gson;
    @NotNull
    private final Map<String, ClientScreenshotMetadata> metadataCache;
    private final Set<String> negativeChecksumCache;
    private static final Logger LOGGER = LoggerFactory.getLogger(ScreenshotMetadataManager.class);

    public ScreenshotMetadataManager(@NotNull File metadataFolder, @NotNull ScreenshotChecksumManager screenshotChecksumManager) {
        Intrinsics.checkNotNullParameter((Object)metadataFolder, (String)"metadataFolder");
        Intrinsics.checkNotNullParameter((Object)screenshotChecksumManager, (String)"screenshotChecksumManager");
        this.metadataFolder = metadataFolder;
        this.screenshotChecksumManager = screenshotChecksumManager;
        this.gson = new GsonBuilder().registerTypeAdapter((Type)((Object)UUID.class), new UUIDTypeAdapter()).registerTypeAdapter((Type)((Object)DateTime.class), new DateTimeTypeAdapter()).create();
        this.metadataCache = new ConcurrentHashMap();
        this.negativeChecksumCache = Sets.newConcurrentHashSet();
    }

    public final void updateMetadata(@NotNull ClientScreenshotMetadata screenshotMetadata) {
        Intrinsics.checkNotNullParameter((Object)screenshotMetadata, (String)"screenshotMetadata");
        this.metadataCache.put(screenshotMetadata.getChecksum(), screenshotMetadata);
        this.writeMetadata(screenshotMetadata);
    }

    private final ClientScreenshotMetadata readMetadata(String imageChecksum) {
        ClientScreenshotMetadata clientScreenshotMetadata;
        try {
            String fileContents = FilesKt.readText$default((File)new File(this.metadataFolder, imageChecksum), null, (int)1, null);
            clientScreenshotMetadata = this.gson.fromJson(fileContents, ClientScreenshotMetadata.class);
        }
        catch (JsonSyntaxException exception) {
            LOGGER.error("Metadata corrupt for checksum " + imageChecksum + ". Attempting recovery.", (Throwable)exception);
            clientScreenshotMetadata = this.tryRecoverMetadata(imageChecksum);
        }
        catch (FileNotFoundException ignored) {
            clientScreenshotMetadata = null;
        }
        return clientScreenshotMetadata;
    }

    private final ClientScreenshotMetadata tryRecoverMetadata(String checksum) {
        ClientScreenshotMetadata metadata2;
        block2: {
            ClientScreenshotMetadata clientScreenshotMetadata;
            Path path = (Path)CollectionsKt.firstOrNull(this.screenshotChecksumManager.getPathsForChecksum(checksum));
            if (path != null) {
                Path it = path;
                boolean bl = false;
                clientScreenshotMetadata = this.createMetadata(UtilsKt.getImageTime(it, null, false), checksum);
            } else {
                clientScreenshotMetadata = null;
            }
            ClientScreenshotMetadata clientScreenshotMetadata2 = metadata2 = clientScreenshotMetadata;
            if (clientScreenshotMetadata2 == null) break block2;
            ClientScreenshotMetadata it = clientScreenshotMetadata2;
            boolean bl = false;
            this.writeMetadata(it);
        }
        return metadata2;
    }

    private final ClientScreenshotMetadata getMetadata(String checksum) {
        if (this.negativeChecksumCache.contains(checksum)) {
            return null;
        }
        ClientScreenshotMetadata metadata2 = this.metadataCache.compute(checksum, (arg_0, arg_1) -> ScreenshotMetadataManager.getMetadata$lambda$2((Function2)new Function2<String, ClientScreenshotMetadata, ClientScreenshotMetadata>(this, checksum){
            final /* synthetic */ ScreenshotMetadataManager this$0;
            final /* synthetic */ String $checksum;
            {
                this.this$0 = $receiver;
                this.$checksum = $checksum;
                super(2);
            }

            @Nullable
            public final ClientScreenshotMetadata invoke(@NotNull String string, @Nullable ClientScreenshotMetadata it) {
                Intrinsics.checkNotNullParameter((Object)string, (String)"<anonymous parameter 0>");
                ClientScreenshotMetadata clientScreenshotMetadata = it;
                if (clientScreenshotMetadata == null) {
                    clientScreenshotMetadata = ScreenshotMetadataManager.access$readMetadata(this.this$0, this.$checksum);
                }
                return clientScreenshotMetadata;
            }
        }, arg_0, arg_1));
        if (metadata2 == null) {
            this.negativeChecksumCache.add(checksum);
        }
        return metadata2;
    }

    @Override
    @Nullable
    public ClientScreenshotMetadata getMetadata(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        File file = path.toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
        return this.getMetadata(file);
    }

    @Override
    @Nullable
    public ClientScreenshotMetadata getMetadata(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        String string = this.screenshotChecksumManager.get(file);
        if (string == null) {
            return null;
        }
        String imageChecksum = string;
        return this.getMetadata(imageChecksum);
    }

    @Nullable
    public final ClientScreenshotMetadata getMetadataCache(@NotNull String mediaId) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)mediaId, (String)"mediaId");
            Iterable $this$firstOrNull$iv = this.metadataCache.values();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                ClientScreenshotMetadata it = (ClientScreenshotMetadata)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getMediaId(), (Object)mediaId)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    private final void writeMetadata(ClientScreenshotMetadata metadata2) {
        this.negativeChecksumCache.remove(metadata2.getChecksum());
        try {
            File file = new File(this.metadataFolder, metadata2.getChecksum());
            String string = this.gson.toJson(metadata2);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toJson(...)");
            FilesKt.writeText$default((File)file, (String)string, null, (int)2, null);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public final void handleExternalDelete(@NotNull String fileName) {
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        String string = this.screenshotChecksumManager.remove(fileName);
        if (string == null) {
            return;
        }
        String checksum = string;
        ClientScreenshotMetadata metadata2 = this.getMetadata(checksum);
        if (metadata2 != null) {
            this.deleteMetadata(metadata2);
        }
    }

    private final void deleteMetadata(ClientScreenshotMetadata metadata2) {
        File metadataFile = new File(this.metadataFolder, metadata2.getChecksum());
        this.metadataCache.remove(metadata2.getChecksum());
        metadataFile.delete();
    }

    public final void deleteMetadata(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        ClientScreenshotMetadata metadata2 = this.getMetadata(file);
        if (metadata2 != null) {
            this.deleteMetadata(metadata2);
            this.screenshotChecksumManager.delete(file);
        }
    }

    @NotNull
    public final ClientScreenshotMetadata createMetadata(@NotNull DateTime time2, @NotNull String checksum) {
        Intrinsics.checkNotNullParameter((Object)time2, (String)"time");
        Intrinsics.checkNotNullParameter((Object)checksum, (String)"checksum");
        return new ClientScreenshotMetadata(USession.Companion.activeNow().getUuid(), time2, checksum, null, new ClientScreenshotMetadata.Location(ClientScreenshotMetadata.Location.Type.UNKNOWN, "Unknown"), false, false, null, 128, null);
    }

    @Override
    @NotNull
    public synchronized ClientScreenshotMetadata getOrCreateMetadata(@NotNull Path path) {
        ClientScreenshotMetadata clientScreenshotMetadata;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        File file = path.toFile();
        Intrinsics.checkNotNull((Object)file);
        ClientScreenshotMetadata existingMetadata = this.getMetadata(file);
        if (existingMetadata != null) {
            return existingMetadata;
        }
        String string = this.screenshotChecksumManager.get(file);
        if (string == null) {
            throw new IllegalStateException("No checksum for file " + file + ". Was the file deleted?");
        }
        String checksum = string;
        ClientScreenshotMetadata it = clientScreenshotMetadata = this.createMetadata(UtilsKt.getImageTime(path, null, false), checksum);
        boolean bl = false;
        this.updateMetadata(it);
        return clientScreenshotMetadata;
    }

    private static final ClientScreenshotMetadata getMetadata$lambda$2(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (ClientScreenshotMetadata)$tmp0.invoke(p0, p1);
    }

    public static final /* synthetic */ ClientScreenshotMetadata access$readMetadata(ScreenshotMetadataManager $this, String imageChecksum) {
        return $this.readMetadata(imageChecksum);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lgg/essential/gui/screenshot/handler/ScreenshotMetadataManager$Companion;", "", "()V", "LOGGER", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "essential-gui-essential"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

