/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.gui.screenshot.handler;

import gg.essential.gui.screenshot.handler.ChecksumSnapshot;
import gg.essential.gui.screenshot.handler.SerializedChecksum;
import gg.essential.lib.gson.Gson;
import gg.essential.lib.gson.JsonSyntaxException;
import gg.essential.vigilance.impl.nightconfig.core.utils.ObservedMap;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.commons.codec.digest.DigestUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0003J\u0013\u0010\u0012\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0011\u001a\u00020\u0003H\u0086\u0002J\u0010\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u0003H\u0002J\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u0017\u001a\u00020\nJ\u0012\u0010\u0018\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0011\u001a\u00020\u0003H\u0002J\u0010\u0010\u0019\u001a\u0004\u0018\u00010\n2\u0006\u0010\u001a\u001a\u00020\nJ\b\u0010\u001b\u001a\u00020\u0010H\u0002J\u0019\u0010\u001c\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\nH\u0086\u0002R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u0006\u001a\u001e\u0012\f\u0012\n \t*\u0004\u0018\u00010\b0\b\u0012\f\u0012\n \t*\u0004\u0018\u00010\n0\n0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lgg/essential/gui/screenshot/handler/ScreenshotChecksumManager;", "", "screenshotFolder", "Ljava/io/File;", "cacheFile", "(Ljava/io/File;Ljava/io/File;)V", "entries", "Lgg/essential/vigilance/impl/nightconfig/core/utils/ObservedMap;", "Lgg/essential/gui/screenshot/handler/ChecksumSnapshot;", "kotlin.jvm.PlatformType", "", "gson", "Lgg/essential/lib/gson/Gson;", "persistChanges", "", "delete", "", "file", "get", "getChecksumSnapshot", "getPathsForChecksum", "", "Ljava/nio/file/Path;", "checksum", "readFileChecksum", "remove", "name", "saveState", "set", "essential-gui-essential"})
@SourceDebugExtension(value={"SMAP\nScreenshotChecksumManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScreenshotChecksumManager.kt\ngg/essential/gui/screenshot/handler/ScreenshotChecksumManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,155:1\n766#2:156\n857#2,2:157\n1549#2:159\n1620#2,3:160\n288#2,2:163\n125#3:165\n152#3,3:166\n*S KotlinDebug\n*F\n+ 1 ScreenshotChecksumManager.kt\ngg/essential/gui/screenshot/handler/ScreenshotChecksumManager\n*L\n95#1:156\n95#1:157,2\n97#1:159\n97#1:160,3\n108#1:163,2\n124#1:165\n124#1:166,3\n*E\n"})
public final class ScreenshotChecksumManager {
    @NotNull
    private final File screenshotFolder;
    @NotNull
    private final File cacheFile;
    @NotNull
    private final Gson gson;
    private boolean persistChanges;
    @NotNull
    private final ObservedMap<ChecksumSnapshot, String> entries;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ScreenshotChecksumManager(@NotNull File screenshotFolder2, @NotNull File cacheFile) {
        Intrinsics.checkNotNullParameter((Object)screenshotFolder2, (String)"screenshotFolder");
        Intrinsics.checkNotNullParameter((Object)cacheFile, (String)"cacheFile");
        this.screenshotFolder = screenshotFolder2;
        this.cacheFile = cacheFile;
        this.gson = new Gson();
        this.persistChanges = true;
        this.entries = new ObservedMap(new LinkedHashMap(), () -> ScreenshotChecksumManager.entries$lambda$0(this));
        ObservedMap<ChecksumSnapshot, String> observedMap = this.entries;
        synchronized (observedMap) {
            boolean bl = false;
            if (this.cacheFile.exists()) {
                try {
                    this.persistChanges = false;
                    SerializedChecksum[] data = this.gson.fromJson(FilesKt.readText$default((File)this.cacheFile, null, (int)1, null), SerializedChecksum[].class);
                    if (data != null) {
                        for (SerializedChecksum entry : data) {
                            ((Map)this.entries).put(entry.getSnapshot(), entry.getChecksum());
                        }
                    }
                }
                catch (JsonSyntaxException e) {
                    this.cacheFile.delete();
                }
                finally {
                    this.persistChanges = true;
                }
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void set(@NotNull File file, @NotNull String checksum) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)checksum, (String)"checksum");
        ObservedMap<ChecksumSnapshot, String> observedMap = this.entries;
        synchronized (observedMap) {
            boolean bl = false;
            ((Map)this.entries).put(this.getChecksumSnapshot(file), checksum);
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final String get(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        ObservedMap<ChecksumSnapshot, String> observedMap = this.entries;
        synchronized (observedMap) {
            String string;
            boolean bl = false;
            ChecksumSnapshot checksumSnapshot = this.getChecksumSnapshot(file);
            String get2 = this.entries.get(checksumSnapshot);
            if (get2 != null) {
                string = get2;
            } else {
                String fileChecksum;
                String string2 = fileChecksum = this.readFileChecksum(file);
                if (string2 != null) {
                    String string3;
                    String it = string3 = string2;
                    boolean bl2 = false;
                    ((Map)this.entries).put(checksumSnapshot, fileChecksum);
                    string = string3;
                } else {
                    string = null;
                }
            }
            String string4 = string;
            return string4;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public final List<Path> getPathsForChecksum(@NotNull String checksum) {
        Intrinsics.checkNotNullParameter((Object)checksum, (String)"checksum");
        ObservedMap<ChecksumSnapshot, String> observedMap = this.entries;
        synchronized (observedMap) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Map.Entry it;
            void $this$filterTo$iv$iv;
            boolean bl = false;
            Set<Map.Entry<ChecksumSnapshot, String>> set2 = this.entries.entrySet();
            Intrinsics.checkNotNullExpressionValue(set2, (String)"<get-entries>(...)");
            Iterable $this$filter$iv = set2;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (Map.Entry)element$iv$iv;
                boolean bl2 = false;
                if (!Intrinsics.areEqual(it.getValue(), (Object)checksum)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (Map.Entry)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl3 = false;
                collection.add(new File(this.screenshotFolder, ((ChecksumSnapshot)it.getKey()).getName()).toPath());
            }
            List list = (List)destination$iv$iv;
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final String remove(@NotNull String name2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        ObservedMap<ChecksumSnapshot, String> observedMap = this.entries;
        synchronized (observedMap) {
            String string;
            Object v1;
            block6: {
                boolean bl = false;
                Set<Map.Entry<ChecksumSnapshot, String>> set2 = this.entries.entrySet();
                Intrinsics.checkNotNullExpressionValue(set2, (String)"<get-entries>(...)");
                Iterable $this$firstOrNull$iv = set2;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    Map.Entry it = (Map.Entry)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)((ChecksumSnapshot)it.getKey()).getName(), (Object)name2)) continue;
                    v1 = element$iv;
                    break block6;
                }
                v1 = null;
            }
            Map.Entry entry = v1;
            if (entry != null) {
                Map.Entry it = entry;
                boolean bl = false;
                this.entries.remove(it.getKey());
                string = (String)it.getValue();
            } else {
                string = null;
            }
            String string2 = string;
            return string2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void saveState() {
        if (!this.persistChanges) {
            return;
        }
        ObservedMap<ChecksumSnapshot, String> observedMap = this.entries;
        synchronized (observedMap) {
            Collection<SerializedChecksum> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            boolean bl = false;
            Map map2 = this.entries;
            Gson gson = this.gson;
            File file = this.cacheFile;
            boolean $i$f$map = false;
            void var7_9 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.size());
            boolean $i$f$mapTo = false;
            Iterator iterator2 = $this$mapTo$iv$iv.entrySet().iterator();
            while (iterator2.hasNext()) {
                void it;
                Map.Entry item$iv$iv;
                Map.Entry entry = item$iv$iv = iterator2.next();
                collection = destination$iv$iv;
                boolean bl2 = false;
                Object v = it.getValue();
                Intrinsics.checkNotNullExpressionValue(v, (String)"<get-value>(...)");
                String string = (String)v;
                Object k = it.getKey();
                Intrinsics.checkNotNullExpressionValue(k, (String)"<get-key>(...)");
                collection.add(new SerializedChecksum(string, (ChecksumSnapshot)k));
            }
            collection = (List)destination$iv$iv;
            String string = gson.toJson(collection);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toJson(...)");
            FilesKt.writeText$default((File)file, (String)string, null, (int)2, null);
            Unit unit = Unit.INSTANCE;
        }
    }

    private final String readFileChecksum(File file) {
        String string;
        try {
            string = DigestUtils.md5Hex((String)FilesKt.readText$default((File)file, null, (int)1, null));
        }
        catch (IOException e) {
            e.printStackTrace();
            string = null;
        }
        return string;
    }

    private final ChecksumSnapshot getChecksumSnapshot(File file) {
        String string = file.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return new ChecksumSnapshot(string, file.lastModified(), file.length());
    }

    public final void delete(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this.entries.remove(this.getChecksumSnapshot(file));
    }

    private static final void entries$lambda$0(ScreenshotChecksumManager this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.saveState();
    }
}

