/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.gui.screenshot.editor.tools;

import gg.essential.elementa.UIComponent;
import gg.essential.elementa.components.UIContainer;
import gg.essential.elementa.events.UIClickEvent;
import gg.essential.elementa.utils.ObservableList;
import gg.essential.gui.screenshot.editor.ScreenshotCanvas;
import gg.essential.gui.screenshot.editor.change.Change;
import gg.essential.gui.screenshot.editor.change.VectorStroke;
import gg.essential.gui.screenshot.editor.tools.Tool;
import gg.essential.util.lwjgl3.api.nanovg.NanoVG;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Observable;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u001fB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u001d\u001a\u00020\u001eH\u0016R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR \u0010\u000b\u001a\b\u0018\u00010\fR\u00020\u0000X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0014\"\u0004\b\u0019\u0010\u0016R\u001a\u0010\u001a\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u0014\"\u0004\b\u001c\u0010\u0016\u00a8\u0006 "}, d2={"Lgg/essential/gui/screenshot/editor/tools/PenTool;", "Lgg/essential/gui/screenshot/editor/tools/Tool;", "editableScreenshot", "Lgg/essential/gui/screenshot/editor/ScreenshotCanvas;", "(Lgg/essential/gui/screenshot/editor/ScreenshotCanvas;)V", "color", "Ljava/awt/Color;", "getColor", "()Ljava/awt/Color;", "setColor", "(Ljava/awt/Color;)V", "currentVectorStroke", "Lgg/essential/gui/screenshot/editor/tools/PenTool$PenVectorStroke;", "getCurrentVectorStroke", "()Lgg/essential/gui/screenshot/editor/tools/PenTool$PenVectorStroke;", "setCurrentVectorStroke", "(Lgg/essential/gui/screenshot/editor/tools/PenTool$PenVectorStroke;)V", "previousMouseX", "", "getPreviousMouseX", "()F", "setPreviousMouseX", "(F)V", "previousMouseY", "getPreviousMouseY", "setPreviousMouseY", "width", "getWidth", "setWidth", "enable", "", "PenVectorStroke", "essential-gui-essential"})
public final class PenTool
extends Tool {
    @NotNull
    private Color color;
    private float width;
    private float previousMouseX;
    private float previousMouseY;
    @Nullable
    private PenVectorStroke currentVectorStroke;

    public PenTool(@NotNull ScreenshotCanvas editableScreenshot) {
        Intrinsics.checkNotNullParameter((Object)editableScreenshot, (String)"editableScreenshot");
        super(editableScreenshot);
        Color color2 = Color.WHITE;
        Intrinsics.checkNotNullExpressionValue((Object)color2, (String)"WHITE");
        this.color = color2;
        this.width = 1.0f;
        this.previousMouseX = -1.0f;
        this.previousMouseY = -1.0f;
    }

    @NotNull
    public final Color getColor() {
        return this.color;
    }

    public final void setColor(@NotNull Color color2) {
        Intrinsics.checkNotNullParameter((Object)color2, (String)"<set-?>");
        this.color = color2;
    }

    public final float getWidth() {
        return this.width;
    }

    public final void setWidth(float f) {
        this.width = f;
    }

    public final float getPreviousMouseX() {
        return this.previousMouseX;
    }

    public final void setPreviousMouseX(float f) {
        this.previousMouseX = f;
    }

    public final float getPreviousMouseY() {
        return this.previousMouseY;
    }

    public final void setPreviousMouseY(float f) {
        this.previousMouseY = f;
    }

    @Nullable
    public final PenVectorStroke getCurrentVectorStroke() {
        return this.currentVectorStroke;
    }

    public final void setCurrentVectorStroke(@Nullable PenVectorStroke penVectorStroke) {
        this.currentVectorStroke = penVectorStroke;
    }

    @Override
    public void enable() {
        this.getEditableScreenshot().setOnDraw((Function4<? super UIContainer, ? super Float, ? super Float, ? super Integer, Unit>)((Function4)new Function4<UIContainer, Float, Float, Integer, Unit>(this){
            final /* synthetic */ PenTool this$0;
            {
                this.this$0 = $receiver;
                super(4);
            }

            public final void invoke(@NotNull UIContainer $this$null, float mouseX, float mouseY, int mouseButton) {
                Intrinsics.checkNotNullParameter((Object)$this$null, (String)"$this$null");
                float relativeX = RangesKt.coerceIn((float)(mouseX - $this$null.getLeft()), (float)0.0f, (float)$this$null.getWidth());
                float relativeY = RangesKt.coerceIn((float)(mouseY - $this$null.getTop()), (float)0.0f, (float)$this$null.getHeight());
                if (!(relativeX < 0.0f || relativeY < 0.0f || relativeX > this.this$0.getEditableScreenshot().getWidth() || relativeY > this.this$0.getEditableScreenshot().getHeight())) {
                    boolean LEFT_CLICK = false;
                    if (mouseButton == 0) {
                        Object object;
                        if (!(this.this$0.getPreviousMouseX() == -1.0f && this.this$0.getPreviousMouseY() == -1.0f || relativeX == this.this$0.getPreviousMouseX() && relativeY == this.this$0.getPreviousMouseY() || (object = this.this$0.getCurrentVectorStroke()) == null || (object = ((PenVectorStroke)object).getList()) == null)) {
                            ((ObservableList)object).add(TuplesKt.to((Object)Float.valueOf(relativeX / $this$null.getWidth()), (Object)Float.valueOf(relativeY / $this$null.getHeight())));
                        }
                        this.this$0.setPreviousMouseX(relativeX);
                        this.this$0.setPreviousMouseY(relativeY);
                    }
                }
            }
        }));
        this.getEditableScreenshot().getScreenshotDisplay().onMouseClick((Function2<? super UIComponent, ? super UIClickEvent, Unit>)((Function2)new Function2<UIComponent, UIClickEvent, Unit>(this){
            final /* synthetic */ PenTool this$0;
            {
                this.this$0 = $receiver;
                super(2);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull UIComponent $this$onMouseClick, @NotNull UIClickEvent it) {
                void it2;
                Intrinsics.checkNotNullParameter((Object)$this$onMouseClick, (String)"$this$onMouseClick");
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                if (it.getMouseButton() != 0) {
                    return;
                }
                PenVectorStroke penVectorStroke = this.this$0.new PenVectorStroke(this.this$0.getColor(), this.this$0.getWidth());
                PenTool penTool = this.this$0;
                PenVectorStroke penVectorStroke2 = penVectorStroke;
                PenTool penTool2 = this.this$0;
                boolean bl = false;
                penTool.getEditableScreenshot().getVectorEditingOverlay().pushChange((Change)it2);
                penTool2.setCurrentVectorStroke(penVectorStroke);
            }
        }));
        this.getEditableScreenshot().getScreenshotDisplay().onMouseRelease((Function1<? super UIComponent, Unit>)((Function1)new Function1<UIComponent, Unit>(this){
            final /* synthetic */ PenTool this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull UIComponent $this$onMouseRelease) {
                Intrinsics.checkNotNullParameter((Object)$this$onMouseRelease, (String)"$this$onMouseRelease");
                this.this$0.setPreviousMouseX(-1.0f);
                this.this$0.setPreviousMouseY(-1.0f);
                this.this$0.setCurrentVectorStroke(null);
            }
        }));
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J(\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u0005H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR#\u0010\t\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u000b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0017"}, d2={"Lgg/essential/gui/screenshot/editor/tools/PenTool$PenVectorStroke;", "Lgg/essential/gui/screenshot/editor/change/VectorStroke;", "colorObj", "Ljava/awt/Color;", "strokeWidth", "", "(Lgg/essential/gui/screenshot/editor/tools/PenTool;Ljava/awt/Color;F)V", "getColorObj", "()Ljava/awt/Color;", "list", "Lgg/essential/elementa/utils/ObservableList;", "Lkotlin/Pair;", "getList", "()Lgg/essential/elementa/utils/ObservableList;", "getStrokeWidth", "()F", "render", "", "vg", "Lgg/essential/util/lwjgl3/api/nanovg/NanoVG;", "width", "height", "scale", "essential-gui-essential"})
    @SourceDebugExtension(value={"SMAP\nPenTool.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PenTool.kt\ngg/essential/gui/screenshot/editor/tools/PenTool$PenVectorStroke\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,105:1\n1#2:106\n3464#3,10:107\n*S KotlinDebug\n*F\n+ 1 PenTool.kt\ngg/essential/gui/screenshot/editor/tools/PenTool$PenVectorStroke\n*L\n95#1:107,10\n*E\n"})
    public final class PenVectorStroke
    extends VectorStroke {
        @NotNull
        private final Color colorObj;
        private final float strokeWidth;
        @NotNull
        private final ObservableList<Pair<Float, Float>> list;

        public PenVectorStroke(Color colorObj, float strokeWidth) {
            Intrinsics.checkNotNullParameter((Object)colorObj, (String)"colorObj");
            super(PenTool.this.getEditableScreenshot(), colorObj.getRGB());
            this.colorObj = colorObj;
            this.strokeWidth = strokeWidth;
            this.list = new ObservableList(new ArrayList());
            this.list.addObserver((arg_0, arg_1) -> PenVectorStroke._init_$lambda$0(this, arg_0, arg_1));
        }

        @NotNull
        public final Color getColorObj() {
            return this.colorObj;
        }

        public final float getStrokeWidth() {
            return this.strokeWidth;
        }

        @NotNull
        public final ObservableList<Pair<Float, Float>> getList() {
            return this.list;
        }

        @Override
        public void render(@NotNull NanoVG vg, float width2, float height2, float scale2) {
            Intrinsics.checkNotNullParameter((Object)vg, (String)"vg");
            vg.beginPath();
            vg.strokeWidth(this.strokeWidth * scale2);
            vg.strokeColor(this.colorObj);
            Pair pair = (Pair)CollectionsKt.firstOrNull((List)this.list);
            if (pair != null) {
                Pair pair2 = pair;
                boolean bl = false;
                float x = ((Number)pair2.component1()).floatValue();
                float y = ((Number)pair2.component2()).floatValue();
                vg.startPoint(x * width2, y * height2);
            }
            Iterable $this$zipWithNext$iv = CollectionsKt.drop((Iterable)this.list, (int)1);
            boolean $i$f$zipWithNext = false;
            Iterator iterator$iv = $this$zipWithNext$iv.iterator();
            if (!iterator$iv.hasNext()) {
                CollectionsKt.emptyList();
            } else {
                List result$iv = new ArrayList();
                Object current$iv = iterator$iv.next();
                while (iterator$iv.hasNext()) {
                    Object next$iv = iterator$iv.next();
                    Pair pair3 = (Pair)next$iv;
                    Pair pair4 = (Pair)current$iv;
                    List list = result$iv;
                    boolean bl = false;
                    float x1 = ((Number)pair4.component1()).floatValue();
                    float y1 = ((Number)pair4.component2()).floatValue();
                    float x2 = ((Number)pair3.component1()).floatValue();
                    float y2 = ((Number)pair3.component2()).floatValue();
                    vg.quadBezierTo(x1 * width2, y1 * height2, x2 * width2, y2 * height2);
                    list.add(Unit.INSTANCE);
                    current$iv = next$iv;
                }
            }
            vg.stroke();
        }

        private static final void _init_$lambda$0(PenVectorStroke this$0, Observable observable2, Object object) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            this$0.getEditableScreenshot().getVectorEditingOverlay().markDirty();
        }
    }
}

