/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.gui.screenshot.components;

import gg.essential.Essential;
import gg.essential.elementa.ElementaVersion;
import gg.essential.elementa.UIComponent;
import gg.essential.elementa.state.BasicState;
import gg.essential.elementa.state.State;
import gg.essential.gui.InternalEssentialGUI;
import gg.essential.gui.common.ExtensionsKt;
import gg.essential.gui.screenshot.LocalScreenshot;
import gg.essential.gui.screenshot.ScreenshotId;
import gg.essential.gui.screenshot.components.FocusEditComponent;
import gg.essential.gui.screenshot.components.FocusListComponent;
import gg.essential.gui.screenshot.components.FocusType;
import gg.essential.gui.screenshot.components.ListViewComponent;
import gg.essential.gui.screenshot.components.ScreenshotBrowser;
import gg.essential.gui.screenshot.components.ScreenshotOptionsDropdown;
import gg.essential.gui.screenshot.components.ScreenshotProperties;
import gg.essential.gui.screenshot.components.ScreenshotProviderManager;
import gg.essential.gui.screenshot.components.ScreenshotStateManager;
import gg.essential.gui.screenshot.components.View;
import gg.essential.gui.screenshot.handler.ScreenshotMetadataManager;
import gg.essential.network.connectionmanager.media.ScreenshotCollectionChangeEvent;
import gg.essential.network.connectionmanager.media.ScreenshotManager;
import gg.essential.universal.UKeyboard;
import gg.essential.util.GuiUtil;
import java.io.File;
import java.nio.file.Path;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.client.Minecraft;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00a8\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0013\u0012\n\b\u0002\u0010\u0003\u001a\u0004\u0018\u00010\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0015\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\t\u0010\nJ\r\u0010\u000b\u001a\u00020\b\u00a2\u0006\u0004\b\u000b\u0010\fJ\u001b\u0010\u000f\u001a\u00020\b2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\b0\r\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u001d\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u0012\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u001b\u0010\u0018\u001a\u00020\b2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00020\u0016\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u000f\u0010\u001a\u001a\u00020\u0012H\u0002\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u000f\u0010\u001c\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u001c\u0010\fJ\r\u0010\u001d\u001a\u00020\b\u00a2\u0006\u0004\b\u001d\u0010\fJ\u0015\u0010\u001d\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\u001d\u0010\nJ\u0015\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0013\u0010\nJ'\u0010#\u001a\u00020\b2\u0006\u0010\u001f\u001a\u00020\u001e2\u0006\u0010!\u001a\u00020 2\u0006\u0010\"\u001a\u00020 H\u0016\u00a2\u0006\u0004\b#\u0010$J\u000f\u0010%\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b%\u0010\fR \u0010'\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\r0&8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b'\u0010(R\u001d\u0010+\u001a\b\u0012\u0004\u0012\u00020*0)8\u0006\u00a2\u0006\f\n\u0004\b+\u0010,\u001a\u0004\b-\u0010.R\u0017\u00100\u001a\u00020/8\u0006\u00a2\u0006\f\n\u0004\b0\u00101\u001a\u0004\b2\u00103R\u0017\u00105\u001a\u0002048\u0006\u00a2\u0006\f\n\u0004\b5\u00106\u001a\u0004\b7\u00108R\u001d\u0010:\u001a\b\u0012\u0004\u0012\u0002090)8\u0006\u00a2\u0006\f\n\u0004\b:\u0010,\u001a\u0004\b;\u0010.R\u001f\u0010<\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060)8\u0006\u00a2\u0006\f\n\u0004\b<\u0010,\u001a\u0004\b=\u0010.R\u0017\u0010?\u001a\u00020>8\u0006\u00a2\u0006\f\n\u0004\b?\u0010@\u001a\u0004\bA\u0010BR\u001f\u0010C\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060)8\u0006\u00a2\u0006\f\n\u0004\bC\u0010,\u001a\u0004\bD\u0010.R\u0017\u0010F\u001a\u00020E8\u0006\u00a2\u0006\f\n\u0004\bF\u0010G\u001a\u0004\bH\u0010IR\u0017\u0010K\u001a\u00020J8\u0006\u00a2\u0006\f\n\u0004\bK\u0010L\u001a\u0004\bM\u0010NR\u001a\u0010Q\u001a\b\u0012\u0004\u0012\u00020P0O8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bQ\u0010RR\u001c\u0010U\u001a\u00070S\u00a2\u0006\u0002\bT8\u0006\u00a2\u0006\f\n\u0004\bU\u0010V\u001a\u0004\bW\u0010XR\u0017\u0010Z\u001a\u00020Y8\u0006\u00a2\u0006\f\n\u0004\bZ\u0010[\u001a\u0004\b\\\u0010]R\u0016\u0010^\u001a\u00020*8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b^\u0010_\u00a8\u0006`"}, d2={"Lgg/essential/gui/screenshot/components/ScreenshotBrowser;", "Lgg/essential/gui/InternalEssentialGUI;", "Ljava/nio/file/Path;", "editPath", "<init>", "(Ljava/nio/file/Path;)V", "Lgg/essential/gui/screenshot/components/ScreenshotProperties;", "properties", "", "changeFocusedComponent", "(Lgg/essential/gui/screenshot/components/ScreenshotProperties;)V", "closeFocus", "()V", "Lkotlin/Function0;", "function", "closeOperation", "(Lkotlin/jvm/functions/Function0;)V", "newScreenshot", "", "openFocusView", "editCallback", "(Ljava/nio/file/Path;Z)V", "", "paths", "externalDelete", "(Ljava/util/Set;)V", "onEscapeButtonPressed", "()Z", "onScreenClose", "openEditor", "Lnet/minecraft/client/Minecraft;", "mcIn", "", "w", "h", "resize", "(Lnet/minecraft/client/Minecraft;II)V", "updateGuiScale", "Ljava/util/concurrent/ConcurrentLinkedQueue;", "closeOperations", "Ljava/util/concurrent/ConcurrentLinkedQueue;", "Lgg/essential/elementa/state/BasicState;", "Lgg/essential/gui/screenshot/components/View;", "currentView", "Lgg/essential/elementa/state/BasicState;", "getCurrentView", "()Lgg/essential/elementa/state/BasicState;", "Lgg/essential/gui/screenshot/components/FocusEditComponent;", "focusEditComponent", "Lgg/essential/gui/screenshot/components/FocusEditComponent;", "getFocusEditComponent", "()Lgg/essential/gui/screenshot/components/FocusEditComponent;", "Lgg/essential/gui/screenshot/components/FocusListComponent;", "focusListComponent", "Lgg/essential/gui/screenshot/components/FocusListComponent;", "getFocusListComponent", "()Lgg/essential/gui/screenshot/components/FocusListComponent;", "Lgg/essential/gui/screenshot/components/FocusType;", "focusType", "getFocusType", "focusing", "getFocusing", "Lgg/essential/gui/screenshot/components/ListViewComponent;", "listViewComponent", "Lgg/essential/gui/screenshot/components/ListViewComponent;", "getListViewComponent", "()Lgg/essential/gui/screenshot/components/ListViewComponent;", "menuDialogOwner", "getMenuDialogOwner", "Lgg/essential/gui/screenshot/components/ScreenshotOptionsDropdown;", "optionsDropdown", "Lgg/essential/gui/screenshot/components/ScreenshotOptionsDropdown;", "getOptionsDropdown", "()Lgg/essential/gui/screenshot/components/ScreenshotOptionsDropdown;", "Lgg/essential/gui/screenshot/components/ScreenshotProviderManager;", "providerManager", "Lgg/essential/gui/screenshot/components/ScreenshotProviderManager;", "getProviderManager", "()Lgg/essential/gui/screenshot/components/ScreenshotProviderManager;", "Ljava/util/function/Consumer;", "Lgg/essential/network/connectionmanager/media/ScreenshotCollectionChangeEvent;", "refreshHandler", "Ljava/util/function/Consumer;", "Lgg/essential/network/connectionmanager/media/ScreenshotManager;", "Lorg/jetbrains/annotations/NotNull;", "screenshotManager", "Lgg/essential/network/connectionmanager/media/ScreenshotManager;", "getScreenshotManager", "()Lgg/essential/network/connectionmanager/media/ScreenshotManager;", "Lgg/essential/gui/screenshot/components/ScreenshotStateManager;", "stateManager", "Lgg/essential/gui/screenshot/components/ScreenshotStateManager;", "getStateManager", "()Lgg/essential/gui/screenshot/components/ScreenshotStateManager;", "stateToRestore", "Lgg/essential/gui/screenshot/components/View;", "Essential 1.20.1-forge"})
@SourceDebugExtension(value={"SMAP\nScreenshotBrowser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScreenshotBrowser.kt\ngg/essential/gui/screenshot/components/ScreenshotBrowser\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,224:1\n1#2:225\n*E\n"})
public final class ScreenshotBrowser
extends InternalEssentialGUI {
    @NotNull
    private final ConcurrentLinkedQueue<Function0<Unit>> closeOperations;
    @NotNull
    private final BasicState<ScreenshotProperties> focusing;
    @NotNull
    private final BasicState<View> currentView;
    @NotNull
    private final BasicState<FocusType> focusType;
    @NotNull
    private final ScreenshotManager screenshotManager;
    @NotNull
    private final ScreenshotStateManager stateManager;
    @NotNull
    private final ListViewComponent listViewComponent;
    @NotNull
    private final ScreenshotProviderManager providerManager;
    @NotNull
    private final FocusListComponent focusListComponent;
    @NotNull
    private final FocusEditComponent focusEditComponent;
    @NotNull
    private final BasicState<ScreenshotProperties> menuDialogOwner;
    @NotNull
    private final ScreenshotOptionsDropdown optionsDropdown;
    @NotNull
    private View stateToRestore;
    @NotNull
    private final Consumer<ScreenshotCollectionChangeEvent> refreshHandler;

    public ScreenshotBrowser(@Nullable Path editPath) {
        super(ElementaVersion.V6, "Pictures", 0, false, "Browsing pictures", 12, null);
        this.closeOperations = new ConcurrentLinkedQueue();
        this.focusing = new BasicState<Object>(null);
        this.currentView = this.focusing.map(currentView.1.INSTANCE);
        this.focusType = new BasicState<FocusType>(FocusType.VIEW);
        ScreenshotManager screenshotManager = Essential.getInstance().getConnectionManager().getScreenshotManager();
        Intrinsics.checkNotNullExpressionValue((Object)screenshotManager, (String)"getScreenshotManager(...)");
        this.screenshotManager = screenshotManager;
        this.stateManager = new ScreenshotStateManager(this.screenshotManager);
        this.listViewComponent = new ListViewComponent(this);
        this.providerManager = new ScreenshotProviderManager(this, this.listViewComponent.getScreenshotScrollComponent());
        this.focusListComponent = new FocusListComponent(this);
        this.focusEditComponent = new FocusEditComponent(this);
        this.menuDialogOwner = new BasicState<Object>(null);
        this.optionsDropdown = new ScreenshotOptionsDropdown(this, (State<ScreenshotProperties>)this.menuDialogOwner);
        this.stateToRestore = View.LIST;
        this.refreshHandler = arg_0 -> ScreenshotBrowser.refreshHandler$lambda$0(this, arg_0);
        ExtensionsKt.bindParent$default((UIComponent)this.getTitleText(), (UIComponent)this.getTitleBar(), this.listViewComponent.getActive(), false, null, 12, null);
        this.currentView.map(1.INSTANCE).onSetValue((Function1)new Function1<Boolean, Unit>(){

            public final void invoke(boolean it) {
                this.setBackButtonVisible(it);
            }
        });
        CollectionsKt.removeFirst(this.getWindow().getKeyTypedListeners());
        this.getWindow().onKeyType((Function3<? super UIComponent, ? super Character, ? super Integer, Unit>)((Function3)new Function3<UIComponent, Character, Integer, Unit>(){

            public final void invoke(@NotNull UIComponent $this$onKeyType, char typedChar, int keyCode) {
                Intrinsics.checkNotNullParameter((Object)$this$onKeyType, (String)"$this$onKeyType");
                if (keyCode == UKeyboard.KEY_ESCAPE && this.onEscapeButtonPressed()) {
                    return;
                }
                this.defaultKeyBehavior(typedChar, keyCode);
            }
        }));
        if (editPath != null) {
            ScreenshotId screenshotId = new LocalScreenshot(editPath);
            ScreenshotMetadataManager screenshotMetadataManager = this.screenshotManager.getScreenshotMetadataManager();
            File file = editPath.toFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
            this.openEditor(new ScreenshotProperties(screenshotId, screenshotMetadataManager.getMetadata(file)));
        }
        this.screenshotManager.registerScreenshotCollectionChangeHandler(this.refreshHandler);
    }

    public /* synthetic */ ScreenshotBrowser(Path path, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            path = null;
        }
        this(path);
    }

    @NotNull
    public final BasicState<ScreenshotProperties> getFocusing() {
        return this.focusing;
    }

    @NotNull
    public final BasicState<View> getCurrentView() {
        return this.currentView;
    }

    @NotNull
    public final BasicState<FocusType> getFocusType() {
        return this.focusType;
    }

    @NotNull
    public final ScreenshotManager getScreenshotManager() {
        return this.screenshotManager;
    }

    @NotNull
    public final ScreenshotStateManager getStateManager() {
        return this.stateManager;
    }

    @NotNull
    public final ListViewComponent getListViewComponent() {
        return this.listViewComponent;
    }

    @NotNull
    public final ScreenshotProviderManager getProviderManager() {
        return this.providerManager;
    }

    @NotNull
    public final FocusListComponent getFocusListComponent() {
        return this.focusListComponent;
    }

    @NotNull
    public final FocusEditComponent getFocusEditComponent() {
        return this.focusEditComponent;
    }

    @NotNull
    public final BasicState<ScreenshotProperties> getMenuDialogOwner() {
        return this.menuDialogOwner;
    }

    @NotNull
    public final ScreenshotOptionsDropdown getOptionsDropdown() {
        return this.optionsDropdown;
    }

    public final void openFocusView(@NotNull ScreenshotProperties properties2) {
        Intrinsics.checkNotNullParameter((Object)properties2, (String)"properties");
        this.changeFocusedComponent(properties2);
        this.focusType.set(FocusType.VIEW);
    }

    public final void changeFocusedComponent(@NotNull ScreenshotProperties properties2) {
        Intrinsics.checkNotNullParameter((Object)properties2, (String)"properties");
        this.focusing.set(properties2);
        this.focusListComponent.beginPreview(properties2);
    }

    public final void openEditor(@NotNull ScreenshotProperties properties2) {
        Intrinsics.checkNotNullParameter((Object)properties2, (String)"properties");
        this.stateToRestore = this.currentView.get();
        this.focusing.set(properties2);
        this.focusType.set(FocusType.EDIT);
    }

    public final void openEditor() {
        ScreenshotProperties screenshotProperties = this.focusing.get();
        Intrinsics.checkNotNull((Object)screenshotProperties);
        this.openEditor(screenshotProperties);
    }

    public final void closeFocus() {
        if (this.focusType.get() == FocusType.EDIT) {
            this.focusEditComponent.onClose();
        } else {
            this.focusListComponent.onClose();
        }
        if (this.stateToRestore == View.LIST) {
            this.focusing.set((ScreenshotProperties)((Object)closeFocus.1.INSTANCE));
        } else {
            this.focusType.set(FocusType.VIEW);
            this.stateToRestore = View.LIST;
        }
    }

    private final boolean onEscapeButtonPressed() {
        if (this.currentView.get() != View.FOCUS) {
            return false;
        }
        if (this.focusType.get() == FocusType.EDIT) {
            this.focusEditComponent.onBackButtonPressed();
        } else {
            this.closeFocus();
        }
        return true;
    }

    @Override
    public void onScreenClose() {
        super.onScreenClose();
        this.providerManager.cleanup();
        for (Function0<Unit> closeOperation : this.closeOperations) {
            closeOperation.invoke();
        }
    }

    public final void externalDelete(@NotNull Set<? extends Path> paths2) {
        Intrinsics.checkNotNullParameter(paths2, (String)"paths");
        this.providerManager.externalDelete(paths2);
        this.listViewComponent.reload();
        ScreenshotProperties screenshotProperties = this.focusing.get();
        if (screenshotProperties == null) {
            return;
        }
        ScreenshotProperties focused = screenshotProperties;
        ScreenshotId focusedId = focused.getId();
        if (focusedId instanceof LocalScreenshot && paths2.contains(((LocalScreenshot)focusedId).getPath())) {
            this.stateToRestore = View.LIST;
            this.closeFocus();
        } else if (this.focusType.get() == FocusType.VIEW) {
            this.openFocusView(focused);
        }
    }

    @Override
    public void updateGuiScale() {
        this.setNewGuiScale(GuiUtil.INSTANCE.getGuiScale());
        super.updateGuiScale();
    }

    public void m_6574_(@NotNull Minecraft mcIn, int w, int h) {
        Intrinsics.checkNotNullParameter((Object)mcIn, (String)"mcIn");
        this.setNewGuiScale(GuiUtil.INSTANCE.getGuiScale());
        super.m_6574_(mcIn, w, h);
    }

    public final void editCallback(@NotNull Path newScreenshot, boolean openFocusView) {
        ScreenshotProperties properties2;
        Intrinsics.checkNotNullParameter((Object)newScreenshot, (String)"newScreenshot");
        this.providerManager.reloadItems();
        this.listViewComponent.reload();
        ScreenshotProperties screenshotProperties = this.focusing.get();
        if (screenshotProperties != null) {
            ScreenshotProperties it = screenshotProperties;
            boolean bl = false;
            this.focusListComponent.beginPreview(it);
        }
        if (openFocusView && (properties2 = this.providerManager.getPropertyMap().get(new LocalScreenshot(newScreenshot))) != null) {
            if (this.focusType.get() == FocusType.EDIT) {
                this.closeFocus();
            }
            this.openFocusView(properties2);
        }
    }

    public final void closeOperation(@NotNull Function0<Unit> function) {
        Intrinsics.checkNotNullParameter(function, (String)"function");
        this.closeOperations.add(function);
    }

    private static final void refreshHandler$lambda$0(ScreenshotBrowser this$0, ScreenshotCollectionChangeEvent it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (it.screenshotsDeleted()) {
            Set<Path> set2 = it.getDeletedPaths();
            Intrinsics.checkNotNullExpressionValue(set2, (String)"getDeletedPaths(...)");
            this$0.externalDelete(set2);
        } else if (it.screenshotsCreated()) {
            this$0.providerManager.reloadItems();
            this$0.listViewComponent.reload();
        }
    }

    public ScreenshotBrowser() {
        this(null, 1, null);
    }
}

