/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.gui.common;

import gg.essential.elementa.UIComponent;
import gg.essential.elementa.components.UIBlock;
import gg.essential.elementa.constraints.CenterConstraint;
import gg.essential.elementa.dsl.UtilitiesKt;
import gg.essential.universal.UMatrixStack;
import java.awt.Color;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u001e\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0011"}, d2={"Lgg/essential/gui/common/LoadingIcon;", "Lgg/essential/elementa/UIComponent;", "scale", "", "(D)V", "getScale", "()D", "<set-?>", "", "time", "getTime", "()F", "draw", "", "matrixStack", "Lgg/essential/universal/UMatrixStack;", "Companion", "essential-gui-essential"})
public final class LoadingIcon
extends UIComponent {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final double scale;
    private float time;
    public static final float TIME_PER_FRAME = 0.12f;
    @NotNull
    private static final List<String> frames;
    public static final int FRAMES = 8;

    public LoadingIcon(double scale2) {
        this.scale = scale2;
        this.setX(new CenterConstraint());
        this.setY(new CenterConstraint());
        this.setWidth(UtilitiesKt.getPixels((double)7 * this.scale));
        this.setHeight(UtilitiesKt.getPixels((double)7 * this.scale));
        this.addUpdateFunc((Function2<? super Float, ? super Integer, Unit>)((Function2)new Function2<Float, Integer, Unit>(){

            public final void invoke(float dt, int n) {
                LoadingIcon loadingIcon = this;
                loadingIcon.time = loadingIcon.getTime() + dt;
            }
        }));
    }

    public final double getScale() {
        return this.scale;
    }

    public final float getTime() {
        return this.time;
    }

    @Override
    public void draw(@NotNull UMatrixStack matrixStack) {
        Intrinsics.checkNotNullParameter((Object)matrixStack, (String)"matrixStack");
        this.beforeDraw(matrixStack);
        Companion.draw(matrixStack, (this.getLeft() + this.getRight()) / (float)2, (this.getTop() + this.getBottom()) / (float)2, this.scale, this.time, this.getColor());
        super.draw(matrixStack);
    }

    static {
        Object[] objectArray = new String[]{"       ", "       ", "       ", "   X   ", "   X   ", "   X   ", "   X   ", "       ", "       ", "       ", "   X   ", "  XXX  ", "  XXX  ", "  XXX  ", "  X X  ", "       ", "       ", "   X   ", "  XXX  ", " XXXXX ", " XXXXX ", " XX XX ", " X   X ", "       ", "   X   ", "  XXX  ", " XXXXX ", "XXXXXXX", "XXX XXX", "XX   XX", "X     X", "       ", "       ", "   X   ", "  XXX  ", " XXXXX ", " XXXXX ", " XX XX ", " X   X ", "       ", "       ", "       ", "   X   ", "  XXX  ", "  XXX  ", "  XXX  ", "  X X  ", "       ", "       ", "       ", "       ", "   X   ", "   X   ", "   X   ", "   X   ", "       "};
        frames = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J6\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u0014R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lgg/essential/gui/common/LoadingIcon$Companion;", "", "()V", "FRAMES", "", "TIME_PER_FRAME", "", "frames", "", "", "draw", "", "matrixStack", "Lgg/essential/universal/UMatrixStack;", "xCenter", "yCenter", "scale", "", "time", "color", "Ljava/awt/Color;", "essential-gui-essential"})
    public static final class Companion {
        private Companion() {
        }

        public final void draw(@NotNull UMatrixStack matrixStack, float xCenter, float yCenter, double scale2, float time2, @NotNull Color color2) {
            Intrinsics.checkNotNullParameter((Object)matrixStack, (String)"matrixStack");
            Intrinsics.checkNotNullParameter((Object)color2, (String)"color");
            double x0 = (double)xCenter - 3.5 * scale2;
            double y0 = (double)yCenter - 3.5 * scale2;
            int frame = (int)(time2 / 0.12f) % 8;
            for (int i2 = 0; i2 < 7; ++i2) {
                for (int j = 0; j < 7; ++j) {
                    if (((String)frames.get(j * 8 + frame)).charAt(i2) != 'X') continue;
                    UIBlock.Companion.drawBlockSized(matrixStack, color2, x0 + (double)i2 * scale2, y0 + (double)j * scale2, scale2, scale2);
                }
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

