/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.elementa.impl.dom4j.tree;

import gg.essential.elementa.impl.dom4j.Document;
import gg.essential.elementa.impl.dom4j.DocumentFactory;
import gg.essential.elementa.impl.dom4j.DocumentType;
import gg.essential.elementa.impl.dom4j.Element;
import gg.essential.elementa.impl.dom4j.IllegalAddException;
import gg.essential.elementa.impl.dom4j.Node;
import gg.essential.elementa.impl.dom4j.ProcessingInstruction;
import gg.essential.elementa.impl.dom4j.tree.AbstractDocument;
import gg.essential.elementa.impl.dom4j.tree.BackedList;
import gg.essential.elementa.impl.dom4j.tree.ContentListFacade;
import java.util.Iterator;
import java.util.List;
import org.xml.sax.EntityResolver;

public class DefaultDocument
extends AbstractDocument {
    private String name;
    private Element rootElement;
    private List<Node> content;
    private DocumentType docType;
    private DocumentFactory documentFactory = DocumentFactory.getInstance();
    private transient EntityResolver entityResolver;

    public DefaultDocument() {
    }

    public DefaultDocument(String name2) {
        this.name = name2;
    }

    public DefaultDocument(Element rootElement) {
        this.rootElement = rootElement;
    }

    public DefaultDocument(DocumentType docType) {
        this.docType = docType;
    }

    public DefaultDocument(Element rootElement, DocumentType docType) {
        this.rootElement = rootElement;
        this.docType = docType;
    }

    public DefaultDocument(String name2, Element rootElement, DocumentType docType) {
        this.name = name2;
        this.rootElement = rootElement;
        this.docType = docType;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name2) {
        this.name = name2;
    }

    @Override
    public Element getRootElement() {
        return this.rootElement;
    }

    @Override
    public DocumentType getDocType() {
        return this.docType;
    }

    @Override
    public void setDocType(DocumentType docType) {
        this.docType = docType;
    }

    @Override
    public Document addDocType(String docTypeName, String publicId, String systemId) {
        this.setDocType(this.getDocumentFactory().createDocType(docTypeName, publicId, systemId));
        return this;
    }

    @Override
    public String getXMLEncoding() {
        return this.encoding;
    }

    @Override
    public EntityResolver getEntityResolver() {
        return this.entityResolver;
    }

    @Override
    public void setEntityResolver(EntityResolver entityResolver) {
        this.entityResolver = entityResolver;
    }

    @Override
    public Object clone() {
        DefaultDocument document = (DefaultDocument)super.clone();
        document.rootElement = null;
        document.content = null;
        document.appendContent(this);
        return document;
    }

    @Override
    public List<ProcessingInstruction> processingInstructions() {
        BackedList<ProcessingInstruction> answer = this.createResultList();
        for (Node node2 : this.contentList()) {
            if (!(node2 instanceof ProcessingInstruction)) continue;
            answer.add((ProcessingInstruction)node2);
        }
        return answer;
    }

    @Override
    public List<ProcessingInstruction> processingInstructions(String target2) {
        BackedList<ProcessingInstruction> answer = this.createResultList();
        for (Node node2 : this.contentList()) {
            ProcessingInstruction pi;
            if (!(node2 instanceof ProcessingInstruction) || !target2.equals((pi = (ProcessingInstruction)node2).getName())) continue;
            answer.add(pi);
        }
        return answer;
    }

    @Override
    public ProcessingInstruction processingInstruction(String target2) {
        for (Node node2 : this.contentList()) {
            ProcessingInstruction pi;
            if (!(node2 instanceof ProcessingInstruction) || !target2.equals((pi = (ProcessingInstruction)node2).getName())) continue;
            return pi;
        }
        return null;
    }

    @Override
    public boolean removeProcessingInstruction(String target2) {
        Iterator<Node> iter2 = this.contentList().iterator();
        while (iter2.hasNext()) {
            ProcessingInstruction pi;
            Node node2 = iter2.next();
            if (!(node2 instanceof ProcessingInstruction) || !target2.equals((pi = (ProcessingInstruction)node2).getName())) continue;
            iter2.remove();
            return true;
        }
        return false;
    }

    @Override
    public void setContent(List<Node> content) {
        this.rootElement = null;
        this.contentRemoved();
        if (content instanceof ContentListFacade) {
            content = ((ContentListFacade)content).getBackingList();
        }
        if (content == null) {
            this.content = null;
        } else {
            int size = content.size();
            List<Node> newContent = this.createContentList(size);
            for (Node node2 : content) {
                Document doc = node2.getDocument();
                if (doc != null && doc != this) {
                    node2 = (Node)node2.clone();
                }
                if (node2 instanceof Element) {
                    if (this.rootElement == null) {
                        this.rootElement = (Element)node2;
                    } else {
                        throw new IllegalAddException("A document may only contain one root element: " + content);
                    }
                }
                newContent.add(node2);
                this.childAdded(node2);
            }
            this.content = newContent;
        }
    }

    @Override
    public void clearContent() {
        this.contentRemoved();
        this.content = null;
        this.rootElement = null;
    }

    public void setDocumentFactory(DocumentFactory documentFactory) {
        this.documentFactory = documentFactory;
    }

    @Override
    protected List<Node> contentList() {
        if (this.content == null) {
            this.content = this.createContentList();
            if (this.rootElement != null) {
                this.content.add(this.rootElement);
            }
        }
        return this.content;
    }

    @Override
    protected void addNode(Node node2) {
        if (node2 != null) {
            Document document = node2.getDocument();
            if (document != null && document != this) {
                String message2 = "The Node already has an existing document: " + document;
                throw new IllegalAddException(this, node2, message2);
            }
            this.contentList().add(node2);
            this.childAdded(node2);
        }
    }

    @Override
    protected void addNode(int index2, Node node2) {
        if (node2 != null) {
            Document document = node2.getDocument();
            if (document != null && document != this) {
                String message2 = "The Node already has an existing document: " + document;
                throw new IllegalAddException(this, node2, message2);
            }
            this.contentList().add(index2, node2);
            this.childAdded(node2);
        }
    }

    @Override
    protected boolean removeNode(Node node2) {
        if (node2 == this.rootElement) {
            this.rootElement = null;
        }
        if (this.contentList().remove(node2)) {
            this.childRemoved(node2);
            return true;
        }
        return false;
    }

    @Override
    protected void rootElementAdded(Element element) {
        this.rootElement = element;
        element.setDocument(this);
    }

    @Override
    protected DocumentFactory getDocumentFactory() {
        return this.documentFactory;
    }
}

