/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.elementa.impl.commonmark.internal;

import gg.essential.elementa.impl.commonmark.internal.util.Escaping;
import gg.essential.elementa.impl.commonmark.internal.util.Parsing;
import gg.essential.elementa.impl.commonmark.node.Block;
import gg.essential.elementa.impl.commonmark.node.FencedCodeBlock;
import gg.essential.elementa.impl.commonmark.parser.SourceLine;
import gg.essential.elementa.impl.commonmark.parser.block.AbstractBlockParser;
import gg.essential.elementa.impl.commonmark.parser.block.AbstractBlockParserFactory;
import gg.essential.elementa.impl.commonmark.parser.block.BlockContinue;
import gg.essential.elementa.impl.commonmark.parser.block.BlockStart;
import gg.essential.elementa.impl.commonmark.parser.block.MatchedBlockParser;
import gg.essential.elementa.impl.commonmark.parser.block.ParserState;

public class FencedCodeBlockParser
extends AbstractBlockParser {
    private final FencedCodeBlock block = new FencedCodeBlock();
    private String firstLine;
    private StringBuilder otherLines = new StringBuilder();

    public FencedCodeBlockParser(char fenceChar, int fenceLength, int fenceIndent) {
        this.block.setFenceChar(fenceChar);
        this.block.setFenceLength(fenceLength);
        this.block.setFenceIndent(fenceIndent);
    }

    @Override
    public Block getBlock() {
        return this.block;
    }

    @Override
    public BlockContinue tryContinue(ParserState state2) {
        int nextNonSpace = state2.getNextNonSpaceIndex();
        int newIndex = state2.getIndex();
        CharSequence line = state2.getLine().getContent();
        if (state2.getIndent() < Parsing.CODE_BLOCK_INDENT && nextNonSpace < line.length() && line.charAt(nextNonSpace) == this.block.getFenceChar() && this.isClosing(line, nextNonSpace)) {
            return BlockContinue.finished();
        }
        int length = line.length();
        for (int i2 = this.block.getFenceIndent(); i2 > 0 && newIndex < length && line.charAt(newIndex) == ' '; ++newIndex, --i2) {
        }
        return BlockContinue.atIndex(newIndex);
    }

    @Override
    public void addLine(SourceLine line) {
        if (this.firstLine == null) {
            this.firstLine = line.getContent().toString();
        } else {
            this.otherLines.append(line.getContent());
            this.otherLines.append('\n');
        }
    }

    @Override
    public void closeBlock() {
        this.block.setInfo(Escaping.unescapeString(this.firstLine.trim()));
        this.block.setLiteral(this.otherLines.toString());
    }

    private static FencedCodeBlockParser checkOpener(CharSequence line, int index2, int indent) {
        int backticks = 0;
        int tildes = 0;
        int length = line.length();
        block4: for (int i2 = index2; i2 < length; ++i2) {
            switch (line.charAt(i2)) {
                case '`': {
                    ++backticks;
                    continue block4;
                }
                case '~': {
                    ++tildes;
                    continue block4;
                }
            }
        }
        if (backticks >= 3 && tildes == 0) {
            if (Parsing.find('`', line, index2 + backticks) != -1) {
                return null;
            }
            return new FencedCodeBlockParser('`', backticks, indent);
        }
        if (tildes >= 3 && backticks == 0) {
            return new FencedCodeBlockParser('~', tildes, indent);
        }
        return null;
    }

    private boolean isClosing(CharSequence line, int index2) {
        char fenceChar = this.block.getFenceChar();
        int fenceLength = this.block.getFenceLength();
        int fences = Parsing.skip(fenceChar, line, index2, line.length()) - index2;
        if (fences < fenceLength) {
            return false;
        }
        int after = Parsing.skipSpaceTab(line, index2 + fences, line.length());
        return after == line.length();
    }

    public static class Factory
    extends AbstractBlockParserFactory {
        @Override
        public BlockStart tryStart(ParserState state2, MatchedBlockParser matchedBlockParser) {
            int indent = state2.getIndent();
            if (indent >= Parsing.CODE_BLOCK_INDENT) {
                return BlockStart.none();
            }
            int nextNonSpace = state2.getNextNonSpaceIndex();
            FencedCodeBlockParser blockParser = FencedCodeBlockParser.checkOpener(state2.getLine().getContent(), nextNonSpace, indent);
            if (blockParser != null) {
                return BlockStart.of(blockParser).atIndex(nextNonSpace + blockParser.block.getFenceLength());
            }
            return BlockStart.none();
        }
    }
}

