/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.elementa.impl.commonmark.internal;

import gg.essential.elementa.impl.commonmark.node.Text;
import gg.essential.elementa.impl.commonmark.parser.delimiter.DelimiterRun;
import java.util.List;

public class Delimiter
implements DelimiterRun {
    public final List<Text> characters;
    public final char delimiterChar;
    private final int originalLength;
    private final boolean canOpen;
    private final boolean canClose;
    public Delimiter previous;
    public Delimiter next;

    public Delimiter(List<Text> characters, char delimiterChar, boolean canOpen, boolean canClose, Delimiter previous) {
        this.characters = characters;
        this.delimiterChar = delimiterChar;
        this.canOpen = canOpen;
        this.canClose = canClose;
        this.previous = previous;
        this.originalLength = characters.size();
    }

    @Override
    public boolean canOpen() {
        return this.canOpen;
    }

    @Override
    public boolean canClose() {
        return this.canClose;
    }

    @Override
    public int length() {
        return this.characters.size();
    }

    @Override
    public int originalLength() {
        return this.originalLength;
    }

    @Override
    public Text getOpener() {
        return this.characters.get(this.characters.size() - 1);
    }

    @Override
    public Text getCloser() {
        return this.characters.get(0);
    }

    @Override
    public Iterable<Text> getOpeners(int length) {
        if (length < 1 || length > this.length()) {
            throw new IllegalArgumentException("length must be between 1 and " + this.length() + ", was " + length);
        }
        return this.characters.subList(this.characters.size() - length, this.characters.size());
    }

    @Override
    public Iterable<Text> getClosers(int length) {
        if (length < 1 || length > this.length()) {
            throw new IllegalArgumentException("length must be between 1 and " + this.length() + ", was " + length);
        }
        return this.characters.subList(0, length);
    }
}

