/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.elementa.font;

import gg.essential.elementa.UIComponent;
import gg.essential.elementa.constraints.ConstraintType;
import gg.essential.elementa.constraints.resolution.ConstraintVisitor;
import gg.essential.elementa.font.FontProvider;
import gg.essential.elementa.font.data.Atlas;
import gg.essential.elementa.font.data.AtlasBounds;
import gg.essential.elementa.font.data.Font;
import gg.essential.elementa.font.data.Glyph;
import gg.essential.elementa.font.data.PlaneBounds;
import gg.essential.universal.UGraphics;
import gg.essential.universal.UMatrixStack;
import gg.essential.universal.render.DrawCallBuilder;
import gg.essential.universal.render.URenderPipeline;
import gg.essential.universal.shader.BlendState;
import gg.essential.universal.vertex.UBufferBuilder;
import gg.essential.universal.vertex.UBuiltBuffer;
import gg.essential.universal.vertex.UVertexConsumer;
import java.awt.Color;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 <2\u00020\u0001:\u0001<B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004JH\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020!2\u0006\u0010#\u001a\u00020!2\u0006\u0010$\u001a\u00020!H\u0002JR\u0010%\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010&\u001a\u00020'2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020!2\u0006\u0010(\u001a\u00020!2\u0006\u0010)\u001a\u00020!2\u0006\u0010*\u001a\u00020\u00112\b\u0010+\u001a\u0004\u0018\u00010\u001fH\u0016J8\u0010,\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010&\u001a\u00020'2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020!2\u0006\u0010(\u001a\u00020!H\u0002J@\u0010,\u001a\u00020\u00172\u0006\u0010-\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010&\u001a\u00020'2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020!2\u0006\u0010(\u001a\u00020!H\u0002J\b\u0010.\u001a\u00020!H\u0016J\b\u0010/\u001a\u00020!H\u0016J\u000e\u00100\u001a\u00020!2\u0006\u00101\u001a\u00020!J\b\u00102\u001a\u00020!H\u0016J$\u00103\u001a\u000e\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u00020!042\u0006\u0010&\u001a\u00020'2\u0006\u00101\u001a\u00020!H\u0002J\u0018\u00105\u001a\u00020!2\u0006\u0010&\u001a\u00020'2\u0006\u00101\u001a\u00020!H\u0016J\u0018\u00106\u001a\u00020!2\u0006\u0010&\u001a\u00020'2\u0006\u00101\u001a\u00020!H\u0016J\u0018\u00107\u001a\u00020\u00172\u0006\u00108\u001a\u0002092\u0006\u0010:\u001a\u00020;H\u0016R\u001a\u0010\u0005\u001a\u00020\u0001X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001c\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u0011X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006="}, d2={"Lgg/essential/elementa/font/BasicFontRenderer;", "Lgg/essential/elementa/font/FontProvider;", "regularFont", "Lgg/essential/elementa/font/data/Font;", "(Lgg/essential/elementa/font/data/Font;)V", "cachedValue", "getCachedValue", "()Lgg/essential/elementa/font/FontProvider;", "setCachedValue", "(Lgg/essential/elementa/font/FontProvider;)V", "constrainTo", "Lgg/essential/elementa/UIComponent;", "getConstrainTo", "()Lgg/essential/elementa/UIComponent;", "setConstrainTo", "(Lgg/essential/elementa/UIComponent;)V", "recalculate", "", "getRecalculate", "()Z", "setRecalculate", "(Z)V", "drawGlyph", "", "worldRenderer", "Lgg/essential/universal/vertex/UVertexConsumer;", "matrixStack", "Lgg/essential/universal/UMatrixStack;", "glyph", "Lgg/essential/elementa/font/data/Glyph;", "color", "Ljava/awt/Color;", "x", "", "y", "width", "height", "drawString", "string", "", "originalPointSize", "scale", "shadow", "shadowColor", "drawStringNow", "vertexConsumer", "getBaseLineHeight", "getBelowLineHeight", "getLineHeight", "pointSize", "getShadowHeight", "getStringDimensions", "Lkotlin/Pair;", "getStringHeight", "getStringWidth", "visitImpl", "visitor", "Lgg/essential/elementa/constraints/resolution/ConstraintVisitor;", "type", "Lgg/essential/elementa/constraints/ConstraintType;", "Companion", "Elementa"})
public final class BasicFontRenderer
implements FontProvider {
    @NotNull
    private static final Companion Companion;
    @NotNull
    private final Font regularFont;
    @NotNull
    private FontProvider cachedValue;
    private boolean recalculate;
    @Nullable
    private UIComponent constrainTo;
    @NotNull
    private static final URenderPipeline PIPELINE;

    public BasicFontRenderer(@NotNull Font regularFont) {
        Intrinsics.checkNotNullParameter((Object)regularFont, (String)"regularFont");
        this.regularFont = regularFont;
        this.cachedValue = this;
    }

    @Override
    @NotNull
    public FontProvider getCachedValue() {
        return this.cachedValue;
    }

    @Override
    public void setCachedValue(@NotNull FontProvider fontProvider) {
        Intrinsics.checkNotNullParameter((Object)fontProvider, (String)"<set-?>");
        this.cachedValue = fontProvider;
    }

    @Override
    public boolean getRecalculate() {
        return this.recalculate;
    }

    @Override
    public void setRecalculate(boolean bl) {
        this.recalculate = bl;
    }

    @Override
    @Nullable
    public UIComponent getConstrainTo() {
        return this.constrainTo;
    }

    @Override
    public void setConstrainTo(@Nullable UIComponent uIComponent) {
        this.constrainTo = uIComponent;
    }

    @Override
    public float getStringWidth(@NotNull String string, float pointSize) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        return ((Number)this.getStringDimensions(string, pointSize).getFirst()).floatValue();
    }

    @Override
    public float getStringHeight(@NotNull String string, float pointSize) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        return ((Number)this.getStringDimensions(string, pointSize).getSecond()).floatValue();
    }

    private final Pair<Float, Float> getStringDimensions(String string, float pointSize) {
        float width2 = 0.0f;
        float height2 = 0.0f;
        float currentPointSize = pointSize / (float)10 * this.regularFont.getFontInfo().getAtlas().getSize();
        int i2 = 0;
        while (i2 < string.length()) {
            Glyph glyph;
            char c = string.charAt(i2);
            if (c == '\u00a7' && i2 + 1 < string.length()) {
                i2 += 2;
                continue;
            }
            Glyph glyph2 = glyph = this.regularFont.getFontInfo().getGlyphs().get(c);
            if ((glyph2 != null ? glyph2.getAtlasBounds() : null) == null) {
                ++i2;
                continue;
            }
            PlaneBounds planeBounds = glyph.getPlaneBounds();
            if (planeBounds != null) {
                height2 = Math.max((planeBounds.getTop() - planeBounds.getBottom()) * currentPointSize, height2);
            }
            boolean lastCorrection = i2 >= string.length() - 1;
            width2 += (glyph.getAtlasBounds().getRight() - glyph.getAtlasBounds().getLeft() - (float)lastCorrection) / this.regularFont.getFontInfo().getAtlas().getSize() * currentPointSize;
            ++i2;
        }
        return new Pair((Object)Float.valueOf(width2), (Object)Float.valueOf(height2));
    }

    public final float getLineHeight(float pointSize) {
        return this.regularFont.getFontInfo().getMetrics().getLineHeight() * pointSize;
    }

    @Override
    public void drawString(@NotNull UMatrixStack matrixStack, @NotNull String string, @NotNull Color color2, float x, float y, float originalPointSize, float scale2, boolean shadow2, @Nullable Color shadowColor2) {
        Intrinsics.checkNotNullParameter((Object)matrixStack, (String)"matrixStack");
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        Intrinsics.checkNotNullParameter((Object)color2, (String)"color");
        float scaledPointSize = originalPointSize / (float)10 * this.regularFont.getFontInfo().getAtlas().getSize();
        if (shadow2) {
            Color color3 = shadowColor2;
            if (color3 == null) {
                color3 = new Color((color2.getRGB() & 0xFCFCFC) >> 2 | color2.getRGB() & 0xFF000000);
            }
            this.drawStringNow(matrixStack, string, color3, x + 1.0f, y, scaledPointSize * scale2);
        }
        this.drawStringNow(matrixStack, string, color2, x, y - 1.0f, scaledPointSize * scale2);
    }

    @Override
    public float getBaseLineHeight() {
        return this.regularFont.getFontInfo().getAtlas().getBaseCharHeight();
    }

    @Override
    public float getShadowHeight() {
        return this.regularFont.getFontInfo().getAtlas().getShadowHeight();
    }

    @Override
    public float getBelowLineHeight() {
        return this.regularFont.getFontInfo().getAtlas().getBelowLineHeight();
    }

    private final void drawStringNow(UMatrixStack matrixStack, String string, Color color2, float x, float y, float originalPointSize) {
        if (URenderPipeline.Companion.isRequired()) {
            UBufferBuilder bufferBuilder = UBufferBuilder.Companion.create(UGraphics.DrawMode.QUADS, UGraphics.CommonVertexFormats.POSITION_TEXTURE_COLOR);
            this.drawStringNow(bufferBuilder, matrixStack, string, color2, x, y, originalPointSize);
            UBuiltBuffer uBuiltBuffer = bufferBuilder.build();
            if (uBuiltBuffer != null) {
                uBuiltBuffer.drawAndClose(PIPELINE, (Function1<? super DrawCallBuilder, Unit>)((Function1)new Function1<DrawCallBuilder, Unit>(this){
                    final /* synthetic */ BasicFontRenderer this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull DrawCallBuilder $this$drawAndClose) {
                        Intrinsics.checkNotNullParameter((Object)$this$drawAndClose, (String)"$this$drawAndClose");
                        $this$drawAndClose.texture(0, BasicFontRenderer.access$getRegularFont$p(this.this$0).getTexture().getDynamicGlId());
                    }
                }));
            }
        } else {
            UGraphics.bindTexture(0, this.regularFont.getTexture().getDynamicGlId());
            UGraphics bufferBuilder = UGraphics.getFromTessellator();
            bufferBuilder.beginWithDefaultShader(UGraphics.DrawMode.QUADS, UGraphics.CommonVertexFormats.POSITION_TEXTURE_COLOR);
            UVertexConsumer uVertexConsumer = bufferBuilder.asUVertexConsumer();
            Intrinsics.checkNotNullExpressionValue((Object)uVertexConsumer, (String)"bufferBuilder.asUVertexConsumer()");
            this.drawStringNow(uVertexConsumer, matrixStack, string, color2, x, y, originalPointSize);
            bufferBuilder.drawDirect();
        }
    }

    private final void drawStringNow(UVertexConsumer vertexConsumer, UMatrixStack matrixStack, String string, Color color2, float x, float y, float originalPointSize) {
        float currentX = x;
        int i2 = 0;
        while (i2 < string.length()) {
            char c = string.charAt(i2);
            if (c == '\u00a7' && i2 + 1 < string.length()) {
                i2 += 2;
                continue;
            }
            Glyph glyph = this.regularFont.getFontInfo().getGlyphs().get(c);
            if (glyph == null) {
                ++i2;
                continue;
            }
            PlaneBounds planeBounds = glyph.getPlaneBounds();
            if (planeBounds != null) {
                float width2 = (planeBounds.getRight() - planeBounds.getLeft()) * originalPointSize;
                float height2 = (planeBounds.getTop() - planeBounds.getBottom()) * originalPointSize;
                this.drawGlyph(vertexConsumer, matrixStack, glyph, color2, currentX, y + planeBounds.getBottom() * originalPointSize, width2, height2);
            }
            currentX = glyph.getAtlasBounds() != null ? (currentX += (glyph.getAtlasBounds().getRight() - glyph.getAtlasBounds().getLeft()) / this.regularFont.getFontInfo().getAtlas().getSize() * originalPointSize) : (currentX += glyph.getAdvance() * originalPointSize);
            ++i2;
        }
    }

    private final void drawGlyph(UVertexConsumer worldRenderer, UMatrixStack matrixStack, Glyph glyph, Color color2, float x, float y, float width2, float height2) {
        AtlasBounds atlasBounds = glyph.getAtlasBounds();
        if (atlasBounds == null) {
            return;
        }
        AtlasBounds atlasBounds2 = atlasBounds;
        Atlas atlas = this.regularFont.getFontInfo().getAtlas();
        double textureTop = 1.0 - (double)(atlasBounds2.getTop() / atlas.getHeight());
        double textureBottom = 1.0 - (double)(atlasBounds2.getBottom() / atlas.getHeight());
        double textureLeft = atlasBounds2.getLeft() / atlas.getWidth();
        double textureRight = atlasBounds2.getRight() / atlas.getWidth();
        double doubleX = x;
        double doubleY = y;
        worldRenderer.pos(matrixStack, doubleX, doubleY + (double)height2, 0.0).tex(textureLeft, textureBottom).color(color2.getRed(), color2.getGreen(), color2.getBlue(), 255).endVertex();
        worldRenderer.pos(matrixStack, doubleX + (double)width2, doubleY + (double)height2, 0.0).tex(textureRight, textureBottom).color(color2.getRed(), color2.getGreen(), color2.getBlue(), 255).endVertex();
        worldRenderer.pos(matrixStack, doubleX + (double)width2, doubleY, 0.0).tex(textureRight, textureTop).color(color2.getRed(), color2.getGreen(), color2.getBlue(), 255).endVertex();
        worldRenderer.pos(matrixStack, doubleX, doubleY, 0.0).tex(textureLeft, textureTop).color(color2.getRed(), color2.getGreen(), color2.getBlue(), 255).endVertex();
    }

    @Override
    public void visitImpl(@NotNull ConstraintVisitor visitor, @NotNull ConstraintType type) {
        Intrinsics.checkNotNullParameter((Object)visitor, (String)"visitor");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
    }

    public static final /* synthetic */ Font access$getRegularFont$p(BasicFontRenderer $this) {
        return $this.regularFont;
    }

    static {
        URenderPipeline.Builder builder;
        Companion = new Companion(null);
        URenderPipeline.Builder $this$PIPELINE_u24lambda_u240 = builder = URenderPipeline.Companion.builderWithDefaultShader("elementa:basic_font", UGraphics.DrawMode.QUADS, UGraphics.CommonVertexFormats.POSITION_COLOR);
        boolean bl = false;
        $this$PIPELINE_u24lambda_u240.setBlendState(BlendState.copy$default(BlendState.NORMAL, null, null, null, BlendState.Param.ONE, BlendState.Param.ZERO, false, 39, null));
        PIPELINE = builder.build();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lgg/essential/elementa/font/BasicFontRenderer$Companion;", "", "()V", "PIPELINE", "Lgg/essential/universal/render/URenderPipeline;", "Elementa"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

