/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.elementa.components.image;

import gg.essential.elementa.components.image.ImageCache;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.net.URL;
import java.nio.channels.FileChannel;
import java.nio.file.OpenOption;
import java.util.concurrent.TimeUnit;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import javax.imageio.stream.ImageOutputStream;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0013\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eH\u0096\u0002J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012H\u0002J\"\u0010\u0014\u001a\u0014\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00050\u00152\u0006\u0010\u0017\u001a\u00020\u0003H\u0002J\u0019\u0010\u0018\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\fH\u0096\u0002J \u0010\u001a\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u001b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0012\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d*\u00020\u001fH\u0002J\u0016\u0010 \u001a\u0004\u0018\u00010\u0016*\u00020\u001e2\u0006\u0010!\u001a\u00020\u0016H\u0002J\u0016\u0010\"\u001a\u0004\u0018\u00010\u0016*\u00020\u001f2\u0006\u0010#\u001a\u00020\u0016H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lgg/essential/elementa/components/image/FileImageCache;", "Lgg/essential/elementa/components/image/ImageCache;", "directory", "Ljava/io/File;", "cacheTime", "", "timeUnit", "Ljava/util/concurrent/TimeUnit;", "deleteOnCacheMiss", "", "(Ljava/io/File;JLjava/util/concurrent/TimeUnit;Z)V", "get", "Ljava/awt/image/BufferedImage;", "url", "Ljava/net/URL;", "moveDown", "", "hashCode", "", "index", "readEntry", "Lkotlin/Triple;", "", "file", "set", "image", "writeEntry", "img", "asSequence", "Lkotlin/sequences/Sequence;", "Lorg/w3c/dom/Node;", "Lorg/w3c/dom/NodeList;", "attributeValue", "name", "findValueByKeyword", "keyword", "Elementa"})
@SourceDebugExtension(value={"SMAP\nFileImageCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileImageCache.kt\ngg/essential/elementa/components/image/FileImageCache\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,137:1\n1#2:138\n*E\n"})
public final class FileImageCache
implements ImageCache {
    @NotNull
    private final File directory;
    private final long cacheTime;
    @NotNull
    private final TimeUnit timeUnit;
    private final boolean deleteOnCacheMiss;

    public FileImageCache(@NotNull File directory, long cacheTime, @NotNull TimeUnit timeUnit, boolean deleteOnCacheMiss) {
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        Intrinsics.checkNotNullParameter((Object)((Object)timeUnit), (String)"timeUnit");
        this.directory = directory;
        this.cacheTime = cacheTime;
        this.timeUnit = timeUnit;
        this.deleteOnCacheMiss = deleteOnCacheMiss;
        if (!this.directory.exists()) {
            this.directory.mkdirs();
        }
        if (!this.directory.isDirectory()) {
            throw new IllegalArgumentException("Directory " + this.directory.getAbsolutePath() + " is not a valid directory for a FileImageCache");
        }
    }

    public /* synthetic */ FileImageCache(File file, long l, TimeUnit timeUnit, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            bl = true;
        }
        this(file, l, timeUnit, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    @Nullable
    public BufferedImage get(@NotNull URL url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        hashCode = url.hashCode();
        index = 0;
        var4_4 = FileChannel.open(new File(this.directory, "" + hashCode + '-' + index + ".png").toPath(), new OpenOption[0]);
        var5_5 = null;
        try {
            open = (FileChannel)var4_4;
            $i$a$-use-FileImageCache$get$1 = false;
            lock = open.lock();
            while (true) {
                if (!(file = new File(this.directory, "" + hashCode + '-' + index + ".png")).exists()) {
                    lock.release();
                    var12_13 = null;
                    return var12_13;
                }
                cacheItem = this.readEntry(file);
                if (!Intrinsics.areEqual((Object)cacheItem.getSecond(), (Object)url.toString())) ** GOTO lbl28
                if (System.currentTimeMillis() - ((Number)cacheItem.getThird()).longValue() < this.timeUnit.toMillis(this.cacheTime)) {
                    lock.release();
                    var11_14 = (BufferedImage)cacheItem.getFirst();
                    return var11_14;
                }
                if (this.deleteOnCacheMiss) {
                    file.delete();
                    this.moveDown(hashCode, index);
                }
lbl28:
                // 4 sources

                ++index;
                continue;
                break;
            }
            catch (Throwable var6_7) {
                var5_5 = var6_7;
                throw var6_7;
            }
        }
        finally {
            CloseableKt.closeFinally((Closeable)var4_4, (Throwable)var5_5);
        }
    }

    @Override
    public void set(@NotNull URL url, @NotNull BufferedImage image2) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)image2, (String)"image");
        int hashCode = url.hashCode();
        int index2 = 0;
        while (true) {
            File file;
            if (!(file = new File(this.directory, "" + hashCode + '-' + index2 + ".png")).exists()) {
                this.writeEntry(file, image2, url);
                return;
            }
            ++index2;
        }
    }

    private final void moveDown(int hashCode, int index2) {
        int tmp = index2 + 1;
        File src;
        while ((src = new File(this.directory, "" + hashCode + '-' + tmp + ".png")).exists()) {
            src.renameTo(new File(this.directory, "" + hashCode + '-' + (tmp - 1) + ".png"));
            ++tmp;
        }
        return;
    }

    private final void writeEntry(File file, BufferedImage img2, URL url) {
        ImageWriter writer = ImageIO.getImageWritersByFormatName("png").next();
        ImageWriteParam writeParam = writer.getDefaultWriteParam();
        ImageTypeSpecifier typeSpecifier = ImageTypeSpecifier.createFromBufferedImageType(1);
        IIOMetadata metadata2 = writer.getDefaultImageMetadata(typeSpecifier, writeParam);
        IIOMetadataNode urlEntry = new IIOMetadataNode("tEXtEntry");
        urlEntry.setAttribute("keyword", "image_url");
        urlEntry.setAttribute("value", url.toString());
        IIOMetadataNode cacheTimeEntry = new IIOMetadataNode("tEXtEntry");
        cacheTimeEntry.setAttribute("keyword", "cache_time");
        cacheTimeEntry.setAttribute("value", String.valueOf(System.currentTimeMillis()));
        IIOMetadataNode text2 = new IIOMetadataNode("tEXt");
        text2.appendChild(urlEntry);
        text2.appendChild(cacheTimeEntry);
        IIOMetadataNode root = new IIOMetadataNode("javax_imageio_png_1.0");
        root.appendChild(text2);
        metadata2.mergeTree("javax_imageio_png_1.0", root);
        FileOutputStream fos = new FileOutputStream(file);
        ImageOutputStream stream = ImageIO.createImageOutputStream(fos);
        writer.setOutput(stream);
        writer.write(metadata2, new IIOImage(img2, null, metadata2), writeParam);
        stream.close();
        fos.close();
    }

    private final Triple<BufferedImage, String, Long> readEntry(File file) {
        Object v1;
        byte[] imageData;
        block2: {
            Sequence<Node> sequence;
            ImageReader imageReader = ImageIO.getImageReadersByFormatName("png").next();
            imageData = FilesKt.readBytes((File)file);
            imageReader.setInput(ImageIO.createImageInputStream(new ByteArrayInputStream(imageData)), true);
            Node metadata2 = imageReader.getImageMetadata(0).getAsTree("javax_imageio_1.0");
            NodeList nodeList = metadata2.getChildNodes();
            Intrinsics.checkNotNullExpressionValue((Object)nodeList, (String)"metadata.childNodes");
            Sequence<Node> sequence2 = sequence = this.asSequence(nodeList);
            for (Object e : sequence2) {
                Node it = (Node)e;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getNodeName(), (Object)"Text")) continue;
                v1 = e;
                break block2;
            }
            v1 = null;
        }
        Intrinsics.checkNotNull(v1);
        NodeList nodeList = ((Node)v1).getChildNodes();
        Intrinsics.checkNotNullExpressionValue((Object)nodeList, (String)"metadata.childNodes.asSe\u2026 == \"Text\" }!!.childNodes");
        NodeList childNodes = nodeList;
        String string = this.findValueByKeyword(childNodes, "image_url");
        if (string == null) {
            string = "";
        }
        String cacheUrl = string;
        String string2 = this.findValueByKeyword(childNodes, "cache_time");
        long timeCached = string2 != null ? Long.parseLong(string2) : 0L;
        return new Triple((Object)ImageIO.read(new ByteArrayInputStream(imageData)), (Object)cacheUrl, (Object)timeCached);
    }

    private final Sequence<Node> asSequence(NodeList $this$asSequence) {
        return SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)((Iterable)RangesKt.until((int)0, (int)$this$asSequence.getLength()))), (Function1)((Function1)new Function1<Integer, Node>($this$asSequence){
            final /* synthetic */ NodeList $this_asSequence;
            {
                this.$this_asSequence = $receiver;
                super(1);
            }

            public final Node invoke(int it) {
                return this.$this_asSequence.item(it);
            }
        }));
    }

    private final String attributeValue(Node $this$attributeValue, String name2) {
        Node node2 = $this$attributeValue.getAttributes().getNamedItem(name2);
        return node2 != null ? node2.getNodeValue() : null;
    }

    private final String findValueByKeyword(NodeList $this$findValueByKeyword, String keyword) {
        Object v0;
        block1: {
            Sequence<Node> sequence;
            Sequence<Node> sequence2 = sequence = this.asSequence($this$findValueByKeyword);
            for (Object e : sequence2) {
                Node it = (Node)e;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)this.attributeValue(it, "keyword"), (Object)keyword)) continue;
                v0 = e;
                break block1;
            }
            v0 = null;
        }
        Node node2 = v0;
        return node2 != null ? this.attributeValue(node2, "value") : null;
    }
}

