/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.elementa.components;

import gg.essential.elementa.UIComponent;
import gg.essential.elementa.components.UIPoint;
import gg.essential.elementa.dsl.UtilitiesKt;
import gg.essential.universal.UGraphics;
import gg.essential.universal.UMatrixStack;
import gg.essential.universal.render.URenderPipeline;
import gg.essential.universal.shader.BlendState;
import gg.essential.universal.vertex.UBufferBuilder;
import gg.essential.universal.vertex.UBuiltBuffer;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Deprecated(message="Currently only supports convex polygons. Use with care! Or better, create a dedicated component for your use case.")
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0017\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u0011\b\u0007\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0010\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u000fJ\u001f\u0010\u0012\u001a\u00020\u00002\u0012\u0010\u0013\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000f0\u0014\"\u00020\u000f\u00a2\u0006\u0002\u0010\u0015J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0018\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0002\u001a\u00020\u0003H\u0003J\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eR$\u0010\u0005\u001a\u00020\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u0007\u0010\b\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lgg/essential/elementa/components/UIShape;", "Lgg/essential/elementa/UIComponent;", "color", "Ljava/awt/Color;", "(Ljava/awt/Color;)V", "drawMode", "", "getDrawMode$annotations", "()V", "getDrawMode", "()I", "setDrawMode", "(I)V", "vertices", "", "Lgg/essential/elementa/components/UIPoint;", "addVertex", "point", "addVertices", "points", "", "([Lgg/essential/elementa/components/UIPoint;)Lgg/essential/elementa/components/UIShape;", "draw", "", "matrixStack", "Lgg/essential/universal/UMatrixStack;", "drawLegacy", "getVertices", "Companion", "Elementa"})
@SourceDebugExtension(value={"SMAP\nUIShape.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UIShape.kt\ngg/essential/elementa/components/UIShape\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,104:1\n1849#2,2:105\n1849#2,2:107\n*S KotlinDebug\n*F\n+ 1 UIShape.kt\ngg/essential/elementa/components/UIShape\n*L\n59#1:105,2\n86#1:107,2\n*E\n"})
public class UIShape
extends UIComponent {
    @NotNull
    private static final Companion Companion;
    @NotNull
    private List<UIPoint> vertices;
    private int drawMode;
    @NotNull
    private static final URenderPipeline PIPELINE;

    @JvmOverloads
    public UIShape(@NotNull Color color2) {
        Intrinsics.checkNotNullParameter((Object)color2, (String)"color");
        this.vertices = new ArrayList();
        this.drawMode = 9;
        this.setColor(UtilitiesKt.toConstraint(color2));
    }

    public /* synthetic */ UIShape(Color color2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            Color color3 = Color.WHITE;
            Intrinsics.checkNotNullExpressionValue((Object)color3, (String)"WHITE");
            color2 = color3;
        }
        this(color2);
    }

    public final int getDrawMode() {
        return this.drawMode;
    }

    public final void setDrawMode(int n) {
        this.drawMode = n;
    }

    @Deprecated(message="Only supports GL_POLYGON on 1.17+, implemented as TRIANGEL_FAN.")
    public static /* synthetic */ void getDrawMode$annotations() {
    }

    @NotNull
    public final UIShape addVertex(@NotNull UIPoint point) {
        UIShape uIShape;
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        UIShape $this$addVertex_u24lambda_u240 = uIShape = this;
        boolean bl = false;
        $this$addVertex_u24lambda_u240.getParent().addChild(point);
        $this$addVertex_u24lambda_u240.vertices.add(point);
        return uIShape;
    }

    @NotNull
    public final UIShape addVertices(UIPoint ... points2) {
        UIShape uIShape;
        Intrinsics.checkNotNullParameter((Object)points2, (String)"points");
        UIShape $this$addVertices_u24lambda_u241 = uIShape = this;
        boolean bl = false;
        $this$addVertices_u24lambda_u241.getParent().addChildren(Arrays.copyOf(points2, points2.length));
        CollectionsKt.addAll((Collection)$this$addVertices_u24lambda_u241.vertices, (Object[])points2);
        return uIShape;
    }

    @NotNull
    public final List<UIPoint> getVertices() {
        return this.vertices;
    }

    @Override
    public void draw(@NotNull UMatrixStack matrixStack) {
        Intrinsics.checkNotNullParameter((Object)matrixStack, (String)"matrixStack");
        this.beforeDrawCompat(matrixStack);
        Color color2 = this.getColor();
        if (color2.getAlpha() == 0) {
            super.draw(matrixStack);
            return;
        }
        if (URenderPipeline.Companion.isRequired()) {
            this.draw(matrixStack, color2);
        } else {
            this.drawLegacy(matrixStack, color2);
        }
        super.draw(matrixStack);
    }

    private final void draw(UMatrixStack matrixStack, Color color2) {
        block1: {
            UBufferBuilder bufferBuilder = UBufferBuilder.Companion.create(UGraphics.DrawMode.TRIANGLE_FAN, UGraphics.CommonVertexFormats.POSITION_COLOR);
            Iterable $this$forEach$iv = this.vertices;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                UIPoint it = (UIPoint)element$iv;
                boolean bl = false;
                bufferBuilder.pos(matrixStack, it.getAbsoluteX(), it.getAbsoluteY(), 0.0).color(color2.getRed(), color2.getGreen(), color2.getBlue(), color2.getAlpha()).endVertex();
            }
            UBuiltBuffer uBuiltBuffer = bufferBuilder.build();
            if (uBuiltBuffer == null) break block1;
            UBuiltBuffer.drawAndClose$default(uBuiltBuffer, PIPELINE, null, 2, null);
        }
    }

    @Deprecated(message="Stops working in 1.21.5, see UGraphics.Globals")
    private final void drawLegacy(UMatrixStack matrixStack, Color color2) {
        UGraphics.enableBlend();
        UGraphics.disableTexture2D();
        float red = (float)color2.getRed() / 255.0f;
        float green = (float)color2.getGreen() / 255.0f;
        float blue = (float)color2.getBlue() / 255.0f;
        float alpha = (float)color2.getAlpha() / 255.0f;
        UGraphics worldRenderer = UGraphics.getFromTessellator();
        UGraphics.tryBlendFuncSeparate(770, 771, 1, 0);
        if (UGraphics.isCoreProfile()) {
            worldRenderer.beginWithDefaultShader(UGraphics.DrawMode.TRIANGLE_FAN, UGraphics.CommonVertexFormats.POSITION_COLOR);
        } else {
            worldRenderer.begin(this.drawMode, UGraphics.CommonVertexFormats.POSITION_COLOR);
        }
        Iterable $this$forEach$iv = this.vertices;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            UIPoint it = (UIPoint)element$iv;
            boolean bl = false;
            worldRenderer.pos(matrixStack, it.getAbsoluteX(), it.getAbsoluteY(), 0.0).color(red, green, blue, alpha).endVertex();
        }
        worldRenderer.drawDirect();
        UGraphics.enableTexture2D();
        UGraphics.disableBlend();
    }

    @JvmOverloads
    public UIShape() {
        this(null, 1, null);
    }

    static {
        URenderPipeline.Builder builder;
        Companion = new Companion(null);
        URenderPipeline.Builder $this$PIPELINE_u24lambda_u244 = builder = URenderPipeline.Companion.builderWithDefaultShader("elementa:shape", UGraphics.DrawMode.TRIANGLE_FAN, UGraphics.CommonVertexFormats.POSITION_COLOR);
        boolean bl = false;
        $this$PIPELINE_u24lambda_u244.setBlendState(BlendState.copy$default(BlendState.NORMAL, null, null, null, BlendState.Param.ONE, BlendState.Param.ZERO, false, 39, null));
        PIPELINE = builder.build();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lgg/essential/elementa/components/UIShape$Companion;", "", "()V", "PIPELINE", "Lgg/essential/universal/render/URenderPipeline;", "Elementa"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

